/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics.emitters.particles;

import de.gurkenlabs.litiengine.graphics.emitters.particles.ShapeParticle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;

public class PolygonParticle
extends ShapeParticle {
    private int sides;

    public PolygonParticle(float width, float height, int sides) {
        super(width, height);
        this.sides = sides;
    }

    @Override
    protected Shape getShape(Point2D emitterOrigin) {
        Path2D.Double path = new Path2D.Double();
        double x = this.getAbsoluteX(emitterOrigin) + this.getWidth() / 2.0f;
        double y = this.getAbsoluteY(emitterOrigin) + this.getHeight() / 2.0f;
        double theta = Math.PI * 2 / (double)this.sides;
        ((Path2D)path).moveTo(x + (double)this.getWidth(), y + 0.0);
        for (int i = 0; i < this.sides; ++i) {
            ((Path2D)path).lineTo(x + (double)this.getWidth() * Math.cos(theta * (double)i), y + (double)this.getHeight() * Math.sin(theta * (double)i));
        }
        path.closePath();
        AffineTransform rotate = AffineTransform.getRotateInstance(Math.toRadians(this.getAngle()), (double)this.getAbsoluteX(emitterOrigin) + (double)this.getWidth() * 0.5, (double)this.getAbsoluteY(emitterOrigin) + (double)this.getHeight() * 0.5);
        return rotate.createTransformedShape(path);
    }
}

