/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics.animation;

import de.gurkenlabs.litiengine.Direction;
import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.entities.AnimationInfo;
import de.gurkenlabs.litiengine.entities.Creature;
import de.gurkenlabs.litiengine.graphics.CreatureAnimationState;
import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.graphics.animation.Animation;
import de.gurkenlabs.litiengine.graphics.animation.EntityAnimationController;
import de.gurkenlabs.litiengine.resources.Resources;
import java.util.HashMap;
import java.util.Optional;

public class CreatureAnimationController<T extends Creature>
extends EntityAnimationController<T> {
    private String[] customDeathAnimations;
    private String randomDeathSprite;

    public CreatureAnimationController(T creature, boolean useFlippedSpritesAsFallback) {
        super(creature);
        this.init(useFlippedSpritesAsFallback);
    }

    public CreatureAnimationController(T creature, Animation defaultAnimation) {
        this(creature, true, defaultAnimation, new Animation[0]);
    }

    public CreatureAnimationController(T creature, boolean useFlippedSpritesAsFallback, Animation defaultAnimation, Animation ... animations) {
        super(creature, defaultAnimation, animations);
        this.init(useFlippedSpritesAsFallback);
    }

    public static String getSpriteName(Creature creature, CreatureAnimationState state) {
        return creature.getSpritesheetName() + "-" + state.spriteString();
    }

    public static String getSpriteName(Creature creature, CreatureAnimationState state, Direction direction) {
        return CreatureAnimationController.getSpriteName(creature, state) + "-" + direction.name().toLowerCase();
    }

    @Override
    public boolean isAutoScaling() {
        return ((Creature)this.getEntity()).isScaling() || super.isAutoScaling();
    }

    @Override
    protected String getSpritePrefix() {
        return ((Creature)this.getEntity()).getSpritesheetName();
    }

    protected String getCurrentAnimationName() {
        Creature entity = (Creature)this.getEntity();
        Direction direction = entity.getFacingDirection();
        if (((Creature)this.getEntity()).isDead()) {
            String deadName = this.getDeadSpriteName(direction);
            return this.hasAnimation(deadName) ? deadName : this.chooseRandomDeathAnimation();
        }
        if (entity.isIdle()) {
            String idleName = this.getIdleSpriteName(direction);
            return this.hasAnimation(idleName) ? idleName : this.getMoveSpriteName(direction);
        }
        String moveName = this.getMoveSpriteName(direction);
        return this.hasAnimation(moveName) ? moveName : this.getIdleSpriteName(direction);
    }

    private String chooseRandomDeathAnimation() {
        if (this.customDeathAnimations.length == 0) {
            return null;
        }
        String randomDeathAnimation = Game.random().choose(this.customDeathAnimations);
        String prefixedDeathAnimation = this.getSpritePrefix() + "-" + randomDeathAnimation;
        if (this.randomDeathSprite == null && randomDeathAnimation != null && !randomDeathAnimation.isEmpty() && this.hasAnimation(prefixedDeathAnimation)) {
            this.randomDeathSprite = prefixedDeathAnimation;
        }
        return this.randomDeathSprite;
    }

    private void initializeAvailableAnimations() {
        for (CreatureAnimationState state : CreatureAnimationState.values()) {
            this.initializeBaseAnimation(state, null);
            for (Direction dir : Direction.values()) {
                this.initializeBaseAnimation(state, dir);
            }
        }
    }

    private void initializeBaseAnimation(CreatureAnimationState state, Direction dir) {
        Spritesheet sprite = Resources.spritesheets().get(dir == null ? this.getSpriteName(state) : this.getSpriteName(state, dir));
        if (sprite != null) {
            this.add(new Animation(sprite, true, new int[0]));
        }
    }

    private void initializeFlippedAnimations() {
        HashMap<String, Optional> animations = new HashMap<String, Optional>();
        for (Direction direction : new Direction[]{Direction.LEFT, Direction.RIGHT}) {
            for (CreatureAnimationState state : CreatureAnimationState.values()) {
                String spriteName2 = this.getSpriteName(state, direction);
                animations.put(spriteName2, this.getAll().stream().filter(x -> x.getName().equals(spriteName2)).findFirst());
            }
        }
        animations.forEach((spriteName, animation) -> {
            String oppositeSpriteName = spriteName.endsWith("left") ? spriteName.replace("left", "right") : spriteName.replace("right", "left");
            Optional oppositeAnimation = (Optional)animations.get(oppositeSpriteName);
            if (animation.isEmpty() && oppositeAnimation.isPresent()) {
                this.add(CreatureAnimationController.flippedAnimation((Animation)oppositeAnimation.get(), spriteName, false));
            }
        });
    }

    private String getDeadSpriteName(Direction dir) {
        return this.getSpriteNameWithDirection(CreatureAnimationState.DEAD, dir);
    }

    private String getIdleSpriteName(Direction dir) {
        return this.getSpriteNameWithDirection(CreatureAnimationState.IDLE, dir);
    }

    private String getMoveSpriteName(Direction dir) {
        return this.getSpriteNameWithDirection(CreatureAnimationState.MOVE, dir);
    }

    private String getSpriteNameWithDirection(CreatureAnimationState state, Direction dir) {
        String name = this.getSpriteName(state, dir);
        if (this.hasAnimation(name)) {
            return name;
        }
        return this.getFallbackSpriteName(state, dir);
    }

    private String getFallbackSpriteName(CreatureAnimationState state, Direction dir) {
        String animName = this.getSpriteName(state);
        if (this.hasAnimation(animName)) {
            return animName;
        }
        animName = this.getSpriteName(state.getOpposite(), dir);
        if (this.hasAnimation(animName)) {
            return animName;
        }
        for (Direction d : Direction.values()) {
            animName = this.getSpriteName(state, d);
            if (!this.hasAnimation(animName)) continue;
            return animName;
        }
        for (Direction d : Direction.values()) {
            animName = this.getSpriteName(state.getOpposite(), d);
            if (!this.hasAnimation(animName)) continue;
            return animName;
        }
        return this.getDefault() != null ? this.getDefault().getName() : null;
    }

    private String getSpriteName(CreatureAnimationState state) {
        return CreatureAnimationController.getSpriteName((Creature)this.getEntity(), state);
    }

    private String getSpriteName(CreatureAnimationState state, Direction direction) {
        return CreatureAnimationController.getSpriteName((Creature)this.getEntity(), state, direction);
    }

    private void init(boolean useFlippedSpritesAsFallback) {
        this.initializeAvailableAnimations();
        if (useFlippedSpritesAsFallback) {
            this.initializeFlippedAnimations();
        }
        this.addRule(e -> true, e -> this.getCurrentAnimationName());
        AnimationInfo info = ((Creature)this.getEntity()).getClass().getAnnotation(AnimationInfo.class);
        this.customDeathAnimations = info != null ? info.deathAnimations() : new String[0];
    }
}

