/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.TmxProperty;
import de.gurkenlabs.litiengine.environment.tilemap.TmxType;
import de.gurkenlabs.litiengine.environment.tilemap.xml.DecimalFloatAdapter;
import de.gurkenlabs.litiengine.environment.tilemap.xml.MapObject;
import de.gurkenlabs.litiengine.util.ArrayUtilities;
import java.lang.reflect.Field;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class MapObjectSerializer {
    private static final Logger log = Logger.getLogger(MapObjectSerializer.class.getName());

    private MapObjectSerializer() {
    }

    public static MapObject serialize(IEntity entity) {
        MapObject obj = new MapObject();
        obj.setId(entity.getMapId());
        obj.setX((float)entity.getX());
        obj.setY((float)entity.getY());
        obj.setWidth((float)entity.getWidth());
        obj.setHeight((float)entity.getHeight());
        obj.setName(entity.getName());
        TmxType type = entity.getClass().getAnnotation(TmxType.class);
        if (type != null) {
            obj.setType(type.value().toString());
        }
        MapObjectSerializer.serialize(entity.getClass(), entity, obj);
        if (!entity.getTags().isEmpty()) {
            obj.setValue("tags", ArrayUtilities.join(entity.getTags()));
        }
        return obj;
    }

    private static <T extends IEntity> void serialize(Class<?> clz, T entity, MapObject mapObject) {
        for (Field field : clz.getDeclaredFields()) {
            MapObjectSerializer.serialize(field, entity, (IMapObject)mapObject);
        }
        Class<?> parentClass = clz.getSuperclass();
        if (parentClass != null) {
            MapObjectSerializer.serialize(parentClass, entity, mapObject);
        }
    }

    private static void serialize(Field field, Object entity, IMapObject mapObject) {
        TmxProperty property = field.getAnnotation(TmxProperty.class);
        if (property == null) {
            return;
        }
        try {
            Object value;
            if (!field.canAccess(entity)) {
                field.setAccessible(true);
            }
            if ((value = field.get(entity)) == null) {
                return;
            }
            mapObject.setValue(property.name(), MapObjectSerializer.getPropertyValue(field, value));
        }
        catch (IllegalAccessException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private static String getPropertyValue(Field field, Object value) {
        if (field.getType().equals(Float.class) || field.getType().equals(Double.class)) {
            try {
                return new DecimalFloatAdapter().marshal((Float)value);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        } else {
            if (field.getType().equals(Integer.class)) {
                return Integer.toString((Integer)value);
            }
            if (field.getType().equals(Short.TYPE)) {
                return Short.toString((Short)value);
            }
            if (field.getType().equals(Byte.TYPE)) {
                return Byte.toString((Byte)value);
            }
            if (field.getType().equals(Long.TYPE)) {
                return Long.toString((Long)value);
            }
        }
        if (value instanceof List) {
            return ArrayUtilities.join((List)value);
        }
        if (value.getClass().isArray()) {
            if (field.getType().getComponentType() == Integer.TYPE) {
                return ArrayUtilities.join((int[])value);
            }
            if (field.getType().getComponentType() == Double.TYPE) {
                return ArrayUtilities.join((double[])value);
            }
            if (field.getType().getComponentType() == Float.TYPE) {
                return ArrayUtilities.join((float[])value);
            }
            if (field.getType().getComponentType() == Short.TYPE) {
                return ArrayUtilities.join((short[])value);
            }
            if (field.getType().getComponentType() == Byte.TYPE) {
                return ArrayUtilities.join((byte[])value);
            }
            if (field.getType().getComponentType() == Long.TYPE) {
                return ArrayUtilities.join((long[])value);
            }
            if (field.getType().getComponentType() == String.class) {
                return ArrayUtilities.join((String[])value);
            }
            if (field.getType().getComponentType() == Boolean.TYPE) {
                return ArrayUtilities.join((boolean[])value);
            }
            return ArrayUtilities.join((Object[])value);
        }
        return value.toString();
    }
}

