/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.Direction;
import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.GameMetrics;
import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.configuration.Quality;
import de.gurkenlabs.litiengine.entities.CollisionBox;
import de.gurkenlabs.litiengine.entities.Creature;
import de.gurkenlabs.litiengine.entities.EntityInfo;
import de.gurkenlabs.litiengine.entities.ICollisionEntity;
import de.gurkenlabs.litiengine.entities.ICombatEntity;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.entities.IMobileEntity;
import de.gurkenlabs.litiengine.entities.LightSource;
import de.gurkenlabs.litiengine.entities.MapArea;
import de.gurkenlabs.litiengine.entities.Prop;
import de.gurkenlabs.litiengine.entities.SoundSource;
import de.gurkenlabs.litiengine.entities.Spawnpoint;
import de.gurkenlabs.litiengine.entities.StaticShadow;
import de.gurkenlabs.litiengine.entities.Trigger;
import de.gurkenlabs.litiengine.environment.CollisionBoxMapObjectLoader;
import de.gurkenlabs.litiengine.environment.CreatureMapObjectLoader;
import de.gurkenlabs.litiengine.environment.CustomMapObjectLoader;
import de.gurkenlabs.litiengine.environment.EmitterMapObjectLoader;
import de.gurkenlabs.litiengine.environment.EnvironmentEntityListener;
import de.gurkenlabs.litiengine.environment.EnvironmentListener;
import de.gurkenlabs.litiengine.environment.EnvironmentRenderedListener;
import de.gurkenlabs.litiengine.environment.IMapObjectLoader;
import de.gurkenlabs.litiengine.environment.LightSourceMapObjectLoader;
import de.gurkenlabs.litiengine.environment.MapAreaMapObjectLoader;
import de.gurkenlabs.litiengine.environment.PropMapObjectLoader;
import de.gurkenlabs.litiengine.environment.SoundSourceMapObjectLoader;
import de.gurkenlabs.litiengine.environment.SpawnpointMapObjectLoader;
import de.gurkenlabs.litiengine.environment.StaticShadowMapObjectLoader;
import de.gurkenlabs.litiengine.environment.TriggerMapObjectLoader;
import de.gurkenlabs.litiengine.environment.tilemap.IMap;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObjectLayer;
import de.gurkenlabs.litiengine.environment.tilemap.MapRenderer;
import de.gurkenlabs.litiengine.environment.tilemap.MapUtilities;
import de.gurkenlabs.litiengine.environment.tilemap.xml.Blueprint;
import de.gurkenlabs.litiengine.graphics.AmbientLight;
import de.gurkenlabs.litiengine.graphics.DebugRenderer;
import de.gurkenlabs.litiengine.graphics.IRenderable;
import de.gurkenlabs.litiengine.graphics.RenderType;
import de.gurkenlabs.litiengine.graphics.StaticShadowLayer;
import de.gurkenlabs.litiengine.graphics.StaticShadowType;
import de.gurkenlabs.litiengine.graphics.emitters.Emitter;
import de.gurkenlabs.litiengine.physics.GravityForce;
import de.gurkenlabs.litiengine.physics.IMovementController;
import de.gurkenlabs.litiengine.resources.Resources;
import de.gurkenlabs.litiengine.util.TimeUtilities;
import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Environment
implements IRenderable {
    private static final Map<String, IMapObjectLoader> mapObjectLoaders = new ConcurrentHashMap<String, IMapObjectLoader>();
    private static final String GRAVITY_IDENTIFIER = "GRAVITY";
    private static final Logger log = Logger.getLogger(Environment.class.getName());
    private static int localIdSequence = 0;
    private final Map<Integer, ICombatEntity> combatEntities = new ConcurrentHashMap<Integer, ICombatEntity>();
    private final Map<Integer, IMobileEntity> mobileEntities = new ConcurrentHashMap<Integer, IMobileEntity>();
    private final Map<Integer, GravityForce> gravityForces = new ConcurrentHashMap<Integer, GravityForce>();
    private final Map<RenderType, Map<Integer, IEntity>> miscEntities = Collections.synchronizedMap(new EnumMap(RenderType.class));
    private final Map<IMapObjectLayer, List<IEntity>> layerEntities = new ConcurrentHashMap<IMapObjectLayer, List<IEntity>>();
    private final Map<String, Collection<IEntity>> entitiesByTag = new ConcurrentHashMap<String, Collection<IEntity>>();
    private final Map<Integer, IEntity> allEntities = new ConcurrentHashMap<Integer, IEntity>();
    private final Map<RenderType, Collection<EnvironmentRenderedListener>> renderListeners = Collections.synchronizedMap(new EnumMap(RenderType.class));
    private final Collection<EnvironmentListener> listeners = ConcurrentHashMap.newKeySet();
    private final Collection<EnvironmentEntityListener> entityListeners = ConcurrentHashMap.newKeySet();
    private final Map<RenderType, Collection<IRenderable>> renderables = Collections.synchronizedMap(new EnumMap(RenderType.class));
    private final Collection<Emitter> emitters = ConcurrentHashMap.newKeySet();
    private final Collection<CollisionBox> colliders = ConcurrentHashMap.newKeySet();
    private final Collection<Prop> props = ConcurrentHashMap.newKeySet();
    private final Collection<Creature> creatures = ConcurrentHashMap.newKeySet();
    private final Collection<StaticShadow> staticShadows = ConcurrentHashMap.newKeySet();
    private final Collection<LightSource> lightSources = ConcurrentHashMap.newKeySet();
    private final Collection<SoundSource> soundSources = ConcurrentHashMap.newKeySet();
    private final Collection<Spawnpoint> spawnPoints = ConcurrentHashMap.newKeySet();
    private final Collection<MapArea> mapAreas = ConcurrentHashMap.newKeySet();
    private final Collection<Trigger> triggers = ConcurrentHashMap.newKeySet();
    private AmbientLight ambientLight;
    private StaticShadowLayer staticShadowLayer;
    private boolean loaded;
    private boolean initialized;
    private final IMap map;
    private int gravity;
    private boolean rendering;

    public Environment(IMap map) {
        this.map = map;
        if (this.getMap() != null) {
            Game.physics().setBounds(this.getMap().getBounds());
            this.setGravity(this.getMap().getIntValue(GRAVITY_IDENTIFIER, 0));
        }
        for (RenderType renderType : RenderType.values()) {
            this.miscEntities.put(renderType, new ConcurrentHashMap());
            this.renderListeners.put(renderType, ConcurrentHashMap.newKeySet());
            this.renderables.put(renderType, ConcurrentHashMap.newKeySet());
        }
    }

    public Environment(String mapPath) {
        this((IMap)Resources.maps().get(mapPath));
    }

    public static void registerMapObjectLoader(IMapObjectLoader mapObjectLoader) {
        mapObjectLoaders.put(mapObjectLoader.getMapObjectType(), mapObjectLoader);
    }

    public static void registerCustomEntityType(String mapObjectType, Class<? extends IEntity> entityType) {
        if (entityType.isInterface() || Modifier.isAbstract(entityType.getModifiers())) {
            log.log(Level.WARNING, "Cannot register the custom entity type [{0}]: Type must not be an interface or abstract class.", entityType.getName());
            return;
        }
        CustomMapObjectLoader.ConstructorInvocation invocation = CustomMapObjectLoader.findConstructor(entityType);
        if (invocation == null) {
            log.log(Level.WARNING, "Cannot register the custom entity type [{0}]: No matching constructor found.", entityType.getName());
            return;
        }
        CustomMapObjectLoader mapObjectLoader = new CustomMapObjectLoader(mapObjectType, invocation);
        Environment.registerMapObjectLoader(mapObjectLoader);
    }

    public static void registerCustomEntityType(Class<? extends IEntity> entityType) {
        EntityInfo info = entityType.getAnnotation(EntityInfo.class);
        if (info == null || info.customMapObjectType().isEmpty()) {
            log.log(Level.WARNING, "Cannot register the custom entity type [{0}]: EntityInfo.customMapObjectType must be specified.\nAdd an EntityInfo annotation to the class and provide the required information or use the registerCustomEntityType overload and provide the type explicitly.", entityType.getName());
            return;
        }
        Environment.registerCustomEntityType(info.customMapObjectType(), entityType);
    }

    public void onRendered(RenderType renderType, EnvironmentRenderedListener listener) {
        this.renderListeners.get((Object)renderType).add(listener);
    }

    public void removeListener(EnvironmentRenderedListener listener) {
        for (Collection<EnvironmentRenderedListener> rends : this.renderListeners.values()) {
            rends.remove(listener);
        }
    }

    public void addListener(EnvironmentListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(EnvironmentListener listener) {
        this.listeners.remove(listener);
    }

    public void addEntityListener(EnvironmentEntityListener listener) {
        this.entityListeners.add(listener);
    }

    public void removeEntityListener(EnvironmentEntityListener listener) {
        this.entityListeners.remove(listener);
    }

    public void add(IEntity entity) {
        if (entity == null) {
            return;
        }
        this.addEntity(entity);
        this.assignRenderType(entity, entity.getRenderType());
        this.fireEntityEvent(l -> l.entityAdded(entity));
    }

    public <T extends IEntity> void addAll(Iterable<T> entities) {
        if (entities == null) {
            return;
        }
        for (IEntity ent : entities) {
            this.add(ent);
        }
    }

    public void addAll(IEntity ... entities) {
        this.addAll(Arrays.asList(entities));
    }

    public void updateLighting() {
        if (this.getMap() != null) {
            this.updateLighting(this.getMap().getBounds());
        }
    }

    public void updateLighting(Rectangle2D section) {
        if (this.getStaticShadowLayer() != null) {
            this.getStaticShadowLayer().updateSection(section);
        }
        if (this.getAmbientLight() != null) {
            this.getAmbientLight().updateSection(section);
        }
    }

    public void add(IRenderable renderable, RenderType renderType) {
        this.renderables.get((Object)renderType).add(renderable);
    }

    public Collection<IEntity> build(Blueprint blueprint, double x, double y) {
        return this.build(blueprint, new Point2D.Double(x, y));
    }

    public Collection<IEntity> build(Blueprint blueprint, Point2D location) {
        List<IMapObject> mapObjects = blueprint.build(location);
        ArrayList<IEntity> loadedEntities = new ArrayList<IEntity>();
        for (IMapObject obj : mapObjects) {
            loadedEntities.addAll(this.load(obj));
        }
        return loadedEntities;
    }

    public void clear() {
        Game.physics().clear();
        this.combatEntities.clear();
        this.mobileEntities.clear();
        this.gravityForces.clear();
        this.layerEntities.clear();
        this.entitiesByTag.clear();
        this.allEntities.clear();
        for (RenderType renderType : RenderType.values()) {
            this.miscEntities.get((Object)renderType).clear();
            this.renderListeners.get((Object)renderType).clear();
            this.renderables.get((Object)renderType).clear();
        }
        Environment.dispose(this.allEntities.values());
        Environment.dispose(this.triggers);
        this.emitters.clear();
        this.colliders.clear();
        this.props.clear();
        this.creatures.clear();
        this.staticShadows.clear();
        this.combatEntities.clear();
        this.mobileEntities.clear();
        this.lightSources.clear();
        this.spawnPoints.clear();
        this.soundSources.clear();
        this.mapAreas.clear();
        this.triggers.clear();
        this.ambientLight = null;
        this.staticShadowLayer = null;
        for (Map map : this.miscEntities.values()) {
            map.clear();
        }
        this.initialized = false;
        this.fireEvent(l -> l.cleared(this));
    }

    public boolean contains(IEntity entity) {
        return this.contains(entity.getMapId());
    }

    public boolean contains(int mapId) {
        return this.allEntities.containsKey(mapId);
    }

    public Collection<ICombatEntity> findCombatEntities(Shape shape) {
        return this.findCombatEntities(shape, entity -> true);
    }

    public Collection<ICombatEntity> findCombatEntities(Shape shape, Predicate<ICombatEntity> condition) {
        ArrayList<ICombatEntity> foundCombatEntities = new ArrayList<ICombatEntity>();
        if (shape == null) {
            return foundCombatEntities;
        }
        if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            for (ICombatEntity combatEntity : this.getCombatEntities().stream().filter(condition).toList()) {
                if (!combatEntity.getHitBox().intersects(rectangle2D)) continue;
                foundCombatEntities.add(combatEntity);
            }
            return foundCombatEntities;
        }
        for (ICombatEntity combatEntity : this.getCombatEntities().stream().filter(condition).toList()) {
            if (!combatEntity.getHitBox().intersects(shape.getBounds()) || !GeometricUtilities.shapeIntersects(combatEntity.getHitBox(), shape)) continue;
            foundCombatEntities.add(combatEntity);
        }
        return foundCombatEntities;
    }

    public Collection<IEntity> findEntities(Shape shape) {
        ArrayList<IEntity> foundEntities = new ArrayList<IEntity>();
        if (shape == null) {
            return foundEntities;
        }
        if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            for (IEntity entity : this.allEntities.values()) {
                if (!entity.getBoundingBox().intersects(rectangle2D)) continue;
                foundEntities.add(entity);
            }
            return foundEntities;
        }
        for (IEntity entity : this.allEntities.values()) {
            if (!entity.getBoundingBox().intersects(shape.getBounds()) || !GeometricUtilities.shapeIntersects(entity.getBoundingBox(), shape)) continue;
            foundEntities.add(entity);
        }
        return foundEntities;
    }

    public IEntity get(int mapId) {
        return this.allEntities.get(mapId);
    }

    public List<IEntity> get(int ... mapIds) {
        ArrayList<IEntity> foundEntities = new ArrayList<IEntity>();
        if (mapIds == null) {
            return foundEntities;
        }
        for (int id : mapIds) {
            IEntity entity = this.allEntities.get(id);
            if (entity == null) continue;
            foundEntities.add(entity);
        }
        return foundEntities;
    }

    public <T extends IEntity> T get(Class<T> clss, int mapId) {
        IEntity ent = this.get(mapId);
        if (!clss.isInstance(ent)) {
            return null;
        }
        return (T)((IEntity)clss.cast(ent));
    }

    public IEntity get(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        for (IEntity entity : this.allEntities.values()) {
            if (entity.getName() == null || !entity.getName().equals(name)) continue;
            return entity;
        }
        return null;
    }

    public <T extends IEntity> T get(Class<T> clss, String name) {
        IEntity ent = this.get(name);
        if (!clss.isInstance(ent)) {
            return null;
        }
        return (T)((IEntity)clss.cast(ent));
    }

    public Collection<IEntity> getByTag(String ... tags) {
        ArrayList<IEntity> foundEntities = new ArrayList<IEntity>();
        for (String rawTag : tags) {
            String tag = rawTag.toLowerCase();
            for (IEntity ent : (Collection)this.getEntitiesByTag().getOrDefault(tag, List.of())) {
                if (foundEntities.contains(ent)) continue;
                foundEntities.add(ent);
            }
        }
        return foundEntities;
    }

    public <T extends IEntity> Collection<T> getByTag(Class<? extends T> clss, String ... tags) {
        ArrayList<IEntity> foundEntities = new ArrayList<IEntity>();
        for (String rawTag : tags) {
            String tag = rawTag.toLowerCase();
            for (IEntity ent : (Collection)this.getEntitiesByTag().getOrDefault(tag, List.of())) {
                if (foundEntities.contains(ent) || !clss.isInstance(ent)) continue;
                foundEntities.add((IEntity)clss.cast(ent));
            }
        }
        return foundEntities;
    }

    public AmbientLight getAmbientLight() {
        return this.ambientLight;
    }

    public StaticShadowLayer getStaticShadowLayer() {
        return this.staticShadowLayer;
    }

    public Collection<Integer> getAllMapIDs() {
        return Collections.unmodifiableCollection(this.allEntities.keySet());
    }

    public Collection<MapArea> getAreas() {
        return Collections.unmodifiableCollection(this.mapAreas);
    }

    public Collection<MapArea> getAreas(String tag) {
        if (tag == null || tag.isEmpty()) {
            return this.getAreas();
        }
        return this.mapAreas.stream().filter(p -> p.hasTag(tag)).toList();
    }

    public MapArea getArea(int mapId) {
        return Environment.getById(this.mapAreas, mapId);
    }

    public MapArea getArea(String name) {
        return Environment.getByName(this.mapAreas, name);
    }

    public Collection<Emitter> getEmitters() {
        return Collections.unmodifiableCollection(this.emitters);
    }

    public Collection<Emitter> getEmitters(String tag) {
        if (tag == null || tag.isEmpty()) {
            return this.getEmitters();
        }
        return this.emitters.stream().filter(p -> p.hasTag(tag)).toList();
    }

    public Emitter getEmitter(int mapId) {
        return Environment.getById(this.emitters, mapId);
    }

    public Emitter getEmitter(String name) {
        return Environment.getByName(this.emitters, name);
    }

    public Collection<CollisionBox> getCollisionBoxes() {
        return Collections.unmodifiableCollection(this.colliders);
    }

    public Collection<CollisionBox> getCollisionBoxes(String tag) {
        if (tag == null || tag.isEmpty()) {
            return this.getCollisionBoxes();
        }
        return this.colliders.stream().filter(p -> p.hasTag(tag)).toList();
    }

    public CollisionBox getCollisionBox(int mapId) {
        return Environment.getById(this.colliders, mapId);
    }

    public CollisionBox getCollisionBox(String name) {
        return Environment.getByName(this.colliders, name);
    }

    public Collection<ICombatEntity> getCombatEntities() {
        return Collections.unmodifiableCollection(this.combatEntities.values());
    }

    public Collection<ICombatEntity> getCombatEntities(String tag) {
        if (tag == null || tag.isEmpty()) {
            return this.getCombatEntities();
        }
        return this.combatEntities.values().stream().filter(p -> p.hasTag(tag)).toList();
    }

    public ICombatEntity getCombatEntity(int mapId) {
        return Environment.getById(this.combatEntities.values(), mapId);
    }

    public ICombatEntity getCombatEntity(String name) {
        return Environment.getByName(this.combatEntities.values(), name);
    }

    public Collection<IEntity> getEntities() {
        return Collections.unmodifiableCollection(this.allEntities.values());
    }

    public <T> Collection<T> getEntities(Class<? extends T> cls) {
        ArrayList<T> foundEntities = new ArrayList<T>();
        for (IEntity ent : this.allEntities.values()) {
            if (!cls.isInstance(ent)) continue;
            foundEntities.add(cls.cast(ent));
        }
        return foundEntities;
    }

    public <T> Collection<T> getEntities(Class<? extends T> cls, String tag) {
        ArrayList<T> foundEntities = new ArrayList<T>();
        for (IEntity ent : this.allEntities.values()) {
            if (!cls.isInstance(ent) || !ent.hasTag(tag)) continue;
            foundEntities.add(cls.cast(ent));
        }
        return foundEntities;
    }

    public <T> Collection<T> getEntities(Class<? extends T> cls, Predicate<T> pred) {
        ArrayList<T> foundEntities = new ArrayList<T>();
        for (IEntity ent : this.allEntities.values()) {
            T entity;
            if (!cls.isInstance(ent) || !pred.test(entity = cls.cast(ent))) continue;
            foundEntities.add(entity);
        }
        return foundEntities;
    }

    public Collection<IEntity> getEntities(RenderType renderType) {
        return Collections.unmodifiableCollection(this.miscEntities.get((Object)renderType).values());
    }

    public Collection<IEntity> getEntities(IMapObjectLayer layer) {
        if (layer == null || !this.layerEntities.containsKey(layer)) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableCollection((Collection)this.layerEntities.get(layer));
    }

    public Collection<IEntity> getEntitiesByLayer(String name) {
        if (name == null || name.isEmpty()) {
            return Collections.emptySet();
        }
        for (Map.Entry<IMapObjectLayer, List<IEntity>> entry : this.layerEntities.entrySet()) {
            if (!name.equals(entry.getKey().getName())) continue;
            return Collections.unmodifiableCollection((Collection)entry.getValue());
        }
        return Collections.emptySet();
    }

    public Collection<IEntity> getEntitiesByLayer(int layerId) {
        for (Map.Entry<IMapObjectLayer, List<IEntity>> entry : this.layerEntities.entrySet()) {
            if (layerId != entry.getKey().getId()) continue;
            return Collections.unmodifiableCollection((Collection)entry.getValue());
        }
        return Collections.emptySet();
    }

    public Map<String, Collection<IEntity>> getEntitiesByTag() {
        return this.entitiesByTag;
    }

    public Collection<LightSource> getLightSources() {
        return Collections.unmodifiableCollection(this.lightSources);
    }

    public Collection<LightSource> getLightSources(String tag) {
        if (tag == null || tag.isEmpty()) {
            return this.getLightSources();
        }
        return this.lightSources.stream().filter(p -> p.hasTag(tag)).toList();
    }

    public LightSource getLightSource(int mapId) {
        return Environment.getById(this.lightSources, mapId);
    }

    public LightSource getLightSource(String name) {
        return Environment.getByName(this.lightSources, name);
    }

    public static synchronized int getLocalMapId() {
        return --localIdSequence;
    }

    public IMap getMap() {
        return this.map;
    }

    public Collection<IMobileEntity> getMobileEntities() {
        return Collections.unmodifiableCollection(this.mobileEntities.values());
    }

    public Collection<IMobileEntity> getMobileEntities(String tag) {
        if (tag == null || tag.isEmpty()) {
            return this.getMobileEntities();
        }
        return this.mobileEntities.values().stream().filter(p -> p.hasTag(tag)).toList();
    }

    public IMobileEntity getMobileEntity(int mapId) {
        return Environment.getById(this.mobileEntities.values(), mapId);
    }

    public IMobileEntity getMobileEntity(String name) {
        return Environment.getByName(this.mobileEntities.values(), name);
    }

    public synchronized int getNextMapId() {
        int maxMapID = MapUtilities.getMaxMapId(this.getMap());
        return ++maxMapID;
    }

    public Collection<IRenderable> getRenderables(RenderType renderType) {
        return Collections.unmodifiableCollection(this.renderables.get((Object)renderType));
    }

    public Collection<Prop> getProps() {
        return Collections.unmodifiableCollection(this.props);
    }

    public Collection<Prop> getProps(String tag) {
        if (tag == null || tag.isEmpty()) {
            return this.getProps();
        }
        return this.props.stream().filter(p -> p.hasTag(tag)).toList();
    }

    public Prop getProp(int mapId) {
        return Environment.getById(this.props, mapId);
    }

    public Prop getProp(String name) {
        return Environment.getByName(this.props, name);
    }

    public Collection<Creature> getCreatures() {
        return Collections.unmodifiableCollection(this.creatures);
    }

    public Collection<Creature> getCreatures(String tag) {
        if (tag == null || tag.isEmpty()) {
            return this.getCreatures();
        }
        return this.creatures.stream().filter(p -> p.hasTag(tag)).toList();
    }

    public Creature getCreature(int mapId) {
        return Environment.getById(this.creatures, mapId);
    }

    public Creature getCreature(String name) {
        return Environment.getByName(this.creatures, name);
    }

    public Collection<Spawnpoint> getSpawnpoints() {
        return Collections.unmodifiableCollection(this.spawnPoints);
    }

    public Collection<Spawnpoint> getSpawnpoints(String tag) {
        if (tag == null || tag.isEmpty()) {
            return this.getSpawnpoints();
        }
        return this.spawnPoints.stream().filter(p -> p.hasTag(tag)).toList();
    }

    public Spawnpoint getSpawnpoint(int mapId) {
        return Environment.getById(this.spawnPoints, mapId);
    }

    public Spawnpoint getSpawnpoint(String name) {
        return Environment.getByName(this.spawnPoints, name);
    }

    public Collection<SoundSource> getSoundSources() {
        return Collections.unmodifiableCollection(this.soundSources);
    }

    public Collection<SoundSource> getSoundSources(String tag) {
        if (tag == null || tag.isEmpty()) {
            return this.getSoundSources();
        }
        return this.soundSources.stream().filter(p -> p.hasTag(tag)).toList();
    }

    public SoundSource getSoundSource(int mapId) {
        return Environment.getById(this.soundSources, mapId);
    }

    public SoundSource getSoundSource(String name) {
        return Environment.getByName(this.soundSources, name);
    }

    public Collection<StaticShadow> getStaticShadows() {
        return Collections.unmodifiableCollection(this.staticShadows);
    }

    public Collection<StaticShadow> getStaticShadows(String tag) {
        if (tag == null || tag.isEmpty()) {
            return this.getStaticShadows();
        }
        return this.staticShadows.stream().filter(p -> p.hasTag(tag)).toList();
    }

    public StaticShadow getStaticShadow(int mapId) {
        return Environment.getById(this.staticShadows, mapId);
    }

    public StaticShadow getStaticShadow(String name) {
        return Environment.getByName(this.staticShadows, name);
    }

    public Collection<Trigger> getTriggers() {
        return Collections.unmodifiableCollection(this.triggers);
    }

    public Collection<Trigger> getTriggers(String tag) {
        if (tag == null || tag.isEmpty()) {
            return this.getTriggers();
        }
        return this.triggers.stream().filter(p -> p.hasTag(tag)).toList();
    }

    public Trigger getTrigger(int mapId) {
        return Environment.getById(this.triggers, mapId);
    }

    public Trigger getTrigger(String name) {
        return Environment.getByName(this.triggers, name);
    }

    public Collection<String> getUsedTags() {
        return Collections.unmodifiableCollection(this.getEntitiesByTag().keySet());
    }

    public Point2D getCenter() {
        return new Point2D.Double(this.getMap().getSizeInPixels().getWidth() / 2.0, this.getMap().getSizeInPixels().getHeight() / 2.0);
    }

    public void init() {
        if (this.initialized) {
            return;
        }
        if (this.getMap() != null) {
            this.loadMapObjects();
            this.addStaticShadows();
            this.addAmbientLight();
        }
        this.fireEvent(l -> l.initialized(this));
        this.initialized = true;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void load() {
        this.init();
        if (this.loaded) {
            return;
        }
        if (this.getMap() != null) {
            Game.physics().setBounds(new Rectangle2D.Double(0.0, 0.0, this.getMap().getSizeInPixels().getWidth(), this.getMap().getSizeInPixels().getHeight()));
        }
        this.allEntities.values().forEach(this::load);
        this.updateLighting();
        this.loaded = true;
        this.fireEvent(l -> l.loaded(this));
    }

    public boolean loadFromMap(int mapId) {
        for (IMapObjectLayer layer : this.getMap().getMapObjectLayers()) {
            Optional<IMapObject> opt = layer.getMapObjects().stream().filter(mapObject -> mapObject.getType() != null && !mapObject.getType().isEmpty() && mapObject.getId() == mapId).findFirst();
            if (!opt.isPresent()) continue;
            return !this.load(opt.get()).isEmpty();
        }
        return false;
    }

    public void reloadFromMap(int mapId) {
        this.remove(mapId);
        this.loadFromMap(mapId);
    }

    public Collection<IEntity> load(IMapObject mapObject) {
        if (mapObject == null) {
            return Collections.emptySet();
        }
        IMapObjectLoader loader = mapObject.getType() == null || mapObject.getType().isEmpty() ? (IMapObjectLoader)mapObjectLoaders.getOrDefault("UNDEFINED", null) : mapObjectLoaders.get(mapObject.getType());
        if (loader != null) {
            Collection<IEntity> loadedEntities = loader.load(this, mapObject);
            loader.afterLoad(loadedEntities, mapObject);
            for (IEntity entity : loadedEntities) {
                if (entity == null) continue;
                if (mapObject.getLayer() != null && entity.renderWithLayer()) {
                    this.addEntity(entity);
                    this.layerEntities.computeIfAbsent(mapObject.getLayer(), m -> new CopyOnWriteArrayList()).add(entity);
                    this.fireEntityEvent(l -> l.entityAdded(entity));
                    continue;
                }
                this.add(entity);
            }
            return loadedEntities;
        }
        return Collections.emptySet();
    }

    public Trigger interact(ICollisionEntity source) {
        return this.interact(source, null);
    }

    public Trigger interact(ICollisionEntity source, Predicate<Trigger> condition) {
        for (Trigger trigger : this.triggers) {
            boolean result;
            if (!trigger.canTrigger(source) || condition != null && !condition.test(trigger) || !(result = trigger.interact(source))) continue;
            return trigger;
        }
        return null;
    }

    public void remove(IEntity entity) {
        if (entity == null) {
            return;
        }
        this.allEntities.remove(entity.getMapId());
        this.layerEntities.values().removeIf(layer -> layer.remove(entity) && layer.isEmpty());
        if (this.miscEntities.get((Object)entity.getRenderType()) != null) {
            this.miscEntities.get((Object)entity.getRenderType()).values().remove(entity);
        }
        for (String tag : entity.getTags()) {
            if (!this.getEntitiesByTag().containsKey(tag)) continue;
            this.getEntitiesByTag().get(tag).remove(entity);
            if (!this.getEntitiesByTag().get(tag).isEmpty()) continue;
            this.getEntitiesByTag().remove(tag);
        }
        if (entity instanceof Emitter) {
            Emitter emitter = (Emitter)entity;
            this.removeEmitter(emitter);
        }
        if (entity instanceof MapArea) {
            MapArea mapArea = (MapArea)entity;
            this.mapAreas.remove(mapArea);
        }
        if (entity instanceof Prop) {
            this.props.remove(entity);
        }
        if (entity instanceof Creature) {
            this.creatures.remove(entity);
        }
        if (entity instanceof CollisionBox) {
            this.colliders.remove(entity);
            this.staticShadows.removeIf(x -> x.getOrigin() != null && x.getOrigin().equals(entity));
        }
        if (entity instanceof LightSource) {
            this.lightSources.remove(entity);
            this.updateLighting(entity);
        }
        if (entity instanceof Trigger) {
            this.triggers.remove(entity);
        }
        if (entity instanceof Spawnpoint) {
            this.spawnPoints.remove(entity);
        }
        if (entity instanceof SoundSource) {
            this.soundSources.remove(entity);
        }
        if (entity instanceof StaticShadow) {
            this.staticShadows.remove(entity);
            this.updateLighting(entity);
        }
        if (entity instanceof IMobileEntity) {
            this.mobileEntities.values().remove(entity);
        }
        if (entity instanceof ICombatEntity) {
            this.combatEntities.values().remove(entity);
        }
        this.unload(entity);
        this.fireEntityEvent(l -> l.entityRemoved(entity));
    }

    public void remove(int mapId) {
        IEntity ent = this.get(mapId);
        if (ent == null) {
            return;
        }
        this.remove(ent);
    }

    public void remove(String name) {
        IEntity ent = this.get(name);
        if (ent == null) {
            return;
        }
        this.remove(ent);
    }

    public <T extends IEntity> void removeAll(Iterable<T> entities) {
        if (entities == null) {
            return;
        }
        for (IEntity ent : entities) {
            this.remove(ent);
        }
    }

    public void removeAll(IEntity ... entities) {
        this.removeAll(Arrays.asList(entities));
    }

    public void removeRenderable(IRenderable renderable) {
        for (Collection<IRenderable> rends : this.renderables.values()) {
            rends.remove(renderable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(Graphics2D g) {
        long renderStart = System.nanoTime();
        AffineTransform otx = g.getTransform();
        this.rendering = true;
        try {
            g.scale(Game.world().camera().getRenderScale(), Game.world().camera().getRenderScale());
            if (this.getMap() != null && this.getMap().getBackgroundColor() != null) {
                g.setColor(this.getMap().getBackgroundColor());
                g.fill(new Rectangle2D.Double(0.0, 0.0, Game.world().camera().getViewport().getWidth(), Game.world().camera().getViewport().getHeight()));
            }
            this.render(g, RenderType.BACKGROUND);
            this.render(g, RenderType.GROUND);
            DebugRenderer.renderMapDebugInfo(g, this.getMap());
            this.render(g, RenderType.SURFACE);
            this.render(g, RenderType.NORMAL);
            this.render(g, RenderType.OVERLAY);
            long ambientStart = System.nanoTime();
            if (Game.config().graphics().getGraphicQuality().ordinal() >= Quality.MEDIUM.ordinal() && this.getAmbientLight() != null && this.getAmbientLight().getColor().getAlpha() != 0) {
                this.getAmbientLight().render(g);
            }
            double ambientTime = TimeUtilities.nanoToMs(System.nanoTime() - ambientStart);
            long shadowRenderStart = System.nanoTime();
            if (this.getStaticShadows().stream().anyMatch(x -> x.getShadowType() != StaticShadowType.NONE)) {
                this.getStaticShadowLayer().render(g);
            }
            double shadowTime = TimeUtilities.nanoToMs(System.nanoTime() - shadowRenderStart);
            this.render(g, RenderType.UI);
            if (Game.config().debug().trackRenderTimes()) {
                double totalRenderTime = TimeUtilities.nanoToMs(System.nanoTime() - renderStart);
                Game.metrics().trackRenderTime("shadow", shadowTime, new GameMetrics.RenderInfo[0]);
                Game.metrics().trackRenderTime("ambient", ambientTime, new GameMetrics.RenderInfo[0]);
                Game.metrics().trackRenderTime("world", totalRenderTime, new GameMetrics.RenderInfo[0]);
            }
        }
        finally {
            this.rendering = false;
            g.setTransform(otx);
        }
    }

    public int getGravity() {
        return this.gravity;
    }

    public void setGravity(int gravity) {
        this.gravity = gravity;
        if (this.getGravity() != 0) {
            for (IMobileEntity entity : this.mobileEntities.values()) {
                if (this.gravityForces.containsKey(entity.getMapId())) {
                    this.gravityForces.get(entity.getMapId()).setStrength(this.gravity);
                    continue;
                }
                this.addGravityForce(entity);
            }
        } else {
            for (IMobileEntity entity : this.mobileEntities.values()) {
                this.removeGravity(entity);
            }
        }
    }

    public void unload() {
        if (!this.loaded) {
            return;
        }
        for (IEntity entity : this.allEntities.values()) {
            this.unload(entity);
        }
        this.loaded = false;
        this.fireEvent(l -> l.unloaded(this));
    }

    public boolean isRendering() {
        return this.rendering;
    }

    private static <T extends IEntity> T getById(Collection<T> entities, int mapId) {
        for (IEntity m : entities) {
            if (m.getMapId() != mapId) continue;
            return (T)m;
        }
        return null;
    }

    private static <T extends IEntity> T getByName(Collection<T> entities, String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        for (IEntity m : entities) {
            if (m.getName() == null || !m.getName().equals(name)) continue;
            return (T)m;
        }
        return null;
    }

    private static void loadPhysicsEntity(IEntity entity) {
        ICollisionEntity iCollisionEntity;
        if (entity instanceof ICollisionEntity && (iCollisionEntity = (ICollisionEntity)entity).hasCollision()) {
            Game.physics().add(iCollisionEntity);
        }
    }

    private static void loadUpdatableOrEmitterEntity(IEntity entity) {
        if (entity instanceof Emitter) {
            Emitter emitter = (Emitter)entity;
            if (emitter.isActivateOnInit()) {
                emitter.activate();
            }
        } else if (entity instanceof IUpdateable) {
            IUpdateable iUpdateable = (IUpdateable)((Object)entity);
            Game.loop().attach(iUpdateable);
        }
    }

    private static void dispose(Collection<? extends IEntity> entities) {
        for (IEntity iEntity : entities) {
            if (iEntity instanceof IUpdateable) {
                IUpdateable iUpdateable = (IUpdateable)((Object)iEntity);
                Game.loop().detach(iUpdateable);
            }
            iEntity.detachControllers();
        }
    }

    private void render(Graphics2D g, RenderType renderType) {
        long renderStart = System.nanoTime();
        if (this.getMap() != null) {
            MapRenderer.render(g, this.getMap(), Game.world().camera().getViewport(), this, renderType);
        }
        for (IRenderable rend : this.getRenderables(renderType)) {
            rend.render(g);
        }
        Game.graphics().renderEntities(g, this.miscEntities.get((Object)renderType).values(), renderType == RenderType.NORMAL);
        this.fireRenderEvent(g, renderType);
        if (Game.config().debug().trackRenderTimes() && this.getMap() != null) {
            double renderTime = TimeUtilities.nanoToMs(System.nanoTime() - renderStart);
            Game.metrics().trackRenderTime(renderType.toString().toLowerCase(), renderTime, new GameMetrics.RenderInfo("layers", this.getMap().getRenderLayers().stream().filter(l -> l.getRenderType() == renderType).count()), new GameMetrics.RenderInfo("renderables", this.getRenderables(renderType).size()), new GameMetrics.RenderInfo("entities", this.miscEntities.get((Object)renderType).size()));
        }
    }

    private void addAmbientLight() {
        Color ambientColor = this.getMap().getColorValue("AMBIENTLIGHT", AmbientLight.DEFAULT_COLOR);
        this.ambientLight = new AmbientLight(this, ambientColor);
    }

    private void addStaticShadows() {
        Color color = this.getMap().getColorValue("SHADOWCOLOR", StaticShadow.DEFAULT_COLOR);
        this.staticShadowLayer = new StaticShadowLayer(this, color);
    }

    private void load(IEntity entity) {
        if (entity.getEnvironment() != null) {
            entity.getEnvironment().remove(entity);
        }
        Environment.loadPhysicsEntity(entity);
        Environment.loadUpdatableOrEmitterEntity(entity);
        if (entity instanceof IMobileEntity) {
            IMobileEntity iMobileEntity = (IMobileEntity)entity;
            if (this.getGravity() != 0) {
                this.addGravityForce(iMobileEntity);
            }
        }
        entity.attachControllers();
        if (this.loaded && (entity instanceof LightSource || entity instanceof StaticShadow)) {
            this.updateLighting(entity);
        }
        entity.loaded(this);
    }

    private void addGravityForce(IMobileEntity entity) {
        IMovementController mvmtControl = entity.movement();
        if (mvmtControl != null) {
            GravityForce force = new GravityForce((IEntity)entity, (float)this.getGravity(), Direction.DOWN);
            force.setIdentifier(GRAVITY_IDENTIFIER);
            entity.movement().apply(force);
            this.gravityForces.put(entity.getMapId(), force);
        }
    }

    private void removeGravity(IMobileEntity entity) {
        if (this.gravityForces.containsKey(entity.getMapId())) {
            this.gravityForces.get(entity.getMapId()).end();
        }
    }

    private void loadMapObjects() {
        for (IMapObjectLayer layer : this.getMap().getMapObjectLayers()) {
            for (IMapObject mapObject : layer.getMapObjects()) {
                this.load(mapObject);
            }
        }
    }

    private void unload(IEntity entity) {
        if (entity instanceof ICollisionEntity) {
            ICollisionEntity iCollisionEntity = (ICollisionEntity)entity;
            Game.physics().remove(iCollisionEntity);
        }
        if (entity instanceof IUpdateable) {
            IUpdateable iUpdateable = (IUpdateable)((Object)entity);
            Game.loop().detach(iUpdateable);
        }
        if (entity instanceof IMobileEntity) {
            IMobileEntity iMobileEntity = (IMobileEntity)entity;
            this.removeGravity(iMobileEntity);
        }
        entity.detachControllers();
        if (entity instanceof Emitter) {
            Emitter emitter = (Emitter)entity;
            emitter.deactivate();
        }
        if (this.loaded && (entity instanceof LightSource || entity instanceof StaticShadow)) {
            this.updateLighting(entity);
        }
        entity.removed(this);
    }

    private void addEntity(IEntity entity) {
        int desiredID = entity.getMapId();
        if (desiredID == 0 || this.allEntities.containsKey(desiredID)) {
            entity.setMapId(Environment.getLocalMapId());
            log.fine(() -> String.format("Entity [%s] was assigned a local mapID because #%d was already taken or invalid.", entity, desiredID));
        }
        if (entity instanceof Emitter) {
            Emitter emitter = (Emitter)entity;
            this.addEmitter(emitter);
        }
        if (entity instanceof ICombatEntity) {
            ICombatEntity iCombatEntity = (ICombatEntity)entity;
            this.combatEntities.put(entity.getMapId(), iCombatEntity);
        }
        if (entity instanceof IMobileEntity) {
            IMobileEntity iMobileEntity = (IMobileEntity)entity;
            this.mobileEntities.put(entity.getMapId(), iMobileEntity);
        }
        if (entity instanceof Prop) {
            Prop prop = (Prop)entity;
            this.props.add(prop);
        }
        if (entity instanceof Creature) {
            Creature creature = (Creature)entity;
            this.creatures.add(creature);
        }
        if (entity instanceof CollisionBox) {
            CollisionBox collisionBox = (CollisionBox)entity;
            this.colliders.add(collisionBox);
        }
        if (entity instanceof LightSource) {
            LightSource lightSource = (LightSource)entity;
            this.lightSources.add(lightSource);
        }
        if (entity instanceof Trigger) {
            Trigger trigger = (Trigger)entity;
            this.triggers.add(trigger);
        }
        if (entity instanceof Spawnpoint) {
            Spawnpoint spawnpoint = (Spawnpoint)entity;
            this.spawnPoints.add(spawnpoint);
        }
        if (entity instanceof SoundSource) {
            SoundSource soundSource = (SoundSource)entity;
            this.soundSources.add(soundSource);
        }
        if (entity instanceof StaticShadow) {
            StaticShadow staticShadow = (StaticShadow)entity;
            this.staticShadows.add(staticShadow);
        } else if (entity instanceof MapArea) {
            MapArea mapArea = (MapArea)entity;
            this.mapAreas.add(mapArea);
        }
        for (String rawTag : entity.getTags()) {
            String tag;
            if (rawTag == null || (tag = rawTag.trim().toLowerCase()).isEmpty()) continue;
            this.getEntitiesByTag().computeIfAbsent(tag, t -> new CopyOnWriteArrayList()).add(entity);
        }
        if (this.loaded) {
            this.load(entity);
        }
        this.allEntities.put(entity.getMapId(), entity);
    }

    private void addEmitter(Emitter emitter) {
        this.manageEmitterRenderables(emitter, Collection::add);
        this.emitters.add(emitter);
    }

    private void removeEmitter(Emitter emitter) {
        this.manageEmitterRenderables(emitter, Collection::remove);
        this.emitters.remove(emitter);
    }

    private void manageEmitterRenderables(Emitter emitter, BiConsumer<Collection<IRenderable>, IRenderable> cons) {
        for (RenderType renderType : RenderType.values()) {
            IRenderable renderable;
            if (renderType == RenderType.NONE || (renderable = emitter.getRenderable(renderType)) == null) continue;
            cons.accept(this.renderables.get((Object)renderType), renderable);
        }
        this.emitters.remove(emitter);
    }

    public void assignRenderType(IEntity entity, RenderType renderType) {
        this.miscEntities.get((Object)entity.getRenderType()).remove(entity.getMapId());
        this.miscEntities.get((Object)renderType).put(entity.getMapId(), entity);
    }

    private void updateLighting(IEntity entity) {
        if (entity instanceof StaticShadow) {
            StaticShadow staticShadow = (StaticShadow)entity;
            this.updateLighting(staticShadow.getArea() != null ? staticShadow.getArea().getBounds2D() : staticShadow.getBoundingBox());
            return;
        }
        this.updateLighting(entity.getBoundingBox());
    }

    private void fireEvent(Consumer<EnvironmentListener> cons) {
        for (EnvironmentListener listener : this.listeners) {
            cons.accept(listener);
        }
    }

    private void fireRenderEvent(Graphics2D g, RenderType type) {
        for (EnvironmentRenderedListener listener : this.renderListeners.get((Object)type)) {
            listener.rendered(g, type);
        }
    }

    private void fireEntityEvent(Consumer<EnvironmentEntityListener> cons) {
        for (EnvironmentEntityListener listener : this.entityListeners) {
            cons.accept(listener);
        }
    }

    static {
        Environment.registerMapObjectLoader(new PropMapObjectLoader());
        Environment.registerMapObjectLoader(new CollisionBoxMapObjectLoader());
        Environment.registerMapObjectLoader(new TriggerMapObjectLoader());
        Environment.registerMapObjectLoader(new EmitterMapObjectLoader());
        Environment.registerMapObjectLoader(new LightSourceMapObjectLoader());
        Environment.registerMapObjectLoader(new SpawnpointMapObjectLoader());
        Environment.registerMapObjectLoader(new MapAreaMapObjectLoader());
        Environment.registerMapObjectLoader(new StaticShadowMapObjectLoader());
        Environment.registerMapObjectLoader(new CreatureMapObjectLoader());
        Environment.registerMapObjectLoader(new SoundSourceMapObjectLoader());
    }
}

