/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.entities.CollisionBox;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.entities.StaticShadow;
import de.gurkenlabs.litiengine.environment.Environment;
import de.gurkenlabs.litiengine.environment.MapObjectLoader;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import java.util.ArrayList;
import java.util.Collection;

public class CollisionBoxMapObjectLoader
extends MapObjectLoader {
    protected CollisionBoxMapObjectLoader() {
        super(MapObjectType.COLLISIONBOX);
    }

    @Override
    public Collection<IEntity> load(Environment environment, IMapObject mapObject) {
        ArrayList<IEntity> entities = new ArrayList<IEntity>();
        if (!this.isMatchingType(mapObject)) {
            return entities;
        }
        CollisionBox col = this.createCollisionBox(mapObject);
        CollisionBoxMapObjectLoader.loadDefaultProperties(col, mapObject);
        col.setCollisionBoxWidth(col.getWidth());
        col.setCollisionBoxHeight(col.getHeight());
        entities.add(col);
        if (col.isObstructingLight()) {
            entities.add(new StaticShadow(col));
        }
        return entities;
    }

    protected CollisionBox createCollisionBox(IMapObject mapObject) {
        return new CollisionBox();
    }
}

