/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.entities.behavior;

import de.gurkenlabs.litiengine.entities.behavior.State;

public abstract class Transition
implements Comparable<Transition> {
    private final int priority;
    private State targetState;

    protected Transition(int priority) {
        this.priority = priority;
    }

    protected Transition(int priority, State targetState) {
        this(priority);
        this.targetState = targetState;
    }

    @Override
    public int compareTo(Transition other) {
        return Integer.compare(this.getPriority(), other.getPriority());
    }

    public State getNextState() {
        return this.targetState;
    }

    public int getPriority() {
        return this.priority;
    }

    protected abstract boolean conditionsFullfilled();
}

