/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.graphics.IRenderable;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class GameMetrics
implements IRenderable {
    private static final Font TITLE_FONT = new Font("Monospaced", 1, 12);
    private static final Font METRIC_FONT = new Font("Monospaced", 0, 12);
    private static final int OFFSET_X = 5;
    private static final int OFFSET_Y = 14;
    private final List<RenderMetrics> renderMetrics;
    private final Runtime runtime;
    private final String javaVersion;
    private Color renderColor = Color.RED;
    private int currentOffsetY;
    private int framesPerSecond;
    private int maxFramesPerSecond;
    private float usedMemory;

    GameMetrics() {
        this.renderMetrics = new CopyOnWriteArrayList<RenderMetrics>();
        this.runtime = Runtime.getRuntime();
        this.javaVersion = System.getProperty("java.version") + " (VM: " + System.getProperty("java.vm.name") + ", VENDOR: " + System.getProperty("java.vendor") + ")";
    }

    public int getFramesPerSecond() {
        return this.framesPerSecond;
    }

    public float getUsedMemory() {
        return this.usedMemory;
    }

    public Color getRenderColor() {
        return this.renderColor;
    }

    public void trackRenderTime(String name, double renderTime, RenderInfo ... infos) {
        this.renderMetrics.add(new RenderMetrics(this, name, renderTime, infos));
    }

    @Override
    public void render(Graphics2D g) {
        this.updateMetrics();
        if (!Game.config().client().showGameMetrics()) {
            return;
        }
        this.currentOffsetY = 0;
        g.setColor(this.renderColor);
        this.drawTitle(g, "[client]");
        this.drawMetric(g, "fps       : " + this.getFramesPerSecond());
        this.drawMetric(g, "max fps   : " + this.maxFramesPerSecond);
        this.drawMetric(g, "updatables: " + Game.loop().getUpdatableCount());
        if (Game.config().debug().isDebugEnabled()) {
            this.drawTitle(g, "[jvm]");
            this.drawMetric(g, "java      : " + this.javaVersion);
            this.drawMetric(g, "memory    : " + String.format("%-5.5s", Float.valueOf(this.usedMemory)) + " MB");
            this.drawMetric(g, "threads   : " + Thread.activeCount());
        }
        if (!this.renderMetrics.isEmpty()) {
            this.drawTitle(g, "[update]");
            for (RenderMetrics metric : this.renderMetrics) {
                this.drawMetric(g, metric.toString());
            }
            this.renderMetrics.clear();
        }
    }

    void setFramesPerSecond(int currentFramesPerSecond) {
        this.framesPerSecond = currentFramesPerSecond;
    }

    void setEstimatedMaxFramesPerSecond(int maxFrames) {
        this.maxFramesPerSecond = maxFrames;
    }

    public void setRenderColor(Color color) {
        this.renderColor = color;
    }

    private void updateMetrics() {
        this.usedMemory = (float)Math.round((float)(this.runtime.totalMemory() - this.runtime.freeMemory()) / 1048576.0f * 10.0f) * 0.1f;
    }

    private void drawTitle(Graphics2D g, String title) {
        this.currentOffsetY += 14;
        g.setFont(TITLE_FONT);
        g.drawString(title, 5, this.currentOffsetY);
        this.currentOffsetY += 14;
    }

    private void drawMetric(Graphics2D g, String metric) {
        g.setFont(METRIC_FONT);
        g.drawString(metric, 5, this.currentOffsetY);
        this.currentOffsetY += 14;
    }

    public class RenderMetrics {
        private final List<RenderInfo> renderInfo = new ArrayList<RenderInfo>();
        private final String renderName;
        private final double renderTime;

        RenderMetrics(GameMetrics this$0, String name, double renderTime, RenderInfo ... infos) {
            this.renderInfo.addAll(Arrays.asList(infos));
            this.renderName = name;
            this.renderTime = renderTime;
        }

        public String getRenderName() {
            return this.renderName;
        }

        public double getRenderTime() {
            return this.renderTime;
        }

        public List<RenderInfo> getRenderInfos() {
            return this.renderInfo;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("%-10.10s", this.getRenderName()));
            sb.append(": ");
            sb.append(String.format("%-4.4f", this.getRenderTime()));
            sb.append(" ms");
            if (!this.renderInfo.isEmpty()) {
                sb.append(" ");
                for (RenderInfo info : this.getRenderInfos()) {
                    sb.append(info);
                }
            }
            return sb.toString();
        }
    }

    public static class RenderInfo {
        private final String name;
        private final Object value;

        public RenderInfo(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return "[" + this.getName() + ": " + String.valueOf(this.getValue()) + "]";
        }
    }
}

