/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.resources;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.GameListener;
import de.gurkenlabs.litiengine.resources.ResourceLoadException;
import de.gurkenlabs.litiengine.resources.Resources;
import de.gurkenlabs.litiengine.resources.ResourcesContainerClearedListener;
import de.gurkenlabs.litiengine.resources.ResourcesContainerListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.function.Supplier;

public abstract class ResourcesContainer<T> {
    private static final ExecutorService ASYNC_POOL = Executors.newWorkStealingPool();
    private final Map<String, T> resources = new ConcurrentHashMap<String, T>();
    private final Map<String, String> aliases = new ConcurrentHashMap<String, String>();
    private final List<ResourcesContainerListener<? super T>> listeners = new CopyOnWriteArrayList<ResourcesContainerListener<? super T>>();
    private final List<ResourcesContainerClearedListener> clearedListeners = new CopyOnWriteArrayList<ResourcesContainerClearedListener>();

    public void addContainerListener(ResourcesContainerListener<? super T> listener) {
        this.listeners.add(listener);
    }

    public void removeContainerListener(ResourcesContainerListener<T> listener) {
        this.listeners.remove(listener);
    }

    public void addClearedListener(ResourcesContainerClearedListener listener) {
        this.clearedListeners.add(listener);
    }

    public void removeClearedListener(ResourcesContainerClearedListener listener) {
        this.clearedListeners.remove(listener);
    }

    public void add(String resourceName, T resource) {
        this.resources.put(resourceName, resource);
        for (ResourcesContainerListener<T> listener : this.listeners) {
            listener.added(resourceName, resource);
        }
    }

    public void add(URL resourceName, T resource) {
        this.add(resourceName.toString(), resource);
    }

    public void clear() {
        this.resources.clear();
        for (ResourcesContainerListener<T> listener : this.listeners) {
            listener.cleared();
        }
    }

    public boolean contains(String resourceName) {
        return this.resources.containsKey(this.getIdentifier(resourceName));
    }

    public boolean contains(URL resourceName) {
        return this.contains(resourceName.toString());
    }

    public boolean contains(T resource) {
        return this.resources.containsValue(resource);
    }

    public int count() {
        return this.resources.size();
    }

    public Collection<T> get(Predicate<? super T> pred) {
        if (pred == null) {
            return new ArrayList();
        }
        return this.resources.values().stream().filter(pred).toList();
    }

    public T get(String resourceName) {
        return this.get(this.getIdentifier(resourceName), false);
    }

    public T get(URL resourceName) {
        return this.get(resourceName, false);
    }

    public T get(String resourceName, Supplier<? extends T> loadCallback) {
        Optional<T> opt = this.tryGet(resourceName);
        if (opt.isPresent()) {
            return opt.get();
        }
        T resource = loadCallback.get();
        if (resource != null) {
            this.add(resourceName, resource);
        }
        return resource;
    }

    public T get(URL resourceName, Supplier<? extends T> loadCallback) {
        return this.get(resourceName.toString(), loadCallback);
    }

    public T get(String resourceName, boolean forceLoad) {
        if (resourceName == null) {
            return null;
        }
        if (forceLoad) {
            T resource = this.loadResource(resourceName);
            if (resource == null) {
                return null;
            }
            this.resources.put(resourceName, resource);
            return resource;
        }
        return (T)this.resources.computeIfAbsent(resourceName, this::loadResource);
    }

    public T get(URL resourceName, boolean forceLoad) {
        return this.get(resourceName.toString(), forceLoad);
    }

    public Future<T> getAsync(URL location) {
        return ASYNC_POOL.submit(() -> this.get(location));
    }

    public Future<T> getAsync(String name) {
        return this.getAsync(Resources.getLocation(this.getIdentifier(name)));
    }

    public Collection<T> getAll() {
        return this.resources.values();
    }

    public T remove(String resourceName) {
        T removedResource = this.resources.remove(resourceName);
        if (removedResource != null) {
            for (ResourcesContainerListener<T> listener : this.listeners) {
                listener.removed(resourceName, removedResource);
            }
        }
        return removedResource;
    }

    public T remove(URL resourceName) {
        return this.remove(resourceName.toString());
    }

    public Optional<T> tryGet(String resourceName) {
        if (this.contains(resourceName)) {
            return Optional.of(this.get(resourceName));
        }
        return Optional.empty();
    }

    public Optional<T> tryGet(URL resourceName) {
        return this.tryGet(resourceName.getPath());
    }

    protected abstract T load(URL var1) throws Exception;

    protected String getAlias(String resourceName, T resource) {
        return null;
    }

    protected Map<String, T> getResources() {
        return this.resources;
    }

    private T loadResource(String identifier) {
        T newResource;
        try {
            newResource = this.load(Resources.getLocation(identifier));
        }
        catch (Exception e) {
            throw new ResourceLoadException(e);
        }
        for (ResourcesContainerListener<T> listener : this.listeners) {
            listener.added(identifier, newResource);
        }
        String alias = this.getAlias(identifier, newResource);
        if (alias != null) {
            this.aliases.put(alias, identifier);
        }
        return newResource;
    }

    private String getIdentifier(String resourceName) {
        return this.aliases.getOrDefault(resourceName, resourceName);
    }

    static {
        Game.addGameListener(new GameListener(){

            @Override
            public void terminated() {
                ASYNC_POOL.shutdownNow();
            }
        });
    }
}

