/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.resources;

import de.gurkenlabs.litiengine.environment.tilemap.ITileset;
import de.gurkenlabs.litiengine.environment.tilemap.xml.Blueprint;
import de.gurkenlabs.litiengine.environment.tilemap.xml.Tileset;
import de.gurkenlabs.litiengine.environment.tilemap.xml.TmxMap;
import de.gurkenlabs.litiengine.graphics.emitters.xml.EmitterData;
import de.gurkenlabs.litiengine.resources.Resources;
import de.gurkenlabs.litiengine.resources.SoundResource;
import de.gurkenlabs.litiengine.resources.SpritesheetResource;
import de.gurkenlabs.litiengine.util.io.XmlUtilities;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipException;

@XmlRootElement(name="litidata")
public class ResourceBundle
implements Serializable {
    private static final Logger log = Logger.getLogger(ResourceBundle.class.getName());
    public static final String FILE_EXTENSION = "litidata";
    public static final float CURRENT_VERSION = 1.0f;
    private static final long serialVersionUID = -2101786184799276518L;
    @XmlAttribute(name="version")
    private float version;
    @XmlElementWrapper(name="maps")
    @XmlElement(name="map")
    private final List<TmxMap> maps;
    @XmlElementWrapper(name="spriteSheets")
    @XmlElement(name="sprite")
    private List<SpritesheetResource> spriteSheets = new ArrayList<SpritesheetResource>();
    @XmlElementWrapper(name="tilesets")
    @XmlElement(name="tileset")
    private List<Tileset> tilesets;
    @XmlElementWrapper(name="emitters")
    @XmlElement(name="emitter")
    private final List<EmitterData> emitters;
    @XmlElementWrapper(name="blueprints")
    @XmlElement(name="blueprint")
    private final List<Blueprint> blueprints;
    @XmlElementWrapper(name="sounds")
    @XmlElement(name="sound")
    private final List<SoundResource> sounds;

    public ResourceBundle() {
        this.maps = new ArrayList<TmxMap>();
        this.tilesets = new ArrayList<Tileset>();
        this.emitters = new ArrayList<EmitterData>();
        this.blueprints = new ArrayList<Blueprint>();
        this.sounds = new ArrayList<SoundResource>();
    }

    public static ResourceBundle load(String file) {
        return ResourceBundle.load(Resources.getLocation(file));
    }

    public static ResourceBundle load(URL file) {
        try {
            ResourceBundle gameFile = ResourceBundle.getResourceBundle(file);
            if (gameFile == null) {
                return null;
            }
            for (Tileset tileset : gameFile.getTilesets()) {
                tileset.finish(file);
            }
            for (TmxMap map : gameFile.getMaps()) {
                for (ITileset tileset : map.getTilesets()) {
                    if (!(tileset instanceof Tileset)) continue;
                    Tileset ts = (Tileset)tileset;
                    ts.load(gameFile.getTilesets());
                }
                map.finish(file);
            }
            return gameFile;
        }
        catch (JAXBException | IOException e) {
            log.log(Level.SEVERE, "{} - {}", new Object[]{file, e.getMessage()});
            return null;
        }
    }

    @XmlTransient
    public List<TmxMap> getMaps() {
        return this.maps;
    }

    @XmlTransient
    public List<SpritesheetResource> getSpriteSheets() {
        return this.spriteSheets;
    }

    @XmlTransient
    public List<Tileset> getTilesets() {
        return this.tilesets;
    }

    @XmlTransient
    public List<EmitterData> getEmitters() {
        return this.emitters;
    }

    @XmlTransient
    public List<Blueprint> getBluePrints() {
        return this.blueprints;
    }

    @XmlTransient
    public List<SoundResource> getSounds() {
        return this.sounds;
    }

    public String save(String fileName, boolean compress) {
        File newFile;
        Object fileNameWithExtension = fileName;
        if (!((String)fileNameWithExtension).endsWith(".litidata")) {
            fileNameWithExtension = (String)fileNameWithExtension + ".litidata";
        }
        if ((newFile = new File((String)fileNameWithExtension)).exists()) {
            try {
                Files.delete(newFile.toPath().toAbsolutePath());
            }
            catch (IOException e) {
                log.log(Level.WARNING, e.getMessage(), e);
            }
        }
        Collections.sort(this.getMaps());
        Collections.sort(this.getSpriteSheets());
        Collections.sort(this.getTilesets());
        Collections.sort(this.getEmitters());
        Collections.sort(this.getBluePrints());
        Collections.sort(this.getSounds());
        try (FileOutputStream fileOut = new FileOutputStream(newFile, false);){
            JAXBContext jaxbContext = XmlUtilities.getContext(ResourceBundle.class);
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)false);
            if (compress) {
                GZIPOutputStream stream = new GZIPOutputStream(fileOut);
                jaxbMarshaller.marshal((Object)this, (OutputStream)stream);
                stream.flush();
                stream.close();
            } else {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                jaxbMarshaller.marshal((Object)this, (OutputStream)out);
                out.flush();
                XmlUtilities.saveWithCustomIndentation(new ByteArrayInputStream(out.toByteArray()), fileOut, 1);
                out.close();
            }
        }
        catch (JAXBException | IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return newFile.toString();
    }

    void beforeMarshal(Marshaller m) {
        ArrayList<SpritesheetResource> distinctList = new ArrayList<SpritesheetResource>();
        for (SpritesheetResource sprite : this.getSpriteSheets()) {
            if (distinctList.stream().anyMatch(x -> x.getName().equals(sprite.getName()) && x.getImage().equals(sprite.getImage()))) continue;
            distinctList.add(sprite);
        }
        this.spriteSheets = distinctList;
        ArrayList<Tileset> distinctTilesets = new ArrayList<Tileset>();
        for (Tileset tileset : this.getTilesets()) {
            if (distinctTilesets.stream().anyMatch(x -> x.getName().equals(tileset.getName()))) continue;
            distinctTilesets.add(tileset);
        }
        this.tilesets = distinctTilesets;
        if (this.version == 0.0f) {
            this.version = 1.0f;
        }
    }

    private static ResourceBundle getResourceBundle(URL file) throws JAXBException, IOException {
        ResourceBundle resourceBundle;
        block8: {
            JAXBContext jaxbContext = XmlUtilities.getContext(ResourceBundle.class);
            Unmarshaller um = jaxbContext.createUnmarshaller();
            InputStream inputStream = Resources.get(file);
            try {
                GZIPInputStream zipStream = new GZIPInputStream(inputStream);
                resourceBundle = (ResourceBundle)um.unmarshal((InputStream)zipStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ZipException e) {
                    return XmlUtilities.read(ResourceBundle.class, file);
                }
            }
            inputStream.close();
        }
        return resourceBundle;
    }
}

