/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.resources;

import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.environment.MapObjectSerializer;
import de.gurkenlabs.litiengine.environment.tilemap.IMap;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObjectLayer;
import de.gurkenlabs.litiengine.environment.tilemap.IMapOrientation;
import de.gurkenlabs.litiengine.environment.tilemap.ITileLayer;
import de.gurkenlabs.litiengine.environment.tilemap.ITileset;
import de.gurkenlabs.litiengine.environment.tilemap.xml.MapObject;
import de.gurkenlabs.litiengine.environment.tilemap.xml.MapObjectLayer;
import de.gurkenlabs.litiengine.environment.tilemap.xml.Tile;
import de.gurkenlabs.litiengine.environment.tilemap.xml.TileData;
import de.gurkenlabs.litiengine.environment.tilemap.xml.TileLayer;
import de.gurkenlabs.litiengine.environment.tilemap.xml.TmxException;
import de.gurkenlabs.litiengine.environment.tilemap.xml.TmxMap;
import de.gurkenlabs.litiengine.graphics.RenderType;
import de.gurkenlabs.litiengine.resources.Resources;
import de.gurkenlabs.litiengine.resources.ResourcesContainer;
import de.gurkenlabs.litiengine.util.io.FileUtilities;
import de.gurkenlabs.litiengine.util.io.XmlUtilities;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.function.IntBinaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Maps
extends ResourcesContainer<IMap> {
    private static final Logger log = Logger.getLogger(Maps.class.getName());

    Maps() {
    }

    public static boolean isSupported(String fileName) {
        String extension = FileUtilities.getExtension(fileName);
        return extension != null && !extension.isEmpty() && extension.equalsIgnoreCase("tmx");
    }

    public MapGenerator generate(IMapOrientation orientation, String name, int width, int height, int tileWidth, int tileHeight, ITileset ... tilesets) {
        TmxMap map = new TmxMap(orientation);
        map.setTileWidth(tileWidth);
        map.setTileHeight(tileHeight);
        map.setWidth(width);
        map.setHeight(height);
        map.setName(name);
        for (ITileset tileset : tilesets) {
            map.getTilesets().add(tileset);
        }
        return new MapGenerator(map);
    }

    @Override
    protected IMap load(URL resourceName) throws IOException, URISyntaxException {
        TmxMap map;
        try {
            map = XmlUtilities.read(TmxMap.class, resourceName);
        }
        catch (JAXBException e) {
            throw new TmxException(e.getMessage(), e);
        }
        if (map == null) {
            return null;
        }
        map.finish(resourceName);
        return map;
    }

    @Override
    protected String getAlias(String resourceName, IMap resource) {
        if (resource == null || resource.getName() == null || resource.getName().isEmpty() || resource.getName().equalsIgnoreCase(resourceName)) {
            return null;
        }
        return resource.getName();
    }

    public class MapGenerator
    implements AutoCloseable {
        private final TmxMap map;

        private MapGenerator(TmxMap map) {
            this.map = map;
        }

        public IMap getMap() {
            return this.map;
        }

        public ITileLayer addTileLayer(RenderType renderType, IntBinaryOperator tileCallback) {
            TileData data;
            ArrayList<Tile> tiles = new ArrayList<Tile>();
            for (int y = 0; y < this.map.getHeight(); ++y) {
                for (int x = 0; x < this.map.getWidth(); ++x) {
                    int tile = tileCallback.applyAsInt(x, y);
                    tiles.add(new Tile(tile));
                }
            }
            try {
                data = new TileData(tiles, this.map.getWidth(), this.map.getHeight(), "csv", TileData.Compression.NONE);
                data.setValue(TileData.encode(data));
            }
            catch (IOException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                return null;
            }
            TileLayer layer = new TileLayer(data);
            layer.setRenderType(renderType);
            layer.setWidth(this.map.getWidth());
            layer.setHeight(this.map.getHeight());
            this.map.addLayer(layer);
            return layer;
        }

        public IMapObject add(IEntity entity) {
            return this.add(MapObjectSerializer.serialize(entity));
        }

        public IMapObject add(IMapObjectLayer layer, IEntity entity) {
            MapObject mapObject = MapObjectSerializer.serialize(entity);
            return this.add(layer, mapObject);
        }

        public IMapObject add(IMapObject mapObject) {
            IMapObjectLayer layer;
            if (this.getMap().getMapObjectLayers().isEmpty()) {
                layer = new MapObjectLayer();
                layer.setName("default");
                this.getMap().addLayer(layer);
            } else {
                layer = this.getMap().getMapObjectLayer(0);
            }
            return this.add(layer, mapObject);
        }

        public IMapObject add(IMapObjectLayer layer, IMapObject mapObject) {
            layer.addMapObject(mapObject);
            return mapObject;
        }

        @Override
        public void close() {
            try {
                URL resource = Resources.getLocation(this.map.getName() + ".tmx");
                this.map.finish(resource);
                Maps.this.add(resource, this.map);
            }
            catch (TmxException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }
}

