/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.physics;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.entities.ICollisionEntity;
import de.gurkenlabs.litiengine.entities.IMobileEntity;
import de.gurkenlabs.litiengine.physics.Force;
import de.gurkenlabs.litiengine.physics.IMovementController;
import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;

public class MovementController<T extends IMobileEntity>
implements IMovementController {
    private final List<Force> activeForces = new CopyOnWriteArrayList<Force>();
    private final T mobileEntity;
    private final List<Predicate<IMobileEntity>> movementPredicates = new CopyOnWriteArrayList<Predicate<IMobileEntity>>();
    private float dx;
    private float dy;
    private double velocity;
    private double moveAngle;

    public MovementController(T mobileEntity) {
        this.mobileEntity = mobileEntity;
    }

    @Override
    public void attach() {
        Game.loop().attach(this);
    }

    @Override
    public void detach() {
        Game.loop().detach(this);
    }

    @Override
    public void apply(Force force) {
        if (!this.activeForces.contains(force)) {
            this.activeForces.add(force);
        }
    }

    @Override
    public List<Force> getActiveForces() {
        return this.activeForces;
    }

    public T getEntity() {
        return this.mobileEntity;
    }

    @Override
    public float getDx() {
        return this.dx;
    }

    @Override
    public void setDx(float dx) {
        this.dx = dx;
    }

    @Override
    public float getDy() {
        return this.dy;
    }

    @Override
    public void setDy(float dy) {
        this.dy = dy;
    }

    @Override
    public void onMovementCheck(Predicate<IMobileEntity> predicate) {
        if (!this.movementPredicates.contains(predicate)) {
            this.movementPredicates.add(predicate);
        }
    }

    @Override
    public void update() {
        this.handleForces();
        this.handleMovement();
    }

    public void handleMovement() {
        if (!this.isMovementAllowed()) {
            this.velocity = 0.0;
            return;
        }
        double deltaTime = (float)Game.loop().getDeltaTime() * Game.loop().getTimeScale();
        double acceleration = this.getEntity().getAcceleration(deltaTime);
        double deceleration = this.getEntity().getDeceleration(deltaTime, this.getVelocity());
        double dxTemp = this.getDx();
        double dyTemp = this.getDy();
        this.setDx(0.0f);
        this.setDy(0.0f);
        double deltaVelocity = Math.min(Math.sqrt(Math.pow(dxTemp, 2.0) + Math.pow(dyTemp, 2.0)), acceleration);
        if (deltaVelocity != 0.0) {
            double newVelocity = this.getVelocity() + deltaVelocity;
            this.setVelocity(newVelocity);
        } else {
            double newVelocity = Math.max(0.0, this.getVelocity() - deceleration);
            this.setVelocity(newVelocity);
            dxTemp = GeometricUtilities.getDeltaX(this.moveAngle);
            dyTemp = GeometricUtilities.getDeltaY(this.moveAngle);
        }
        if (this.getVelocity() == 0.0) {
            this.moveAngle = 0.0;
            return;
        }
        this.moveEntity(dxTemp, dyTemp);
    }

    @Override
    public Force getForce(String identifier) {
        if (identifier == null || identifier.isEmpty()) {
            return null;
        }
        return this.getActiveForces().stream().filter(x -> x.getIdentifier() != null && x.getIdentifier().equals(identifier)).findFirst().orElse(null);
    }

    @Override
    public double getMoveAngle() {
        return this.moveAngle;
    }

    @Override
    public void setVelocity(double velocity) {
        double maxVelocity = this.getEntity().getTickVelocity();
        this.velocity = Math.clamp(velocity, -maxVelocity, maxVelocity);
    }

    @Override
    public double getVelocity() {
        return this.velocity;
    }

    protected void moveEntity(double deltaX, double deltaY) {
        this.moveAngle = Math.toDegrees(Math.atan2(deltaX, deltaY));
        Game.physics().move((IMobileEntity)this.getEntity(), this.moveAngle, this.getVelocity());
    }

    protected boolean isMovementAllowed() {
        return this.movementPredicates.stream().allMatch(p -> p.test(this.getEntity()));
    }

    private void handleForces() {
        if (this.activeForces.isEmpty()) {
            return;
        }
        this.activeForces.removeIf(Force::hasEnded);
        this.moveEntityByActiveForces();
    }

    private void moveEntityByActiveForces() {
        Point2D combinedForcesVector = this.combineActiveForces();
        Point2D.Double target = new Point2D.Double(this.getEntity().getX() + combinedForcesVector.getX(), this.getEntity().getY() + combinedForcesVector.getY());
        boolean success = Game.physics().move((IMobileEntity)this.getEntity(), (Point2D)target, false);
        if (!success) {
            this.activeForces.stream().filter(Force::cancelOnCollision).forEach(Force::end);
        }
    }

    private Point2D combineActiveForces() {
        double deltaX = 0.0;
        double deltaY = 0.0;
        for (Force force : this.activeForces) {
            if (force.cancelOnReached() && force.hasReached((ICollisionEntity)this.getEntity())) {
                force.end();
                continue;
            }
            double angle = GeometricUtilities.calcRotationAngleInDegrees(this.getEntity().getCollisionBoxCenter(), force.getLocation());
            double strength = (float)Game.loop().getDeltaTime() * 0.001f * force.getStrength() * Game.loop().getTimeScale();
            deltaX += GeometricUtilities.getDeltaX(angle, strength);
            deltaY += GeometricUtilities.getDeltaY(angle, strength);
        }
        return new Point2D.Double(deltaX, deltaY);
    }
}

