/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.physics;

import de.gurkenlabs.litiengine.Direction;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.physics.Force;
import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import java.awt.geom.Point2D;

public class GravityForce
extends Force {
    private final float directionAngle;
    private final IEntity forceEntity;

    public GravityForce(IEntity forceEntity, float strength, Direction direction) {
        this(forceEntity, strength, direction.toAngle());
    }

    public GravityForce(IEntity forceEntity, float strength, float angle) {
        super(forceEntity.getCenter(), strength, 0.0f);
        this.forceEntity = forceEntity;
        this.directionAngle = angle;
        this.setCancelOnCollision(false);
        this.setCancelOnReached(false);
    }

    public IEntity getForceEntity() {
        return this.forceEntity;
    }

    @Override
    public Point2D getLocation() {
        return GeometricUtilities.project(this.getForceEntity().getCenter(), this.directionAngle, Math.max(this.getForceEntity().getHeight(), this.getForceEntity().getWidth() * 2.0 + (double)this.getStrength()));
    }
}

