/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.input;

import de.gurkenlabs.litiengine.entities.IMobileEntity;
import de.gurkenlabs.litiengine.input.Input;
import de.gurkenlabs.litiengine.input.KeyboardEntityController;
import de.gurkenlabs.litiengine.util.ListUtilities;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;

public class PlatformingMovementController<T extends IMobileEntity>
extends KeyboardEntityController<T> {
    public static final String JUMP_ACTION = "jump";
    private final List<Integer> jump;

    public PlatformingMovementController(T entity) {
        this(entity, 32);
    }

    public PlatformingMovementController(T entity, int jump) {
        super(entity);
        this.getUpKeys().clear();
        this.getDownKeys().clear();
        this.jump = new ArrayList<Integer>();
        this.addJumpKey(jump);
        Input.keyboard().onKeyPressed(this::handlePressedKey);
    }

    @Override
    public void handlePressedKey(KeyEvent keyCode) {
        super.handlePressedKey(keyCode);
        if (this.jump.contains(keyCode.getKeyCode())) {
            this.getEntity().perform(JUMP_ACTION);
        }
    }

    public void addJumpKey(int keyCode) {
        if (this.jump.contains(keyCode)) {
            return;
        }
        this.jump.add(keyCode);
    }

    public List<Integer> getJumpKeys() {
        return this.jump;
    }

    public void setJumpKeys(int ... jump) {
        this.setUpKeys(ListUtilities.getIntList(jump));
    }
}

