/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.gui;

import de.gurkenlabs.litiengine.Align;
import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.graphics.ShapeRenderer;
import de.gurkenlabs.litiengine.gui.GuiComponent;
import de.gurkenlabs.litiengine.gui.GuiProperties;
import de.gurkenlabs.litiengine.sound.Sound;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;

public class SpeechBubble
extends GuiComponent
implements IUpdateable {
    private int displayTime = GuiProperties.getDefaultSpeechBubbleDisplayTime();
    private long startedTick;
    private final IEntity entity;
    private Align boxAlign;
    private boolean renderTriangle;
    private Path2D triangle;
    private double triangleSize;
    private double entityCenterX;
    private int typeDelay;
    private int textIndex;
    private Sound typeSound;
    private long lastTypeTick;
    private final String totalText;

    public SpeechBubble(IEntity entity, String text) {
        this(entity, entity.getWidth() * 4.0 * (double)Game.world().camera().getRenderScale(), entity.getHeight() * 2.0 * (double)Game.world().camera().getRenderScale(), 3000, text);
    }

    public SpeechBubble(IEntity entity, double width, double height, int displayTime, String text) {
        super(Game.world().camera().getViewportDimensionCenter(entity).getX() * (double)Game.world().camera().getRenderScale() - width / 2.0, Game.world().camera().getViewportLocation(entity).getY() * (double)Game.world().camera().getRenderScale() - height, width, height);
        this.entity = entity;
        this.totalText = text;
        this.setAutomaticLineBreaks(true);
        this.setForwardMouseEvents(false);
        this.setRenderTriangle(true);
        this.setBoxAlign(GuiProperties.getDefaultTextAlign());
        this.setTriangleSize(this.getWidth() * 1.0 / 10.0);
        this.setDisplayTime(displayTime);
        this.setTypeDelay((int)((double)this.getDisplayTime() * 0.5 / (double)this.totalText.length()));
    }

    public IEntity getEntity() {
        return this.entity;
    }

    public int getDisplayTime() {
        return this.displayTime;
    }

    public void setDisplayTime(int displayTime) {
        this.displayTime = displayTime;
    }

    public void start() {
        this.startedTick = Game.time().now();
        Game.screens().current().getComponents().add(this);
        this.prepare();
        Game.loop().attach(this);
    }

    public void stop() {
        Game.screens().current().getComponents().remove(this);
        this.suspend();
        Game.loop().detach(this);
    }

    @Override
    public void render(Graphics2D g) {
        if (this.isRenderingTriangle()) {
            if (!this.getAppearance().isTransparentBackground()) {
                g.setColor(this.getAppearance().getBackgroundColor1());
                ShapeRenderer.render(g, this.getTriangle());
            }
            g.setColor(this.getCurrentAppearance().getBorderColor());
            ShapeRenderer.renderOutline(g, (Shape)this.getTriangle(), this.getCurrentAppearance().getBorderStyle());
        }
        super.render(g);
    }

    public Align getBoxAlign() {
        return this.boxAlign;
    }

    public void setBoxAlign(Align boxAlign) {
        this.boxAlign = boxAlign;
    }

    @Override
    public void update() {
        if (Game.time().since(this.startedTick) >= (long)this.getDisplayTime()) {
            this.stop();
            return;
        }
        this.entityCenterX = Game.world().camera().getViewportDimensionCenter(this.getEntity()).getX() * (double)Game.world().camera().getRenderScale();
        switch (this.getBoxAlign()) {
            case CENTER: 
            case CENTER_LEFT: 
            case CENTER_RIGHT: {
                this.setX(this.entityCenterX - this.getBoxAlign().getValue(this.getWidth()));
                break;
            }
            case LEFT: {
                this.setX(this.entityCenterX - this.getBoxAlign().getValue(this.getWidth()) - this.getTriangleSize() / 2.0);
                break;
            }
            case RIGHT: {
                this.setX(this.entityCenterX - this.getBoxAlign().getValue(this.getWidth()) + this.getTriangleSize() / 2.0);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.getBoxAlign()));
            }
        }
        this.setY(Game.world().camera().getViewportLocation(this.getEntity()).getY() * (double)Game.world().camera().getRenderScale() - (this.getHeight() + this.getTriangleSize()));
        this.type();
    }

    public boolean isRenderingTriangle() {
        return this.renderTriangle;
    }

    public void setRenderTriangle(boolean renderTriangle) {
        this.renderTriangle = renderTriangle;
    }

    @Override
    public void setLocation(Point2D location) {
        this.triangle = null;
        super.setLocation(location);
    }

    @Override
    public void setWidth(double width) {
        this.triangle = null;
        super.setWidth(width);
    }

    @Override
    public void setHeight(double height) {
        this.triangle = null;
        super.setHeight(height);
    }

    public Path2D getTriangle() {
        if (this.triangle != null) {
            return this.triangle;
        }
        this.triangle = new Path2D.Double();
        this.triangle.moveTo(0.0, 0.0);
        this.triangle.lineTo(this.getTriangleSize(), 0.0);
        this.triangle.lineTo(this.getTriangleSize() / 2.0, this.getTriangleSize());
        this.triangle.closePath();
        AffineTransform at = new AffineTransform();
        at.translate(this.entityCenterX - this.getTriangleSize() / 2.0, this.getY() + this.getHeight());
        this.triangle.transform(at);
        return this.triangle;
    }

    public double getTriangleSize() {
        return this.triangleSize;
    }

    public void setTriangleSize(double triangleSize) {
        this.triangle = null;
        this.triangleSize = triangleSize;
    }

    private void type() {
        if (this.textIndex < this.totalText.length() && Game.time().since(this.lastTypeTick) > (long)this.getTypeDelay()) {
            ++this.textIndex;
            this.setText(this.totalText.substring(0, this.textIndex));
            this.lastTypeTick = Game.time().now();
            if (this.getTypeSound() != null) {
                Game.audio().playSound(this.getTypeSound(), this.getEntity());
            }
        }
    }

    public int getTypeDelay() {
        return this.typeDelay;
    }

    public void setTypeDelay(int typeDelay) {
        this.typeDelay = typeDelay;
    }

    public Sound getTypeSound() {
        return this.typeSound;
    }

    public void setTypeSound(Sound typeSound) {
        this.typeSound = typeSound;
    }

    public String getTotalText() {
        return this.totalText;
    }
}

