/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.GameMetrics;
import de.gurkenlabs.litiengine.gui.screens.Screen;
import de.gurkenlabs.litiengine.resources.ImageFormat;
import de.gurkenlabs.litiengine.util.TimeUtilities;
import de.gurkenlabs.litiengine.util.io.ImageSerializer;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.IntConsumer;

public class RenderComponent
extends Canvas {
    public static final Color DEFAULT_BACKGROUND_COLOR = Color.BLACK;
    public static final Font DEFAULT_FONT = new Font("Monospaced", 0, 12);
    private final transient List<IntConsumer> fpsChangedConsumer = new CopyOnWriteArrayList<IntConsumer>();
    private final transient List<Consumer<Graphics2D>> renderedConsumer = new CopyOnWriteArrayList<Consumer<Graphics2D>>();
    private transient BufferStrategy currentBufferStrategy;
    private float currentAlpha = Float.NaN;
    private long fadeInStart = -1L;
    private long fadeOutStart = -1L;
    private int fadeInTime;
    private int fadeOutTime;
    private int frameCount = 0;
    private long lastFpsTime = System.currentTimeMillis();
    private boolean takeScreenShot;

    public RenderComponent(Dimension size) {
        this.setBackground(DEFAULT_BACKGROUND_COLOR);
        this.setFont(DEFAULT_FONT);
        this.setSize(size);
        this.setPreferredSize(size);
    }

    public void fadeIn(int ms) {
        this.resetFade();
        this.fadeInStart = Game.time().now();
        this.fadeInTime = ms;
    }

    public void fadeOut(int ms) {
        this.resetFade();
        this.fadeOutStart = Game.time().now();
        this.fadeOutTime = ms;
    }

    private void resetFade() {
        this.fadeOutStart = -1L;
        this.fadeInStart = -1L;
        this.fadeOutTime = 0;
        this.fadeInTime = 0;
    }

    public void init() {
        this.createBufferStrategy(2);
        this.currentBufferStrategy = this.getBufferStrategy();
    }

    public void onFpsChanged(IntConsumer fpsConsumer) {
        if (!this.fpsChangedConsumer.contains(fpsConsumer)) {
            this.fpsChangedConsumer.add(fpsConsumer);
        }
    }

    public void onRendered(Consumer<Graphics2D> renderedConsumer) {
        if (!this.renderedConsumer.contains(renderedConsumer)) {
            this.renderedConsumer.add(renderedConsumer);
        }
    }

    public void render() {
        if (System.currentTimeMillis() - this.lastFpsTime >= 1000L) {
            this.lastFpsTime = System.currentTimeMillis();
            this.fpsChangedConsumer.forEach(consumer -> consumer.accept(this.frameCount));
            this.frameCount = 0;
        }
        this.handleFade();
        do {
            Graphics2D g = (Graphics2D)this.currentBufferStrategy.getDrawGraphics();
            try {
                this.renderGraphics(g);
            }
            finally {
                g.dispose();
            }
            this.currentBufferStrategy.show();
        } while (this.currentBufferStrategy.contentsLost());
        Toolkit.getDefaultToolkit().sync();
        ++this.frameCount;
    }

    private void renderGraphics(Graphics2D g) {
        this.clearBackground(g);
        this.applyRenderingHints(g);
        Screen currentScreen = Game.screens().current();
        if (currentScreen != null) {
            this.renderScreen(g, currentScreen);
        }
        Game.window().cursor().render(g);
        this.renderedConsumer.forEach(consumer -> consumer.accept(g));
        this.applyFadeOverlay(g);
        if (this.takeScreenShot && currentScreen != null) {
            this.takeAndSaveScreenshot(currentScreen);
        }
    }

    private void clearBackground(Graphics2D g) {
        g.setColor(this.getBackground());
        Rectangle bounds = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        g.setClip(bounds);
        g.fill(bounds);
    }

    private void applyRenderingHints(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, Game.config().graphics().colorInterpolation() ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, Game.config().graphics().colorInterpolation() ? RenderingHints.VALUE_INTERPOLATION_BILINEAR : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
    }

    private void renderScreen(Graphics2D g, Screen screen) {
        long renderStart = System.nanoTime();
        screen.render(g);
        if (Game.config().debug().trackRenderTimes()) {
            double totalRenderTime = TimeUtilities.nanoToMs(System.nanoTime() - renderStart);
            Game.metrics().trackRenderTime("screen", totalRenderTime, new GameMetrics.RenderInfo[0]);
        }
    }

    private void applyFadeOverlay(Graphics2D g) {
        if (!Float.isNaN(this.currentAlpha)) {
            int visibleAlpha = Math.clamp((long)Math.round(255.0f * (1.0f - this.currentAlpha)), 0, 255);
            g.setColor(new Color(this.getBackground().getRGB() & 0xFFFFFF | visibleAlpha << 24, true));
            g.fill(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
        }
    }

    private void takeAndSaveScreenshot(Screen screen) {
        BufferedImage img = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Graphics2D imgGraphics = img.createGraphics();
        screen.render(imgGraphics);
        imgGraphics.dispose();
        this.saveScreenshot(img);
    }

    public void takeScreenshot() {
        this.takeScreenShot = true;
    }

    private void handleFade() {
        if (this.fadeOutStart != -1L) {
            this.updateAlpha(this.fadeOutStart, this.fadeOutTime, false);
            if (this.currentAlpha == 0.0f) {
                this.resetFade();
            }
        } else if (this.fadeInStart != -1L) {
            this.updateAlpha(this.fadeInStart, this.fadeInTime, true);
            if (this.currentAlpha == 1.0f) {
                this.resetFade();
            }
        }
    }

    private void updateAlpha(long startTime, int duration, boolean fadeIn) {
        long timePassed = Game.time().since(startTime);
        this.currentAlpha = Math.clamp((float)(fadeIn ? timePassed : (long)duration - timePassed) / (float)duration, 0.0f, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveScreenshot(BufferedImage img) {
        try {
            String timeStamp = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(new Date());
            File folder = new File("./screenshots/");
            if (!folder.exists()) {
                folder.mkdirs();
            }
            String path = "./screenshots/" + timeStamp + ImageFormat.PNG.toFileExtension();
            ImageSerializer.saveImage(path, img);
        }
        finally {
            this.takeScreenShot = false;
        }
    }
}

