/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.entities.LightSource;
import de.gurkenlabs.litiengine.environment.Environment;
import de.gurkenlabs.litiengine.environment.MapObjectLoader;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;

public class LightSourceMapObjectLoader
extends MapObjectLoader {
    protected LightSourceMapObjectLoader() {
        super(MapObjectType.LIGHTSOURCE);
    }

    @Override
    public Collection<IEntity> load(Environment environment, IMapObject mapObject) {
        ArrayList<IEntity> entities = new ArrayList<IEntity>();
        if (!this.isMatchingType(mapObject)) {
            return entities;
        }
        int intensity = mapObject.getIntValue("lightIntensity", 100);
        Color color = mapObject.getColorValue("lightColor");
        if (color == null) {
            return entities;
        }
        boolean active = mapObject.getBoolValue("lightActive", true);
        LightSource.Type lightType = mapObject.getEnumValue("lightShape", LightSource.Type.class, LightSource.Type.RECTANGLE);
        LightSource light = this.createLightSource(mapObject, intensity, color, lightType, active);
        LightSourceMapObjectLoader.loadDefaultProperties(light, mapObject);
        entities.add(light);
        return entities;
    }

    protected LightSource createLightSource(IMapObject mapObject, int intensity, Color color, LightSource.Type lightType, boolean active) {
        return new LightSource(intensity, color, lightType, active);
    }
}

