/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.entities;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.entities.AnimationInfo;
import de.gurkenlabs.litiengine.entities.CombatEntity;
import de.gurkenlabs.litiengine.entities.Material;
import de.gurkenlabs.litiengine.entities.PropState;
import de.gurkenlabs.litiengine.entities.Rotation;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import de.gurkenlabs.litiengine.environment.tilemap.TmxProperty;
import de.gurkenlabs.litiengine.environment.tilemap.TmxType;
import de.gurkenlabs.litiengine.graphics.animation.IEntityAnimationController;
import de.gurkenlabs.litiengine.graphics.animation.PropAnimationController;
import java.awt.geom.Point2D;

@AnimationInfo(spritePrefix={"prop-"})
@TmxType(value=MapObjectType.PROP)
public class Prop
extends CombatEntity {
    @TmxProperty(name="material")
    private Material material;
    @TmxProperty(name="addShadow")
    private boolean addShadow;
    @TmxProperty(name="flipHorizontally")
    private boolean flipHorizontally;
    @TmxProperty(name="flipVertically")
    private boolean flipVertically;
    @TmxProperty(name="scaling")
    private boolean scaling;
    @TmxProperty(name="rotationSprite")
    private Rotation rotation = Rotation.NONE;
    @TmxProperty(name="spritesheetName")
    private String spritesheetName;

    public Prop(String spritesheetName) {
        this(0.0, 0.0, spritesheetName);
    }

    public Prop(double x, double y, String spritesheetName) {
        this(x, y, spritesheetName, Material.UNDEFINED);
    }

    public Prop(double x, double y, String spritesheetName, Material material) {
        this(new Point2D.Double(x, y), spritesheetName, material);
    }

    public Prop(Point2D location, String spritesheetName) {
        this(location, spritesheetName, Material.UNDEFINED);
    }

    public Prop(Point2D location, String spritesheetName, Material material) {
        this.spritesheetName = spritesheetName;
        this.material = material;
        this.setLocation(location);
        this.updateAnimationController();
    }

    public Material getMaterial() {
        return this.material;
    }

    public String getSpritesheetName() {
        return this.spritesheetName;
    }

    public PropState getState() {
        if (!this.isIndestructible() && this.getHitPoints().get() <= 0) {
            return PropState.DESTROYED;
        }
        if (!this.isIndestructible() && (double)this.getHitPoints().get().intValue() <= (double)this.getHitPoints().getMax().intValue() * 0.5) {
            return PropState.DAMAGED;
        }
        return PropState.INTACT;
    }

    public boolean isAddShadow() {
        return this.addShadow;
    }

    public boolean isScaling() {
        return this.scaling;
    }

    public boolean flipHorizontally() {
        return this.flipHorizontally;
    }

    public boolean flipVertically() {
        return this.flipVertically;
    }

    public Rotation getSpriteRotation() {
        return this.rotation;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public void setSpritesheetName(String spriteName) {
        this.spritesheetName = spriteName;
        this.updateAnimationController();
    }

    public void setAddShadow(boolean addShadow) {
        this.addShadow = addShadow;
    }

    public void setScaling(boolean scaling) {
        this.scaling = scaling;
    }

    @Override
    public boolean isDead() {
        if (this.isIndestructible()) {
            return false;
        }
        return this.getHitPoints().get() <= 0;
    }

    public void setSpriteRotation(Rotation spriteRotation) {
        this.rotation = spriteRotation;
    }

    public void setFlipHorizontally(boolean flipHorizontally) {
        this.flipHorizontally = flipHorizontally;
    }

    public void setFlipVertically(boolean flipVertically) {
        this.flipVertically = flipVertically;
    }

    @Override
    public String toString() {
        String str = "#" + this.getMapId() + ": ";
        str = this.getName() != null && !this.getName().isEmpty() ? str + this.getName() : str + Prop.class.getSimpleName();
        str = str + " (" + this.getSpritesheetName() + ")";
        return str;
    }

    protected IEntityAnimationController<?> createAnimationController() {
        return new PropAnimationController<Prop>(this);
    }

    private void updateAnimationController() {
        IEntityAnimationController<?> controller = this.createAnimationController();
        this.getControllers().addController(controller);
        if (Game.world().environment() != null && Game.world().environment().isLoaded()) {
            Game.loop().attach(controller);
        }
    }
}

