/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.entities;

import de.gurkenlabs.litiengine.Align;
import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.Valign;
import de.gurkenlabs.litiengine.entities.EntityPivotType;
import de.gurkenlabs.litiengine.entities.ICollisionEntity;
import de.gurkenlabs.litiengine.entities.IEntity;
import java.awt.geom.Point2D;

public class EntityPivot {
    private final IEntity entity;
    private final EntityPivotType type;
    private double offsetX;
    private double offsetY;

    public EntityPivot(IEntity entity, EntityPivotType type, double offsetX, double offsetY) {
        this.entity = entity;
        this.type = type;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        if (type == EntityPivotType.COLLISIONBOX_CENTER && !(entity instanceof ICollisionEntity)) {
            throw new IllegalArgumentException("Pivot type COLLISIONBOX_CENTER is only supported for collision entities.");
        }
    }

    public EntityPivot(IEntity entity, Align align, Valign valign) {
        this(entity, align, valign, 0.0, 0.0);
    }

    public EntityPivot(IEntity entity, Align align, Valign valign, double offsetX, double offsetY) {
        this(entity, EntityPivotType.LOCATION, align.getValue(entity.getWidth()) + offsetX, valign.getValue(entity.getHeight()) + offsetY);
    }

    public IEntity getEntity() {
        return this.entity;
    }

    public EntityPivotType getType() {
        return this.type;
    }

    public double getOffsetX() {
        return this.offsetX;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public Point2D getPoint() {
        EntityPivotType pivot = this.getType();
        return switch (pivot) {
            case EntityPivotType.COLLISIONBOX_CENTER -> new Point2D.Double(((ICollisionEntity)this.getEntity()).getCollisionBox().getCenterX() + this.getOffsetX(), ((ICollisionEntity)this.getEntity()).getCollisionBox().getCenterY() + this.getOffsetY());
            case EntityPivotType.DIMENSION_CENTER -> new Point2D.Double(this.getEntity().getCenter().getX() + this.getOffsetX(), this.getEntity().getCenter().getY() + this.getOffsetY());
            case EntityPivotType.SPREAD -> new Point2D.Double(this.getEntity().getX() + Game.random().nextDouble(this.getEntity().getWidth()) + this.getOffsetX(), this.getEntity().getY() + Game.random().nextDouble(this.getEntity().getHeight()) + this.getOffsetY());
            default -> new Point2D.Double(this.getEntity().getX() + this.getOffsetX(), this.getEntity().getY() + this.getOffsetY());
        };
    }

    public void setOffsetX(double offsetX) {
        this.offsetX = offsetX;
    }

    public void setOffsetY(double offsetY) {
        this.offsetY = offsetY;
    }

    public void setOffset(Point2D offset) {
        this.setOffsetX(offset.getX());
        this.setOffsetY(offset.getY());
    }
}

