/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.configuration;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.configuration.ConfigurationGroup;
import de.gurkenlabs.litiengine.configuration.ConfigurationGroupInfo;

@ConfigurationGroupInfo(prefix="dbg_", debug=true)
public class DebugConfiguration
extends ConfigurationGroup {
    private boolean debugEnabled = false;
    private boolean renderBoundingBoxes = false;
    private boolean renderCollisionBoxes = false;
    private boolean renderDebugMouse = false;
    private boolean renderEntityNames = false;
    private boolean renderGuiComponentBoundingBoxes = false;
    private boolean renderHitBoxes = false;
    private boolean showMouseTargetMetric = true;
    private boolean showTilesMetric = false;
    private boolean trackRenderTimes = false;

    DebugConfiguration() {
    }

    public boolean isDebugEnabled() {
        return Game.isDebug() && this.debugEnabled;
    }

    public boolean isRenderDebugMouse() {
        return this.isDebugEnabled() && this.renderDebugMouse;
    }

    public boolean renderBoundingBoxes() {
        return this.isDebugEnabled() && this.renderBoundingBoxes;
    }

    public boolean renderCollisionBoxes() {
        return this.isDebugEnabled() && this.renderCollisionBoxes;
    }

    public boolean renderEntityNames() {
        return this.isDebugEnabled() && this.renderEntityNames;
    }

    public boolean renderHitBoxes() {
        return this.isDebugEnabled() && this.renderHitBoxes;
    }

    public boolean renderGuiComponentBoundingBoxes() {
        return this.isDebugEnabled() && this.renderGuiComponentBoundingBoxes;
    }

    public boolean showMouseTargetMetric() {
        return this.isDebugEnabled() && this.showMouseTargetMetric;
    }

    public boolean showTilesMetric() {
        return this.isDebugEnabled() && this.showTilesMetric;
    }

    public boolean trackRenderTimes() {
        return this.isDebugEnabled() && this.trackRenderTimes;
    }

    public void setDebugEnabled(boolean debugEnabled) {
        this.set("debugEnabled", debugEnabled);
    }

    public void setRenderBoundingBoxes(boolean renderBoundingBoxes) {
        this.set("renderBoundingBoxes", renderBoundingBoxes);
    }

    public void setRenderCollisionBoxes(boolean renderCollisionBoxes) {
        this.set("renderCollisionBoxes", renderCollisionBoxes);
    }

    public void setRenderDebugMouse(boolean renderDebugMouse) {
        this.set("renderDebugMouse", renderDebugMouse);
    }

    public void setRenderEntityNames(boolean renderEntityNames) {
        this.set("renderEntityNames", renderEntityNames);
    }

    public void setRenderHitBoxes(boolean renderHitBoxes) {
        this.set("renderHitBoxes", renderHitBoxes);
    }

    public void setShowMouseTargetMetric(boolean showMouseTargetMetric) {
        this.set("showMouseTargetMetric", showMouseTargetMetric);
    }

    public void setShowTilesMetric(boolean showTilesMetric) {
        this.set("showTilesMetric", showTilesMetric);
    }

    public void setRenderGuiComponentBoundingBoxes(boolean renderGuiComponentBoundingBoxes) {
        this.set("renderGuiComponentBoundingBoxes", renderGuiComponentBoundingBoxes);
    }

    public void setTrackRenderTimes(boolean trackRenderTimes) {
        this.set("trackRenderTimes", trackRenderTimes);
    }
}

