/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.attributes;

import de.gurkenlabs.litiengine.attributes.AttributeModifier;
import de.gurkenlabs.litiengine.attributes.Modification;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Attribute<T extends Number> {
    private final List<AttributeModifier<T>> modifiers = new ArrayList<AttributeModifier<T>>();
    private T baseValue;

    public Attribute(T initialValue) {
        this.baseValue = initialValue;
    }

    public void addModifier(AttributeModifier<T> modifier) {
        if (this.getModifiers().contains(modifier)) {
            return;
        }
        this.getModifiers().add(modifier);
        Collections.sort(this.getModifiers());
    }

    public void removeModifier(AttributeModifier<T> modifier) {
        this.getModifiers().remove(modifier);
        Collections.sort(this.getModifiers());
    }

    public T get() {
        return this.applyModifiers(this.getBase());
    }

    public T getBase() {
        return this.baseValue;
    }

    public List<AttributeModifier<T>> getModifiers() {
        return this.modifiers;
    }

    public boolean isModifierApplied(AttributeModifier<T> modifier) {
        return this.getModifiers().contains(modifier);
    }

    public void modifyBaseValue(AttributeModifier<T> modifier) {
        this.baseValue = modifier.modify(this.getBase());
    }

    public void modifyBaseValue(Modification modification, double value) {
        this.baseValue = new AttributeModifier<T>(modification, value).modify(this.getBase());
    }

    public void setBaseValue(T baseValue) {
        this.baseValue = baseValue;
    }

    protected T applyModifiers(T baseValue) {
        T currentValue = baseValue;
        for (AttributeModifier<T> modifier : this.getModifiers()) {
            currentValue = modifier.modify(currentValue);
        }
        return currentValue;
    }

    public String toString() {
        return this.get() == null ? null : this.get().toString();
    }
}

