/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.abilities.effects;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.abilities.effects.EffectApplication;
import de.gurkenlabs.litiengine.abilities.effects.EffectEvent;
import de.gurkenlabs.litiengine.abilities.targeting.TargetingStrategy;
import de.gurkenlabs.litiengine.entities.ICombatEntity;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class Effect
implements IUpdateable {
    private final List<EffectApplication> appliances;
    private final Collection<EffectAppliedListener> appliedListeners = ConcurrentHashMap.newKeySet();
    private final Collection<EffectCeasedListener> ceasedListeners = ConcurrentHashMap.newKeySet();
    private final List<Effect> followUpEffects;
    private final TargetingStrategy targetingStrategy;
    private final ICombatEntity executor;
    private int delay;
    private int duration;

    protected Effect(TargetingStrategy targetingStrategy) {
        this(targetingStrategy, null);
    }

    protected Effect(TargetingStrategy targetingStrategy, ICombatEntity executor) {
        this(targetingStrategy, executor, 0);
    }

    protected Effect(TargetingStrategy targetingStrategy, ICombatEntity executor, int duration) {
        this.appliances = new ArrayList<EffectApplication>();
        this.followUpEffects = new CopyOnWriteArrayList<Effect>();
        this.executor = executor;
        this.duration = duration;
        this.targetingStrategy = targetingStrategy;
    }

    public void onEffectApplied(EffectAppliedListener listener) {
        this.appliedListeners.add(listener);
    }

    public void removeEffectAppliedListener(EffectAppliedListener listener) {
        this.appliedListeners.remove(listener);
    }

    public void onEffectCeased(EffectCeasedListener listener) {
        this.ceasedListeners.add(listener);
    }

    public void removeEffectCeasedListener(EffectCeasedListener listener) {
        this.ceasedListeners.remove(listener);
    }

    public void apply(Shape impactArea) {
        Collection<ICombatEntity> affected = this.targetingStrategy.findTargets(impactArea, this.getExecutingEntity());
        for (ICombatEntity affectedEntity : affected) {
            this.apply(affectedEntity);
        }
        this.appliances.add(new EffectApplication(affected, impactArea));
        if (this.appliances.size() == 1) {
            Game.loop().attach(this);
        }
    }

    public void cease(ICombatEntity entity) {
        entity.getAppliedEffects().remove(this);
        EffectEvent event = new EffectEvent(this, entity);
        for (EffectCeasedListener listener : this.ceasedListeners) {
            listener.ceased(event);
        }
    }

    public ICombatEntity getExecutingEntity() {
        return this.executor;
    }

    public List<EffectApplication> getActiveAppliances() {
        return this.appliances;
    }

    public int getDelay() {
        return this.delay;
    }

    public int getDuration() {
        return this.duration;
    }

    public TargetingStrategy getTargetingStrategy() {
        return this.targetingStrategy;
    }

    public List<Effect> getFollowUpEffects() {
        return this.followUpEffects;
    }

    public boolean isActive(ICombatEntity entity) {
        return this.getActiveAppliances().stream().anyMatch(a -> a.getAffectedEntities().stream().anyMatch(e -> e.equals(entity)));
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    @Override
    public void update() {
        Iterator<EffectApplication> iterator = this.getActiveAppliances().iterator();
        while (iterator.hasNext()) {
            EffectApplication appliance = iterator.next();
            if (!this.hasEnded(appliance)) continue;
            iterator.remove();
            this.cease(appliance);
        }
        if (this.getActiveAppliances().isEmpty()) {
            Game.loop().detach(this);
        }
    }

    protected void apply(ICombatEntity entity) {
        entity.getAppliedEffects().add(this);
        EffectEvent event = new EffectEvent(this, entity);
        for (EffectAppliedListener listener : this.appliedListeners) {
            listener.applied(event);
        }
    }

    protected void cease(EffectApplication appliance) {
        for (ICombatEntity entity : appliance.getAffectedEntities()) {
            this.cease(entity);
        }
        this.getFollowUpEffects().forEach(followUp -> followUp.apply(appliance.getImpactArea()));
    }

    protected long getTotalDuration() {
        return (long)this.getDuration() + (long)this.getDelay();
    }

    protected boolean hasEnded(EffectApplication appliance) {
        long effectDuration = Game.time().since(appliance.getAppliedTicks());
        return effectDuration > (long)this.getDuration();
    }

    @FunctionalInterface
    public static interface EffectCeasedListener
    extends EventListener {
        public void ceased(EffectEvent var1);
    }

    @FunctionalInterface
    public static interface EffectAppliedListener
    extends EventListener {
        public void applied(EffectEvent var1);
    }
}

