/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.abilities.effects;

import de.gurkenlabs.litiengine.abilities.effects.Effect;
import de.gurkenlabs.litiengine.abilities.targeting.TargetingStrategy;
import de.gurkenlabs.litiengine.attributes.Attribute;
import de.gurkenlabs.litiengine.attributes.AttributeModifier;
import de.gurkenlabs.litiengine.attributes.Modification;
import de.gurkenlabs.litiengine.entities.ICombatEntity;

public abstract class AttributeEffect<T extends Number>
extends Effect {
    private final AttributeModifier<T> modifier;

    protected AttributeEffect(TargetingStrategy targetingStrategy, Modification modification, double delta) {
        this(targetingStrategy, null, modification, delta);
    }

    protected AttributeEffect(TargetingStrategy targetingStrategy, ICombatEntity executingEntity, Modification modification, double delta) {
        super(targetingStrategy, executingEntity);
        this.modifier = new AttributeModifier(modification, delta);
    }

    @Override
    public void cease(ICombatEntity affectedEntity) {
        super.cease(affectedEntity);
        this.getAttribute(affectedEntity).removeModifier(this.getModifier());
    }

    public AttributeModifier<T> getModifier() {
        return this.modifier;
    }

    @Override
    protected void apply(ICombatEntity affectedEntity) {
        super.apply(affectedEntity);
        this.getAttribute(affectedEntity).addModifier(this.getModifier());
    }

    protected abstract Attribute<T> getAttribute(ICombatEntity var1);
}

