/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.abilities;

import de.gurkenlabs.litiengine.abilities.AbilityInfo;
import de.gurkenlabs.litiengine.attributes.Attribute;

public class AbilityAttributes {
    private final Attribute<Integer> cooldown;
    private final Attribute<Integer> duration;
    private final Attribute<Integer> impact;
    private final Attribute<Integer> impactAngle;
    private final Attribute<Integer> range;
    private final Attribute<Integer> value;

    public AbilityAttributes(AbilityInfo info) {
        this(info.cooldown(), info.duration(), info.range(), info.impact(), info.impactAngle(), info.value());
    }

    public AbilityAttributes(int cooldown, int duration, int range, int impact, int impactAngle, int value) {
        this.cooldown = new Attribute<Integer>(cooldown);
        this.duration = new Attribute<Integer>(duration);
        this.range = new Attribute<Integer>(range);
        this.impact = new Attribute<Integer>(impact);
        this.impactAngle = new Attribute<Integer>(impactAngle);
        this.value = new Attribute<Integer>(value);
    }

    public Attribute<Integer> cooldown() {
        return this.cooldown;
    }

    public Attribute<Integer> duration() {
        return this.duration;
    }

    public Attribute<Integer> impact() {
        return this.impact;
    }

    public Attribute<Integer> impactAngle() {
        return this.impactAngle;
    }

    public Attribute<Integer> range() {
        return this.range;
    }

    public Attribute<Integer> value() {
        return this.value;
    }

    public void copyValues(AbilityAttributes otherAttributes) {
        this.cooldown().setBaseValue(otherAttributes.cooldown().getBase());
        this.duration().setBaseValue(otherAttributes.duration().getBase());
        this.impact().setBaseValue(otherAttributes.impact().getBase());
        this.impactAngle().setBaseValue(otherAttributes.impactAngle().getBase());
        this.range().setBaseValue(otherAttributes.range().getBase());
        this.value().setBaseValue(otherAttributes.value().getBase());
    }
}

