/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.abilities;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.abilities.AbilityAttributes;
import de.gurkenlabs.litiengine.abilities.AbilityExecution;
import de.gurkenlabs.litiengine.abilities.AbilityInfo;
import de.gurkenlabs.litiengine.abilities.CastType;
import de.gurkenlabs.litiengine.abilities.effects.Effect;
import de.gurkenlabs.litiengine.entities.Creature;
import de.gurkenlabs.litiengine.entities.EntityPivot;
import de.gurkenlabs.litiengine.graphics.IRenderable;
import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

@AbilityInfo
public abstract class Ability
implements IRenderable {
    private final Collection<AbilityCastListener> abilityCastListeners = ConcurrentHashMap.newKeySet();
    private final AbilityAttributes attributes;
    private final List<Effect> effects = new CopyOnWriteArrayList<Effect>();
    private final Creature executor;
    private final EntityPivot entityPivot;
    private String name;
    private String description;
    private boolean multiTarget;
    private CastType castType;
    private AbilityExecution currentExecution;

    protected Ability(Creature executor) {
        AbilityInfo info = this.getClass().getAnnotation(AbilityInfo.class);
        this.attributes = new AbilityAttributes(info);
        this.executor = executor;
        this.name = info.name();
        this.multiTarget = info.multiTarget();
        this.description = info.description();
        this.castType = info.castType();
        this.entityPivot = new EntityPivot(executor, info.origin(), info.pivotOffsetX(), info.pivotOffsetY());
    }

    public void onCast(AbilityCastListener listener) {
        this.abilityCastListeners.add(listener);
    }

    public void removeAbilityCastListener(AbilityCastListener listener) {
        this.abilityCastListeners.remove(listener);
    }

    public void onEffectApplied(Effect.EffectAppliedListener listener) {
        for (Effect effect : this.getEffects()) {
            this.onEffectApplied(effect, listener);
        }
    }

    public void onEffectCeased(Effect.EffectCeasedListener listener) {
        for (Effect effect : this.getEffects()) {
            this.onEffectCeased(effect, listener);
        }
    }

    public void addEffect(Effect effect) {
        this.getEffects().add(effect);
    }

    public Shape calculateImpactArea() {
        return this.internalCalculateImpactArea(this.getExecutor().getAngle());
    }

    public Ellipse2D calculatePotentialImpactArea() {
        int range = this.getAttributes().impact().get();
        double arcX = this.getPivot().getPoint().getX() - (double)range * 0.5;
        double arcY = this.getPivot().getPoint().getY() - (double)range * 0.5;
        return new Ellipse2D.Double(arcX, arcY, range, range);
    }

    public boolean canCast() {
        return !this.getExecutor().isDead() && !this.isOnCooldown();
    }

    public boolean isOnCooldown() {
        return this.getCurrentExecution() != null && this.getCurrentExecution().getExecutionTicks() > 0L && Game.time().since(this.getCurrentExecution().getExecutionTicks()) < (long)this.getAttributes().cooldown().get().intValue();
    }

    public AbilityExecution cast() {
        if (!this.canCast()) {
            return null;
        }
        this.currentExecution = new AbilityExecution(this);
        for (AbilityCastListener listener : this.abilityCastListeners) {
            listener.abilityCast(this.currentExecution);
        }
        return this.getCurrentExecution();
    }

    public AbilityAttributes getAttributes() {
        return this.attributes;
    }

    public CastType getCastType() {
        return this.castType;
    }

    public float getCooldownInSeconds() {
        return (float)((double)this.getAttributes().cooldown().get().intValue() * 0.001);
    }

    public AbilityExecution getCurrentExecution() {
        return this.currentExecution;
    }

    public String getDescription() {
        return this.description;
    }

    public Creature getExecutor() {
        return this.executor;
    }

    public String getName() {
        return this.name;
    }

    public EntityPivot getPivot() {
        return this.entityPivot;
    }

    public float getRemainingCooldownInSeconds() {
        if (this.getCurrentExecution() == null || this.getExecutor() == null || this.getExecutor().isDead()) {
            return 0.0f;
        }
        return (float)(!this.canCast() ? (double)((long)this.getAttributes().cooldown().get().intValue() - Game.time().since(this.getCurrentExecution().getExecutionTicks())) * 0.001 : 0.0);
    }

    public boolean isActive() {
        return this.getCurrentExecution() != null && Game.time().since(this.getCurrentExecution().getExecutionTicks()) < (long)this.getAttributes().duration().get().intValue();
    }

    public boolean isMultiTarget() {
        return this.multiTarget;
    }

    @Override
    public void render(Graphics2D g) {
        g.setColor(new Color(255, 255, 0, 25));
        Game.graphics().renderShape(g, this.calculateImpactArea(), true);
        Stroke oldStroke = g.getStroke();
        g.setStroke(new BasicStroke(2.0f));
        g.setColor(new Color(255, 255, 0, 50));
        Game.graphics().renderOutline(g, this.calculateImpactArea(), true);
        g.setStroke(oldStroke);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMultiTarget(boolean multiTarget) {
        this.multiTarget = multiTarget;
    }

    public void setCastType(CastType castType) {
        this.castType = castType;
    }

    void setCurrentExecution(AbilityExecution ae) {
        this.currentExecution = ae;
    }

    public List<Effect> getEffects() {
        return this.effects;
    }

    protected Shape internalCalculateImpactArea(double angle) {
        int impact = this.getAttributes().impact().get();
        int impactAngle = this.getAttributes().impactAngle().get();
        double arcX = this.getPivot().getPoint().getX() - (double)impact;
        double arcY = this.getPivot().getPoint().getY() - (double)impact;
        Point2D appliedRange = GeometricUtilities.project((Point2D)new Point2D.Double(arcX, arcY), angle, (double)this.getAttributes().range().get().intValue() * 0.5);
        double start = angle - 90.0 - (double)impactAngle / 2.0;
        if (impactAngle % 360 == 0) {
            return new Ellipse2D.Double(appliedRange.getX(), appliedRange.getY(), (double)impact * 2.0, (double)impact * 2.0);
        }
        return new Arc2D.Double(appliedRange.getX(), appliedRange.getY(), (double)impact * 2.0, (double)impact * 2.0, start, impactAngle, 2);
    }

    private void onEffectApplied(Effect effect, Effect.EffectAppliedListener listener) {
        effect.onEffectApplied(listener);
        for (Effect followUp : effect.getFollowUpEffects()) {
            this.onEffectApplied(followUp, listener);
        }
    }

    private void onEffectCeased(Effect effect, Effect.EffectCeasedListener listener) {
        effect.onEffectCeased(listener);
        for (Effect followUp : effect.getFollowUpEffects()) {
            this.onEffectCeased(followUp, listener);
        }
    }

    @FunctionalInterface
    public static interface AbilityCastListener
    extends EventListener {
        public void abilityCast(AbilityExecution var1);
    }
}

