/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine;

import de.gurkenlabs.litiengine.DefaultUncaughtExceptionHandler;
import de.gurkenlabs.litiengine.GameInfo;
import de.gurkenlabs.litiengine.GameListener;
import de.gurkenlabs.litiengine.GameLog;
import de.gurkenlabs.litiengine.GameLoop;
import de.gurkenlabs.litiengine.GameMetrics;
import de.gurkenlabs.litiengine.GameRandom;
import de.gurkenlabs.litiengine.GameTime;
import de.gurkenlabs.litiengine.GameWindow;
import de.gurkenlabs.litiengine.IGameLoop;
import de.gurkenlabs.litiengine.configuration.ConfigurationGroup;
import de.gurkenlabs.litiengine.configuration.GameConfiguration;
import de.gurkenlabs.litiengine.environment.GameWorld;
import de.gurkenlabs.litiengine.graphics.Camera;
import de.gurkenlabs.litiengine.graphics.DebugRenderer;
import de.gurkenlabs.litiengine.graphics.RenderEngine;
import de.gurkenlabs.litiengine.gui.screens.ScreenManager;
import de.gurkenlabs.litiengine.input.Input;
import de.gurkenlabs.litiengine.physics.PhysicsEngine;
import de.gurkenlabs.litiengine.resources.Resources;
import de.gurkenlabs.litiengine.sound.SoundEngine;
import de.gurkenlabs.litiengine.tweening.TweenEngine;
import de.gurkenlabs.litiengine.util.ArrayUtilities;
import de.gurkenlabs.litiengine.util.io.XmlUtilities;
import java.awt.AWTError;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public final class Game {
    public static final int EXIT_GAME_CLOSED = 0;
    public static final int EXIT_GAME_CRASHED = -1;
    public static final String COMMANDLINE_ARG_RELEASE = "-release";
    public static final String COMMANDLINE_ARG_NOGUI = "-nogui";
    private static final List<GameListener> gameListeners = new CopyOnWriteArrayList<GameListener>();
    private static final RenderEngine graphicsEngine = new RenderEngine();
    private static final SoundEngine soundEngine = new SoundEngine();
    private static final PhysicsEngine physicsEngine = new PhysicsEngine();
    private static final GameConfiguration configuration = new GameConfiguration(new ConfigurationGroup[0]);
    private static final GameMetrics metrics = new GameMetrics();
    private static final GameLog log = new GameLog();
    private static final GameTime gameTime = new GameTime();
    private static final GameRandom random = new GameRandom();
    private static GameInfo gameInfo = new GameInfo();
    private static final TweenEngine tweenEngine = new TweenEngine();
    private static GameLoop gameLoop;
    private static ScreenManager screenManager;
    private static GameWindow gameWindow;
    private static final GameWorld world;
    private static boolean debug;
    private static boolean noGUIMode;
    private static boolean hasStarted;
    private static boolean initialized;

    private Game() {
        throw new UnsupportedOperationException();
    }

    public static void addGameListener(GameListener listener) {
        gameListeners.add(listener);
    }

    public static void removeGameListener(GameListener listener) {
        gameListeners.remove(listener);
    }

    public static void allowDebug(boolean allow) {
        debug = allow;
    }

    public static void hideGUI(boolean noGui) {
        noGUIMode = noGui;
    }

    public static boolean isDebug() {
        return debug;
    }

    public static boolean isInNoGUIMode() {
        return noGUIMode;
    }

    public static boolean hasStarted() {
        return hasStarted;
    }

    public static GameInfo info() {
        return gameInfo;
    }

    public static GameConfiguration config() {
        return configuration;
    }

    public static GameMetrics metrics() {
        return metrics;
    }

    public static GameTime time() {
        return gameTime;
    }

    public static GameWindow window() {
        return gameWindow;
    }

    public static SoundEngine audio() {
        return soundEngine;
    }

    public static PhysicsEngine physics() {
        return physicsEngine;
    }

    public static RenderEngine graphics() {
        return graphicsEngine;
    }

    public static IGameLoop loop() {
        return gameLoop;
    }

    public static Logger log() {
        return log.log();
    }

    public static GameRandom random() {
        return random;
    }

    public static ScreenManager screens() {
        return screenManager;
    }

    public static GameWorld world() {
        return world;
    }

    public static TweenEngine tweens() {
        return tweenEngine;
    }

    public static void init(Runnable preInitialization, Runnable postInitialization, String ... args) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                throw new AWTError("Cannot call init(Runnable, Runnable, String...) from the event dispatcher thread!");
            }
            Game.log().log(Level.INFO, "PreInitialization started");
            SwingUtilities.invokeAndWait(preInitialization);
            Game.log().log(Level.INFO, "PreInitialization complete");
            Game.init(true, args);
            Game.log().log(Level.INFO, "PostInitialization started");
            SwingUtilities.invokeAndWait(postInitialization);
            Game.log().log(Level.INFO, "PostInitialization complete.");
        }
        catch (InterruptedException | InvocationTargetException e) {
            throw new Error(e);
        }
    }

    public static void init(String ... args) {
        Game.init(!SwingUtilities.isEventDispatchThread(), args);
    }

    private static Runnable initImpl(String ... args) {
        return () -> {
            Game.log().log(Level.INFO, "Initialization started");
            if (!SwingUtilities.isEventDispatchThread()) {
                throw new AWTError("Game must be initialized inside the Swing Dispatch Thread!");
            }
            if (initialized) {
                Game.log().log(Level.INFO, "The game has already been initialized.");
                return;
            }
            log.init();
            Game.handleCommandLineArguments(args);
            Game.config().load();
            Locale.setDefault(Locale.of(Game.config().client().getCountry(), Game.config().client().getLanguage()));
            gameLoop = new GameLoop("Main Update Loop", Game.config().client().getMaxFps());
            Game.loop().attach(Game.physics());
            Game.loop().attach(Game.world());
            Game.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(Game.config().client().exitOnError()));
            screenManager = new ScreenManager();
            gameWindow = new GameWindow();
            Game.window().init();
            world.setCamera(new Camera());
            for (GameListener listener : gameListeners) {
                listener.initialized(args);
            }
            if (!Game.isInNoGUIMode()) {
                Game.window().getRenderComponent().onRendered(g -> Game.metrics().render((Graphics2D)g));
                Game.graphics().addEntityRenderedListener(e -> DebugRenderer.renderEntityDebugInfo(e.getGraphics(), e.getEntity()));
                Game.window().getRenderComponent().onFpsChanged(fps -> Game.metrics().setFramesPerSecond(fps));
                Game.window().setIcons(Arrays.asList((BufferedImage)Resources.images().get("liti-logo-x16.png"), (BufferedImage)Resources.images().get("liti-logo-x20.png"), (BufferedImage)Resources.images().get("liti-logo-x32.png"), (BufferedImage)Resources.images().get("liti-logo-x48.png")));
                Input.keyboard().onKeyTyped(154, key -> {
                    if (key.getModifiers() != 0) {
                        return;
                    }
                    Game.window().getRenderComponent().takeScreenshot();
                });
            }
            Runtime.getRuntime().addShutdownHook(new Thread(Game::terminate, "Shutdown"));
            initialized = true;
            Game.log().log(Level.INFO, "Initialization complete");
        };
    }

    public static void init(boolean initInSwingThread, String ... args) {
        if (initInSwingThread) {
            try {
                SwingUtilities.invokeAndWait(Game.initImpl(new String[0]));
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new Error(e);
            }
        } else {
            Game.initImpl(args).run();
        }
    }

    public static void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        gameLoop.setUncaughtExceptionHandler(uncaughtExceptionHandler);
        Thread.setDefaultUncaughtExceptionHandler(uncaughtExceptionHandler);
    }

    public static void start() {
        Runnable r = () -> {
            if (!SwingUtilities.isEventDispatchThread()) {
                throw new AssertionError((Object)"Game wasn't started inside the Swing Dispatch Thread?! This should be impossible!");
            }
            if (!initialized) {
                throw new IllegalStateException("The game cannot be started without being first initialized. Call Game.init(...) before Game.start().");
            }
            gameLoop.start();
            tweenEngine.start();
            soundEngine.start();
            for (GameListener listener : gameListeners) {
                listener.started();
            }
            hasStarted = true;
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new Error(e);
            }
        }
    }

    public static void exit() {
        if (Game.terminating()) {
            System.exit(0);
        }
    }

    public static void setInfo(GameInfo info) {
        gameInfo = info;
    }

    public static void setInfo(String gameInfoFile) {
        Game.setInfo(Resources.getLocation(gameInfoFile));
    }

    public static void setInfo(URL gameInfoFile) {
        GameInfo info;
        try {
            info = XmlUtilities.read(GameInfo.class, gameInfoFile);
        }
        catch (Exception e) {
            Game.log().log(Level.WARNING, "Could not read game info from {0}", new Object[]{gameInfoFile});
            Game.setInfo((GameInfo)null);
            return;
        }
        Game.setInfo(info);
    }

    static boolean terminating() {
        for (GameListener listener : gameListeners) {
            try {
                if (listener.terminating()) continue;
                return false;
            }
            catch (Exception e) {
                Game.log().log(Level.WARNING, "game listener threw an exception while terminating", e);
            }
        }
        return true;
    }

    static void terminate() {
        if (!initialized) {
            return;
        }
        hasStarted = false;
        initialized = false;
        Game.config().save();
        gameLoop.terminate();
        tweenEngine.terminate();
        soundEngine.terminate();
        Game.world().clear();
        for (GameListener listener : gameListeners) {
            try {
                listener.terminated();
            }
            catch (Exception e) {
                Game.log().log(Level.WARNING, "game listener threw an exception during shutdown", e);
            }
        }
        gameLoop = null;
        screenManager = null;
        gameWindow = null;
    }

    private static void handleCommandLineArguments(String[] args) {
        if (args == null || args.length == 0) {
            return;
        }
        if (ArrayUtilities.contains(args, COMMANDLINE_ARG_RELEASE, true)) {
            Game.allowDebug(false);
        }
        if (ArrayUtilities.contains(args, COMMANDLINE_ARG_NOGUI, true)) {
            Game.hideGUI(true);
        }
    }

    static {
        world = new GameWorld();
        debug = true;
        noGUIMode = false;
        world.onLoaded(gameTime);
        Game.addGameListener(new Input.InputGameAdapter());
    }
}

