/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.serializer.spi.iobuffer;

import de.gsi.serializer.FieldDescription;
import de.gsi.serializer.FieldSerialiser;
import de.gsi.serializer.IoClassSerialiser;
import de.gsi.serializer.utils.ClassUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.Set;

public class FieldCollectionsHelper {
    private FieldCollectionsHelper() {
    }

    public static void register(IoClassSerialiser serialiser) {
        FieldSerialiser.TriFunction<Collection> returnCollection = (io, obj, field) -> io.getCollection(field == null ? null : (Collection)field.getField().get(obj));
        FieldSerialiser.TriFunction<Collection> returnList = (io, obj, field) -> io.getList(field == null ? null : (List)field.getField().get(obj));
        FieldSerialiser.TriFunction<Collection> returnQueue = (io, obj, field) -> io.getQueue(field == null ? null : (Queue)field.getField().get(obj));
        FieldSerialiser.TriFunction<Collection> returnSet = (io, obj, field) -> io.getSet(field == null ? null : (Set)field.getField().get(obj));
        FieldSerialiser.TriConsumer collectionWriter = (io, obj, field) -> {
            if (field != null && !field.getActualTypeArguments().isEmpty() && ClassUtils.isPrimitiveWrapperOrString(ClassUtils.getRawType(field.getActualTypeArguments().get(0)))) {
                io.put((FieldDescription)field, (Collection)field.getField().get(obj), field.getActualTypeArguments().get(0));
                return;
            }
            if (field != null) {
                io.put((FieldDescription)field, (Collection)field.getField().get(obj), field.getActualTypeArguments().get(0));
                return;
            }
            throw new IllegalArgumentException("serialiser for obj = '" + obj + "' and type = '" + (Serializable)(obj == null ? "null" : obj.getClass()) + "'  not yet implemented, field = " + field);
        };
        serialiser.addClassDefinition(new FieldSerialiser<Collection>((io, obj, field) -> field.getField().set(obj, returnCollection.apply(io, obj, field)), returnCollection, collectionWriter, Collection.class, new Class[0]));
        serialiser.addClassDefinition(new FieldSerialiser<Collection>((io, obj, field) -> field.getField().set(obj, returnList.apply(io, obj, field)), returnList, collectionWriter, List.class, new Class[0]));
        serialiser.addClassDefinition(new FieldSerialiser<Collection>((io, obj, field) -> field.getField().set(obj, returnQueue.apply(io, obj, field)), returnQueue, collectionWriter, Queue.class, new Class[0]));
        serialiser.addClassDefinition(new FieldSerialiser<Collection>((io, obj, field) -> field.getField().set(obj, returnSet.apply(io, obj, field)), returnSet, collectionWriter, Set.class, new Class[0]));
    }
}

