/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.serializer.spi;

import de.gsi.dataset.utils.AssertUtils;
import de.gsi.serializer.IoBuffer;
import java.lang.reflect.Field;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import sun.misc.Unsafe;

public class FastByteBuffer
implements IoBuffer {
    public static final int SIZE_OF_BOOLEAN = 1;
    public static final int SIZE_OF_BYTE = 1;
    public static final int SIZE_OF_SHORT = 2;
    public static final int SIZE_OF_CHAR = 2;
    public static final int SIZE_OF_INT = 4;
    public static final int SIZE_OF_LONG = 8;
    public static final int SIZE_OF_FLOAT = 4;
    public static final int SIZE_OF_DOUBLE = 8;
    public static final String INVALID_UTF_8 = "Invalid UTF-8";
    private static final int DEFAULT_INITIAL_CAPACITY = 1024;
    private static final int DEFAULT_MIN_CAPACITY_INCREASE = 1024;
    private static final int DEFAULT_MAX_CAPACITY_INCREASE = 102400;
    private static final Unsafe unsafe;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final StringBuilder builder = new StringBuilder(100);
    private int position;
    private int limit;
    private byte[] buffer;
    private boolean enforceSimpleStringEncoding = false;

    public FastByteBuffer() {
        this(1024);
    }

    public FastByteBuffer(byte[] buffer, int limit) {
        AssertUtils.notNull((String)"buffer", (Object)buffer);
        if (buffer.length < limit) {
            throw new IllegalArgumentException(String.format("limit %d >= capacity %d", limit, buffer.length));
        }
        this.buffer = buffer;
        this.limit = limit;
        this.position = 0;
    }

    public FastByteBuffer(int size) {
        AssertUtils.gtEqThanZero((String)"size", (int)size);
        this.buffer = new byte[size];
        this.position = 0;
        this.limit = this.buffer.length;
    }

    @Override
    public int capacity() {
        return this.buffer.length;
    }

    @Override
    public void clear() {
        this.position = 0;
        this.limit = this.capacity();
    }

    @Override
    public byte[] elements() {
        return this.buffer;
    }

    @Override
    public void ensureAdditionalCapacity(int capacity) {
        int neededTotalCapacity = this.position() + capacity;
        if (neededTotalCapacity < this.capacity()) {
            return;
        }
        if (this.position > this.capacity()) {
            throw new IllegalStateException("position " + this.position + " is beyond buffer capacity " + this.capacity());
        }
        int addCapacity = Math.min(Math.max(1024, neededTotalCapacity >> 3), 102400);
        this.forceCapacity(neededTotalCapacity + addCapacity, this.capacity());
    }

    @Override
    public void ensureCapacity(int newCapacity) {
        if (newCapacity <= this.capacity()) {
            return;
        }
        this.forceCapacity(newCapacity, this.capacity());
    }

    @Override
    public void flip() {
        this.limit = this.position;
        this.position = 0;
    }

    @Override
    public void forceCapacity(int length, int preserve) {
        if (length == this.capacity()) {
            return;
        }
        byte[] newBuffer = new byte[length];
        int bytesToCopy = preserve * 1;
        FastByteBuffer.copyMemory(this.buffer, Unsafe.ARRAY_BYTE_BASE_OFFSET, newBuffer, Unsafe.ARRAY_BYTE_BASE_OFFSET, bytesToCopy);
        this.position = this.position < newBuffer.length ? this.position : newBuffer.length - 1;
        this.buffer = newBuffer;
        this.limit = this.buffer.length;
    }

    @Override
    public boolean getBoolean() {
        boolean value = unsafe.getBoolean(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)this.position);
        ++this.position;
        return value;
    }

    @Override
    public boolean[] getBooleanArray(boolean[] dst, int length) {
        int arraySize = this.getInt();
        boolean initNeeded = dst == null || length < 0 || dst.length != arraySize;
        boolean[] values = initNeeded ? new boolean[arraySize] : dst;
        FastByteBuffer.copyMemory(this.buffer, Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position, values, Unsafe.ARRAY_BOOLEAN_BASE_OFFSET, arraySize);
        this.position += arraySize;
        return values;
    }

    @Override
    public byte getByte() {
        byte value = unsafe.getByte(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)this.position);
        ++this.position;
        return value;
    }

    @Override
    public byte[] getByteArray(byte[] dst, int length) {
        int arraySize = this.getInt();
        boolean initNeeded = dst == null || length < 0 || dst.length != arraySize;
        byte[] values = initNeeded ? new byte[arraySize] : dst;
        FastByteBuffer.copyMemory(this.buffer, Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position, values, Unsafe.ARRAY_BYTE_BASE_OFFSET, arraySize);
        this.position += arraySize;
        return values;
    }

    @Override
    public char getChar() {
        char value = unsafe.getChar(this.buffer, (long)Unsafe.ARRAY_CHAR_BASE_OFFSET + (long)this.position);
        this.position += 2;
        return value;
    }

    @Override
    public char[] getCharArray(char[] dst, int length) {
        int arraySize = this.getInt();
        boolean initNeeded = dst == null || length < 0 || dst.length != arraySize;
        char[] values = initNeeded ? new char[arraySize] : dst;
        int bytesToCopy = arraySize * 2;
        FastByteBuffer.copyMemory(this.buffer, Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position, values, Unsafe.ARRAY_SHORT_BASE_OFFSET, bytesToCopy);
        this.position += bytesToCopy;
        return values;
    }

    @Override
    public double getDouble() {
        double value = unsafe.getDouble(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)this.position);
        this.position += 8;
        return value;
    }

    @Override
    public double[] getDoubleArray(double[] dst, int length) {
        int arraySize = this.getInt();
        boolean initNeeded = dst == null || length < 0 || dst.length != arraySize;
        double[] values = initNeeded ? new double[arraySize] : dst;
        int bytesToCopy = arraySize * 8;
        FastByteBuffer.copyMemory(this.buffer, Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position, values, Unsafe.ARRAY_DOUBLE_BASE_OFFSET, bytesToCopy);
        this.position += bytesToCopy;
        return values;
    }

    @Override
    public float getFloat() {
        float value = unsafe.getFloat(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)this.position);
        this.position += 4;
        return value;
    }

    @Override
    public float[] getFloatArray(float[] dst, int length) {
        int arraySize = this.getInt();
        boolean initNeeded = dst == null || length < 0 || dst.length != arraySize;
        float[] values = initNeeded ? new float[arraySize] : dst;
        int bytesToCopy = arraySize * 4;
        FastByteBuffer.copyMemory(this.buffer, Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position, values, Unsafe.ARRAY_FLOAT_BASE_OFFSET, bytesToCopy);
        this.position += bytesToCopy;
        return values;
    }

    @Override
    public int getInt() {
        int value = unsafe.getInt(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)this.position);
        this.position += 4;
        return value;
    }

    @Override
    public int[] getIntArray(int[] dst, int length) {
        int arraySize = this.getInt();
        boolean initNeeded = dst == null || length < 0 || dst.length != arraySize;
        int[] values = initNeeded ? new int[arraySize] : dst;
        int bytesToCopy = arraySize * 4;
        FastByteBuffer.copyMemory(this.buffer, Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position, values, Unsafe.ARRAY_INT_BASE_OFFSET, bytesToCopy);
        this.position += bytesToCopy;
        return values;
    }

    @Override
    public long getLong() {
        long value = unsafe.getLong(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)this.position);
        this.position += 8;
        return value;
    }

    @Override
    public long[] getLongArray(long[] dst, int length) {
        int arraySize = this.getInt();
        boolean initNeeded = dst == null || length < 0 || dst.length != arraySize;
        long[] values = initNeeded ? new long[arraySize] : dst;
        int bytesToCopy = arraySize * 8;
        FastByteBuffer.copyMemory(this.buffer, Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position, values, Unsafe.ARRAY_LONG_BASE_OFFSET, bytesToCopy);
        this.position += bytesToCopy;
        return values;
    }

    @Override
    public short getShort() {
        short value = unsafe.getShort(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)this.position);
        this.position += 2;
        return value;
    }

    @Override
    public short[] getShortArray(short[] dst, int length) {
        int arraySize = this.getInt();
        boolean initNeeded = dst == null || length < 0 || dst.length != arraySize;
        short[] values = initNeeded ? new short[arraySize] : dst;
        int bytesToCopy = arraySize * 2;
        FastByteBuffer.copyMemory(this.buffer, Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position, values, Unsafe.ARRAY_SHORT_BASE_OFFSET, bytesToCopy);
        this.position += bytesToCopy;
        return values;
    }

    @Override
    public String getString() {
        if (this.isEnforceSimpleStringEncoding()) {
            return this.getStringISO8859();
        }
        int arraySize = this.getInt();
        FastByteBuffer.decodeUTF8(this.buffer, this.position, arraySize - 1, this.builder);
        this.position += arraySize;
        return this.builder.toString();
    }

    @Override
    public String[] getStringArray(String[] dst, int length) {
        int arraySize = this.getInt();
        boolean initNeeded = dst == null || length < 0 || dst.length != arraySize;
        String[] ret = initNeeded ? new String[arraySize] : dst;
        for (int k = 0; k < arraySize; ++k) {
            ret[k] = this.getString();
        }
        return ret;
    }

    @Override
    public String getStringISO8859() {
        int arraySize = this.getInt();
        String str = new String(this.buffer, 0, this.position, arraySize - 1);
        this.position += arraySize;
        return str;
    }

    @Override
    public boolean hasRemaining() {
        return this.position() < this.capacity();
    }

    @Override
    public boolean isEnforceSimpleStringEncoding() {
        return this.enforceSimpleStringEncoding;
    }

    @Override
    public void setEnforceSimpleStringEncoding(boolean state) {
        this.enforceSimpleStringEncoding = state;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public void limit(int newLimit) {
        if (newLimit > this.capacity() || newLimit < 0) {
            throw new IllegalArgumentException(String.format("invalid newLimit: [0, position: %d, newLimit:%d, %d]", this.position, newLimit, this.capacity()));
        }
        this.limit = newLimit;
        if (this.position > this.limit) {
            this.position = this.limit;
        }
    }

    @Override
    public ReadWriteLock lock() {
        return this.lock;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public void position(int newPosition) {
        if (newPosition > this.limit || newPosition < 0 || newPosition >= this.capacity()) {
            throw new IllegalArgumentException(String.format("invalid newPosition: %d vs. [0, position=%d, limit:%d, capacity:%d]", newPosition, this.position, this.limit, this.capacity()));
        }
        this.position = newPosition;
    }

    @Override
    public void putBoolean(boolean value) {
        unsafe.putBoolean(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)this.position, value);
        ++this.position;
    }

    @Override
    public void putBooleanArray(boolean[] values, int n) {
        int valuesSize = values == null ? 0 : values.length;
        int nElements = n >= 0 ? Math.min(n, valuesSize) : valuesSize;
        this.ensureAdditionalCapacity(nElements);
        this.putInt(nElements);
        FastByteBuffer.copyMemory(values, Unsafe.ARRAY_BOOLEAN_BASE_OFFSET, this.buffer, Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position, nElements);
        this.position += nElements;
    }

    @Override
    public void putByte(byte value) {
        unsafe.putByte(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)this.position, value);
        ++this.position;
    }

    @Override
    public void putByteArray(byte[] values, int n) {
        int valuesSize = values == null ? 0 : values.length;
        int nElements = n >= 0 ? Math.min(n, valuesSize) : valuesSize;
        this.ensureAdditionalCapacity(nElements);
        this.putInt(nElements);
        FastByteBuffer.copyMemory(values, Unsafe.ARRAY_BOOLEAN_BASE_OFFSET, this.buffer, Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position, nElements);
        this.position += nElements;
    }

    @Override
    public void putChar(char value) {
        unsafe.putChar(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)this.position, value);
        this.position += 2;
    }

    @Override
    public void putCharArray(char[] values, int n) {
        int arrayOffset = Unsafe.ARRAY_CHAR_BASE_OFFSET;
        int valuesSize = values == null ? 0 : values.length;
        int nElements = n >= 0 ? Math.min(n, valuesSize) : valuesSize;
        int bytesToCopy = nElements * 2;
        this.ensureAdditionalCapacity(bytesToCopy);
        this.putInt(nElements);
        FastByteBuffer.copyMemory(values, arrayOffset, this.buffer, arrayOffset + this.position, bytesToCopy);
        this.position += bytesToCopy;
    }

    @Override
    public void putDouble(double value) {
        unsafe.putDouble(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)this.position, value);
        this.position += 8;
    }

    @Override
    public void putDoubleArray(double[] values, int n) {
        int arrayOffset = Unsafe.ARRAY_DOUBLE_BASE_OFFSET;
        int valuesSize = values == null ? 0 : values.length;
        int nElements = n >= 0 ? Math.min(n, valuesSize) : valuesSize;
        int bytesToCopy = nElements * 8;
        this.ensureAdditionalCapacity(bytesToCopy);
        this.putInt(nElements);
        FastByteBuffer.copyMemory(values, arrayOffset, this.buffer, arrayOffset + this.position, bytesToCopy);
        this.position += bytesToCopy;
    }

    @Override
    public void putFloat(float value) {
        unsafe.putFloat(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)this.position, value);
        this.position += 4;
    }

    @Override
    public void putFloatArray(float[] values, int n) {
        int arrayOffset = Unsafe.ARRAY_FLOAT_BASE_OFFSET;
        int valuesSize = values == null ? 0 : values.length;
        int nElements = n >= 0 ? Math.min(n, valuesSize) : valuesSize;
        int bytesToCopy = nElements * 4;
        this.ensureAdditionalCapacity(bytesToCopy);
        this.putInt(nElements);
        FastByteBuffer.copyMemory(values, arrayOffset, this.buffer, arrayOffset + this.position, bytesToCopy);
        this.position += bytesToCopy;
    }

    @Override
    public void putInt(int value) {
        unsafe.putInt(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)this.position, value);
        this.position += 4;
    }

    @Override
    public void putIntArray(int[] values, int n) {
        int arrayOffset = Unsafe.ARRAY_INT_BASE_OFFSET;
        int valuesSize = values == null ? 0 : values.length;
        int nElements = n >= 0 ? Math.min(n, valuesSize) : valuesSize;
        int bytesToCopy = nElements * 4;
        this.ensureAdditionalCapacity(bytesToCopy);
        this.putInt(nElements);
        FastByteBuffer.copyMemory(values, arrayOffset, this.buffer, arrayOffset + this.position, bytesToCopy);
        this.position += bytesToCopy;
    }

    @Override
    public void putLong(long value) {
        unsafe.putLong(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)this.position, value);
        this.position += 8;
    }

    @Override
    public void putLongArray(long[] values, int n) {
        int arrayOffset = Unsafe.ARRAY_LONG_BASE_OFFSET;
        int valuesSize = values == null ? 0 : values.length;
        int nElements = n >= 0 ? Math.min(n, valuesSize) : valuesSize;
        int bytesToCopy = nElements * 8;
        this.ensureAdditionalCapacity(bytesToCopy);
        this.putInt(nElements);
        FastByteBuffer.copyMemory(values, arrayOffset, this.buffer, arrayOffset + this.position, bytesToCopy);
        this.position += bytesToCopy;
    }

    @Override
    public void putShort(short value) {
        unsafe.putShort(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)this.position, value);
        this.position += 2;
    }

    @Override
    public void putShortArray(short[] values, int n) {
        int arrayOffset = Unsafe.ARRAY_SHORT_BASE_OFFSET;
        int valuesSize = values == null ? 0 : values.length;
        int nElements = n >= 0 ? Math.min(n, valuesSize) : valuesSize;
        int bytesToCopy = nElements * 2;
        this.ensureAdditionalCapacity(bytesToCopy);
        this.putInt(nElements);
        FastByteBuffer.copyMemory(values, arrayOffset, this.buffer, arrayOffset + this.position, bytesToCopy);
        this.position += bytesToCopy;
    }

    @Override
    public void putString(String string) {
        if (string == null) {
            this.putString("");
            return;
        }
        if (this.isEnforceSimpleStringEncoding()) {
            this.putStringISO8859(string);
            return;
        }
        int utf16StringLength = string.length();
        int initialPos = this.position;
        this.position += 4;
        this.ensureAdditionalCapacity(3 * utf16StringLength + 1);
        int strLength = FastByteBuffer.encodeUTF8(string, this.buffer, this.position, 3 * utf16StringLength);
        int endPos = this.position + strLength;
        this.position = initialPos;
        this.putInt(strLength + 1);
        this.position = endPos;
        this.putByte((byte)0);
    }

    @Override
    public void putStringArray(String[] values, int n) {
        int valuesSize = values == null ? 0 : values.length;
        int nElements = n >= 0 ? Math.min(n, valuesSize) : valuesSize;
        this.ensureAdditionalCapacity(nElements);
        this.putInt(nElements);
        if (values == null) {
            return;
        }
        if (this.isEnforceSimpleStringEncoding()) {
            for (int k = 0; k < nElements; ++k) {
                this.putStringISO8859(values[k]);
            }
            return;
        }
        for (int k = 0; k < nElements; ++k) {
            this.putString(values[k]);
        }
    }

    @Override
    public void putStringISO8859(String string) {
        if (string == null) {
            this.putStringISO8859("");
            return;
        }
        int initialPos = this.position;
        this.position += 4;
        int strLength = FastByteBuffer.encodeISO8859(string, this.buffer, this.position, string.length());
        int endPos = this.position + strLength;
        this.position = initialPos;
        this.putInt(strLength + 1);
        this.position = endPos;
        this.putByte((byte)0);
    }

    @Override
    public int remaining() {
        return this.limit - this.position;
    }

    @Override
    public void reset() {
        this.position = 0;
        this.limit = this.buffer.length;
    }

    public String toString() {
        return super.toString() + String.format(" - [0, position=%d, limit:%d, capacity:%d]", this.position, this.limit, this.capacity());
    }

    @Override
    public void trim() {
        this.trim(this.position());
    }

    @Override
    public void trim(int requestedCapacity) {
        if (requestedCapacity >= this.capacity() || this.position() > requestedCapacity) {
            return;
        }
        int bytesToCopy = Math.min(Math.max(requestedCapacity, this.position()), this.capacity()) * 1;
        byte[] newBuffer = new byte[bytesToCopy];
        FastByteBuffer.copyMemory(this.buffer, Unsafe.ARRAY_BYTE_BASE_OFFSET, newBuffer, Unsafe.ARRAY_BYTE_BASE_OFFSET, bytesToCopy);
        this.buffer = newBuffer;
        this.limit = newBuffer.length;
    }

    public static FastByteBuffer wrap(byte[] byteArray) {
        return FastByteBuffer.wrap(byteArray, byteArray.length);
    }

    public static FastByteBuffer wrap(byte[] byteArray, int length) {
        return new FastByteBuffer(byteArray, length);
    }

    private static void copyMemory(Object srcBase, int srcOffset, Object destBase, int destOffset, int nBytes) {
        unsafe.copyMemory(srcBase, srcOffset, destBase, destOffset, nBytes);
    }

    private static void decodeUTF8(byte[] bytes, int offset, int size, StringBuilder result) {
        byte byte1;
        int remaining;
        if ((offset | size | bytes.length - offset - size) < 0) {
            throw new ArrayIndexOutOfBoundsException(String.format("buffer length=%d, offset=%d, size=%d", bytes.length, offset, size));
        }
        result.setLength(size);
        long readPos = (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)offset;
        int resultPos = 0;
        for (remaining = size; remaining > 0 && (byte1 = unsafe.getByte(bytes, readPos)) >= 0; --remaining) {
            ++readPos;
            result.setCharAt(resultPos++, (char)byte1);
        }
        while (remaining > 0) {
            byte byte3;
            byte byte2;
            byte1 = unsafe.getByte(bytes, readPos++);
            --remaining;
            if (byte1 >= 0) {
                byte b;
                result.setCharAt(resultPos++, (char)byte1);
                while (remaining > 0 && (b = unsafe.getByte(bytes, readPos)) >= 0) {
                    ++readPos;
                    --remaining;
                    result.setCharAt(resultPos++, (char)b);
                }
                continue;
            }
            if (byte1 < -32) {
                if (remaining < 1) {
                    throw new IllegalArgumentException(INVALID_UTF_8);
                }
                byte2 = unsafe.getByte(bytes, readPos++);
                --remaining;
                int resultPos1 = resultPos++;
                if (byte1 < -62) {
                    throw new IllegalArgumentException("Invalid UTF-8: Illegal leading byte in 2 bytes UTF");
                }
                if (byte2 > -65) {
                    throw new IllegalArgumentException("Invalid UTF-8: Illegal trailing byte in 2 bytes UTF");
                }
                result.setCharAt(resultPos1, (char)((byte1 & 0x1F) << 6 | byte2 & 0x3F));
                continue;
            }
            if (byte1 < -16) {
                if (remaining < 2) {
                    throw new IllegalArgumentException(INVALID_UTF_8);
                }
                byte2 = unsafe.getByte(bytes, readPos++);
                byte3 = unsafe.getByte(bytes, readPos++);
                int resultPos1 = resultPos++;
                if (byte2 > -65 || byte1 == -32 && byte2 < -96 || byte1 == -19 && byte2 >= -96 || byte3 > -65) {
                    throw new IllegalArgumentException(INVALID_UTF_8);
                }
                result.setCharAt(resultPos1, (char)((byte1 & 0xF) << 12 | (byte2 & 0x3F) << 6 | byte3 & 0x3F));
                remaining -= 2;
                continue;
            }
            if (remaining < 3) {
                throw new IllegalArgumentException(INVALID_UTF_8);
            }
            byte2 = unsafe.getByte(bytes, readPos++);
            byte3 = unsafe.getByte(bytes, readPos++);
            byte byte4 = unsafe.getByte(bytes, readPos++);
            int resultPos1 = resultPos++;
            if (byte2 > -65 || (byte1 << 28) + (byte2 - -112) >> 30 != 0 || byte3 > -65 || byte4 > -65) {
                throw new IllegalArgumentException(INVALID_UTF_8);
            }
            int codepoint = (byte1 & 7) << 18 | (byte2 & 0x3F) << 12 | (byte3 & 0x3F) << 6 | byte4 & 0x3F;
            result.setCharAt(resultPos1, (char)(55232 + (codepoint >>> 10)));
            result.setCharAt(resultPos1 + 1, (char)(56320 + (codepoint & 0x3FF)));
            remaining -= 3;
            ++resultPos;
        }
        result.setLength(resultPos);
    }

    private static int encodeISO8859(String sequence, byte[] bytes, int offset, int length) {
        int base = Unsafe.ARRAY_BYTE_BASE_OFFSET + offset;
        for (int i = 0; i < length; ++i) {
            unsafe.putByte(bytes, (long)base + (long)i, (byte)(sequence.charAt(i) & 0xFF));
        }
        return length;
    }

    private static int encodeUTF8(CharSequence sequence, byte[] bytes, int offset, int length) {
        char c;
        int i;
        int utf16Length = sequence.length();
        int base = Unsafe.ARRAY_BYTE_BASE_OFFSET + offset;
        int limit = base + length;
        for (i = 0; i < utf16Length && base + i < limit && (c = sequence.charAt(i)) < '\u0080'; ++i) {
            unsafe.putByte(bytes, (long)base + (long)i, (byte)c);
        }
        if (i == utf16Length) {
            return utf16Length;
        }
        base += i;
        while (i < utf16Length) {
            c = sequence.charAt(i);
            if (c < '\u0080' && base < limit) {
                unsafe.putByte(bytes, base++, (byte)c);
            } else if (c < '\u0800' && base <= limit - 2) {
                unsafe.putByte(bytes, base++, (byte)(0x3C0 | c >>> 6));
                unsafe.putByte(bytes, base++, (byte)(0x80 | 0x3F & c));
            } else if ((c < '\ud800' || '\udfff' < c) && base <= limit - 3) {
                unsafe.putByte(bytes, base++, (byte)(0x1E0 | c >>> 12));
                unsafe.putByte(bytes, base++, (byte)(0x80 | 0x3F & c >>> 6));
                unsafe.putByte(bytes, base++, (byte)(0x80 | 0x3F & c));
            } else if (base <= limit - 4) {
                char low;
                if (i + 1 == sequence.length() || !Character.isSurrogatePair(c, low = sequence.charAt(++i))) {
                    throw new IllegalArgumentException("Unpaired surrogate at index " + (i - 1));
                }
                int codePoint = Character.toCodePoint(c, low);
                unsafe.putByte(bytes, base++, (byte)(0xF0 | codePoint >>> 18));
                unsafe.putByte(bytes, base++, (byte)(0x80 | 0x3F & codePoint >>> 12));
                unsafe.putByte(bytes, base++, (byte)(0x80 | 0x3F & codePoint >>> 6));
                unsafe.putByte(bytes, base++, (byte)(0x80 | 0x3F & codePoint));
            } else {
                throw new ArrayIndexOutOfBoundsException("Failed writing " + c + " at index " + base);
            }
            ++i;
        }
        return base - Unsafe.ARRAY_BYTE_BASE_OFFSET - offset;
    }

    @Override
    public boolean getBoolean(int position) {
        return unsafe.getBoolean(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)position);
    }

    @Override
    public byte getByte(int position) {
        return unsafe.getByte(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)position);
    }

    @Override
    public char getChar(int position) {
        return unsafe.getChar(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)position);
    }

    @Override
    public short getShort(int position) {
        return unsafe.getShort(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)position);
    }

    @Override
    public int getInt(int position) {
        return unsafe.getInt(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)position);
    }

    @Override
    public long getLong(int position) {
        return unsafe.getLong(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)position);
    }

    @Override
    public float getFloat(int position) {
        return unsafe.getFloat(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)position);
    }

    @Override
    public double getDouble(int position) {
        return unsafe.getDouble(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)position);
    }

    @Override
    public String getString(int position) {
        int oldPosition = this.position();
        this.position(position);
        String ret = this.getString();
        this.position(oldPosition);
        return ret;
    }

    @Override
    public void putBoolean(int position, boolean value) {
        unsafe.putBoolean(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)position, value);
    }

    @Override
    public void putByte(int position, byte value) {
        unsafe.putByte(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)position, value);
    }

    @Override
    public void putChar(int position, char value) {
        unsafe.putChar(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)position, value);
    }

    @Override
    public void putShort(int position, short value) {
        unsafe.putShort(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)position, value);
    }

    @Override
    public void putInt(int position, int value) {
        unsafe.putInt(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)position, value);
    }

    @Override
    public void putLong(int position, long value) {
        unsafe.putLong(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)position, value);
    }

    @Override
    public void putFloat(int position, float value) {
        unsafe.putFloat(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)position, value);
    }

    @Override
    public void putDouble(int position, double value) {
        unsafe.putDouble(this.buffer, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)position, value);
    }

    @Override
    public void putString(int position, String value) {
        int oldPosition = this.position();
        this.position(position);
        this.putString(value);
        this.position(oldPosition);
    }

    static {
        try {
            Class<?> cls = Class.forName("jdk.internal.module.IllegalAccessLogger");
            Field logger = cls.getDeclaredField("logger");
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
            unsafe.putObjectVolatile(cls, unsafe.staticFieldOffset(logger), null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | SecurityException e) {
            throw new SecurityException(e);
        }
    }
}

