/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.serializer.spi;

import de.gsi.dataset.utils.AssertUtils;
import de.gsi.dataset.utils.GenericsHelper;
import de.gsi.serializer.DataType;
import de.gsi.serializer.FieldDescription;
import de.gsi.serializer.FieldSerialiser;
import de.gsi.serializer.IoBuffer;
import de.gsi.serializer.IoSerialiser;
import de.gsi.serializer.spi.ClassFieldDescription;
import de.gsi.serializer.spi.ProtocolInfo;
import de.gsi.serializer.spi.WireDataFieldDescription;
import de.gsi.serializer.utils.ClassUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinarySerialiser
implements IoSerialiser {
    public static final int VERSION_MAGIC_NUMBER = -1;
    public static final String PROTOCOL_NAME = "YaS";
    public static final byte VERSION_MAJOR = 1;
    public static final byte VERSION_MINOR = 0;
    public static final byte VERSION_MICRO = 0;
    public static final String PROTOCOL_ERROR_SERIALISER_LOOKUP_MUST_NOT_BE_NULL = "protocol error: serialiser lookup must not be null for DataType == OTHER";
    public static final String PROTOCOL_MISMATCH_N_ELEMENTS_HEADER = "protocol mismatch nElements header = ";
    public static final String NO_SERIALISER_IMP_FOUND = "no serialiser implementation found for classType = ";
    public static final String VS_ARRAY = " vs. array = ";
    private static final Logger LOGGER = LoggerFactory.getLogger(BinarySerialiser.class);
    private static final int ADDITIONAL_HEADER_INFO_SIZE = 1000;
    private static final DataType[] byteToDataType = new DataType[256];
    private static final Byte[] dataTypeToByte = new Byte[256];
    public static final String VS_SHOULD_BE = "' vs. should be '";
    private int bufferIncrements = 1000;
    private IoBuffer buffer;
    private boolean putFieldMetaData = true;
    private WireDataFieldDescription parent;
    private WireDataFieldDescription lastFieldHeader;
    private BiFunction<Type, Type[], FieldSerialiser<Object>> fieldSerialiserLookupFunction;

    public BinarySerialiser(IoBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public ProtocolInfo checkHeaderInfo() {
        int magicNumber = this.buffer.getInt();
        if (magicNumber != -1) {
            throw new IllegalStateException("byte buffer version magic byte incompatible: received '" + magicNumber + "' vs. should be '-1'");
        }
        String producer = this.buffer.getStringISO8859();
        if (!PROTOCOL_NAME.equals(producer)) {
            throw new IllegalStateException("byte buffer producer name incompatible: received '" + producer + "' vs. should be 'YaS'");
        }
        byte major = this.buffer.getByte();
        byte minor = this.buffer.getByte();
        byte micro = this.buffer.getByte();
        WireDataFieldDescription headerStartField = this.getFieldHeader();
        ProtocolInfo header = new ProtocolInfo(this, headerStartField, producer, major, minor, micro);
        if (!header.isCompatible()) {
            String thisHeader = String.format(" serialiser: %s-v%d.%d.%d", PROTOCOL_NAME, (byte)1, (byte)0, (byte)0);
            throw new IllegalStateException("byte buffer version incompatible: received '" + header.toString() + VS_SHOULD_BE + thisHeader + "'");
        }
        return header;
    }

    @Override
    public void setQueryFieldName(String fieldName, int dataStartPosition) {
        if (fieldName == null || fieldName.isBlank()) {
            throw new IllegalArgumentException("fieldName must not be null or blank: " + fieldName);
        }
        this.buffer.position(dataStartPosition);
    }

    @Override
    public int[] getArraySizeDescriptor() {
        int nDims = this.buffer.getInt();
        int[] ret = new int[nDims];
        for (int i = 0; i < nDims; ++i) {
            ret[i] = this.buffer.getInt();
        }
        return ret;
    }

    @Override
    public boolean getBoolean() {
        return this.buffer.getBoolean();
    }

    @Override
    public boolean[] getBooleanArray(boolean[] dst, int length) {
        this.getArraySizeDescriptor();
        return this.buffer.getBooleanArray(dst, length);
    }

    @Override
    public IoBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public void setBuffer(IoBuffer buffer) {
        this.buffer = buffer;
    }

    public int getBufferIncrements() {
        return this.bufferIncrements;
    }

    public void setBufferIncrements(int bufferIncrements) {
        AssertUtils.gtEqThanZero((String)"bufferIncrements", (int)bufferIncrements);
        this.bufferIncrements = bufferIncrements;
    }

    @Override
    public byte getByte() {
        return this.buffer.getByte();
    }

    @Override
    public byte[] getByteArray(byte[] dst, int length) {
        this.getArraySizeDescriptor();
        return this.buffer.getByteArray(dst, length);
    }

    @Override
    public char getChar() {
        return this.buffer.getChar();
    }

    @Override
    public char[] getCharArray(char[] dst, int length) {
        this.getArraySizeDescriptor();
        return this.buffer.getCharArray(dst, length);
    }

    @Override
    public <E> Collection<E> getCollection(Collection<E> collection) {
        Collection<Object> retCollection;
        this.getArraySizeDescriptor();
        int nElements = this.buffer.getInt();
        DataType collectionType = BinarySerialiser.getDataType(this.buffer.getByte());
        DataType valueDataType = BinarySerialiser.getDataType(this.buffer.getByte());
        if (collection != null) {
            retCollection = collection;
            retCollection.clear();
        } else {
            switch (collectionType) {
                case SET: {
                    retCollection = new HashSet(nElements);
                    break;
                }
                case QUEUE: {
                    retCollection = new ArrayDeque(nElements);
                    break;
                }
                default: {
                    retCollection = new ArrayList(nElements);
                }
            }
        }
        if (DataType.OTHER.equals((Object)valueDataType)) {
            Type[] typeArray;
            String classTypeName = this.buffer.getStringISO8859();
            String secondaryTypeName = this.buffer.getStringISO8859();
            Class<?> classType = ClassUtils.getClassByName(classTypeName);
            if (secondaryTypeName.isEmpty()) {
                typeArray = new Type[]{};
            } else {
                Type[] typeArray2 = new Type[1];
                typeArray = typeArray2;
                typeArray2[0] = ClassUtils.getClassByName(secondaryTypeName);
            }
            Type[] secondaryType = typeArray;
            BiFunction<Type, Type[], FieldSerialiser<Object>> serialiserLookup = this.getSerialiserLookupFunction();
            if (serialiserLookup == null) {
                throw new IllegalArgumentException(PROTOCOL_ERROR_SERIALISER_LOOKUP_MUST_NOT_BE_NULL);
            }
            FieldSerialiser<Object> serialiser = serialiserLookup.apply(classType, secondaryType);
            if (serialiser == null) {
                throw new IllegalArgumentException(NO_SERIALISER_IMP_FOUND + classTypeName);
            }
            for (int i = 0; i < nElements; ++i) {
                retCollection.add(serialiser.getReturnObjectFunction().apply(this, null, null));
            }
            return retCollection;
        }
        E[] values = this.getGenericArrayAsBoxedPrimitive(valueDataType);
        if (nElements != values.length) {
            throw new IllegalStateException(PROTOCOL_MISMATCH_N_ELEMENTS_HEADER + nElements + VS_ARRAY + values.length);
        }
        retCollection.addAll(Arrays.asList(values));
        return retCollection;
    }

    @Override
    public <E> E getCustomData(FieldSerialiser<E> serialiser) {
        String classType = null;
        String classSecondaryType = null;
        try {
            classType = this.buffer.getStringISO8859();
            classSecondaryType = this.buffer.getStringISO8859();
            if (serialiser == null) {
                Type[] typeArray;
                Class<?> classTypeT = ClassUtils.getClassByName(classType);
                if (classSecondaryType.isEmpty()) {
                    typeArray = new Type[]{};
                } else {
                    Type[] typeArray2 = new Type[1];
                    typeArray = typeArray2;
                    typeArray2[0] = ClassUtils.getClassByName(classSecondaryType);
                }
                Type[] secondaryTypeT = typeArray;
                return (E)this.getSerialiserLookupFunction().apply(classTypeT, secondaryTypeT).getReturnObjectFunction().apply(this, null, null);
            }
            return serialiser.getReturnObjectFunction().apply(this, null, null);
        }
        catch (Exception e) {
            LOGGER.atError().setCause((Throwable)e).addArgument((Object)classType).addArgument((Object)classSecondaryType).log("problems with generic classType: {} classSecondaryType: {}");
            throw e;
        }
    }

    @Override
    public double getDouble() {
        return this.buffer.getDouble();
    }

    @Override
    public double[] getDoubleArray(double[] dst, int length) {
        this.getArraySizeDescriptor();
        return this.buffer.getDoubleArray(dst, length);
    }

    @Override
    public <E extends Enum<E>> Enum<E> getEnum(Enum<E> enumeration) {
        String enumSimpleName = this.buffer.getStringISO8859();
        String enumName = this.buffer.getStringISO8859();
        this.buffer.getStringISO8859();
        String enumState = this.buffer.getStringISO8859();
        this.buffer.getInt();
        Class<?> enumClass = ClassUtils.getClassByName(enumName);
        if (enumClass == null && (enumClass = ClassUtils.getClassByName(enumSimpleName)) == null) {
            throw new IllegalStateException("could not find enum class description '" + enumName + "' or '" + enumSimpleName + "'");
        }
        try {
            Method valueOf = enumClass.getMethod("valueOf", String.class);
            return (Enum)valueOf.invoke(null, enumState);
        }
        catch (ReflectiveOperationException e) {
            LOGGER.atError().setCause((Throwable)e).addArgument(enumClass).log("could not match 'valueOf(String)' function for class/(supposedly) enum of {}");
            return null;
        }
    }

    @Override
    public String getEnumTypeList() {
        this.buffer.getStringISO8859();
        this.buffer.getStringISO8859();
        String enumTypeList = this.buffer.getStringISO8859();
        this.buffer.getStringISO8859();
        this.buffer.getInt();
        return enumTypeList;
    }

    @Override
    public WireDataFieldDescription getFieldHeader() {
        int headerStart = this.buffer.position();
        byte dataTypeByte = this.buffer.getByte();
        int fieldNameHashCode = this.buffer.getInt();
        int dataStartOffset = this.buffer.getInt();
        int dataStartPosition = headerStart + dataStartOffset;
        int dataSize = this.buffer.getInt();
        String fieldName = this.buffer.position() < dataStartPosition ? this.buffer.getStringISO8859() : null;
        DataType dataType = BinarySerialiser.getDataType(dataTypeByte);
        if (dataType == DataType.END_MARKER) {
            this.parent = (WireDataFieldDescription)this.parent.getParent();
        }
        this.lastFieldHeader = new WireDataFieldDescription(this, this.parent, fieldNameHashCode, fieldName, dataType, headerStart, dataStartOffset, dataSize);
        if (dataType == DataType.START_MARKER) {
            this.parent = this.lastFieldHeader;
        }
        if (this.isPutFieldMetaData()) {
            if (this.buffer.position() < dataStartPosition) {
                this.lastFieldHeader.setFieldUnit(this.buffer.getString());
            }
            if (this.buffer.position() < dataStartPosition) {
                this.lastFieldHeader.setFieldDescription(this.buffer.getString());
            }
            if (this.buffer.position() < dataStartPosition) {
                this.lastFieldHeader.setFieldDirection(this.buffer.getString());
            }
            if (this.buffer.position() < dataStartPosition) {
                String[] fieldGroups = this.buffer.getStringArray();
                this.lastFieldHeader.setFieldGroups(fieldGroups == null ? Collections.emptyList() : Arrays.asList(fieldGroups));
            }
        } else {
            this.buffer.position(dataStartPosition);
        }
        if (this.buffer.position() != dataStartPosition) {
            int diff = dataStartPosition - this.buffer.position();
            throw new IllegalStateException("could not parse FieldHeader: fieldName='" + dataType + ":" + fieldName + "' dataOffset = " + dataStartOffset + " bytes (read) --  buffer position is " + this.buffer.position() + " vs. calculated " + dataStartPosition + " diff = " + diff);
        }
        if (dataSize >= 0) {
            return this.lastFieldHeader;
        }
        if (dataType.isScalar()) {
            dataSize = dataType.getPrimitiveSize();
        } else if (dataType == DataType.STRING) {
            dataSize = this.buffer.getInt(this.buffer.position() + 4) + 4;
        }
        this.lastFieldHeader.setDataSize(dataSize);
        return this.lastFieldHeader;
    }

    @Override
    public float getFloat() {
        return this.buffer.getFloat();
    }

    @Override
    public float[] getFloatArray(float[] dst, int length) {
        this.getArraySizeDescriptor();
        return this.buffer.getFloatArray(dst, length);
    }

    @Override
    public int getInt() {
        return this.buffer.getInt();
    }

    @Override
    public int[] getIntArray(int[] dst, int length) {
        this.getArraySizeDescriptor();
        return this.buffer.getIntArray(dst, length);
    }

    @Override
    public <E> List<E> getList(List<E> collection) {
        List<Object> retCollection;
        this.getArraySizeDescriptor();
        int nElements = this.buffer.getInt();
        DataType listDataType = BinarySerialiser.getDataType(this.buffer.getByte());
        DataType valueDataType = BinarySerialiser.getDataType(this.buffer.getByte());
        if (!listDataType.equals((Object)DataType.LIST) && !listDataType.equals((Object)DataType.COLLECTION)) {
            throw new IllegalArgumentException("dataType incompatible with List = " + listDataType);
        }
        if (collection == null) {
            retCollection = new ArrayList();
        } else {
            retCollection = collection;
            retCollection.clear();
        }
        if (DataType.OTHER.equals((Object)valueDataType)) {
            Type[] typeArray;
            String classTypeName = this.buffer.getStringISO8859();
            String secondaryTypeName = this.buffer.getStringISO8859();
            Class<?> classType = ClassUtils.getClassByName(classTypeName);
            if (secondaryTypeName.isEmpty()) {
                typeArray = new Type[]{};
            } else {
                Type[] typeArray2 = new Type[1];
                typeArray = typeArray2;
                typeArray2[0] = ClassUtils.getClassByName(secondaryTypeName);
            }
            Type[] secondaryType = typeArray;
            BiFunction<Type, Type[], FieldSerialiser<Object>> serialiserLookup = this.getSerialiserLookupFunction();
            if (serialiserLookup == null) {
                throw new IllegalArgumentException(PROTOCOL_ERROR_SERIALISER_LOOKUP_MUST_NOT_BE_NULL);
            }
            FieldSerialiser<Object> serialiser = serialiserLookup.apply(classType, secondaryType);
            if (serialiser == null) {
                throw new IllegalArgumentException(NO_SERIALISER_IMP_FOUND + classTypeName);
            }
            for (int i = 0; i < nElements; ++i) {
                retCollection.add(serialiser.getReturnObjectFunction().apply(this, null, null));
            }
            return retCollection;
        }
        E[] values = this.getGenericArrayAsBoxedPrimitive(valueDataType);
        if (nElements != values.length) {
            throw new IllegalStateException(PROTOCOL_MISMATCH_N_ELEMENTS_HEADER + nElements + VS_ARRAY + values.length);
        }
        retCollection.addAll(Arrays.asList(values));
        return retCollection;
    }

    @Override
    public long getLong() {
        return this.buffer.getLong();
    }

    @Override
    public long[] getLongArray(long[] dst, int length) {
        this.getArraySizeDescriptor();
        return this.buffer.getLongArray(dst, length);
    }

    @Override
    public <K, V, E> Map<K, V> getMap(Map<K, V> map) {
        ConcurrentHashMap<E, E> retMap;
        Object[] values;
        Object[] keys;
        this.getArraySizeDescriptor();
        int nElements = this.buffer.getInt();
        DataType keyDataType = BinarySerialiser.getDataType(this.buffer.getByte());
        BiFunction<Type, Type[], FieldSerialiser<Object>> serialiserLookup = this.getSerialiserLookupFunction();
        if (keyDataType != DataType.OTHER) {
            keys = this.getGenericArrayAsBoxedPrimitive(keyDataType);
        } else {
            Type[] typeArray;
            String classTypeName = this.buffer.getStringISO8859();
            String secondaryTypeName = this.buffer.getStringISO8859();
            Class<?> classType = ClassUtils.getClassByName(classTypeName);
            if (secondaryTypeName.isEmpty()) {
                typeArray = new Type[]{};
            } else {
                Type[] typeArray2 = new Type[1];
                typeArray = typeArray2;
                typeArray2[0] = ClassUtils.getClassByName(secondaryTypeName);
            }
            Type[] secondaryType = typeArray;
            if (serialiserLookup == null) {
                throw new IllegalArgumentException(PROTOCOL_ERROR_SERIALISER_LOOKUP_MUST_NOT_BE_NULL);
            }
            FieldSerialiser<Object> serialiser = serialiserLookup.apply(classType, secondaryType);
            if (serialiser == null) {
                throw new IllegalArgumentException(NO_SERIALISER_IMP_FOUND + classTypeName);
            }
            keys = new Object[nElements];
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = serialiser.getReturnObjectFunction().apply(this, null, null);
            }
        }
        DataType valueDataType = BinarySerialiser.getDataType(this.buffer.getByte());
        if (valueDataType != DataType.OTHER) {
            values = this.getGenericArrayAsBoxedPrimitive(valueDataType);
        } else {
            Type[] typeArray;
            String classTypeName = this.buffer.getStringISO8859();
            String secondaryTypeName = this.buffer.getStringISO8859();
            Class<?> classType = ClassUtils.getClassByName(classTypeName);
            if (secondaryTypeName.isEmpty()) {
                typeArray = new Type[]{};
            } else {
                Type[] typeArray3 = new Type[1];
                typeArray = typeArray3;
                typeArray3[0] = ClassUtils.getClassByName(secondaryTypeName);
            }
            Type[] secondaryType = typeArray;
            if (serialiserLookup == null) {
                throw new IllegalArgumentException(PROTOCOL_ERROR_SERIALISER_LOOKUP_MUST_NOT_BE_NULL);
            }
            FieldSerialiser<Object> serialiser = serialiserLookup.apply(classType, secondaryType);
            if (serialiser == null) {
                throw new IllegalArgumentException(NO_SERIALISER_IMP_FOUND + classTypeName);
            }
            values = new Object[nElements];
            for (int i = 0; i < values.length; ++i) {
                values[i] = serialiser.getReturnObjectFunction().apply(this, null, null);
            }
        }
        ConcurrentHashMap<E, E> concurrentHashMap = retMap = map == null ? new ConcurrentHashMap<E, E>() : map;
        if (map != null) {
            map.clear();
        }
        for (int i = 0; i < keys.length; ++i) {
            retMap.put(keys[i], values[i]);
        }
        return retMap;
    }

    public WireDataFieldDescription getParent() {
        return this.parent;
    }

    @Override
    public <E> Queue<E> getQueue(Queue<E> collection) {
        Queue<Object> retCollection;
        this.getArraySizeDescriptor();
        int nElements = this.buffer.getInt();
        DataType listDataType = BinarySerialiser.getDataType(this.buffer.getByte());
        DataType valueDataType = BinarySerialiser.getDataType(this.buffer.getByte());
        if (!listDataType.equals((Object)DataType.QUEUE) && !listDataType.equals((Object)DataType.COLLECTION)) {
            throw new IllegalArgumentException("dataType incompatible with Queue = " + listDataType);
        }
        if (collection == null) {
            retCollection = new ArrayDeque();
        } else {
            retCollection = collection;
            retCollection.clear();
        }
        if (DataType.OTHER.equals((Object)valueDataType)) {
            Type[] typeArray;
            String classTypeName = this.buffer.getStringISO8859();
            String secondaryTypeName = this.buffer.getStringISO8859();
            Class<?> classType = ClassUtils.getClassByName(classTypeName);
            if (secondaryTypeName.isEmpty()) {
                typeArray = new Type[]{};
            } else {
                Type[] typeArray2 = new Type[1];
                typeArray = typeArray2;
                typeArray2[0] = ClassUtils.getClassByName(secondaryTypeName);
            }
            Type[] secondaryType = typeArray;
            BiFunction<Type, Type[], FieldSerialiser<Object>> serialiserLookup = this.getSerialiserLookupFunction();
            if (serialiserLookup == null) {
                throw new IllegalArgumentException(PROTOCOL_ERROR_SERIALISER_LOOKUP_MUST_NOT_BE_NULL);
            }
            FieldSerialiser<Object> serialiser = serialiserLookup.apply(classType, secondaryType);
            if (serialiser == null) {
                throw new IllegalArgumentException(NO_SERIALISER_IMP_FOUND + classTypeName);
            }
            for (int i = 0; i < nElements; ++i) {
                retCollection.add(serialiser.getReturnObjectFunction().apply(this, null, null));
            }
            return retCollection;
        }
        E[] values = this.getGenericArrayAsBoxedPrimitive(valueDataType);
        if (nElements != values.length) {
            throw new IllegalStateException(PROTOCOL_MISMATCH_N_ELEMENTS_HEADER + nElements + VS_ARRAY + values.length);
        }
        retCollection.addAll(Arrays.asList(values));
        return retCollection;
    }

    @Override
    public <E> Set<E> getSet(Set<E> collection) {
        Set<Object> retCollection;
        this.getArraySizeDescriptor();
        int nElements = this.buffer.getInt();
        DataType listDataType = BinarySerialiser.getDataType(this.buffer.getByte());
        DataType valueDataType = BinarySerialiser.getDataType(this.buffer.getByte());
        if (!listDataType.equals((Object)DataType.SET) && !listDataType.equals((Object)DataType.COLLECTION)) {
            throw new IllegalArgumentException("dataType incompatible with Set = " + listDataType);
        }
        if (collection == null) {
            retCollection = new HashSet();
        } else {
            retCollection = collection;
            retCollection.clear();
        }
        if (DataType.OTHER.equals((Object)valueDataType)) {
            Type[] typeArray;
            BiFunction<Type, Type[], FieldSerialiser<Object>> serialiserLookup = this.getSerialiserLookupFunction();
            if (serialiserLookup == null) {
                throw new IllegalArgumentException(PROTOCOL_ERROR_SERIALISER_LOOKUP_MUST_NOT_BE_NULL);
            }
            String classTypeName = this.buffer.getStringISO8859();
            String secondaryTypeName = this.buffer.getStringISO8859();
            Class<?> classType = ClassUtils.getClassByName(classTypeName);
            if (secondaryTypeName.isEmpty()) {
                typeArray = new Type[]{};
            } else {
                Type[] typeArray2 = new Type[1];
                typeArray = typeArray2;
                typeArray2[0] = ClassUtils.getClassByName(secondaryTypeName);
            }
            Type[] secondaryType = typeArray;
            FieldSerialiser<Object> serialiser = serialiserLookup.apply(classType, secondaryType);
            if (serialiser == null) {
                throw new IllegalArgumentException(NO_SERIALISER_IMP_FOUND + classTypeName);
            }
            for (int i = 0; i < nElements; ++i) {
                retCollection.add(serialiser.getReturnObjectFunction().apply(this, null, null));
            }
            return retCollection;
        }
        E[] values = this.getGenericArrayAsBoxedPrimitive(valueDataType);
        if (nElements != values.length) {
            throw new IllegalStateException(PROTOCOL_MISMATCH_N_ELEMENTS_HEADER + nElements + VS_ARRAY + values.length);
        }
        retCollection.addAll(Arrays.asList(values));
        return retCollection;
    }

    @Override
    public short getShort() {
        return this.buffer.getShort();
    }

    @Override
    public short[] getShortArray(short[] dst, int length) {
        this.getArraySizeDescriptor();
        return this.buffer.getShortArray(dst, length);
    }

    @Override
    public String getString() {
        return this.buffer.getString();
    }

    @Override
    public String[] getStringArray(String[] dst, int length) {
        this.getArraySizeDescriptor();
        return this.buffer.getStringArray(dst, length);
    }

    @Override
    public String getStringISO8859() {
        return this.buffer.getStringISO8859();
    }

    public boolean isEnforceSimpleStringEncoding() {
        return this.buffer.isEnforceSimpleStringEncoding();
    }

    public void setEnforceSimpleStringEncoding(boolean state) {
        this.buffer.setEnforceSimpleStringEncoding(state);
    }

    @Override
    public boolean isPutFieldMetaData() {
        return this.putFieldMetaData;
    }

    @Override
    public void setPutFieldMetaData(boolean putFieldMetaData) {
        this.putFieldMetaData = putFieldMetaData;
    }

    @Override
    public WireDataFieldDescription parseIoStream(boolean readHeader) {
        WireDataFieldDescription fieldRoot;
        this.parent = fieldRoot = this.getRootElement();
        WireDataFieldDescription headerRoot = readHeader ? this.checkHeaderInfo().getFieldHeader() : this.getFieldHeader();
        this.buffer.position(headerRoot.getDataStartPosition());
        this.parseIoStream(headerRoot, 0);
        return fieldRoot;
    }

    public void parseIoStream(WireDataFieldDescription fieldRoot, int recursionDepth) {
        DataType dataType;
        WireDataFieldDescription field;
        if (fieldRoot.getParent() == null) {
            this.parent = this.lastFieldHeader = fieldRoot;
        }
        while ((field = this.getFieldHeader()) != null && (dataType = field.getDataType()) != DataType.END_MARKER) {
            if (dataType == DataType.START_MARKER) {
                this.parseIoStream(field, recursionDepth + 1);
                continue;
            }
            int dataSize = field.getDataSize();
            if (dataSize < 0) {
                throw new IllegalStateException("FieldDescription for '" + field.getFieldName() + "' type '" + dataType + "' has negative dataSize = " + dataSize);
            }
            int skipPosition = field.getDataStartPosition() + dataSize;
            this.buffer.position(skipPosition);
        }
    }

    @Override
    public <E> void put(FieldDescription fieldDescription, Collection<E> collection, Type valueType) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription);
        Object[] values = collection.toArray();
        int nElements = collection.size();
        Class<?> cleanedType = ClassUtils.getRawType(valueType);
        DataType valueDataType = DataType.fromClassType(cleanedType);
        int entrySize = 17;
        this.putArraySizeDescriptor(nElements);
        this.buffer.putInt(nElements);
        if (collection instanceof Queue) {
            this.buffer.putByte(BinarySerialiser.getDataType(DataType.QUEUE));
        } else if (collection instanceof Set) {
            this.buffer.putByte(BinarySerialiser.getDataType(DataType.SET));
        } else if (collection instanceof List) {
            this.buffer.putByte(BinarySerialiser.getDataType(DataType.LIST));
        } else {
            this.buffer.putByte(BinarySerialiser.getDataType(DataType.COLLECTION));
        }
        BiFunction<Type, Type[], FieldSerialiser<Object>> serialiserLookup = this.getSerialiserLookupFunction();
        if (ClassUtils.isPrimitiveWrapperOrString(cleanedType) || serialiserLookup == null) {
            this.buffer.ensureAdditionalCapacity(nElements * 17 + 9);
            this.buffer.putByte(BinarySerialiser.getDataType(valueDataType));
            this.putGenericArrayAsPrimitive(valueDataType, values, nElements);
        } else {
            this.buffer.putByte(BinarySerialiser.getDataType(DataType.OTHER));
            Type[] secondaryType = ClassUtils.getSecondaryType(valueType);
            FieldSerialiser<Object> serialiser = serialiserLookup.apply(valueType, secondaryType);
            if (serialiser == null) {
                throw new IllegalArgumentException("could not find serialiser for class type " + valueType);
            }
            this.buffer.putStringISO8859(serialiser.getClassPrototype().getCanonicalName());
            this.buffer.putStringISO8859(serialiser.getGenericsPrototypes().isEmpty() ? "" : serialiser.getGenericsPrototypes().get(0).getTypeName());
            FieldSerialiser.TriConsumer writerFunction = serialiser.getWriterFunction();
            for (Object value : values) {
                writerFunction.accept(this, value, null);
            }
        }
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, Enum<?> enumeration) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription);
        if (enumeration == null) {
            return;
        }
        Class<?> clazz = enumeration.getClass();
        if (clazz == null) {
            return;
        }
        Enum[] enumConsts = (Enum[])clazz.getEnumConstants();
        if (enumConsts == null) {
            return;
        }
        boolean nElements = true;
        int entrySize = 17;
        this.buffer.ensureAdditionalCapacity(26);
        String typeList = Arrays.stream((Enum[])clazz.getEnumConstants()).map(Object::toString).collect(Collectors.joining(", ", "[", "]"));
        this.buffer.putStringISO8859(clazz.getSimpleName());
        this.buffer.putStringISO8859(enumeration.getClass().getName());
        this.buffer.putStringISO8859(typeList);
        this.buffer.putStringISO8859(enumeration.name());
        this.buffer.putInt(enumeration.ordinal());
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public <K, V, E> void put(FieldDescription fieldDescription, Map<K, V> map, Type keyType, Type valueType) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription);
        Object[] keySet = map.keySet().toArray();
        int nElements = keySet.length;
        this.putArraySizeDescriptor(nElements);
        this.buffer.putInt(nElements);
        Class<?> cleanedKeyType = ClassUtils.getRawType(keyType);
        DataType keyDataType = DataType.fromClassType(cleanedKeyType);
        BiFunction<Type, Type[], FieldSerialiser<Object>> serialiserLookup = this.getSerialiserLookupFunction();
        if (serialiserLookup == null || ClassUtils.isPrimitiveWrapperOrString(cleanedKeyType)) {
            int entrySize = 17;
            this.buffer.ensureAdditionalCapacity(nElements * 17 + 9);
            this.buffer.putByte(BinarySerialiser.getDataType(keyDataType));
            this.putGenericArrayAsPrimitive(keyDataType, keySet, nElements);
        } else {
            this.buffer.putByte(BinarySerialiser.getDataType(DataType.OTHER));
            Type[] secondaryKeyType = ClassUtils.getSecondaryType(keyType);
            FieldSerialiser<Object> serialiserKey = serialiserLookup.apply(keyType, secondaryKeyType);
            if (serialiserKey == null) {
                throw new IllegalArgumentException("could not find serialiser for key class type " + keyType);
            }
            this.buffer.putStringISO8859(serialiserKey.getClassPrototype().getCanonicalName());
            this.buffer.putStringISO8859(serialiserKey.getGenericsPrototypes().isEmpty() ? "" : serialiserKey.getGenericsPrototypes().get(0).getTypeName());
            FieldSerialiser.TriConsumer writerFunctionKey = serialiserKey.getWriterFunction();
            for (Object key : keySet) {
                writerFunctionKey.accept(this, key, null);
            }
        }
        Class<?> cleanedValueType = ClassUtils.getRawType(valueType);
        Object[] valueSet = map.values().toArray();
        DataType valueDataType = DataType.fromClassType(cleanedValueType);
        if (serialiserLookup == null || ClassUtils.isPrimitiveWrapperOrString(cleanedValueType)) {
            int entrySize = 17;
            this.buffer.ensureAdditionalCapacity(nElements * 17 + 9);
            this.buffer.putByte(BinarySerialiser.getDataType(valueDataType));
            this.putGenericArrayAsPrimitive(valueDataType, valueSet, nElements);
        } else {
            this.buffer.putByte(BinarySerialiser.getDataType(DataType.OTHER));
            Type[] secondaryValueType = ClassUtils.getSecondaryType(valueType);
            FieldSerialiser<Object> serialiserValue = serialiserLookup.apply(valueType, secondaryValueType);
            if (serialiserValue == null) {
                throw new IllegalArgumentException("could not find serialiser for value class type " + valueType);
            }
            this.buffer.putStringISO8859(serialiserValue.getClassPrototype().getCanonicalName());
            this.buffer.putStringISO8859(serialiserValue.getGenericsPrototypes().isEmpty() ? "" : serialiserValue.getGenericsPrototypes().get(0).getTypeName());
            FieldSerialiser.TriConsumer writerFunctionValue = serialiserValue.getWriterFunction();
            for (Object value : valueSet) {
                writerFunctionValue.accept(this, value, null);
            }
        }
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public <E> void put(String fieldName, Collection<E> collection, Type valueType) {
        DataType dataType = collection instanceof Queue ? DataType.QUEUE : (collection instanceof Set ? DataType.SET : (collection instanceof List ? DataType.LIST : DataType.COLLECTION));
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, dataType);
        this.put((FieldDescription)null, collection, valueType);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, Enum<?> enumeration) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.ENUM);
        this.put((FieldDescription)null, enumeration);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public <K, V, E> void put(String fieldName, Map<K, V> map, Type keyType, Type valueType) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.MAP);
        this.put((FieldDescription)null, map, keyType, valueType);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, boolean value) {
        this.putFieldHeader(fieldDescription);
        this.buffer.putBoolean(value);
    }

    @Override
    public void put(FieldDescription fieldDescription, boolean[] values, int n) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription);
        int valuesSize = values == null ? 0 : values.length;
        int bytesToCopy = this.putArraySizeDescriptor(n >= 0 ? Math.min(n, valuesSize) : valuesSize);
        this.buffer.putBooleanArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, boolean[] values, int[] dims) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription);
        int bytesToCopy = this.putArraySizeDescriptor(dims);
        this.buffer.putBooleanArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, byte value) {
        this.putFieldHeader(fieldDescription);
        this.buffer.putByte(value);
    }

    @Override
    public void put(FieldDescription fieldDescription, byte[] values, int n) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription);
        int valuesSize = values == null ? 0 : values.length;
        int bytesToCopy = this.putArraySizeDescriptor(n >= 0 ? Math.min(n, valuesSize) : valuesSize);
        this.buffer.putByteArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, byte[] values, int[] dims) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription);
        int bytesToCopy = this.putArraySizeDescriptor(dims);
        this.buffer.putByteArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, char value) {
        this.putFieldHeader(fieldDescription);
        this.buffer.putChar(value);
    }

    @Override
    public void put(FieldDescription fieldDescription, char[] values, int n) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription);
        int valuesSize = values == null ? 0 : values.length;
        int bytesToCopy = this.putArraySizeDescriptor(n >= 0 ? Math.min(n, valuesSize) : valuesSize);
        this.buffer.putCharArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, char[] values, int[] dims) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription);
        int bytesToCopy = this.putArraySizeDescriptor(dims);
        this.buffer.putCharArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, double value) {
        this.putFieldHeader(fieldDescription);
        this.buffer.putDouble(value);
    }

    @Override
    public void put(FieldDescription fieldDescription, double[] values, int n) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription);
        int valuesSize = values == null ? 0 : values.length;
        int bytesToCopy = this.putArraySizeDescriptor(n >= 0 ? Math.min(n, valuesSize) : valuesSize);
        this.buffer.putDoubleArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, double[] values, int[] dims) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription);
        int bytesToCopy = this.putArraySizeDescriptor(dims);
        this.buffer.putDoubleArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, float value) {
        this.putFieldHeader(fieldDescription);
        this.buffer.putFloat(value);
    }

    @Override
    public void put(FieldDescription fieldDescription, float[] values, int n) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription);
        int valuesSize = values == null ? 0 : values.length;
        int bytesToCopy = this.putArraySizeDescriptor(n >= 0 ? Math.min(n, valuesSize) : valuesSize);
        this.buffer.putFloatArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, float[] values, int[] dims) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription);
        int bytesToCopy = this.putArraySizeDescriptor(dims);
        this.buffer.putFloatArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, int value) {
        this.putFieldHeader(fieldDescription);
        this.buffer.putInt(value);
    }

    @Override
    public void put(FieldDescription fieldDescription, int[] values, int n) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription);
        int valuesSize = values == null ? 0 : values.length;
        int bytesToCopy = this.putArraySizeDescriptor(n >= 0 ? Math.min(n, valuesSize) : valuesSize);
        this.buffer.putIntArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, int[] values, int[] dims) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription);
        int bytesToCopy = this.putArraySizeDescriptor(dims);
        this.buffer.putIntArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, long value) {
        this.putFieldHeader(fieldDescription);
        this.buffer.putLong(value);
    }

    @Override
    public void put(FieldDescription fieldDescription, long[] values, int n) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription);
        int valuesSize = values == null ? 0 : values.length;
        int bytesToCopy = this.putArraySizeDescriptor(n >= 0 ? Math.min(n, valuesSize) : valuesSize);
        this.buffer.putLongArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, long[] values, int[] dims) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription);
        int bytesToCopy = this.putArraySizeDescriptor(dims);
        this.buffer.putLongArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, short value) {
        this.putFieldHeader(fieldDescription);
        this.buffer.putShort(value);
    }

    @Override
    public void put(FieldDescription fieldDescription, short[] values, int n) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription);
        int valuesSize = values == null ? 0 : values.length;
        int bytesToCopy = this.putArraySizeDescriptor(n >= 0 ? Math.min(n, valuesSize) : valuesSize);
        this.buffer.putShortArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, short[] values, int[] dims) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription);
        int bytesToCopy = this.putArraySizeDescriptor(dims);
        this.buffer.putShortArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, String string) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription);
        this.buffer.putString(string);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, String[] values, int n) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription);
        int valuesSize = values == null ? 0 : values.length;
        int nElements = n >= 0 ? Math.min(n, valuesSize) : valuesSize;
        this.putArraySizeDescriptor(nElements);
        this.buffer.putStringArray(values, nElements);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, String[] values, int[] dims) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription);
        int nElements = this.putArraySizeDescriptor(dims);
        this.putArraySizeDescriptor(nElements);
        this.buffer.putStringArray(values, nElements);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, boolean value) {
        this.putFieldHeader(fieldName, DataType.BOOL);
        this.buffer.putBoolean(value);
    }

    @Override
    public void put(String fieldName, boolean[] values, int n) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.BOOL_ARRAY);
        int valuesSize = values == null ? 0 : values.length;
        int bytesToCopy = this.putArraySizeDescriptor(n >= 0 ? Math.min(n, valuesSize) : valuesSize);
        this.buffer.putBooleanArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, boolean[] values, int[] dims) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.BOOL_ARRAY);
        int bytesToCopy = this.putArraySizeDescriptor(dims);
        this.buffer.putBooleanArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, byte value) {
        this.putFieldHeader(fieldName, DataType.BYTE);
        this.buffer.putByte(value);
    }

    @Override
    public void put(String fieldName, byte[] values, int n) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.BYTE_ARRAY);
        int valuesSize = values == null ? 0 : values.length;
        int bytesToCopy = this.putArraySizeDescriptor(n >= 0 ? Math.min(n, valuesSize) : valuesSize);
        this.buffer.putByteArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, byte[] values, int[] dims) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.BYTE_ARRAY);
        int bytesToCopy = this.putArraySizeDescriptor(dims);
        this.buffer.putByteArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, char value) {
        this.putFieldHeader(fieldName, DataType.CHAR);
        this.buffer.putChar(value);
    }

    @Override
    public void put(String fieldName, char[] values, int n) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.CHAR_ARRAY);
        int valuesSize = values == null ? 0 : values.length;
        int bytesToCopy = this.putArraySizeDescriptor(n >= 0 ? Math.min(n, valuesSize) : valuesSize);
        this.buffer.putCharArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, char[] values, int[] dims) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.CHAR_ARRAY);
        int bytesToCopy = this.putArraySizeDescriptor(dims);
        this.buffer.putCharArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, double value) {
        this.putFieldHeader(fieldName, DataType.DOUBLE);
        this.buffer.putDouble(value);
    }

    @Override
    public void put(String fieldName, double[] values, int n) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.DOUBLE_ARRAY);
        int valuesSize = values == null ? 0 : values.length;
        int bytesToCopy = this.putArraySizeDescriptor(n >= 0 ? Math.min(n, valuesSize) : valuesSize);
        this.buffer.putDoubleArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, double[] values, int[] dims) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.DOUBLE_ARRAY);
        int bytesToCopy = this.putArraySizeDescriptor(dims);
        this.buffer.putDoubleArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, float value) {
        this.putFieldHeader(fieldName, DataType.FLOAT);
        this.buffer.putFloat(value);
    }

    @Override
    public void put(String fieldName, float[] values, int n) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.FLOAT_ARRAY);
        int valuesSize = values == null ? 0 : values.length;
        int bytesToCopy = this.putArraySizeDescriptor(n >= 0 ? Math.min(n, valuesSize) : valuesSize);
        this.buffer.putFloatArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, float[] values, int[] dims) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.FLOAT_ARRAY);
        int bytesToCopy = this.putArraySizeDescriptor(dims);
        this.buffer.putFloatArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, int value) {
        this.putFieldHeader(fieldName, DataType.INT);
        this.buffer.putInt(value);
    }

    @Override
    public void put(String fieldName, int[] values, int n) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.INT_ARRAY);
        int valuesSize = values == null ? 0 : values.length;
        int bytesToCopy = this.putArraySizeDescriptor(n >= 0 ? Math.min(n, valuesSize) : valuesSize);
        this.buffer.putIntArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, int[] values, int[] dims) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.INT_ARRAY);
        int bytesToCopy = this.putArraySizeDescriptor(dims);
        this.buffer.putIntArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, long value) {
        this.putFieldHeader(fieldName, DataType.LONG);
        this.buffer.putLong(value);
    }

    @Override
    public void put(String fieldName, long[] values, int n) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.LONG_ARRAY);
        int valuesSize = values == null ? 0 : values.length;
        int bytesToCopy = this.putArraySizeDescriptor(n >= 0 ? Math.min(n, valuesSize) : valuesSize);
        this.buffer.putLongArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, long[] values, int[] dims) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.LONG_ARRAY);
        int bytesToCopy = this.putArraySizeDescriptor(dims);
        this.buffer.putLongArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, short value) {
        this.putFieldHeader(fieldName, DataType.SHORT);
        this.buffer.putShort(value);
    }

    @Override
    public void put(String fieldName, short[] values, int n) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.SHORT_ARRAY);
        int valuesSize = values == null ? 0 : values.length;
        int bytesToCopy = this.putArraySizeDescriptor(n >= 0 ? Math.min(n, valuesSize) : valuesSize);
        this.buffer.putShortArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, short[] values, int[] dims) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.SHORT_ARRAY);
        int bytesToCopy = this.putArraySizeDescriptor(dims);
        this.buffer.putShortArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, String string) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.STRING);
        this.buffer.putString(string);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, String[] values, int n) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.STRING_ARRAY);
        int valuesSize = values == null ? 0 : values.length;
        int nElements = n >= 0 ? Math.min(n, valuesSize) : valuesSize;
        this.putArraySizeDescriptor(nElements);
        this.buffer.putStringArray(values, nElements);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, String[] values, int[] dims) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.STRING_ARRAY);
        int nElements = this.putArraySizeDescriptor(dims);
        this.putArraySizeDescriptor(nElements);
        this.buffer.putStringArray(values, nElements);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public int putArraySizeDescriptor(int n) {
        this.buffer.putInt(1);
        this.buffer.putInt(n);
        return n;
    }

    @Override
    public int putArraySizeDescriptor(int[] dims) {
        this.buffer.putInt(dims.length);
        int nElements = 1;
        for (int dim : dims) {
            nElements *= dim;
            this.buffer.putInt(dim);
        }
        return nElements;
    }

    @Override
    public <E> WireDataFieldDescription putCustomData(FieldDescription fieldDescription, E rootObject, Class<? extends E> type, FieldSerialiser<E> serialiser) {
        if (this.parent == null) {
            this.parent = this.lastFieldHeader = this.getRootElement();
        }
        WireDataFieldDescription oldParent = this.parent;
        WireDataFieldDescription ret = this.putFieldHeader(fieldDescription);
        this.buffer.putByte(ret.getFieldStart(), BinarySerialiser.getDataType(DataType.OTHER));
        this.parent = this.lastFieldHeader;
        this.buffer.putStringISO8859(serialiser.getClassPrototype().getCanonicalName());
        this.buffer.putStringISO8859(serialiser.getGenericsPrototypes().isEmpty() ? "" : serialiser.getGenericsPrototypes().get(0).getTypeName());
        serialiser.getWriterFunction().accept(this, rootObject, fieldDescription instanceof ClassFieldDescription ? (ClassFieldDescription)fieldDescription : null);
        this.putEndMarker(fieldDescription);
        this.parent = oldParent;
        return ret;
    }

    @Override
    public void putEndMarker(FieldDescription fieldDescription) {
        this.updateDataEndMarker(this.parent);
        this.updateDataEndMarker(this.lastFieldHeader);
        if (this.parent.getParent() != null) {
            this.parent = (WireDataFieldDescription)this.parent.getParent();
        }
        this.putFieldHeader(fieldDescription);
        this.buffer.putByte(this.lastFieldHeader.getFieldStart(), BinarySerialiser.getDataType(DataType.END_MARKER));
    }

    @Override
    public WireDataFieldDescription putFieldHeader(FieldDescription fieldDescription) {
        if (fieldDescription == null) {
            return null;
        }
        DataType dataType = fieldDescription.getDataType();
        if (this.isPutFieldMetaData()) {
            this.buffer.ensureAdditionalCapacity(this.bufferIncrements);
        }
        boolean isScalar = dataType.isScalar();
        int headerStart = this.buffer.position();
        this.buffer.putByte(BinarySerialiser.getDataType(dataType));
        this.buffer.putInt(fieldDescription.getFieldNameHashCode());
        this.buffer.putInt(-1);
        int dataSize = isScalar ? dataType.getPrimitiveSize() : -1;
        this.buffer.putInt(dataSize);
        this.buffer.putStringISO8859(fieldDescription.getFieldName());
        if (this.isPutFieldMetaData() && fieldDescription.isAnnotationPresent() && dataType != DataType.END_MARKER) {
            this.buffer.putString(fieldDescription.getFieldUnit());
            this.buffer.putString(fieldDescription.getFieldDescription());
            this.buffer.putString(fieldDescription.getFieldDirection());
            String[] groups = fieldDescription.getFieldGroups().toArray(new String[0]);
            this.buffer.putStringArray(groups, groups.length);
        }
        int dataStartOffset = this.buffer.position() - headerStart;
        this.buffer.putInt(headerStart + 5, dataStartOffset);
        this.buffer.ensureAdditionalCapacity(16);
        this.lastFieldHeader = new WireDataFieldDescription(this, this.parent, fieldDescription.getFieldNameHashCode(), fieldDescription.getFieldName(), dataType, headerStart, dataStartOffset, dataSize);
        if (this.isPutFieldMetaData() && fieldDescription.isAnnotationPresent()) {
            this.lastFieldHeader.setFieldUnit(fieldDescription.getFieldUnit());
            this.lastFieldHeader.setFieldDescription(fieldDescription.getFieldDescription());
            this.lastFieldHeader.setFieldDirection(fieldDescription.getFieldDirection());
            this.lastFieldHeader.setFieldGroups(fieldDescription.getFieldGroups());
        }
        return this.lastFieldHeader;
    }

    @Override
    public WireDataFieldDescription putFieldHeader(String fieldName, DataType dataType) {
        int addCapacity = (fieldName.length() + 18) * 1 + this.bufferIncrements + dataType.getPrimitiveSize();
        this.buffer.ensureAdditionalCapacity(addCapacity);
        boolean isScalar = dataType.isScalar();
        int headerStart = this.buffer.position();
        this.buffer.putByte(BinarySerialiser.getDataType(dataType));
        this.buffer.putInt(fieldName.hashCode());
        this.buffer.putInt(-1);
        int dataSize = isScalar ? dataType.getPrimitiveSize() : -1;
        this.buffer.putInt(dataSize);
        this.buffer.putStringISO8859(fieldName);
        int fieldHeaderDataStart = this.buffer.position();
        int dataStartOffset = fieldHeaderDataStart - headerStart;
        this.buffer.putInt(headerStart + 5, dataStartOffset);
        this.buffer.ensureAdditionalCapacity(16);
        this.lastFieldHeader = new WireDataFieldDescription(this, this.parent, fieldName.hashCode(), fieldName, dataType, headerStart, dataStartOffset, dataSize);
        return this.lastFieldHeader;
    }

    public void putGenericArrayAsPrimitive(DataType dataType, Object[] data, int nToCopy) {
        this.putArraySizeDescriptor(nToCopy);
        switch (dataType) {
            case BOOL: {
                this.buffer.putBooleanArray(GenericsHelper.toBoolPrimitive((Object[])data), nToCopy);
                break;
            }
            case BYTE: {
                this.buffer.putByteArray(GenericsHelper.toBytePrimitive((Object[])data), nToCopy);
                break;
            }
            case CHAR: {
                this.buffer.putCharArray(GenericsHelper.toCharPrimitive((Object[])data), nToCopy);
                break;
            }
            case SHORT: {
                this.buffer.putShortArray(GenericsHelper.toShortPrimitive((Object[])data), nToCopy);
                break;
            }
            case INT: {
                this.buffer.putIntArray(GenericsHelper.toIntegerPrimitive((Object[])data), nToCopy);
                break;
            }
            case LONG: {
                this.buffer.putLongArray(GenericsHelper.toLongPrimitive((Object[])data), nToCopy);
                break;
            }
            case FLOAT: {
                this.buffer.putFloatArray(GenericsHelper.toFloatPrimitive((Object[])data), nToCopy);
                break;
            }
            case DOUBLE: {
                this.buffer.putDoubleArray(GenericsHelper.toDoublePrimitive((Object[])data), nToCopy);
                break;
            }
            case STRING: {
                this.buffer.putStringArray(GenericsHelper.toStringPrimitive((Object[])data), nToCopy);
                break;
            }
            case OTHER: {
                break;
            }
            default: {
                throw new IllegalArgumentException("type not implemented - " + data[0].getClass().getSimpleName());
            }
        }
    }

    @Override
    public void putHeaderInfo(FieldDescription ... field) {
        this.parent = this.lastFieldHeader = this.getRootElement();
        this.buffer.ensureAdditionalCapacity(1000);
        this.buffer.putInt(-1);
        this.buffer.putStringISO8859(PROTOCOL_NAME);
        this.buffer.putByte((byte)1);
        this.buffer.putByte((byte)0);
        this.buffer.putByte((byte)0);
        if (field.length == 0 || field[0] == null) {
            this.putStartMarker(new WireDataFieldDescription(this, null, "OBJ_ROOT_START".hashCode(), "OBJ_ROOT_START", DataType.START_MARKER, -1, -1, -1));
        } else {
            this.putStartMarker(field[0]);
        }
    }

    @Override
    public void putStartMarker(FieldDescription fieldDescription) {
        this.putFieldHeader(fieldDescription);
        this.buffer.putByte(this.lastFieldHeader.getFieldStart(), BinarySerialiser.getDataType(DataType.START_MARKER));
        this.parent = this.lastFieldHeader;
    }

    @Override
    public void updateDataEndMarker(WireDataFieldDescription fieldHeader) {
        if (fieldHeader == null) {
            return;
        }
        int sizeMarkerEnd = this.buffer.position();
        if (this.isPutFieldMetaData() && sizeMarkerEnd >= this.buffer.capacity()) {
            throw new IllegalStateException("buffer position " + sizeMarkerEnd + " is beyond buffer capacity " + this.buffer.capacity());
        }
        int dataSize = sizeMarkerEnd - fieldHeader.getDataStartPosition();
        if (fieldHeader.getDataSize() != dataSize) {
            int headerStart = fieldHeader.getFieldStart();
            fieldHeader.setDataSize(dataSize);
            this.buffer.putInt(headerStart + 9, dataSize);
        }
    }

    @Override
    public void setFieldSerialiserLookupFunction(BiFunction<Type, Type[], FieldSerialiser<Object>> serialiserLookupFunction) {
        this.fieldSerialiserLookupFunction = serialiserLookupFunction;
    }

    @Override
    public BiFunction<Type, Type[], FieldSerialiser<Object>> getSerialiserLookupFunction() {
        return this.fieldSerialiserLookupFunction;
    }

    protected <E> E[] getGenericArrayAsBoxedPrimitive(DataType dataType) {
        Object[] retVal;
        this.getArraySizeDescriptor();
        switch (dataType) {
            case BOOL: {
                retVal = GenericsHelper.toObject((boolean[])this.buffer.getBooleanArray());
                break;
            }
            case BYTE: {
                retVal = GenericsHelper.toObject((byte[])this.buffer.getByteArray());
                break;
            }
            case CHAR: {
                retVal = GenericsHelper.toObject((char[])this.buffer.getCharArray());
                break;
            }
            case SHORT: {
                retVal = GenericsHelper.toObject((short[])this.buffer.getShortArray());
                break;
            }
            case INT: {
                retVal = GenericsHelper.toObject((int[])this.buffer.getIntArray());
                break;
            }
            case LONG: {
                retVal = GenericsHelper.toObject((long[])this.buffer.getLongArray());
                break;
            }
            case FLOAT: {
                retVal = GenericsHelper.toObject((float[])this.buffer.getFloatArray());
                break;
            }
            case DOUBLE: {
                retVal = GenericsHelper.toObject((double[])this.buffer.getDoubleArray());
                break;
            }
            case STRING: {
                retVal = this.buffer.getStringArray();
                break;
            }
            default: {
                throw new IllegalArgumentException("type not implemented - " + dataType);
            }
        }
        return retVal;
    }

    private WireDataFieldDescription getRootElement() {
        int headerOffset = 1 + PROTOCOL_NAME.length() + 3;
        return new WireDataFieldDescription(this, null, "ROOT".hashCode(), "ROOT", DataType.OTHER, this.buffer.position() + headerOffset, -1, -1);
    }

    public static byte getDataType(DataType dataType) {
        int id = dataType.getID();
        if (dataTypeToByte[id] != null) {
            return dataTypeToByte[id];
        }
        throw new IllegalArgumentException("DataType " + dataType + " not mapped to specific byte");
    }

    public static DataType getDataType(byte byteValue) {
        int id = byteValue & 0xFF;
        if (dataTypeToByte[id] != null) {
            return byteToDataType[id];
        }
        throw new IllegalArgumentException("DataType byteValue=" + byteValue + " rawByteValue=" + (byteValue & 0xFF) + " not mapped");
    }

    static {
        BinarySerialiser.byteToDataType[0] = DataType.START_MARKER;
        BinarySerialiser.byteToDataType[1] = DataType.BOOL;
        BinarySerialiser.byteToDataType[2] = DataType.BYTE;
        BinarySerialiser.byteToDataType[3] = DataType.SHORT;
        BinarySerialiser.byteToDataType[4] = DataType.INT;
        BinarySerialiser.byteToDataType[5] = DataType.LONG;
        BinarySerialiser.byteToDataType[6] = DataType.FLOAT;
        BinarySerialiser.byteToDataType[7] = DataType.DOUBLE;
        BinarySerialiser.byteToDataType[8] = DataType.CHAR;
        BinarySerialiser.byteToDataType[9] = DataType.STRING;
        BinarySerialiser.byteToDataType[101] = DataType.BOOL_ARRAY;
        BinarySerialiser.byteToDataType[102] = DataType.BYTE_ARRAY;
        BinarySerialiser.byteToDataType[103] = DataType.SHORT_ARRAY;
        BinarySerialiser.byteToDataType[104] = DataType.INT_ARRAY;
        BinarySerialiser.byteToDataType[105] = DataType.LONG_ARRAY;
        BinarySerialiser.byteToDataType[106] = DataType.FLOAT_ARRAY;
        BinarySerialiser.byteToDataType[107] = DataType.DOUBLE_ARRAY;
        BinarySerialiser.byteToDataType[108] = DataType.CHAR_ARRAY;
        BinarySerialiser.byteToDataType[109] = DataType.STRING_ARRAY;
        BinarySerialiser.byteToDataType[200] = DataType.COLLECTION;
        BinarySerialiser.byteToDataType[201] = DataType.ENUM;
        BinarySerialiser.byteToDataType[202] = DataType.LIST;
        BinarySerialiser.byteToDataType[203] = DataType.MAP;
        BinarySerialiser.byteToDataType[204] = DataType.QUEUE;
        BinarySerialiser.byteToDataType[205] = DataType.SET;
        BinarySerialiser.byteToDataType[253] = DataType.OTHER;
        BinarySerialiser.byteToDataType[254] = DataType.END_MARKER;
        for (int i = 0; i < byteToDataType.length; ++i) {
            if (byteToDataType[i] == null) continue;
            int id = byteToDataType[i].getID();
            BinarySerialiser.dataTypeToByte[id] = (byte)i;
        }
    }
}

