/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.serializer;

import de.gsi.dataset.spi.utils.MultiArrayBoolean;
import de.gsi.dataset.spi.utils.MultiArrayByte;
import de.gsi.dataset.spi.utils.MultiArrayChar;
import de.gsi.dataset.spi.utils.MultiArrayDouble;
import de.gsi.dataset.spi.utils.MultiArrayFloat;
import de.gsi.dataset.spi.utils.MultiArrayInt;
import de.gsi.dataset.spi.utils.MultiArrayLong;
import de.gsi.dataset.spi.utils.MultiArrayObject;
import de.gsi.dataset.spi.utils.MultiArrayShort;
import de.gsi.serializer.Cat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public enum DataType {
    START_MARKER(0, "start_marker", "", 0, Cat.SINGLE_VALUE, new Class[0]),
    BOOL(1, "bool", "boolean", 1, Cat.SINGLE_VALUE, Boolean.TYPE, Boolean.class),
    BYTE(2, "byte", "byte", 1, Cat.SINGLE_VALUE, Byte.TYPE, Byte.class),
    SHORT(3, "short", "short", 2, Cat.SINGLE_VALUE, Short.TYPE, Short.class),
    INT(4, "int", "int", 4, Cat.SINGLE_VALUE, Integer.TYPE, Integer.class),
    LONG(5, "long", "long", 8, Cat.SINGLE_VALUE, Long.TYPE, Long.class),
    FLOAT(6, "float", "float", 4, Cat.SINGLE_VALUE, Float.TYPE, Float.class),
    DOUBLE(7, "double", "double", 8, Cat.SINGLE_VALUE, Double.TYPE, Double.class),
    CHAR(8, "char", "char", 2, Cat.SINGLE_VALUE, Character.TYPE, Character.class),
    STRING(9, "string", "java.lang.String", 1, Cat.ARRAY, String.class, String.class),
    BOOL_ARRAY(101, "bool_array", "[Z", 1, Cat.ARRAY, boolean[].class, Boolean[].class, MultiArrayBoolean.class),
    BYTE_ARRAY(102, "byte_array", "[B", 1, Cat.ARRAY, byte[].class, Byte[].class, MultiArrayByte.class),
    SHORT_ARRAY(103, "short_array", "[S", 2, Cat.ARRAY, short[].class, Short[].class, MultiArrayShort.class),
    INT_ARRAY(104, "int_array", "[I", 4, Cat.ARRAY, int[].class, Integer[].class, MultiArrayInt.class),
    LONG_ARRAY(105, "long_array", "[J", 8, Cat.ARRAY, long[].class, Long[].class, MultiArrayLong.class),
    FLOAT_ARRAY(106, "float_array", "[F", 4, Cat.ARRAY, float[].class, Float[].class, MultiArrayFloat.class),
    DOUBLE_ARRAY(107, "double_array", "[D", 8, Cat.ARRAY, double[].class, Double[].class, MultiArrayDouble.class),
    CHAR_ARRAY(108, "char_array", "[C", 2, Cat.ARRAY, char[].class, Character[].class, MultiArrayChar.class),
    STRING_ARRAY(109, "string_array", "[java.lang.String", 1, Cat.ARRAY, String[].class, String[].class, MultiArrayObject.class),
    ENUM(201, "enum", "java.lang.Enum", 4, Cat.ARRAY, Enum.class),
    LIST(202, "list", "", 1, Cat.ARRAY, List.class),
    MAP(203, "map", "", 1, Cat.ARRAY, Map.class),
    QUEUE(204, "queue", "", 1, Cat.ARRAY, Queue.class),
    SET(205, "set", "", 1, Cat.ARRAY, Set.class),
    COLLECTION(200, "collection", "", 1, Cat.ARRAY, Collection.class),
    OTHER(253, "other", "", 1, Cat.COMPLEX_OBJECT, Object.class),
    END_MARKER(254, "end_marker", "", 0, Cat.SINGLE_VALUE, new Class[0]);

    private final int uniqueID;
    private final int primitiveSize;
    private final String stringValue;
    private final String javaName;
    private final List<Class<?>> classTypes;
    private final boolean scalar;
    private final boolean array;
    private final boolean object;

    private DataType(int uniqueID, String stringValue, String javaName, int primitiveSize, Cat type, Class<?> ... classType) {
        this.uniqueID = uniqueID;
        this.stringValue = stringValue;
        this.javaName = javaName;
        this.primitiveSize = primitiveSize;
        this.classTypes = Arrays.asList(classType);
        this.scalar = type.equals((Object)Cat.SINGLE_VALUE);
        this.array = type.equals((Object)Cat.ARRAY);
        this.object = type.equals((Object)Cat.COMPLEX_OBJECT);
    }

    public int getID() {
        return this.uniqueID;
    }

    public String getAsString() {
        return this.stringValue;
    }

    public List<Class<?>> getClassTypes() {
        return this.classTypes;
    }

    public String getJavaName() {
        return this.javaName;
    }

    public int getPrimitiveSize() {
        return this.primitiveSize;
    }

    public boolean isArray() {
        return this.array;
    }

    public boolean isObject() {
        return this.object;
    }

    public boolean isScalar() {
        return this.scalar;
    }

    public static DataType fromByte(byte value) {
        int unsignedByte = value & 0xFF;
        for (DataType type : DataType.values()) {
            if (type.uniqueID != unsignedByte) continue;
            return type;
        }
        throw new IllegalArgumentException("byte entry type is not supported: " + value);
    }

    public static DataType fromClassType(Class<?> classType) {
        for (DataType dataType : DataType.values()) {
            for (Class<?> type : dataType.getClassTypes()) {
                if (!type.isAssignableFrom(classType)) continue;
                return dataType;
            }
        }
        throw new IllegalArgumentException("data type not implemented " + classType.getSimpleName());
    }

    public static DataType fromJavaTypeString(String str) {
        for (DataType type : DataType.values()) {
            if (!type.stringValue.equals(str)) continue;
            return type;
        }
        throw new IllegalArgumentException("java string entry type is not supported: '" + str + "'");
    }

    public static DataType fromString(String str) {
        for (DataType type : DataType.values()) {
            if (!type.stringValue.equals(str)) continue;
            return type;
        }
        throw new IllegalArgumentException("string entry type is not supported: '" + str + "'");
    }
}

