/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.serializer.utils;

import de.gsi.serializer.spi.ClassFieldDescription;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.nio.CharBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassUtils.class);
    private static final Map<Class<?>, Class<?>> primitiveWrapperMap = new HashMap();
    private static final Map<Class<?>, Class<?>> wrapperPrimitiveMap = new HashMap();
    private static final Map<Class<?>, Class<?>> primitiveArrayBoxedMap = new HashMap();
    private static final Map<Class<?>, Class<?>> boxedArrayPrimitiveMap = new HashMap();
    private static final Map<Integer, ClassFieldDescription> CLASS_FIELD_DESCRIPTION_MAP = new ConcurrentHashMap<Integer, ClassFieldDescription>();
    private static final Map<String, Class<?>> CLASS_STRING_MAP = new ConcurrentHashMap();
    private static final Map<Class<?>, Map<String, Method>> CLASS_METHOD_MAP = new ConcurrentHashMap();
    private static int indentationNumberOfSpace = 4;
    private static int maxRecursionDepth = 10;

    private ClassUtils() {
    }

    public static void checkArgument(boolean condition) {
        if (!condition) {
            throw new IllegalArgumentException();
        }
    }

    public static Class<?> getClassByName(String name) {
        return CLASS_STRING_MAP.computeIfAbsent(name, key -> {
            try {
                return Class.forName(key);
            }
            catch (ClassNotFoundException | SecurityException e) {
                LOGGER.atError().setCause((Throwable)e).addArgument((Object)name).log("exception while getting class {}");
                return null;
            }
        });
    }

    public static Class<?> getClassByNameNonVerboseError(String name) {
        return CLASS_STRING_MAP.computeIfAbsent(name, key -> {
            try {
                return Class.forName(key);
            }
            catch (ClassNotFoundException | SecurityException e) {
                return Object.class;
            }
        });
    }

    public static Map<Integer, ClassFieldDescription> getClassDescriptions() {
        return CLASS_FIELD_DESCRIPTION_MAP;
    }

    public static ClassFieldDescription getFieldDescription(Class<?> clazz, Class<?> ... classArguments) {
        if (clazz == null) {
            throw new IllegalArgumentException("object must not be null");
        }
        return CLASS_FIELD_DESCRIPTION_MAP.computeIfAbsent(ClassUtils.computeHashCode(clazz, classArguments), key -> new ClassFieldDescription(clazz, false));
    }

    public static int getIndentationNumberOfSpace() {
        return indentationNumberOfSpace;
    }

    public static Collection<ClassFieldDescription> getKnownClasses() {
        return CLASS_FIELD_DESCRIPTION_MAP.values();
    }

    public static Map<Class<?>, Map<String, Method>> getKnownMethods() {
        return CLASS_METHOD_MAP;
    }

    public static int getMaxRecursionDepth() {
        return maxRecursionDepth;
    }

    public static Method getMethod(Class<?> clazz, String methodName) {
        return CLASS_METHOD_MAP.computeIfAbsent(clazz, c -> new ConcurrentHashMap()).computeIfAbsent(methodName, name -> {
            try {
                return clazz.getMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                return null;
            }
        });
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            ClassUtils.checkArgument(rawType instanceof Class);
            return (Class)rawType;
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            return Array.newInstance(ClassUtils.getRawType(componentType), 0).getClass();
        }
        if (type instanceof TypeVariable) {
            return Object.class;
        }
        if (type instanceof WildcardType) {
            return ClassUtils.getRawType(((WildcardType)type).getUpperBounds()[0]);
        }
        String className = type == null ? "null" : type.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + type + "> is of type " + className);
    }

    public static Type[] getSecondaryType(Type type) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments();
        }
        return new Type[0];
    }

    public static boolean isBoxedArray(Class<?> type) {
        return boxedArrayPrimitiveMap.containsKey(type);
    }

    public static boolean isPrimitiveArray(Class<?> type) {
        return primitiveArrayBoxedMap.containsKey(type);
    }

    public static boolean isPrimitiveOrString(Class<?> type) {
        if (type == null) {
            return false;
        }
        return type.isPrimitive() || String.class.isAssignableFrom(type);
    }

    public static boolean isPrimitiveOrWrapper(Class<?> type) {
        if (type == null) {
            return false;
        }
        return type.isPrimitive() || ClassUtils.isPrimitiveWrapper(type);
    }

    public static boolean isPrimitiveWrapper(Class<?> type) {
        return wrapperPrimitiveMap.containsKey(type);
    }

    public static boolean isPrimitiveWrapperOrString(Class<?> type) {
        if (type == null) {
            return false;
        }
        return wrapperPrimitiveMap.containsKey(type) || String.class.isAssignableFrom(type);
    }

    public static Class<?> primitiveToWrapper(Class<?> cls) {
        Class<?> convertedClass = cls;
        if (cls != null && cls.isPrimitive()) {
            convertedClass = primitiveWrapperMap.get(cls);
        }
        return convertedClass;
    }

    public static void setIndentationNumberOfSpace(int indentationNumberOfSpace) {
        ClassUtils.indentationNumberOfSpace = indentationNumberOfSpace;
    }

    public static void setMaxRecursionDepth(int maxRecursionDepth) {
        ClassUtils.maxRecursionDepth = maxRecursionDepth;
    }

    public static String spaces(int spaces) {
        return CharBuffer.allocate(spaces).toString().replace('\u0000', ' ');
    }

    public static String translateClassName(String name) {
        if (name.startsWith("[Z")) {
            return boolean[].class.getName();
        }
        if (name.startsWith("[B")) {
            return byte[].class.getName();
        }
        if (name.startsWith("[S")) {
            return short[].class.getName();
        }
        if (name.startsWith("[I")) {
            return int[].class.getName();
        }
        if (name.startsWith("[J")) {
            return long[].class.getName();
        }
        if (name.startsWith("[F")) {
            return float[].class.getName();
        }
        if (name.startsWith("[D")) {
            return double[].class.getName();
        }
        if (name.startsWith("[L")) {
            return name.substring(2, name.length() - 1) + "[]";
        }
        return name;
    }

    private static void add(Map<Class<?>, Class<?>> map1, Map<Class<?>, Class<?>> map2, Class<?> obj1, Class<?> obj2) {
        map1.put(obj1, obj2);
        map2.put(obj2, obj1);
    }

    private static int computeHashCode(Class<?> classPrototype, Class<?> ... classArguments) {
        int prime = 31;
        int result = 1;
        result = 31 * result + (classPrototype == null ? 0 : classPrototype.getName().hashCode());
        if (classArguments == null || classArguments.length <= 0) {
            return result;
        }
        for (Class<?> clazz : classArguments) {
            result = 31 * result + clazz.hashCode();
        }
        return result;
    }

    static {
        ClassUtils.add(wrapperPrimitiveMap, primitiveWrapperMap, Boolean.class, Boolean.TYPE);
        ClassUtils.add(wrapperPrimitiveMap, primitiveWrapperMap, Byte.class, Byte.TYPE);
        ClassUtils.add(wrapperPrimitiveMap, primitiveWrapperMap, Character.class, Character.TYPE);
        ClassUtils.add(wrapperPrimitiveMap, primitiveWrapperMap, Short.class, Short.TYPE);
        ClassUtils.add(wrapperPrimitiveMap, primitiveWrapperMap, Integer.class, Integer.TYPE);
        ClassUtils.add(wrapperPrimitiveMap, primitiveWrapperMap, Long.class, Long.TYPE);
        ClassUtils.add(wrapperPrimitiveMap, primitiveWrapperMap, Float.class, Float.TYPE);
        ClassUtils.add(wrapperPrimitiveMap, primitiveWrapperMap, Double.class, Double.TYPE);
        ClassUtils.add(wrapperPrimitiveMap, primitiveWrapperMap, Void.class, Void.TYPE);
        ClassUtils.add(wrapperPrimitiveMap, primitiveWrapperMap, String.class, String.class);
        ClassUtils.add(primitiveArrayBoxedMap, boxedArrayPrimitiveMap, boolean[].class, Boolean[].class);
        ClassUtils.add(primitiveArrayBoxedMap, boxedArrayPrimitiveMap, byte[].class, Byte[].class);
        ClassUtils.add(primitiveArrayBoxedMap, boxedArrayPrimitiveMap, char[].class, Character[].class);
        ClassUtils.add(primitiveArrayBoxedMap, boxedArrayPrimitiveMap, short[].class, Short[].class);
        ClassUtils.add(primitiveArrayBoxedMap, boxedArrayPrimitiveMap, int[].class, Integer[].class);
        ClassUtils.add(primitiveArrayBoxedMap, boxedArrayPrimitiveMap, long[].class, Long[].class);
        ClassUtils.add(primitiveArrayBoxedMap, boxedArrayPrimitiveMap, float[].class, Float[].class);
        ClassUtils.add(primitiveArrayBoxedMap, boxedArrayPrimitiveMap, double[].class, Double[].class);
        ClassUtils.add(primitiveArrayBoxedMap, boxedArrayPrimitiveMap, String[].class, String[].class);
    }
}

