/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.serializer.spi;

import de.gsi.serializer.IoSerialiser;
import de.gsi.serializer.spi.WireDataFieldDescription;

public class ProtocolInfo
extends WireDataFieldDescription {
    private final WireDataFieldDescription fieldHeader;
    private final String producerName;
    private final byte versionMajor;
    private final byte versionMinor;
    private final byte versionMicro;

    ProtocolInfo(IoSerialiser source, WireDataFieldDescription fieldDescription, String producer, byte major, byte minor, byte micro) {
        super(source, null, fieldDescription.hashCode(), fieldDescription.getFieldName(), fieldDescription.getDataType(), fieldDescription.getFieldStart(), fieldDescription.getDataStartOffset(), fieldDescription.getDataSize());
        this.fieldHeader = fieldDescription;
        this.producerName = producer;
        this.versionMajor = major;
        this.versionMinor = minor;
        this.versionMicro = micro;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ProtocolInfo)) {
            return false;
        }
        ProtocolInfo other = (ProtocolInfo)obj;
        return other.isCompatible();
    }

    public WireDataFieldDescription getFieldHeader() {
        return this.fieldHeader;
    }

    public String getProducerName() {
        return this.producerName;
    }

    public byte getVersionMajor() {
        return this.versionMajor;
    }

    public byte getVersionMicro() {
        return this.versionMicro;
    }

    public byte getVersionMinor() {
        return this.versionMinor;
    }

    @Override
    public int hashCode() {
        return this.producerName.hashCode();
    }

    public boolean isCompatible() {
        return this.getVersionMajor() <= 1 && this.getVersionMinor() <= 0;
    }

    @Override
    public String toString() {
        return super.toString() + String.format(" serialiser: %s-v%d.%d.%d", this.getProducerName(), this.getVersionMajor(), this.getVersionMinor(), this.getVersionMicro());
    }
}

