/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.serializer.spi;

import com.jsoniter.JsonIterator;
import com.jsoniter.JsonIteratorPool;
import com.jsoniter.any.Any;
import com.jsoniter.extra.PreciseFloatSupport;
import com.jsoniter.output.EncodingMode;
import com.jsoniter.output.JsonStream;
import com.jsoniter.spi.DecodingMode;
import com.jsoniter.spi.JsonException;
import de.gsi.dataset.utils.ByteBufferOutputStream;
import de.gsi.serializer.DataType;
import de.gsi.serializer.FieldDescription;
import de.gsi.serializer.FieldSerialiser;
import de.gsi.serializer.IoBuffer;
import de.gsi.serializer.IoSerialiser;
import de.gsi.serializer.spi.ProtocolInfo;
import de.gsi.serializer.spi.WireDataFieldDescription;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiFunction;

public class JsonSerialiser
implements IoSerialiser {
    public static final String NOT_A_JSON_COMPATIBLE_PROTOCOL = "Not a JSON compatible protocol";
    public static final String JSON_ROOT = "JSON_ROOT";
    private static final int DEFAULT_INITIAL_CAPACITY = 10000;
    private static final int DEFAULT_INDENTATION = 2;
    private static final char BRACKET_OPEN = '{';
    private static final char BRACKET_CLOSE = '}';
    private static final String LINE_BREAK = System.getProperty("line.separator");
    private final StringBuilder builder = new StringBuilder(10000);
    private IoBuffer buffer;
    private boolean putFieldMetaData = true;
    private Any root = null;
    private Any tempRoot = null;
    private WireDataFieldDescription parent;
    private WireDataFieldDescription lastFieldHeader;
    private String queryFieldName = null;
    private boolean hasFieldBefore = false;
    private String indentation = "";
    private BiFunction<Type, Type[], FieldSerialiser<Object>> fieldSerialiserLookupFunction;

    public JsonSerialiser(IoBuffer buffer) {
        this.buffer = buffer;
        JsonStream.setMode((EncodingMode)EncodingMode.DYNAMIC_MODE);
        JsonIterator.setMode((DecodingMode)DecodingMode.DYNAMIC_MODE_AND_MATCH_FIELD_WITH_HASH);
        try {
            PreciseFloatSupport.enable();
        }
        catch (JsonException jsonException) {
            // empty catch block
        }
    }

    @Override
    public ProtocolInfo checkHeaderInfo() {
        int count = this.buffer.position();
        while (this.buffer.getByte(count) != 123 && (this.buffer.getByte(count) == 0 || this.buffer.getByte(count) == 32 || this.buffer.getByte(count) == 9 || this.buffer.getByte(count) == 10)) {
            ++count;
        }
        if (this.buffer.getByte(count) != 123) {
            throw new IllegalStateException(NOT_A_JSON_COMPATIBLE_PROTOCOL);
        }
        JsonIterator iter = JsonIteratorPool.borrowJsonIterator();
        iter.reset(this.buffer.elements(), 0, this.buffer.limit());
        try {
            this.tempRoot = this.root = iter.readAny();
        }
        catch (IOException e) {
            throw new IllegalStateException(NOT_A_JSON_COMPATIBLE_PROTOCOL, e);
        }
        WireDataFieldDescription headerStartField = new WireDataFieldDescription(this, null, JSON_ROOT.hashCode(), JSON_ROOT, DataType.OTHER, this.buffer.position(), count - 1, -1);
        ProtocolInfo header = new ProtocolInfo(this, headerStartField, JsonSerialiser.class.getCanonicalName(), 1, 0, 0);
        this.parent = this.lastFieldHeader = headerStartField;
        this.queryFieldName = JSON_ROOT;
        return header;
    }

    public <T> T deserialiseObject(T obj) {
        JsonIterator iter = JsonIterator.parse((byte[])this.buffer.elements(), (int)0, (int)this.buffer.limit());
        try {
            return (T)iter.read(obj);
        }
        catch (JsonException | IOException e) {
            throw new IllegalStateException(NOT_A_JSON_COMPATIBLE_PROTOCOL, e);
        }
    }

    @Override
    public int[] getArraySizeDescriptor() {
        return new int[0];
    }

    @Override
    public boolean getBoolean() {
        return this.tempRoot.get((Object)this.queryFieldName).toBoolean();
    }

    @Override
    public boolean[] getBooleanArray(boolean[] dst, int length) {
        return (boolean[])this.tempRoot.get((Object)this.queryFieldName).as(boolean[].class);
    }

    @Override
    public IoBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public byte getByte() {
        return (byte)this.tempRoot.get((Object)this.queryFieldName).toInt();
    }

    @Override
    public byte[] getByteArray(byte[] dst, int length) {
        return (byte[])this.tempRoot.get((Object)this.queryFieldName).as(byte[].class);
    }

    @Override
    public char getChar() {
        return (char)this.tempRoot.get((Object)this.queryFieldName).toInt();
    }

    @Override
    public char[] getCharArray(char[] dst, int length) {
        return (char[])this.tempRoot.get((Object)this.queryFieldName).as(char[].class);
    }

    @Override
    public <E> Collection<E> getCollection(Collection<E> collection) {
        return (Collection)this.tempRoot.get((Object)this.queryFieldName).as(ArrayList.class);
    }

    @Override
    public <E> E getCustomData(FieldSerialiser<E> serialiser) {
        return (E)this.tempRoot.get((Object)this.queryFieldName);
    }

    @Override
    public double getDouble() {
        return this.tempRoot.get((Object)this.queryFieldName).toDouble();
    }

    @Override
    public double[] getDoubleArray(double[] dst, int length) {
        return (double[])this.tempRoot.get((Object)this.queryFieldName).as(double[].class);
    }

    @Override
    public <E extends Enum<E>> Enum<E> getEnum(Enum<E> enumeration) {
        return null;
    }

    @Override
    public String getEnumTypeList() {
        return null;
    }

    @Override
    public WireDataFieldDescription getFieldHeader() {
        return null;
    }

    @Override
    public float getFloat() {
        return this.tempRoot.get((Object)this.queryFieldName).toFloat();
    }

    @Override
    public float[] getFloatArray(float[] dst, int length) {
        return (float[])this.tempRoot.get((Object)this.queryFieldName).as(float[].class);
    }

    @Override
    public int getInt() {
        return this.tempRoot.get((Object)this.queryFieldName).toInt();
    }

    @Override
    public int[] getIntArray(int[] dst, int length) {
        return (int[])this.tempRoot.get((Object)this.queryFieldName).as(int[].class);
    }

    @Override
    public <E> List<E> getList(List<E> collection) {
        return (List)this.tempRoot.get((Object)this.queryFieldName).as(List.class);
    }

    @Override
    public long getLong() {
        return this.tempRoot.get((Object)this.queryFieldName).toLong();
    }

    @Override
    public long[] getLongArray(long[] dst, int length) {
        return (long[])this.tempRoot.get((Object)this.queryFieldName).as(long[].class);
    }

    @Override
    public <K, V, E> Map<K, V> getMap(Map<K, V> map) {
        return null;
    }

    public WireDataFieldDescription getParent() {
        return this.parent;
    }

    @Override
    public <E> Queue<E> getQueue(Queue<E> collection) {
        return (Queue)this.tempRoot.get((Object)this.queryFieldName).as(ArrayDeque.class);
    }

    public String getSerialisedString() {
        return this.buffer.toString();
    }

    @Override
    public <E> Set<E> getSet(Set<E> collection) {
        return (Set)this.tempRoot.get((Object)this.queryFieldName).as(HashSet.class);
    }

    @Override
    public short getShort() {
        return (short)this.tempRoot.get((Object)this.queryFieldName).toLong();
    }

    @Override
    public short[] getShortArray(short[] dst, int length) {
        return (short[])this.tempRoot.get((Object)this.queryFieldName).as(short[].class);
    }

    @Override
    public String getString() {
        return this.tempRoot.get((Object)this.queryFieldName).toString();
    }

    @Override
    public String[] getStringArray(String[] dst, int length) {
        return (String[])this.tempRoot.get((Object)this.queryFieldName).as(String[].class);
    }

    @Override
    public String getStringISO8859() {
        return this.tempRoot.get((Object)this.queryFieldName).toString();
    }

    @Override
    public boolean isPutFieldMetaData() {
        return this.putFieldMetaData;
    }

    @Override
    public WireDataFieldDescription parseIoStream(boolean readHeader) {
        JsonIterator iter = JsonIteratorPool.borrowJsonIterator();
        iter.reset(this.buffer.elements(), 0, this.buffer.limit());
        try {
            this.tempRoot = this.root = iter.readAny();
        }
        catch (IOException e) {
            throw new IllegalStateException(NOT_A_JSON_COMPATIBLE_PROTOCOL, e);
        }
        WireDataFieldDescription fieldRoot = new WireDataFieldDescription(this, null, "ROOT".hashCode(), "ROOT", DataType.OTHER, this.buffer.position(), -1, -1);
        this.parseIoStream(fieldRoot, this.tempRoot, "");
        return fieldRoot;
    }

    @Override
    public <E> void put(FieldDescription fieldDescription, Collection<E> collection, Type valueType) {
        this.put(fieldDescription.getFieldName(), collection, valueType);
    }

    @Override
    public void put(FieldDescription fieldDescription, Enum<?> enumeration) {
        this.put(fieldDescription.getFieldName(), enumeration);
    }

    @Override
    public <K, V, E> void put(FieldDescription fieldDescription, Map<K, V> map, Type keyType, Type valueType) {
        this.put(fieldDescription.getFieldName(), map, keyType, valueType);
    }

    @Override
    public <E> void put(String fieldName, Collection<E> collection, Type valueType) {
        E element;
        this.lineBreak();
        this.builder.append('\"').append(fieldName).append("\", ").append("[");
        if (collection == null || collection.isEmpty()) {
            this.builder.append(']');
            return;
        }
        Iterator<E> iter = collection.iterator();
        this.builder.append(iter.next().toString());
        while ((element = iter.next()) != null) {
            this.builder.append(", ").append(element.toString());
        }
        this.builder.append(']');
        this.hasFieldBefore = true;
    }

    @Override
    public void put(String fieldName, Enum<?> enumeration) {
        this.lineBreak();
        this.builder.append('\"').append(fieldName).append("\": ").append(enumeration);
        this.hasFieldBefore = true;
    }

    @Override
    public <K, V, E> void put(String fieldName, Map<K, V> map, Type keyType, Type valueType) {
        this.lineBreak();
        this.builder.append('\"').append(fieldName).append("\", ").append('{');
        if (map == null || map.isEmpty()) {
            this.builder.append('}');
            return;
        }
        Set<Map.Entry<K, V>> entrySet = map.entrySet();
        boolean isFirst = true;
        block4: for (Map.Entry<K, V> entry : entrySet) {
            V value = entry.getValue();
            if (isFirst) {
                isFirst = false;
            } else {
                this.builder.append(", ");
            }
            this.builder.append('\"').append(entry.getKey()).append('\"').append(':');
            switch (DataType.fromClassType((Class)value)) {
                case CHAR: {
                    this.builder.append((Integer)value);
                    continue block4;
                }
                case STRING: {
                    this.builder.append('\"').append(entry.getValue()).append('\"');
                    continue block4;
                }
            }
            this.builder.append(value);
        }
        this.builder.append('}');
        this.hasFieldBefore = true;
    }

    @Override
    public void put(FieldDescription fieldDescription, boolean value) {
        this.put(fieldDescription.getFieldName(), value);
    }

    @Override
    public void put(FieldDescription fieldDescription, boolean[] values, int n) {
        this.put(fieldDescription.getFieldName(), values, n);
    }

    @Override
    public void put(FieldDescription fieldDescription, boolean[] values, int[] dims) {
        this.put(fieldDescription.getFieldName(), values, dims);
    }

    @Override
    public void put(FieldDescription fieldDescription, byte value) {
        this.put(fieldDescription.getFieldName(), value);
    }

    @Override
    public void put(FieldDescription fieldDescription, byte[] values, int n) {
        this.put(fieldDescription.getFieldName(), values, n);
    }

    @Override
    public void put(FieldDescription fieldDescription, byte[] values, int[] dims) {
        this.put(fieldDescription.getFieldName(), values, dims);
    }

    @Override
    public void put(FieldDescription fieldDescription, char value) {
        this.put(fieldDescription.getFieldName(), value);
    }

    @Override
    public void put(FieldDescription fieldDescription, char[] values, int n) {
        this.put(fieldDescription.getFieldName(), values, n);
    }

    @Override
    public void put(FieldDescription fieldDescription, char[] values, int[] dims) {
        this.put(fieldDescription.getFieldName(), values, dims);
    }

    @Override
    public void put(FieldDescription fieldDescription, double value) {
        this.put(fieldDescription.getFieldName(), value);
    }

    @Override
    public void put(FieldDescription fieldDescription, double[] values, int n) {
        this.put(fieldDescription.getFieldName(), values, n);
    }

    @Override
    public void put(FieldDescription fieldDescription, double[] values, int[] dims) {
        this.put(fieldDescription.getFieldName(), values, dims);
    }

    @Override
    public void put(FieldDescription fieldDescription, float value) {
        this.put(fieldDescription.getFieldName(), value);
    }

    @Override
    public void put(FieldDescription fieldDescription, float[] values, int n) {
        this.put(fieldDescription.getFieldName(), values, n);
    }

    @Override
    public void put(FieldDescription fieldDescription, float[] values, int[] dims) {
        this.put(fieldDescription.getFieldName(), values, dims);
    }

    @Override
    public void put(FieldDescription fieldDescription, int value) {
        this.put(fieldDescription.getFieldName(), value);
    }

    @Override
    public void put(FieldDescription fieldDescription, int[] values, int n) {
        this.put(fieldDescription.getFieldName(), values, n);
    }

    @Override
    public void put(FieldDescription fieldDescription, int[] values, int[] dims) {
        this.put(fieldDescription.getFieldName(), values, dims);
    }

    @Override
    public void put(FieldDescription fieldDescription, long value) {
        this.put(fieldDescription.getFieldName(), value);
    }

    @Override
    public void put(FieldDescription fieldDescription, long[] values, int n) {
        this.put(fieldDescription.getFieldName(), values, n);
    }

    @Override
    public void put(FieldDescription fieldDescription, long[] values, int[] dims) {
        this.put(fieldDescription.getFieldName(), values, dims);
    }

    @Override
    public void put(FieldDescription fieldDescription, short value) {
        this.put(fieldDescription.getFieldName(), value);
    }

    @Override
    public void put(FieldDescription fieldDescription, short[] values, int n) {
        this.put(fieldDescription.getFieldName(), values, n);
    }

    @Override
    public void put(FieldDescription fieldDescription, short[] values, int[] dims) {
        this.put(fieldDescription.getFieldName(), values, dims);
    }

    @Override
    public void put(FieldDescription fieldDescription, String string) {
        this.put(fieldDescription.getFieldName(), string);
    }

    @Override
    public void put(FieldDescription fieldDescription, String[] values, int n) {
        this.put(fieldDescription.getFieldName(), values, n);
    }

    @Override
    public void put(FieldDescription fieldDescription, String[] values, int[] dims) {
        this.put(fieldDescription.getFieldName(), values, dims);
    }

    @Override
    public void put(String fieldName, boolean value) {
        this.lineBreak();
        this.builder.append('\"').append(fieldName).append("\": ").append(value);
        this.hasFieldBefore = true;
    }

    @Override
    public void put(String fieldName, boolean[] values, int n) {
        this.lineBreak();
        this.builder.append('\"').append(fieldName).append("\": ").append("[");
        if (values == null || values.length <= 0) {
            this.builder.append(']');
            return;
        }
        this.builder.append(values[0]);
        int valuesSize = values.length;
        int nElements = n >= 0 ? Math.min(n, valuesSize) : valuesSize;
        for (int i = 1; i < nElements; ++i) {
            this.builder.append(", ").append(values[i]);
        }
        this.builder.append(']');
        this.hasFieldBefore = true;
    }

    @Override
    public void put(String fieldName, boolean[] values, int[] dims) {
        this.put(fieldName, values, this.getNumberElements(dims));
    }

    @Override
    public void put(String fieldName, byte value) {
        this.lineBreak();
        this.builder.append('\"').append(fieldName).append("\": ").append(value);
        this.hasFieldBefore = true;
    }

    @Override
    public void put(String fieldName, byte[] values, int n) {
        this.lineBreak();
        this.builder.append('\"').append(fieldName).append("\": ").append("[");
        if (values == null || values.length <= 0) {
            this.builder.append(']');
            return;
        }
        this.builder.append(values[0]);
        int valuesSize = values.length;
        int nElements = n >= 0 ? Math.min(n, valuesSize) : valuesSize;
        for (int i = 1; i < nElements; ++i) {
            this.builder.append(", ").append(values[i]);
        }
        this.builder.append(']');
        this.hasFieldBefore = true;
    }

    @Override
    public void put(String fieldName, byte[] values, int[] dims) {
        this.put(fieldName, values, this.getNumberElements(dims));
    }

    @Override
    public void put(String fieldName, char value) {
        this.lineBreak();
        this.builder.append('\"').append(fieldName).append("\": ").append((int)value);
        this.hasFieldBefore = true;
    }

    @Override
    public void put(String fieldName, char[] values, int n) {
        this.lineBreak();
        this.builder.append('\"').append(fieldName).append("\": ").append("[");
        if (values == null || values.length <= 0) {
            this.builder.append(']');
            return;
        }
        this.builder.append((int)values[0]);
        int valuesSize = values.length;
        int nElements = n >= 0 ? Math.min(n, valuesSize) : valuesSize;
        for (int i = 1; i < nElements; ++i) {
            this.builder.append(", ").append((int)values[i]);
        }
        this.builder.append(']');
        this.hasFieldBefore = true;
    }

    @Override
    public void put(String fieldName, char[] values, int[] dims) {
        this.put(fieldName, values, this.getNumberElements(dims));
    }

    @Override
    public void put(String fieldName, double value) {
        this.lineBreak();
        this.builder.append('\"').append(fieldName).append("\": ").append(value);
        this.hasFieldBefore = true;
    }

    @Override
    public void put(String fieldName, double[] values, int n) {
        this.lineBreak();
        this.builder.append('\"').append(fieldName).append("\": ").append("[");
        if (values == null || values.length <= 0) {
            this.builder.append(']');
            return;
        }
        this.builder.append(values[0]);
        int valuesSize = values.length;
        int nElements = n >= 0 ? Math.min(n, valuesSize) : valuesSize;
        for (int i = 1; i < nElements; ++i) {
            this.builder.append(", ").append(values[i]);
        }
        this.builder.append(']');
        this.hasFieldBefore = true;
    }

    @Override
    public void put(String fieldName, double[] values, int[] dims) {
        this.put(fieldName, values, this.getNumberElements(dims));
    }

    @Override
    public void put(String fieldName, float value) {
        this.lineBreak();
        this.builder.append('\"').append(fieldName).append("\": ").append(value);
        this.hasFieldBefore = true;
    }

    @Override
    public void put(String fieldName, float[] values, int n) {
        this.lineBreak();
        this.builder.append('\"').append(fieldName).append("\": ").append("[");
        if (values == null || values.length <= 0) {
            this.builder.append(']');
            return;
        }
        this.builder.append(values[0]);
        int valuesSize = values.length;
        int nElements = n >= 0 ? Math.min(n, valuesSize) : valuesSize;
        for (int i = 1; i < nElements; ++i) {
            this.builder.append(", ").append(values[i]);
        }
        this.builder.append(']');
        this.hasFieldBefore = true;
    }

    @Override
    public void put(String fieldName, float[] values, int[] dims) {
        this.put(fieldName, values, this.getNumberElements(dims));
    }

    @Override
    public void put(String fieldName, int value) {
        this.lineBreak();
        this.builder.append('\"').append(fieldName).append("\": ").append(value);
        this.hasFieldBefore = true;
    }

    @Override
    public void put(String fieldName, int[] values, int n) {
        this.lineBreak();
        this.builder.append('\"').append(fieldName).append("\": ").append("[");
        if (values == null || values.length <= 0) {
            this.builder.append(']');
            return;
        }
        this.builder.append(values[0]);
        int valuesSize = values.length;
        int nElements = n >= 0 ? Math.min(n, valuesSize) : valuesSize;
        for (int i = 1; i < nElements; ++i) {
            this.builder.append(", ").append(values[i]);
        }
        this.builder.append(']');
        this.hasFieldBefore = true;
    }

    @Override
    public void put(String fieldName, int[] values, int[] dims) {
        this.put(fieldName, values, this.getNumberElements(dims));
    }

    @Override
    public void put(String fieldName, long value) {
        this.lineBreak();
        this.builder.append('\"').append(fieldName).append("\": ").append(value);
        this.hasFieldBefore = true;
    }

    @Override
    public void put(String fieldName, long[] values, int n) {
        this.lineBreak();
        this.builder.append('\"').append(fieldName).append("\": ").append("[");
        if (values == null || values.length <= 0) {
            this.builder.append(']');
            return;
        }
        this.builder.append(values[0]);
        int valuesSize = values.length;
        int nElements = n >= 0 ? Math.min(n, valuesSize) : valuesSize;
        for (int i = 1; i < nElements; ++i) {
            this.builder.append(", ").append(values[i]);
        }
        this.builder.append(']');
        this.hasFieldBefore = true;
    }

    @Override
    public void put(String fieldName, long[] values, int[] dims) {
        this.put(fieldName, values, this.getNumberElements(dims));
    }

    @Override
    public void put(String fieldName, short value) {
        this.lineBreak();
        this.builder.append('\"').append(fieldName).append("\": ").append(value);
        this.hasFieldBefore = true;
    }

    @Override
    public void put(String fieldName, short[] values, int n) {
        this.lineBreak();
        this.builder.append('\"').append(fieldName).append("\": ").append("[");
        if (values == null || values.length <= 0) {
            this.builder.append(']');
            return;
        }
        this.builder.append(values[0]);
        int valuesSize = values.length;
        int nElements = n >= 0 ? Math.min(n, valuesSize) : valuesSize;
        for (int i = 1; i < nElements; ++i) {
            this.builder.append(", ").append(values[i]);
        }
        this.builder.append(']');
        this.hasFieldBefore = true;
    }

    @Override
    public void put(String fieldName, short[] values, int[] dims) {
        this.put(fieldName, values, this.getNumberElements(dims));
    }

    @Override
    public void put(String fieldName, String string) {
        this.lineBreak();
        this.builder.append('\"').append(fieldName).append("\": \"").append(string).append('\"');
        this.hasFieldBefore = true;
    }

    @Override
    public void put(String fieldName, String[] values, int n) {
        this.lineBreak();
        this.builder.append('\"').append(fieldName).append("\": ").append("[");
        if (values == null || values.length <= 0) {
            this.builder.append(']');
            return;
        }
        this.builder.append('\"').append(values[0]).append('\"');
        int valuesSize = values.length;
        int nElements = n >= 0 ? Math.min(n, valuesSize) : valuesSize;
        for (int i = 1; i < nElements; ++i) {
            this.builder.append(", \"").append(values[i]).append('\"');
        }
        this.builder.append(']');
        this.hasFieldBefore = true;
    }

    @Override
    public void put(String fieldName, String[] values, int[] dims) {
        this.put(fieldName, values, this.getNumberElements(dims));
    }

    @Override
    public int putArraySizeDescriptor(int n) {
        return 0;
    }

    @Override
    public int putArraySizeDescriptor(int[] dims) {
        return 0;
    }

    @Override
    public <E> WireDataFieldDescription putCustomData(FieldDescription fieldDescription, E obj, Class<? extends E> type, FieldSerialiser<E> serialiser) {
        return null;
    }

    @Override
    public void putEndMarker(FieldDescription fieldDescription) {
        this.indentation = this.indentation.substring(0, Math.max(this.indentation.length() - 2, 0));
        this.builder.append(LINE_BREAK).append(this.indentation).append('}').append(LINE_BREAK);
        this.hasFieldBefore = true;
        byte[] outputStrBytes = this.builder.toString().getBytes(StandardCharsets.UTF_8);
        System.arraycopy(outputStrBytes, 0, this.buffer.elements(), this.buffer.position(), outputStrBytes.length);
        this.buffer.position(this.buffer.position() + outputStrBytes.length);
        this.builder.setLength(0);
    }

    @Override
    public WireDataFieldDescription putFieldHeader(FieldDescription fieldDescription) {
        return this.putFieldHeader(fieldDescription.getFieldName(), fieldDescription.getDataType());
    }

    @Override
    public WireDataFieldDescription putFieldHeader(String fieldName, DataType dataType) {
        this.lastFieldHeader = new WireDataFieldDescription(this, this.parent, fieldName.hashCode(), fieldName, dataType, -1, 1, -1);
        this.queryFieldName = fieldName;
        return this.lastFieldHeader;
    }

    @Override
    public void putHeaderInfo(FieldDescription ... field) {
        this.hasFieldBefore = false;
        this.indentation = "";
        this.builder.setLength(0);
        this.putStartMarker(null);
    }

    @Override
    public void putStartMarker(FieldDescription fieldDescription) {
        this.lineBreak();
        if (fieldDescription != null) {
            this.builder.append('\"').append(fieldDescription.getFieldName()).append("\": ");
        }
        this.builder.append('{');
        this.indentation = this.indentation + " ".repeat(2);
        this.builder.append(LINE_BREAK);
        this.builder.append(this.indentation);
        this.hasFieldBefore = false;
    }

    public void serialiseObject(Object obj) {
        if (obj == null) {
            this.builder.setLength(0);
            this.builder.append('{').append('}');
            byte[] bytes = this.getSerialisedString().getBytes(Charset.defaultCharset());
            System.arraycopy(bytes, 0, this.buffer.elements(), this.buffer.position(), bytes.length);
            this.buffer.position(bytes.length);
            return;
        }
        try (ByteBufferOutputStream byteOutputStream = new ByteBufferOutputStream(ByteBuffer.wrap(this.buffer.elements()), new boolean[]{false});){
            byteOutputStream.position(this.buffer.position());
            JsonStream.serialize((Object)obj, (OutputStream)byteOutputStream);
            this.buffer.position(byteOutputStream.position());
        }
        catch (IOException e) {
            throw new IllegalStateException(NOT_A_JSON_COMPATIBLE_PROTOCOL, e);
        }
    }

    @Override
    public void setBuffer(IoBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void setPutFieldMetaData(boolean putFieldMetaData) {
        this.putFieldMetaData = putFieldMetaData;
    }

    @Override
    public void setQueryFieldName(String fieldName, int dataStartPosition) {
        if (fieldName == null || fieldName.isBlank()) {
            throw new IllegalArgumentException("fieldName must not be null or blank: " + fieldName);
        }
        if (this.root == null) {
            throw new IllegalArgumentException("JSON Any root hasn't been analysed/parsed yet");
        }
        this.queryFieldName = fieldName;
    }

    @Override
    public void updateDataEndMarker(WireDataFieldDescription fieldHeader) {
    }

    private int getNumberElements(int[] dims) {
        int n = 1;
        for (int dim : dims) {
            n *= dim;
        }
        return n;
    }

    private void lineBreak() {
        if (this.hasFieldBefore) {
            this.builder.append(',');
            this.builder.append(LINE_BREAK);
            this.builder.append(this.indentation);
        }
    }

    private void parseIoStream(WireDataFieldDescription fieldRoot, Any any, String fieldName) {
        if (!(any.object() instanceof Map) || any.size() == 0) {
            return;
        }
        Map map = any.asMap();
        WireDataFieldDescription putStartMarker = new WireDataFieldDescription(this, fieldRoot, fieldName.hashCode(), fieldName, DataType.START_MARKER, 0, -1, -1);
        for (Map.Entry child : map.entrySet()) {
            String childName = (String)child.getKey();
            Any childAny = (Any)map.get(childName);
            Object data = childAny.object();
            if (data instanceof Map) {
                this.parseIoStream(putStartMarker, childAny, childName);
                continue;
            }
            if (data == null) continue;
            new WireDataFieldDescription(this, putStartMarker, childName.hashCode(), childName, DataType.fromClassType(data.getClass()), 0, -1, -1);
        }
    }

    @Override
    public void setFieldSerialiserLookupFunction(BiFunction<Type, Type[], FieldSerialiser<Object>> serialiserLookupFunction) {
        this.fieldSerialiserLookupFunction = serialiserLookupFunction;
    }

    @Override
    public BiFunction<Type, Type[], FieldSerialiser<Object>> getSerialiserLookupFunction() {
        return this.fieldSerialiserLookupFunction;
    }
}

