/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.serializer;

import de.gsi.serializer.IoClassSerialiser;
import de.gsi.serializer.IoSerialiser;
import de.gsi.serializer.spi.ClassFieldDescription;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldSerialiser<R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldSerialiser.class);
    private final Class<?> classPrototype;
    private final List<Type> classGenericArguments;
    private final String name;
    private final String canonicalName;
    private final String simpleName;
    private final int cachedHashCode;
    protected TriConsumer readerFunction;
    protected TriConsumer writerFunction;
    protected TriFunction<R> returnFunction;

    public FieldSerialiser(TriConsumer reader, TriFunction<R> returnFunction, TriConsumer writer, Class<?> classPrototype, Class<?> ... classGenericArguments) {
        if (reader == null || returnFunction == null || writer == null) {
            LOGGER.atWarn().addArgument((Object)reader).addArgument((Object)writer).log("caution: reader {}, return {} or writer {} is null");
        }
        if (classPrototype == null) {
            throw new IllegalArgumentException("classPrototype must not be null");
        }
        this.readerFunction = reader;
        this.returnFunction = returnFunction;
        this.writerFunction = writer;
        this.classPrototype = classPrototype;
        this.classGenericArguments = Arrays.asList(classGenericArguments);
        this.cachedHashCode = IoClassSerialiser.computeHashCode(classPrototype, this.classGenericArguments);
        String genericFieldString = this.classGenericArguments.isEmpty() ? "" : this.classGenericArguments.stream().map(Type::getTypeName).collect(Collectors.joining(", ", "<", ">"));
        this.canonicalName = classPrototype.getCanonicalName() + genericFieldString;
        this.simpleName = classPrototype.getSimpleName() + IoClassSerialiser.getGenericFieldSimpleTypeString(this.classGenericArguments);
        this.name = "Serialiser for " + this.canonicalName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public Class<?> getClassPrototype() {
        return this.classPrototype;
    }

    public List<Type> getGenericsPrototypes() {
        return this.classGenericArguments;
    }

    public TriConsumer getReaderFunction() {
        return this.readerFunction;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public TriConsumer getWriterFunction() {
        return this.writerFunction;
    }

    public TriFunction<R> getReturnObjectFunction() {
        return this.returnFunction;
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    public String toString() {
        return this.name;
    }

    public static interface TriFunction<R> {
        public R apply(IoSerialiser var1, Object var2, ClassFieldDescription var3);
    }

    public static interface TriConsumer {
        public void accept(IoSerialiser var1, Object var2, ClassFieldDescription var3);
    }
}

