/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.serializer.spi.iobuffer;

import de.gsi.dataset.DataSet;
import de.gsi.dataset.DataSetError;
import de.gsi.dataset.DataSetMetaData;
import de.gsi.dataset.GridDataSet;
import de.gsi.dataset.spi.AbstractDataSet;
import de.gsi.dataset.spi.DataSetBuilder;
import de.gsi.dataset.spi.utils.MathUtils;
import de.gsi.dataset.spi.utils.StringHashMapList;
import de.gsi.dataset.utils.AssertUtils;
import de.gsi.dataset.utils.GenericsHelper;
import de.gsi.serializer.DataType;
import de.gsi.serializer.FieldDescription;
import de.gsi.serializer.IoSerialiser;
import de.gsi.serializer.spi.WireDataFieldDescription;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.InputMismatchException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetSerialiser {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSetSerialiser.class);
    private static final String DATA_SET_NAME = "dataSetName";
    private static final String DIMENSIONS = "nDims";
    private static final String ARRAY_PREFIX = "array";
    private static final String EN_PREFIX = "en";
    private static final String EP_PREFIX = "ep";
    private static final String AXIS = "axis";
    private static final String NAME = "name";
    private static final String UNIT = "unit";
    private static final String MIN = "Min";
    private static final String MAX = "Max";
    private static final String META_INFO = "metaInfo";
    private static final String ERROR_LIST = "errorList";
    private static final String WARNING_LIST = "warningList";
    private static final String INFO_LIST = "infoList";
    private static final String DATA_STYLES = "dataStyles";
    private static final String DATA_LABELS = "dataLabels";
    private final IoSerialiser ioSerialiser;
    private boolean transmitDataLabels = true;
    private boolean transmitMetaData = true;

    private DataSetSerialiser(IoSerialiser ioSerialiser) {
        this.ioSerialiser = ioSerialiser;
    }

    public boolean isDataLablesSerialised() {
        return this.transmitDataLabels;
    }

    public boolean isMetaDataSerialised() {
        return this.transmitMetaData;
    }

    public DataSet read() {
        return this.read(null);
    }

    public DataSet read(DataSet dataSet) {
        DataSetBuilder builder = new DataSetBuilder();
        WireDataFieldDescription root = this.ioSerialiser.parseIoStream(false);
        FieldDescription fieldRoot = root.getChildren().get(0);
        this.parseHeaders(this.ioSerialiser, builder, fieldRoot);
        if (this.isMetaDataSerialised()) {
            this.parseMetaData(this.ioSerialiser, builder, fieldRoot);
        }
        if (this.isDataLablesSerialised()) {
            this.parseDataLabels(builder, fieldRoot);
        }
        this.parseNumericData(this.ioSerialiser, builder, dataSet, fieldRoot);
        if (root.getChildren().size() != 2) {
            throw new IllegalArgumentException("fieldRoot children-count != 2: " + fieldRoot.getChildren().size());
        }
        FieldDescription endMarker = root.getChildren().get(1);
        if (endMarker.getDataType() != DataType.END_MARKER) {
            throw new IllegalArgumentException("fieldRoot END_MARKER expected but found: " + endMarker);
        }
        this.ioSerialiser.getBuffer().position(endMarker.getDataStartPosition());
        this.ioSerialiser.updateDataEndMarker((WireDataFieldDescription)endMarker);
        if (dataSet == null) {
            return builder.build();
        }
        return dataSet.set(builder.build(), false);
    }

    public DataSetSerialiser setDataLablesSerialised(boolean state) {
        this.transmitDataLabels = state;
        return this;
    }

    public DataSetSerialiser setMetaDataSerialised(boolean state) {
        this.transmitMetaData = state;
        return this;
    }

    public void write(DataSet dataSet, boolean asFloat) {
        AssertUtils.notNull((String)"dataSet", (Object)dataSet);
        AssertUtils.notNull((String)"ioSerialiser", (Object)this.ioSerialiser);
        String dataStartMarkerName = "START_MARKER_DATASET:" + dataSet.getName();
        WireDataFieldDescription dataStartMarker = new WireDataFieldDescription(this.ioSerialiser, null, dataStartMarkerName.hashCode(), dataStartMarkerName, DataType.OTHER, -1, -1, -1);
        this.ioSerialiser.putStartMarker(dataStartMarker);
        this.writeHeaderDataToStream(dataSet);
        if (this.isMetaDataSerialised()) {
            this.writeMetaDataToStream(dataSet);
        }
        if (this.isDataLablesSerialised()) {
            this.writeDataLabelsToStream(dataSet);
        }
        if (asFloat) {
            this.writeNumericBinaryDataToBufferFloat(dataSet);
        } else {
            this.writeNumericBinaryDataToBufferDouble(dataSet);
        }
        String dataEndMarkerName = "END_MARKER_DATASET:" + dataSet.getName();
        WireDataFieldDescription dataEndMarker = new WireDataFieldDescription(this.ioSerialiser, null, dataEndMarkerName.hashCode(), dataEndMarkerName, DataType.START_MARKER, -1, -1, -1);
        this.ioSerialiser.putEndMarker(dataEndMarker);
    }

    protected FieldDescription checkFieldCompatibility(FieldDescription rootField, int fieldNameHashCode, String fieldName, DataType ... requireDataTypes) {
        FieldDescription fieldHeader = rootField.findChildField(fieldNameHashCode, fieldName);
        if (fieldHeader == null) {
            return null;
        }
        boolean foundMatchingDataType = false;
        for (DataType dataType : requireDataTypes) {
            if (!fieldHeader.getDataType().equals((Object)dataType)) continue;
            foundMatchingDataType = true;
            break;
        }
        if (!foundMatchingDataType) {
            throw new InputMismatchException(fieldName + " is type " + fieldHeader.getDataType() + " vs. required type " + Arrays.asList(requireDataTypes).toString());
        }
        this.ioSerialiser.getBuffer().position(fieldHeader.getDataStartPosition());
        return fieldHeader;
    }

    protected static int getDimIndex(String fieldName, String prefix) {
        try {
            return Integer.parseInt(fieldName.substring(prefix.length()));
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            LOGGER.atWarn().addArgument((Object)fieldName).log("Invalid field name: {}");
            return -1;
        }
    }

    protected static double[] getDoubleArray(IoSerialiser ioSerialiser, double[] origArray, DataType dataType) {
        switch (dataType) {
            case BOOL_ARRAY: {
                return GenericsHelper.toDoublePrimitive((boolean[])ioSerialiser.getBooleanArray());
            }
            case BYTE_ARRAY: {
                return GenericsHelper.toDoublePrimitive((byte[])ioSerialiser.getByteArray());
            }
            case SHORT_ARRAY: {
                return GenericsHelper.toDoublePrimitive((short[])ioSerialiser.getShortArray());
            }
            case INT_ARRAY: {
                return GenericsHelper.toDoublePrimitive((int[])ioSerialiser.getIntArray());
            }
            case LONG_ARRAY: {
                return GenericsHelper.toDoublePrimitive((long[])ioSerialiser.getLongArray());
            }
            case FLOAT_ARRAY: {
                return GenericsHelper.toDoublePrimitive((float[])ioSerialiser.getFloatArray());
            }
            case DOUBLE_ARRAY: {
                return ioSerialiser.getDoubleArray(origArray);
            }
            case CHAR_ARRAY: {
                return GenericsHelper.toDoublePrimitive((char[])ioSerialiser.getCharArray());
            }
            case STRING_ARRAY: {
                return GenericsHelper.toDoublePrimitive((String[])ioSerialiser.getStringArray());
            }
        }
        throw new IllegalArgumentException("dataType '" + dataType + "' is not an array");
    }

    protected void parseDataLabels(DataSetBuilder builder, FieldDescription fieldRoot) {
        Map map;
        if (this.checkFieldCompatibility(fieldRoot, DATA_LABELS.hashCode(), DATA_LABELS, DataType.MAP) != null) {
            map = new HashMap();
            map = this.ioSerialiser.getMap(map);
            builder.setDataLabelMap(map);
        }
        if (this.checkFieldCompatibility(fieldRoot, DATA_STYLES.hashCode(), DATA_STYLES, DataType.MAP) != null) {
            map = new HashMap();
            map = this.ioSerialiser.getMap(map);
            builder.setDataStyleMap(map);
        }
    }

    protected void parseHeaders(IoSerialiser ioSerialiser, DataSetBuilder builder, FieldDescription fieldRoot) {
        if (this.checkFieldCompatibility(fieldRoot, DATA_SET_NAME.hashCode(), DATA_SET_NAME, DataType.STRING) != null) {
            builder.setName(ioSerialiser.getBuffer().getString());
        }
        if (this.checkFieldCompatibility(fieldRoot, DIMENSIONS.hashCode(), DIMENSIONS, DataType.INT) != null) {
            builder.setDimension(ioSerialiser.getBuffer().getInt());
        }
        for (FieldDescription fieldDescription : fieldRoot.getChildren()) {
            this.parseHeader(ioSerialiser, builder, fieldDescription);
        }
    }

    protected void parseMetaData(IoSerialiser ioSerialiser, DataSetBuilder builder, FieldDescription rootField) {
        if (this.checkFieldCompatibility(rootField, INFO_LIST.hashCode(), INFO_LIST, DataType.STRING_ARRAY) != null) {
            builder.setMetaInfoList(ioSerialiser.getStringArray());
        }
        if (this.checkFieldCompatibility(rootField, WARNING_LIST.hashCode(), WARNING_LIST, DataType.STRING_ARRAY) != null) {
            builder.setMetaWarningList(ioSerialiser.getStringArray());
        }
        if (this.checkFieldCompatibility(rootField, ERROR_LIST.hashCode(), ERROR_LIST, DataType.STRING_ARRAY) != null) {
            builder.setMetaErrorList(ioSerialiser.getStringArray());
        }
        if (this.checkFieldCompatibility(rootField, META_INFO.hashCode(), META_INFO, DataType.MAP) != null) {
            Map map = new HashMap();
            map = ioSerialiser.getMap(map);
            builder.setMetaInfoMap(map);
        }
    }

    protected void parseNumericData(IoSerialiser ioSerialiser, DataSetBuilder builder, DataSet origDataSet, FieldDescription rootField) {
        for (FieldDescription fieldDescription : rootField.getChildren()) {
            String fieldName = fieldDescription.getFieldName();
            if (fieldName == null || fieldDescription.getDataType() != DataType.DOUBLE_ARRAY && fieldDescription.getDataType() != DataType.FLOAT_ARRAY) continue;
            if (fieldName.startsWith(ARRAY_PREFIX)) {
                this.readValues(ioSerialiser, builder, origDataSet, fieldDescription, fieldName);
                continue;
            }
            if (fieldName.startsWith(EP_PREFIX)) {
                this.readPosError(ioSerialiser, builder, origDataSet, fieldDescription, fieldName);
                continue;
            }
            if (!fieldName.startsWith(EN_PREFIX)) continue;
            this.readNegError(ioSerialiser, builder, origDataSet, fieldDescription, fieldName);
        }
    }

    protected void writeDataLabelsToStream(DataSet dataSet) {
        if (dataSet instanceof AbstractDataSet) {
            StringHashMapList styleMap;
            StringHashMapList labelMap = ((AbstractDataSet)dataSet).getDataLabelMap();
            if (!labelMap.isEmpty()) {
                this.ioSerialiser.put(DATA_LABELS, labelMap, (Type)((Object)Integer.class), (Type)((Object)String.class));
            }
            if (!(styleMap = ((AbstractDataSet)dataSet).getDataStyleMap()).isEmpty()) {
                this.ioSerialiser.put(DATA_STYLES, styleMap, (Type)((Object)Integer.class), (Type)((Object)String.class));
            }
            return;
        }
        int dataCount = dataSet.getDataCount();
        HashMap<Integer, String> labelMap = new HashMap<Integer, String>();
        for (int index = 0; index < dataCount; ++index) {
            String label = dataSet.getDataLabel(index);
            if (label == null || label.isEmpty()) continue;
            labelMap.put(index, label);
        }
        if (!labelMap.isEmpty()) {
            this.ioSerialiser.put(DATA_LABELS, labelMap, (Type)((Object)Integer.class), (Type)((Object)String.class));
        }
        HashMap<Integer, String> styleMap = new HashMap<Integer, String>();
        for (int index = 0; index < dataCount; ++index) {
            String style = dataSet.getStyle(index);
            if (style == null || style.isEmpty()) continue;
            styleMap.put(index, style);
        }
        if (!styleMap.isEmpty()) {
            this.ioSerialiser.put(DATA_STYLES, styleMap, (Type)((Object)Integer.class), (Type)((Object)String.class));
        }
    }

    protected void writeHeaderDataToStream(DataSet dataSet) {
        this.ioSerialiser.put(DATA_SET_NAME, dataSet.getName());
        this.ioSerialiser.put(DIMENSIONS, dataSet.getDimension());
        List axisDescriptions = dataSet.getAxisDescriptions();
        StringBuilder builder = new StringBuilder(60);
        for (int i = 0; i < axisDescriptions.size(); ++i) {
            builder.setLength(0);
            String prefix = builder.append(AXIS).append(i).append('.').toString();
            builder.setLength(0);
            String name = builder.append(prefix).append(NAME).toString();
            builder.setLength(0);
            String unit = builder.append(prefix).append(UNIT).toString();
            builder.setLength(0);
            String minName = builder.append(prefix).append(MIN).toString();
            builder.setLength(0);
            String maxName = builder.append(prefix).append(MAX).toString();
            this.ioSerialiser.put(name, dataSet.getAxisDescription(i).getName());
            this.ioSerialiser.put(unit, dataSet.getAxisDescription(i).getUnit());
            this.ioSerialiser.put(minName, dataSet.getAxisDescription(i).getMin());
            this.ioSerialiser.put(maxName, dataSet.getAxisDescription(i).getMax());
        }
    }

    protected void writeMetaDataToStream(DataSet dataSet) {
        if (!(dataSet instanceof DataSetMetaData)) {
            return;
        }
        DataSetMetaData metaDataSet = (DataSetMetaData)dataSet;
        this.ioSerialiser.put(INFO_LIST, metaDataSet.getInfoList().toArray(new String[0]));
        this.ioSerialiser.put(WARNING_LIST, metaDataSet.getWarningList().toArray(new String[0]));
        this.ioSerialiser.put(ERROR_LIST, metaDataSet.getErrorList().toArray(new String[0]));
        this.ioSerialiser.put(META_INFO, metaDataSet.getMetaInfo(), (Type)((Object)String.class), (Type)((Object)String.class));
    }

    protected void writeNumericBinaryDataToBufferDouble(DataSet dataSet) {
        int nDim = dataSet.getDimension();
        if (dataSet instanceof GridDataSet) {
            GridDataSet gridDataSet = (GridDataSet)dataSet;
            for (int dimIndex = 0; dimIndex < nDim; ++dimIndex) {
                boolean gridDimension = dimIndex < gridDataSet.getNGrid();
                int nsamples = gridDimension ? gridDataSet.getShape(dimIndex) : dataSet.getDataCount();
                double[] values = gridDimension ? gridDataSet.getGridValues(dimIndex) : dataSet.getValues(dimIndex);
                this.ioSerialiser.put(ARRAY_PREFIX + dimIndex, values, nsamples);
            }
            return;
        }
        for (int dimIndex = 0; dimIndex < nDim; ++dimIndex) {
            int nsamples = dataSet.getDataCount();
            this.ioSerialiser.put(ARRAY_PREFIX + dimIndex, dataSet.getValues(dimIndex), nsamples);
        }
        if (!(dataSet instanceof DataSetError)) {
            return;
        }
        DataSetError ds = (DataSetError)dataSet;
        block6: for (int dimIndex = 0; dimIndex < nDim; ++dimIndex) {
            int nsamples = dataSet.getDataCount();
            switch (ds.getErrorType(dimIndex)) {
                case SYMMETRIC: {
                    this.ioSerialiser.put(EP_PREFIX + dimIndex, ds.getErrorsPositive(dimIndex), nsamples);
                    continue block6;
                }
                case ASYMMETRIC: {
                    this.ioSerialiser.put(EN_PREFIX + dimIndex, ds.getErrorsNegative(dimIndex), nsamples);
                    this.ioSerialiser.put(EP_PREFIX + dimIndex, ds.getErrorsPositive(dimIndex), nsamples);
                    continue block6;
                }
            }
        }
    }

    protected void writeNumericBinaryDataToBufferFloat(DataSet dataSet) {
        int nDim = dataSet.getDimension();
        if (dataSet instanceof GridDataSet) {
            GridDataSet gridDataSet = (GridDataSet)dataSet;
            for (int dimIndex = 0; dimIndex < nDim; ++dimIndex) {
                boolean gridDimension = dimIndex < gridDataSet.getNGrid();
                int nsamples = gridDimension ? gridDataSet.getShape(dimIndex) : dataSet.getDataCount();
                float[] values = MathUtils.toFloats((double[])(gridDimension ? gridDataSet.getGridValues(dimIndex) : dataSet.getValues(dimIndex)));
                this.ioSerialiser.put(ARRAY_PREFIX + dimIndex, values, nsamples);
            }
            return;
        }
        for (int dimIndex = 0; dimIndex < nDim; ++dimIndex) {
            int nsamples = dataSet.getDataCount();
            this.ioSerialiser.put(ARRAY_PREFIX + dimIndex, MathUtils.toFloats((double[])dataSet.getValues(dimIndex)), nsamples);
        }
        if (!(dataSet instanceof DataSetError)) {
            return;
        }
        DataSetError ds = (DataSetError)dataSet;
        block6: for (int dimIndex = 0; dimIndex < nDim; ++dimIndex) {
            int nsamples = dataSet.getDataCount();
            switch (ds.getErrorType(dimIndex)) {
                default: {
                    continue block6;
                }
                case SYMMETRIC: {
                    this.ioSerialiser.put(EP_PREFIX + dimIndex, MathUtils.toFloats((double[])ds.getErrorsPositive(dimIndex)), nsamples);
                    continue block6;
                }
                case ASYMMETRIC: {
                    this.ioSerialiser.put(EN_PREFIX + dimIndex, MathUtils.toFloats((double[])ds.getErrorsNegative(dimIndex)), nsamples);
                    this.ioSerialiser.put(EP_PREFIX + dimIndex, MathUtils.toFloats((double[])ds.getErrorsPositive(dimIndex)), nsamples);
                }
            }
        }
    }

    private void parseHeader(IoSerialiser ioSerialiser, DataSetBuilder builder, FieldDescription fieldDescription) {
        String fieldName = fieldDescription.getFieldName();
        if (fieldName == null || !fieldName.startsWith(AXIS)) {
            return;
        }
        String[] parsed = fieldName.split("\\.");
        if (parsed.length <= 1) {
            return;
        }
        int dimension = DataSetSerialiser.getDimIndex(parsed[0], AXIS);
        if (dimension < 0) {
            return;
        }
        ioSerialiser.getBuffer().position(fieldDescription.getDataStartPosition());
        switch (parsed[1]) {
            case "Min": {
                builder.setAxisMin(dimension, ioSerialiser.getBuffer().getDouble());
                break;
            }
            case "Max": {
                builder.setAxisMax(dimension, ioSerialiser.getBuffer().getDouble());
                break;
            }
            case "name": {
                builder.setAxisName(dimension, ioSerialiser.getBuffer().getString());
                break;
            }
            case "unit": {
                builder.setAxisUnit(dimension, ioSerialiser.getBuffer().getString());
                break;
            }
            default: {
                LOGGER.atWarn().addArgument((Object)parsed[1]).log("parseHeader(): encountered unknown tag {} - ignore");
            }
        }
    }

    private void readNegError(IoSerialiser ioSerialiser, DataSetBuilder builder, DataSet origDataSet, FieldDescription fieldDescription, String fieldName) {
        int dimIndex = DataSetSerialiser.getDimIndex(fieldName, EN_PREFIX);
        if (dimIndex >= 0) {
            ioSerialiser.getBuffer().position(fieldDescription.getDataStartPosition());
            double[] origErrorArray = origDataSet instanceof DataSetError ? ((DataSetError)origDataSet).getErrorsNegative(dimIndex) : null;
            builder.setNegErrorNoCopy(dimIndex, DataSetSerialiser.getDoubleArray(ioSerialiser, origErrorArray, fieldDescription.getDataType()));
        }
    }

    private void readPosError(IoSerialiser ioSerialiser, DataSetBuilder builder, DataSet origDataSet, FieldDescription fieldDescription, String fieldName) {
        int dimIndex = DataSetSerialiser.getDimIndex(fieldName, EP_PREFIX);
        if (dimIndex >= 0) {
            ioSerialiser.getBuffer().position(fieldDescription.getDataStartPosition());
            double[] origErrorArray = origDataSet instanceof DataSetError ? ((DataSetError)origDataSet).getErrorsPositive(dimIndex) : null;
            builder.setPosErrorNoCopy(dimIndex, DataSetSerialiser.getDoubleArray(ioSerialiser, origErrorArray, fieldDescription.getDataType()));
        }
    }

    private void readValues(IoSerialiser ioSerialiser, DataSetBuilder builder, DataSet origDataSet, FieldDescription fieldDescription, String fieldName) {
        int dimIndex = DataSetSerialiser.getDimIndex(fieldName, ARRAY_PREFIX);
        if (dimIndex >= 0) {
            ioSerialiser.getBuffer().position(fieldDescription.getDataStartPosition());
            builder.setValuesNoCopy(dimIndex, DataSetSerialiser.getDoubleArray(ioSerialiser, origDataSet == null ? null : origDataSet.getValues(dimIndex), fieldDescription.getDataType()));
        }
    }

    public static DataSetSerialiser withIoSerialiser(IoSerialiser ioSerialiser) {
        return new DataSetSerialiser(ioSerialiser);
    }
}

