/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.serializer.spi;

import de.gsi.serializer.DataType;
import de.gsi.serializer.FieldDescription;
import de.gsi.serializer.FieldSerialiser;
import de.gsi.serializer.IoBuffer;
import de.gsi.serializer.IoSerialiser;
import de.gsi.serializer.spi.ProtocolInfo;
import de.gsi.serializer.spi.WireDataFieldDescription;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmwLightSerialiser
implements IoSerialiser {
    public static final String NOT_IMPLEMENTED = "not implemented";
    private static final Logger LOGGER = LoggerFactory.getLogger(CmwLightSerialiser.class);
    private static final int ADDITIONAL_HEADER_INFO_SIZE = 1000;
    private static final DataType[] byteToDataType = new DataType[256];
    private static final Byte[] dataTypeToByte = new Byte[256];
    private int bufferIncrements = 1000;
    private IoBuffer buffer;
    private WireDataFieldDescription parent;
    private WireDataFieldDescription lastFieldHeader;
    private BiFunction<Type, Type[], FieldSerialiser<Object>> fieldSerialiserLookupFunction;

    public CmwLightSerialiser(IoBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public ProtocolInfo checkHeaderInfo() {
        String fieldName = "";
        int dataSize = 4;
        WireDataFieldDescription headerStartField = new WireDataFieldDescription(this, this.parent, "".hashCode(), "", DataType.START_MARKER, this.buffer.position(), this.buffer.position(), 4);
        int nEntries = this.buffer.getInt();
        if (nEntries <= 0) {
            throw new IllegalStateException("nEntries = " + nEntries + " <= 0!");
        }
        this.parent = this.lastFieldHeader = headerStartField;
        return new ProtocolInfo(this, headerStartField, CmwLightSerialiser.class.getCanonicalName(), 1, 0, 1);
    }

    @Override
    public int[] getArraySizeDescriptor() {
        int nDims = this.buffer.getInt();
        int[] ret = new int[nDims];
        for (int i = 0; i < nDims; ++i) {
            ret[i] = this.buffer.getInt();
        }
        return ret;
    }

    @Override
    public boolean getBoolean() {
        return this.buffer.getBoolean();
    }

    @Override
    public boolean[] getBooleanArray(boolean[] dst, int length) {
        this.getArraySizeDescriptor();
        return this.buffer.getBooleanArray(dst, length);
    }

    @Override
    public IoBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public void setBuffer(IoBuffer buffer) {
        this.buffer = buffer;
    }

    public int getBufferIncrements() {
        return this.bufferIncrements;
    }

    @Override
    public byte getByte() {
        return this.buffer.getByte();
    }

    @Override
    public byte[] getByteArray(byte[] dst, int length) {
        this.getArraySizeDescriptor();
        return this.buffer.getByteArray(dst, length);
    }

    @Override
    public char getChar() {
        return this.buffer.getChar();
    }

    @Override
    public char[] getCharArray(char[] dst, int length) {
        this.getArraySizeDescriptor();
        return this.buffer.getCharArray(dst, length);
    }

    @Override
    public <E> Collection<E> getCollection(Collection<E> collection) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    @Override
    public <E> E getCustomData(FieldSerialiser<E> serialiser) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    @Override
    public double getDouble() {
        return this.buffer.getDouble();
    }

    @Override
    public double[] getDoubleArray(double[] dst, int length) {
        this.getArraySizeDescriptor();
        return this.buffer.getDoubleArray(dst, length);
    }

    @Override
    public <E extends Enum<E>> Enum<E> getEnum(Enum<E> enumeration) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    @Override
    public String getEnumTypeList() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    @Override
    public WireDataFieldDescription getFieldHeader() {
        int[] dims;
        int dataSize;
        int headerStart = this.buffer.position();
        String fieldName = this.buffer.getStringISO8859();
        byte dataTypeByte = this.buffer.getByte();
        DataType dataType = CmwLightSerialiser.getDataType(dataTypeByte);
        int dataStartOffset = this.buffer.position() - headerStart;
        int dataStartPosition = headerStart + dataStartOffset;
        if (dataType == DataType.START_MARKER) {
            dataSize = 4;
        } else if (dataType.isScalar()) {
            dataSize = dataType.getPrimitiveSize();
        } else if (dataType == DataType.STRING) {
            dataSize = 4 + this.buffer.getInt();
        } else if (dataType.isArray() && dataType != DataType.STRING_ARRAY) {
            dims = this.getArraySizeDescriptor();
            int arraySize = this.buffer.getInt();
            dataSize = 4 * (dims.length + 2) + arraySize * dataType.getPrimitiveSize();
        } else if (dataType == DataType.STRING_ARRAY) {
            dims = this.getArraySizeDescriptor();
            int arraySize = this.buffer.getInt();
            int totalSize = 4 * arraySize;
            for (int i = 0; i < arraySize; ++i) {
                int stringSize = this.buffer.getInt();
                totalSize += stringSize;
                this.buffer.position(this.buffer.position() + stringSize);
            }
            dataSize = 4 * (dims.length + 2) + totalSize;
        } else {
            throw new IllegalStateException("should not reach here -- format is incompatible with CMW");
        }
        int fieldNameHashCode = fieldName.hashCode();
        this.lastFieldHeader = new WireDataFieldDescription(this, this.parent, fieldNameHashCode, fieldName, dataType, headerStart, dataStartOffset, dataSize);
        this.buffer.position(dataStartPosition);
        if (dataType == DataType.START_MARKER) {
            this.parent = this.lastFieldHeader;
            this.buffer.position(dataStartPosition);
            this.buffer.position(dataStartPosition + dataSize);
        }
        if (dataSize < 0) {
            throw new IllegalStateException("should not reach here -- format is incompatible with CMW");
        }
        return this.lastFieldHeader;
    }

    @Override
    public float getFloat() {
        return this.buffer.getFloat();
    }

    @Override
    public float[] getFloatArray(float[] dst, int length) {
        this.getArraySizeDescriptor();
        return this.buffer.getFloatArray(dst, length);
    }

    @Override
    public int getInt() {
        return this.buffer.getInt();
    }

    @Override
    public int[] getIntArray(int[] dst, int length) {
        this.getArraySizeDescriptor();
        return this.buffer.getIntArray(dst, length);
    }

    @Override
    public <E> List<E> getList(List<E> collection) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    @Override
    public long getLong() {
        return this.buffer.getLong();
    }

    @Override
    public long[] getLongArray(long[] dst, int length) {
        this.getArraySizeDescriptor();
        return this.buffer.getLongArray(dst, length);
    }

    @Override
    public <K, V, E> Map<K, V> getMap(Map<K, V> map) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    public WireDataFieldDescription getParent() {
        return this.parent;
    }

    @Override
    public <E> Queue<E> getQueue(Queue<E> collection) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    @Override
    public <E> Set<E> getSet(Set<E> collection) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    @Override
    public short getShort() {
        return this.buffer.getShort();
    }

    @Override
    public short[] getShortArray(short[] dst, int length) {
        this.getArraySizeDescriptor();
        return this.buffer.getShortArray(dst, length);
    }

    @Override
    public String getString() {
        return this.buffer.getString();
    }

    @Override
    public String[] getStringArray(String[] dst, int length) {
        this.getArraySizeDescriptor();
        return this.buffer.getStringArray(dst, length);
    }

    @Override
    public String getStringISO8859() {
        return this.buffer.getStringISO8859();
    }

    public boolean isEnforceSimpleStringEncoding() {
        return this.buffer.isEnforceSimpleStringEncoding();
    }

    public void setEnforceSimpleStringEncoding(boolean state) {
        this.buffer.setEnforceSimpleStringEncoding(state);
    }

    @Override
    public boolean isPutFieldMetaData() {
        return false;
    }

    @Override
    public void setPutFieldMetaData(boolean putFieldMetaData) {
    }

    @Override
    public WireDataFieldDescription parseIoStream(boolean readHeader) {
        WireDataFieldDescription fieldRoot;
        this.parent = fieldRoot = this.getRootElement();
        WireDataFieldDescription headerRoot = readHeader ? this.checkHeaderInfo().getFieldHeader() : this.getFieldHeader();
        this.buffer.position(headerRoot.getDataStartPosition() + headerRoot.getDataSize());
        this.parseIoStream(headerRoot, 0);
        return fieldRoot;
    }

    public void parseIoStream(WireDataFieldDescription fieldRoot, int recursionDepth) {
        if (fieldRoot == null || fieldRoot.getDataType() != DataType.START_MARKER) {
            throw new IllegalStateException("fieldRoot not a START_MARKER but: " + fieldRoot);
        }
        this.buffer.position(fieldRoot.getDataStartPosition());
        int nEntries = this.buffer.getInt();
        if (nEntries < 0) {
            throw new IllegalStateException("nEntries = " + nEntries + " < 0!");
        }
        this.parent = this.lastFieldHeader = fieldRoot;
        for (int i = 0; i < nEntries; ++i) {
            WireDataFieldDescription field = this.getFieldHeader();
            int dataSize = field.getDataSize();
            int skipPosition = field.getDataStartPosition() + dataSize;
            if (field.getDataType() == DataType.START_MARKER) {
                this.parent = this.lastFieldHeader = field;
                this.parseIoStream(field, recursionDepth + 1);
                this.parent = this.lastFieldHeader = fieldRoot;
                continue;
            }
            if (dataSize < 0) {
                LOGGER.atWarn().addArgument((Object)field.getFieldName()).addArgument((Object)field.getDataType()).addArgument((Object)dataSize).log("WireDataFieldDescription for '{}' type '{}' has bytesToSkip '{} <= 0'");
                throw new IllegalStateException();
            }
            if (skipPosition < this.buffer.capacity()) {
                this.buffer.position(skipPosition);
                continue;
            }
            if (skipPosition == this.buffer.capacity()) {
                return;
            }
            throw new IllegalStateException("reached beyond end of buffer at " + skipPosition + " vs. capacity" + this.buffer.capacity() + " " + field);
        }
    }

    @Override
    public <E> void put(FieldDescription fieldDescription, Collection<E> collection, Type valueType) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    @Override
    public void put(FieldDescription fieldDescription, Enum<?> enumeration) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    @Override
    public <K, V, E> void put(FieldDescription fieldDescription, Map<K, V> map, Type keyType, Type valueType) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    @Override
    public void put(FieldDescription fieldDescription, boolean value) {
        this.putFieldHeader(fieldDescription, DataType.BOOL);
        this.buffer.putBoolean(value);
    }

    @Override
    public void put(FieldDescription fieldDescription, boolean[] values, int n) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription, DataType.BOOL_ARRAY);
        int valuesSize = values == null ? 0 : values.length;
        int bytesToCopy = this.putArraySizeDescriptor(n >= 0 ? Math.min(n, valuesSize) : valuesSize);
        this.buffer.putBooleanArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, boolean[] values, int[] dims) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription, DataType.BOOL_ARRAY);
        int bytesToCopy = this.putArraySizeDescriptor(dims);
        this.buffer.putBooleanArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, byte value) {
        this.putFieldHeader(fieldDescription, DataType.BYTE);
        this.buffer.putByte(value);
    }

    @Override
    public void put(FieldDescription fieldDescription, byte[] values, int n) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription, DataType.BYTE_ARRAY);
        int valuesSize = values == null ? 0 : values.length;
        int bytesToCopy = this.putArraySizeDescriptor(n >= 0 ? Math.min(n, valuesSize) : valuesSize);
        this.buffer.putByteArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, byte[] values, int[] dims) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription, DataType.BYTE_ARRAY);
        int bytesToCopy = this.putArraySizeDescriptor(dims);
        this.buffer.putByteArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, char value) {
        this.putFieldHeader(fieldDescription, DataType.CHAR);
        this.buffer.putChar(value);
    }

    @Override
    public void put(FieldDescription fieldDescription, char[] values, int n) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription, DataType.CHAR_ARRAY);
        int valuesSize = values == null ? 0 : values.length;
        int bytesToCopy = this.putArraySizeDescriptor(n >= 0 ? Math.min(n, valuesSize) : valuesSize);
        this.buffer.putCharArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, char[] values, int[] dims) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription, DataType.CHAR_ARRAY);
        int bytesToCopy = this.putArraySizeDescriptor(dims);
        this.buffer.putCharArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, double value) {
        this.putFieldHeader(fieldDescription, DataType.DOUBLE);
        this.buffer.putDouble(value);
    }

    @Override
    public void put(FieldDescription fieldDescription, double[] values, int n) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription, DataType.DOUBLE_ARRAY);
        int valuesSize = values == null ? 0 : values.length;
        int bytesToCopy = this.putArraySizeDescriptor(n >= 0 ? Math.min(n, valuesSize) : valuesSize);
        this.buffer.putDoubleArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, double[] values, int[] dims) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription, DataType.DOUBLE_ARRAY);
        int bytesToCopy = this.putArraySizeDescriptor(dims);
        this.buffer.putDoubleArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, float value) {
        this.putFieldHeader(fieldDescription, DataType.FLOAT);
        this.buffer.putFloat(value);
    }

    @Override
    public void put(FieldDescription fieldDescription, float[] values, int n) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription, DataType.FLOAT_ARRAY);
        int valuesSize = values == null ? 0 : values.length;
        int bytesToCopy = this.putArraySizeDescriptor(n >= 0 ? Math.min(n, valuesSize) : valuesSize);
        this.buffer.putFloatArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, float[] values, int[] dims) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription, DataType.FLOAT_ARRAY);
        int bytesToCopy = this.putArraySizeDescriptor(dims);
        this.buffer.putFloatArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, int value) {
        this.putFieldHeader(fieldDescription, DataType.INT);
        this.buffer.putInt(value);
    }

    @Override
    public void put(FieldDescription fieldDescription, int[] values, int n) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription, DataType.INT_ARRAY);
        int valuesSize = values == null ? 0 : values.length;
        int bytesToCopy = this.putArraySizeDescriptor(n >= 0 ? Math.min(n, valuesSize) : valuesSize);
        this.buffer.putIntArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, int[] values, int[] dims) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription, DataType.INT_ARRAY);
        int bytesToCopy = this.putArraySizeDescriptor(dims);
        this.buffer.putIntArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, long value) {
        this.putFieldHeader(fieldDescription, DataType.LONG);
        this.buffer.putLong(value);
    }

    @Override
    public void put(FieldDescription fieldDescription, long[] values, int n) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription, DataType.LONG_ARRAY);
        int valuesSize = values == null ? 0 : values.length;
        int bytesToCopy = this.putArraySizeDescriptor(n >= 0 ? Math.min(n, valuesSize) : valuesSize);
        this.buffer.putLongArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, long[] values, int[] dims) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription, DataType.LONG_ARRAY);
        int bytesToCopy = this.putArraySizeDescriptor(dims);
        this.buffer.putLongArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, short value) {
        this.putFieldHeader(fieldDescription, DataType.SHORT);
        this.buffer.putShort(value);
    }

    @Override
    public void put(FieldDescription fieldDescription, short[] values, int n) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription, DataType.SHORT_ARRAY);
        int valuesSize = values == null ? 0 : values.length;
        int bytesToCopy = this.putArraySizeDescriptor(n >= 0 ? Math.min(n, valuesSize) : valuesSize);
        this.buffer.putShortArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, short[] values, int[] dims) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription, DataType.SHORT_ARRAY);
        int bytesToCopy = this.putArraySizeDescriptor(dims);
        this.buffer.putShortArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, String string) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription, DataType.STRING);
        this.buffer.putString(string);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, String[] values, int n) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription, DataType.STRING_ARRAY);
        int valuesSize = values == null ? 0 : values.length;
        int nElements = n >= 0 ? Math.min(n, valuesSize) : valuesSize;
        this.putArraySizeDescriptor(nElements);
        this.buffer.putStringArray(values, nElements);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(FieldDescription fieldDescription, String[] values, int[] dims) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldDescription, DataType.STRING_ARRAY);
        int nElements = this.putArraySizeDescriptor(dims);
        this.putArraySizeDescriptor(nElements);
        this.buffer.putStringArray(values, nElements);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, boolean value) {
        this.putFieldHeader(fieldName, DataType.BOOL);
        this.buffer.putBoolean(value);
    }

    @Override
    public void put(String fieldName, boolean[] values, int n) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.BOOL_ARRAY);
        int valuesSize = values == null ? 0 : values.length;
        int bytesToCopy = this.putArraySizeDescriptor(n >= 0 ? Math.min(n, valuesSize) : valuesSize);
        this.buffer.putBooleanArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, boolean[] values, int[] dims) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.BOOL_ARRAY);
        if (dims.length == 2) {
            this.buffer.putByte(fieldHeader.getDataStartPosition() - 1, (byte)17);
        } else if (dims.length > 2) {
            this.buffer.putByte(fieldHeader.getDataStartPosition() - 1, (byte)25);
        }
        int bytesToCopy = this.putArraySizeDescriptor(dims);
        this.buffer.putBooleanArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, byte value) {
        this.putFieldHeader(fieldName, DataType.BYTE);
        this.buffer.putByte(value);
    }

    @Override
    public void put(String fieldName, byte[] values, int n) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.BYTE_ARRAY);
        int valuesSize = values == null ? 0 : values.length;
        int bytesToCopy = this.putArraySizeDescriptor(n >= 0 ? Math.min(n, valuesSize) : valuesSize);
        this.buffer.putByteArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, byte[] values, int[] dims) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.BYTE_ARRAY);
        if (dims.length == 2) {
            this.buffer.putByte(fieldHeader.getDataStartPosition() - 1, (byte)18);
        } else if (dims.length > 2) {
            this.buffer.putByte(fieldHeader.getDataStartPosition() - 1, (byte)26);
        }
        int bytesToCopy = this.putArraySizeDescriptor(dims);
        this.buffer.putByteArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, char value) {
        this.putFieldHeader(fieldName, DataType.CHAR);
        this.buffer.putChar(value);
    }

    @Override
    public void put(String fieldName, char[] values, int n) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.CHAR_ARRAY);
        int valuesSize = values == null ? 0 : values.length;
        int bytesToCopy = this.putArraySizeDescriptor(n >= 0 ? Math.min(n, valuesSize) : valuesSize);
        this.buffer.putCharArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, char[] values, int[] dims) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.CHAR_ARRAY);
        if (dims.length == 2) {
            this.buffer.putByte(fieldHeader.getDataStartPosition() - 1, (byte)-53);
        } else if (dims.length > 2) {
            this.buffer.putByte(fieldHeader.getDataStartPosition() - 1, (byte)-52);
        }
        int bytesToCopy = this.putArraySizeDescriptor(dims);
        this.buffer.putCharArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, double value) {
        this.putFieldHeader(fieldName, DataType.DOUBLE);
        this.buffer.putDouble(value);
    }

    @Override
    public void put(String fieldName, double[] values, int n) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.DOUBLE_ARRAY);
        int valuesSize = values == null ? 0 : values.length;
        int bytesToCopy = this.putArraySizeDescriptor(n >= 0 ? Math.min(n, valuesSize) : valuesSize);
        this.buffer.putDoubleArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, double[] values, int[] dims) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.DOUBLE_ARRAY);
        if (dims.length == 2) {
            this.buffer.putByte(fieldHeader.getDataStartPosition() - 1, (byte)23);
        } else if (dims.length > 2) {
            this.buffer.putByte(fieldHeader.getDataStartPosition() - 1, (byte)31);
        }
        int bytesToCopy = this.putArraySizeDescriptor(dims);
        this.buffer.putDoubleArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, float value) {
        this.putFieldHeader(fieldName, DataType.FLOAT);
        this.buffer.putFloat(value);
    }

    @Override
    public void put(String fieldName, float[] values, int n) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.FLOAT_ARRAY);
        int valuesSize = values == null ? 0 : values.length;
        int bytesToCopy = this.putArraySizeDescriptor(n >= 0 ? Math.min(n, valuesSize) : valuesSize);
        this.buffer.putFloatArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, float[] values, int[] dims) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.FLOAT_ARRAY);
        if (dims.length == 2) {
            this.buffer.putByte(fieldHeader.getDataStartPosition() - 1, (byte)22);
        } else if (dims.length > 2) {
            this.buffer.putByte(fieldHeader.getDataStartPosition() - 1, (byte)30);
        }
        int bytesToCopy = this.putArraySizeDescriptor(dims);
        this.buffer.putFloatArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, int value) {
        this.putFieldHeader(fieldName, DataType.INT);
        this.buffer.putInt(value);
    }

    @Override
    public void put(String fieldName, int[] values, int n) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.INT_ARRAY);
        int valuesSize = values == null ? 0 : values.length;
        int bytesToCopy = this.putArraySizeDescriptor(n >= 0 ? Math.min(n, valuesSize) : valuesSize);
        this.buffer.putIntArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, int[] values, int[] dims) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.INT_ARRAY);
        if (dims.length == 2) {
            this.buffer.putByte(fieldHeader.getDataStartPosition() - 1, (byte)20);
        } else if (dims.length > 2) {
            this.buffer.putByte(fieldHeader.getDataStartPosition() - 1, (byte)28);
        }
        int bytesToCopy = this.putArraySizeDescriptor(dims);
        this.buffer.putIntArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, long value) {
        this.putFieldHeader(fieldName, DataType.LONG);
        this.buffer.putLong(value);
    }

    @Override
    public void put(String fieldName, long[] values, int n) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.LONG_ARRAY);
        int valuesSize = values == null ? 0 : values.length;
        int bytesToCopy = this.putArraySizeDescriptor(n >= 0 ? Math.min(n, valuesSize) : valuesSize);
        this.buffer.putLongArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, long[] values, int[] dims) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.LONG_ARRAY);
        if (dims.length == 2) {
            this.buffer.putByte(fieldHeader.getDataStartPosition() - 1, (byte)21);
        } else if (dims.length > 2) {
            this.buffer.putByte(fieldHeader.getDataStartPosition() - 1, (byte)29);
        }
        int bytesToCopy = this.putArraySizeDescriptor(dims);
        this.buffer.putLongArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, short value) {
        this.putFieldHeader(fieldName, DataType.SHORT);
        this.buffer.putShort(value);
    }

    @Override
    public void put(String fieldName, short[] values, int n) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.SHORT_ARRAY);
        int valuesSize = values == null ? 0 : values.length;
        int bytesToCopy = this.putArraySizeDescriptor(n >= 0 ? Math.min(n, valuesSize) : valuesSize);
        this.buffer.putShortArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, short[] values, int[] dims) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.SHORT_ARRAY);
        if (dims.length == 2) {
            this.buffer.putByte(fieldHeader.getDataStartPosition() - 1, (byte)19);
        } else if (dims.length > 2) {
            this.buffer.putByte(fieldHeader.getDataStartPosition() - 1, (byte)27);
        }
        int bytesToCopy = this.putArraySizeDescriptor(dims);
        this.buffer.putShortArray(values, bytesToCopy);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, String string) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.STRING);
        this.buffer.putString(string);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, String[] values, int n) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.STRING_ARRAY);
        int valuesSize = values == null ? 0 : values.length;
        int nElements = n >= 0 ? Math.min(n, valuesSize) : valuesSize;
        this.putArraySizeDescriptor(nElements);
        this.buffer.putStringArray(values, nElements);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, String[] values, int[] dims) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.STRING_ARRAY);
        if (dims.length == 2) {
            this.buffer.putByte(fieldHeader.getDataStartPosition() - 1, (byte)24);
        } else if (dims.length > 2) {
            this.buffer.putByte(fieldHeader.getDataStartPosition() - 1, (byte)32);
        }
        int nElements = this.putArraySizeDescriptor(dims);
        this.buffer.putStringArray(values, nElements);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public <E> void put(String fieldName, Collection<E> collection, Type valueType) {
        DataType dataType = collection instanceof Queue ? DataType.QUEUE : (collection instanceof Set ? DataType.SET : (collection instanceof List ? DataType.LIST : DataType.COLLECTION));
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, dataType);
        this.put((FieldDescription)null, collection, valueType);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public void put(String fieldName, Enum<?> enumeration) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.ENUM);
        this.put((FieldDescription)null, enumeration);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public <K, V, E> void put(String fieldName, Map<K, V> map, Type keyType, Type valueType) {
        WireDataFieldDescription fieldHeader = this.putFieldHeader(fieldName, DataType.MAP);
        this.put((FieldDescription)null, map, keyType, valueType);
        this.updateDataEndMarker(fieldHeader);
    }

    @Override
    public int putArraySizeDescriptor(int n) {
        this.buffer.putInt(1);
        this.buffer.putInt(n);
        return n;
    }

    @Override
    public int putArraySizeDescriptor(int[] dims) {
        this.buffer.putInt(dims.length);
        int nElements = 1;
        for (int dim : dims) {
            nElements *= dim;
            this.buffer.putInt(dim);
        }
        return nElements;
    }

    @Override
    public <E> WireDataFieldDescription putCustomData(FieldDescription fieldDescription, E rootObject, Class<? extends E> type, FieldSerialiser<E> serialiser) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED);
    }

    @Override
    public void putEndMarker(FieldDescription fieldDescription) {
        if (this.parent.getParent() != null) {
            this.parent = (WireDataFieldDescription)this.parent.getParent();
        }
    }

    @Override
    public WireDataFieldDescription putFieldHeader(FieldDescription fieldDescription) {
        return this.putFieldHeader(fieldDescription, fieldDescription.getDataType());
    }

    public WireDataFieldDescription putFieldHeader(FieldDescription fieldDescription, DataType customDataType) {
        int dataSize;
        boolean isScalar = customDataType.isScalar();
        int headerStart = this.buffer.position();
        String fieldName = fieldDescription.getFieldName();
        this.buffer.putStringISO8859(fieldName);
        this.buffer.putByte(CmwLightSerialiser.getDataType(customDataType));
        int dataStart = this.buffer.position();
        int dataStartOffset = dataStart - headerStart;
        if (isScalar) {
            dataSize = customDataType.getPrimitiveSize();
        } else if (customDataType == DataType.START_MARKER) {
            dataSize = 4;
            this.buffer.ensureAdditionalCapacity(dataSize);
        } else {
            dataSize = -1;
            this.buffer.ensureAdditionalCapacity(16);
        }
        this.lastFieldHeader = new WireDataFieldDescription(this, this.parent, fieldDescription.getFieldNameHashCode(), fieldDescription.getFieldName(), customDataType, headerStart, dataStartOffset, dataSize);
        this.updateDataEntryCount();
        return this.lastFieldHeader;
    }

    @Override
    public WireDataFieldDescription putFieldHeader(String fieldName, DataType dataType) {
        int dataSize;
        boolean isScalar = dataType.isScalar();
        int headerStart = this.buffer.position();
        this.buffer.putStringISO8859(fieldName);
        this.buffer.putByte(CmwLightSerialiser.getDataType(dataType));
        int dataStart = this.buffer.position();
        int dataStartOffset = dataStart - headerStart;
        if (isScalar) {
            dataSize = dataType.getPrimitiveSize();
        } else if (dataType == DataType.START_MARKER) {
            dataSize = 4;
            this.buffer.ensureAdditionalCapacity(dataSize);
        } else {
            dataSize = -1;
            this.buffer.ensureAdditionalCapacity(16);
        }
        int fieldNameHashCode = fieldName.hashCode();
        this.lastFieldHeader = new WireDataFieldDescription(this, this.parent, fieldNameHashCode, fieldName, dataType, headerStart, dataStartOffset, dataSize);
        this.updateDataEntryCount();
        return this.lastFieldHeader;
    }

    @Override
    public void putHeaderInfo(FieldDescription ... field) {
        this.parent = this.lastFieldHeader = this.getRootElement();
        String fieldName = "";
        int dataSize = 4;
        this.lastFieldHeader = new WireDataFieldDescription(this, this.parent, "".hashCode(), "", DataType.START_MARKER, this.buffer.position(), this.buffer.position(), 4);
        this.buffer.putInt(0);
        this.updateDataEntryCount();
        this.parent = this.lastFieldHeader;
    }

    @Override
    public void putStartMarker(FieldDescription fieldDescription) {
        this.putFieldHeader(fieldDescription, DataType.START_MARKER);
        this.buffer.putInt(0);
        this.updateDataEndMarker(this.lastFieldHeader);
        this.parent = this.lastFieldHeader;
    }

    @Override
    public void setQueryFieldName(String fieldName, int dataStartPosition) {
        if (fieldName == null || fieldName.isBlank()) {
            throw new IllegalArgumentException("fieldName must not be null or blank: " + fieldName);
        }
        this.buffer.position(dataStartPosition);
    }

    @Override
    public void updateDataEndMarker(WireDataFieldDescription fieldHeader) {
        int dataSize = this.buffer.position() - fieldHeader.getDataStartPosition();
        if (fieldHeader.getDataSize() != dataSize) {
            fieldHeader.setDataSize(dataSize);
        }
    }

    private WireDataFieldDescription getRootElement() {
        return new WireDataFieldDescription(this, null, "ROOT".hashCode(), "ROOT", DataType.OTHER, this.buffer.position(), -1, -1);
    }

    private void updateDataEntryCount() {
        if (this.parent == null) {
            throw new IllegalStateException("no parent");
        }
        int parentDataStart = this.parent.getDataStartPosition();
        if (parentDataStart >= 0) {
            this.buffer.position(parentDataStart);
            int nEntries = this.buffer.getInt();
            this.buffer.position(parentDataStart);
            this.buffer.putInt(nEntries + 1);
            this.buffer.position(this.lastFieldHeader.getDataStartPosition());
        }
    }

    public static byte getDataType(DataType dataType) {
        int id = dataType.getID();
        if (dataTypeToByte[id] != null) {
            return dataTypeToByte[id];
        }
        throw new IllegalArgumentException("DataType " + dataType + " not mapped to specific byte");
    }

    public static DataType getDataType(byte byteValue) {
        int id = byteValue & 0xFF;
        if (byteToDataType[id] != null) {
            return byteToDataType[id];
        }
        throw new IllegalArgumentException("DataType byteValue=" + byteValue + " rawByteValue=" + (byteValue & 0xFF) + " not mapped");
    }

    @Override
    public void setFieldSerialiserLookupFunction(BiFunction<Type, Type[], FieldSerialiser<Object>> serialiserLookupFunction) {
        this.fieldSerialiserLookupFunction = serialiserLookupFunction;
    }

    @Override
    public BiFunction<Type, Type[], FieldSerialiser<Object>> getSerialiserLookupFunction() {
        return this.fieldSerialiserLookupFunction;
    }

    static {
        CmwLightSerialiser.byteToDataType[0] = DataType.BOOL;
        CmwLightSerialiser.byteToDataType[1] = DataType.BYTE;
        CmwLightSerialiser.byteToDataType[2] = DataType.SHORT;
        CmwLightSerialiser.byteToDataType[3] = DataType.INT;
        CmwLightSerialiser.byteToDataType[4] = DataType.LONG;
        CmwLightSerialiser.byteToDataType[5] = DataType.FLOAT;
        CmwLightSerialiser.byteToDataType[6] = DataType.DOUBLE;
        CmwLightSerialiser.byteToDataType[201] = DataType.CHAR;
        CmwLightSerialiser.byteToDataType[7] = DataType.STRING;
        CmwLightSerialiser.byteToDataType[8] = DataType.START_MARKER;
        CmwLightSerialiser.byteToDataType[9] = DataType.BOOL_ARRAY;
        CmwLightSerialiser.byteToDataType[10] = DataType.BYTE_ARRAY;
        CmwLightSerialiser.byteToDataType[11] = DataType.SHORT_ARRAY;
        CmwLightSerialiser.byteToDataType[12] = DataType.INT_ARRAY;
        CmwLightSerialiser.byteToDataType[13] = DataType.LONG_ARRAY;
        CmwLightSerialiser.byteToDataType[14] = DataType.FLOAT_ARRAY;
        CmwLightSerialiser.byteToDataType[15] = DataType.DOUBLE_ARRAY;
        CmwLightSerialiser.byteToDataType[202] = DataType.CHAR_ARRAY;
        CmwLightSerialiser.byteToDataType[16] = DataType.STRING_ARRAY;
        CmwLightSerialiser.byteToDataType[17] = DataType.BOOL_ARRAY;
        CmwLightSerialiser.byteToDataType[18] = DataType.BYTE_ARRAY;
        CmwLightSerialiser.byteToDataType[19] = DataType.SHORT_ARRAY;
        CmwLightSerialiser.byteToDataType[20] = DataType.INT_ARRAY;
        CmwLightSerialiser.byteToDataType[21] = DataType.LONG_ARRAY;
        CmwLightSerialiser.byteToDataType[22] = DataType.FLOAT_ARRAY;
        CmwLightSerialiser.byteToDataType[23] = DataType.DOUBLE_ARRAY;
        CmwLightSerialiser.byteToDataType[203] = DataType.CHAR_ARRAY;
        CmwLightSerialiser.byteToDataType[24] = DataType.STRING_ARRAY;
        CmwLightSerialiser.byteToDataType[25] = DataType.BOOL_ARRAY;
        CmwLightSerialiser.byteToDataType[26] = DataType.BYTE_ARRAY;
        CmwLightSerialiser.byteToDataType[27] = DataType.SHORT_ARRAY;
        CmwLightSerialiser.byteToDataType[28] = DataType.INT_ARRAY;
        CmwLightSerialiser.byteToDataType[29] = DataType.LONG_ARRAY;
        CmwLightSerialiser.byteToDataType[30] = DataType.FLOAT_ARRAY;
        CmwLightSerialiser.byteToDataType[31] = DataType.DOUBLE_ARRAY;
        CmwLightSerialiser.byteToDataType[204] = DataType.CHAR_ARRAY;
        CmwLightSerialiser.byteToDataType[32] = DataType.STRING_ARRAY;
        for (int i = byteToDataType.length - 1; i >= 0; --i) {
            if (byteToDataType[i] == null) continue;
            int id = byteToDataType[i].getID();
            CmwLightSerialiser.dataTypeToByte[id] = (byte)i;
        }
    }
}

