/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.serializer.spi;

import de.gsi.serializer.DataType;
import de.gsi.serializer.FieldDescription;
import de.gsi.serializer.FieldSerialiser;
import de.gsi.serializer.annotations.Description;
import de.gsi.serializer.annotations.Direction;
import de.gsi.serializer.annotations.Groups;
import de.gsi.serializer.annotations.MetaInfo;
import de.gsi.serializer.annotations.Unit;
import de.gsi.serializer.utils.ClassUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Unsafe;

public class ClassFieldDescription
implements FieldDescription {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassFieldDescription.class);
    private final int hierarchyDepth;
    private final FieldAccess fieldAccess;
    private final String fieldName;
    private final int fieldNameHashCode;
    private final String fieldNameRelative;
    private final String fieldUnit;
    private final String fieldDescription;
    private final String fieldDirection;
    private final List<String> fieldGroups;
    private final boolean annotationPresent;
    private final ClassFieldDescription parent;
    private final List<FieldDescription> children = new ArrayList<FieldDescription>();
    private final Class<?> classType;
    private final DataType dataType;
    private final String typeName;
    private final int modifierID;
    private final boolean modPublic;
    private final boolean modProtected;
    private final boolean modPrivate;
    private final boolean modAbstract;
    private final boolean modStatic;
    private final boolean modFinal;
    private final boolean modTransient;
    private final boolean modVolatile;
    private final boolean modSynchronized;
    private final boolean modNative;
    private final boolean modStrict;
    private final boolean modInterface;
    private final boolean isprimitive;
    private final boolean isclass;
    private final boolean isEnum;
    private final boolean serializable;
    private String toStringName;
    private Type genericType;
    private List<Type> genericTypeList;
    private List<String> genericTypeNameList;
    private String genericTypeNames;
    private String genericTypeNamesSimple;
    private String modifierStr;
    private FieldSerialiser<?> fieldSerialiser;

    public ClassFieldDescription(Class<?> referenceClass, boolean fullScan) {
        this(referenceClass, null, null, 0);
        if (referenceClass == null) {
            throw new IllegalArgumentException("object must not be null");
        }
        this.genericType = this.classType.getGenericSuperclass();
        ClassFieldDescription.exploreClass(this.classType, this, 0, fullScan);
    }

    protected ClassFieldDescription(Class<?> referenceClass, Field field, ClassFieldDescription parent, int recursionLevel) {
        this.hierarchyDepth = recursionLevel;
        this.parent = parent;
        if (referenceClass == null) {
            if (field == null) {
                throw new IllegalArgumentException("field must not be null");
            }
            this.fieldAccess = new FieldAccess(field);
            this.classType = field.getType();
            this.fieldNameHashCode = field.getName().hashCode();
            this.fieldName = field.getName().intern();
            this.fieldNameRelative = this.parent == null ? this.fieldName : (this.parent.getFieldNameRelative() + "." + this.fieldName).intern();
            this.modifierID = field.getModifiers();
            this.dataType = DataType.fromClassType(this.classType);
        } else {
            this.fieldAccess = null;
            this.classType = referenceClass;
            this.fieldNameHashCode = this.classType.getName().hashCode();
            this.fieldNameRelative = this.fieldName = this.classType.getName().intern();
            this.modifierID = this.classType.getModifiers();
            this.dataType = DataType.START_MARKER;
        }
        AnnotatedElement annotatedElement = field == null ? referenceClass : field;
        this.fieldUnit = ClassFieldDescription.getFieldUnit(annotatedElement);
        this.fieldDescription = ClassFieldDescription.getFieldDescription(annotatedElement);
        this.fieldDirection = ClassFieldDescription.getFieldDirection(annotatedElement);
        this.fieldGroups = ClassFieldDescription.getFieldGroups(annotatedElement);
        this.annotationPresent = this.fieldUnit != null || this.fieldDescription != null || this.fieldDirection != null || !this.fieldGroups.isEmpty();
        this.typeName = ClassUtils.translateClassName(this.classType.getTypeName()).intern();
        this.modPublic = Modifier.isPublic(this.modifierID);
        this.modProtected = Modifier.isProtected(this.modifierID);
        this.modPrivate = Modifier.isPrivate(this.modifierID);
        this.modAbstract = Modifier.isAbstract(this.modifierID);
        this.modStatic = Modifier.isStatic(this.modifierID);
        this.modFinal = Modifier.isFinal(this.modifierID);
        this.modTransient = Modifier.isTransient(this.modifierID);
        this.modVolatile = Modifier.isVolatile(this.modifierID);
        this.modSynchronized = Modifier.isSynchronized(this.modifierID);
        this.modNative = Modifier.isNative(this.modifierID);
        this.modStrict = Modifier.isStrict(this.modifierID);
        this.modInterface = this.classType.isInterface();
        this.isprimitive = this.classType.isPrimitive();
        this.isclass = !this.isprimitive && !this.modInterface;
        this.isEnum = Enum.class.isAssignableFrom(this.classType);
        this.serializable = !this.modTransient && !this.modStatic;
    }

    public ClassFieldDescription(Field field, ClassFieldDescription parent, int recursionLevel, boolean fullScan) {
        this(null, field, parent, recursionLevel);
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        if (this.serializable) {
            field.setAccessible(true);
        }
        if (this.parent != null && (this.serializable || fullScan)) {
            this.parent.getChildren().add(this);
        }
    }

    public Object allocateMemberClassField(Object fieldParent) {
        try {
            Object newFieldObj;
            Class<?> fieldParentClass = ClassUtils.getRawType(this.getParent(this, 1).getType());
            if (fieldParentClass.getDeclaringClass() == null) {
                Constructor<?> constr = fieldParentClass.getDeclaredConstructor(new Class[0]);
                newFieldObj = constr.newInstance(new Object[0]);
            } else {
                Constructor<?> constr = fieldParentClass.getDeclaredConstructor(fieldParent.getClass());
                newFieldObj = constr.newInstance(fieldParent);
            }
            this.getField().set(fieldParent, newFieldObj);
            return newFieldObj;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOGGER.atError().setCause((Throwable)e).log("error initialising inner class object");
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FieldDescription)) {
            return false;
        }
        FieldDescription other = (FieldDescription)obj;
        if (this.getFieldNameHashCode() != other.getFieldNameHashCode()) {
            return false;
        }
        if (this.getDataType() != other.getDataType()) {
            return false;
        }
        return this.getFieldName().equals(other.getFieldName());
    }

    @Override
    public FieldDescription findChildField(String fieldName) {
        return this.findChildField(fieldName.hashCode(), fieldName);
    }

    @Override
    public FieldDescription findChildField(int fieldNameHashCode, String fieldName) {
        for (int i = 0; i < this.children.size(); ++i) {
            FieldDescription child = this.children.get(i);
            String name = child.getFieldName();
            if (name == fieldName) {
                return child;
            }
            if (child.getFieldNameHashCode() != fieldNameHashCode || !name.equals(fieldName)) continue;
            return child;
        }
        return null;
    }

    public List<String> getActualTypeArgumentNames() {
        if (this.genericTypeNameList == null) {
            this.genericTypeNameList = this.getActualTypeArguments().stream().map(Type::getTypeName).collect(Collectors.toList());
        }
        return this.genericTypeNameList;
    }

    public List<Type> getActualTypeArguments() {
        if (this.genericTypeList == null) {
            this.genericTypeList = new ArrayList<Type>();
            if (this.fieldAccess == null || this.getGenericType() == null || !(this.getGenericType() instanceof ParameterizedType)) {
                return this.genericTypeList;
            }
            this.genericTypeList.addAll(Arrays.asList(((ParameterizedType)this.getGenericType()).getActualTypeArguments()));
        }
        return this.genericTypeList;
    }

    @Override
    public List<FieldDescription> getChildren() {
        return this.children;
    }

    @Override
    public int getDataSize() {
        return 0;
    }

    @Override
    public int getDataStartOffset() {
        return 0;
    }

    @Override
    public int getDataStartPosition() {
        return 0;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    public FieldAccess getField() {
        return this.fieldAccess;
    }

    @Override
    public String getFieldDescription() {
        return this.fieldDescription;
    }

    @Override
    public String getFieldDirection() {
        return this.fieldDirection;
    }

    @Override
    public List<String> getFieldGroups() {
        return this.fieldGroups;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public int getFieldNameHashCode() {
        return this.fieldNameHashCode;
    }

    public String getFieldNameRelative() {
        return this.fieldNameRelative;
    }

    public FieldSerialiser getFieldSerialiser() {
        return this.fieldSerialiser;
    }

    @Override
    public int getFieldStart() {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public String getFieldUnit() {
        return this.fieldUnit;
    }

    public String getGenericFieldTypeString() {
        if (this.genericTypeNames == null) {
            this.genericTypeNames = this.getActualTypeArgumentNames().isEmpty() ? "" : this.getActualTypeArgumentNames().stream().collect(Collectors.joining(", ", "<", ">")).intern();
        }
        return this.genericTypeNames;
    }

    public String getGenericFieldTypeStringSimple() {
        if (this.genericTypeNamesSimple == null) {
            this.genericTypeNamesSimple = this.getActualTypeArgumentNames().isEmpty() ? "" : this.getActualTypeArguments().stream().map(t -> ClassUtils.translateClassName(t.getTypeName())).collect(Collectors.joining(", ", "<", ">")).intern();
        }
        return this.genericTypeNamesSimple;
    }

    public Type getGenericType() {
        if (this.genericType == null) {
            this.genericType = this.fieldAccess == null ? new Type(){

                @Override
                public String getTypeName() {
                    return "unknown type";
                }
            } : this.fieldAccess.field.getGenericType();
        }
        return this.genericType;
    }

    public int getHierarchyDepth() {
        return this.hierarchyDepth;
    }

    public int getModifierID() {
        return this.modifierID;
    }

    public String getModifierString() {
        if (this.modifierStr == null) {
            this.modifierStr = Modifier.toString(this.modifierID).intern();
        }
        return this.modifierStr;
    }

    @Override
    public FieldDescription getParent() {
        return this.parent;
    }

    public FieldDescription getParent(FieldDescription field, int hierarchyLevel) {
        if (field == null) {
            throw new IllegalArgumentException("field is null at hierarchyLevel = " + hierarchyLevel);
        }
        if (hierarchyLevel == 0 || field.getParent() == null) {
            return field;
        }
        return this.getParent(field.getParent(), hierarchyLevel - 1);
    }

    @Override
    public Type getType() {
        return this.classType;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int hashCode() {
        return this.fieldNameHashCode;
    }

    public boolean isAbstract() {
        return this.modAbstract;
    }

    @Override
    public boolean isAnnotationPresent() {
        return this.annotationPresent;
    }

    public boolean isClass() {
        return this.isclass;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public boolean isFinal() {
        return this.modFinal;
    }

    public boolean isInterface() {
        return this.modInterface;
    }

    public boolean isNative() {
        return this.modNative;
    }

    public boolean isPrimitive() {
        return this.isprimitive;
    }

    public boolean isPrivate() {
        return this.modPrivate;
    }

    public boolean isProtected() {
        return this.modProtected;
    }

    public boolean isPublic() {
        return this.modPublic;
    }

    public boolean isRoot() {
        return this.hierarchyDepth == 0;
    }

    public boolean isSerializable() {
        return this.serializable;
    }

    public boolean isStatic() {
        return this.modStatic;
    }

    public boolean isStrict() {
        return this.modStrict;
    }

    public boolean isSynchronized() {
        return this.modSynchronized;
    }

    public boolean isTransient() {
        return this.modTransient;
    }

    public boolean isVolatile() {
        return this.modVolatile;
    }

    @Override
    public void printFieldStructure() {
        ClassFieldDescription.printClassStructure(this, true, 0);
    }

    public void setFieldSerialiser(FieldSerialiser<?> fieldSerialiser) {
        this.fieldSerialiser = fieldSerialiser;
    }

    public String toString() {
        if (this.toStringName == null) {
            this.toStringName = (ClassFieldDescription.class.getSimpleName() + " for: " + this.getModifierString() + " " + this.getTypeName() + this.getGenericFieldTypeStringSimple() + " " + this.getFieldName() + " (hierarchyDepth = " + this.getHierarchyDepth() + ")").intern();
        }
        return this.toStringName;
    }

    protected static void exploreClass(Class<?> classType, ClassFieldDescription parent, int recursionLevel, boolean fullScan) {
        if (recursionLevel > ClassUtils.getMaxRecursionDepth()) {
            throw new IllegalStateException("recursion error while scanning object structure: recursionLevel = '" + recursionLevel + "' > " + ClassFieldDescription.class.getSimpleName() + ".maxRecursionLevel ='" + ClassUtils.getMaxRecursionDepth() + "'");
        }
        if (classType.getSuperclass() != null && !classType.getSuperclass().equals(Object.class) && !classType.getSuperclass().equals(Enum.class)) {
            ClassFieldDescription.exploreClass(classType.getSuperclass(), parent, recursionLevel + 1, fullScan);
        }
        for (Field pfield : classType.getDeclaredFields()) {
            boolean isClassAndNotObjectOrEnmum;
            FieldDescription localParent = parent.getParent();
            if (localParent != null && pfield.getType().equals(localParent.getType()) && recursionLevel >= ClassUtils.getMaxRecursionDepth() || pfield.getName().startsWith("this$")) continue;
            ClassFieldDescription field = new ClassFieldDescription(pfield, parent, recursionLevel + 1, fullScan);
            boolean bl = isClassAndNotObjectOrEnmum = field.isClass() && (!field.getType().equals(Object.class) || !field.getType().equals(Enum.class));
            if (!field.isSerializable() || !isClassAndNotObjectOrEnmum && !field.isInterface() || !field.getDataType().equals((Object)DataType.OTHER)) continue;
            ClassFieldDescription.exploreClass(ClassUtils.getRawType(field.getType()), field, recursionLevel + 1, fullScan);
        }
    }

    protected static void printClassStructure(ClassFieldDescription field, boolean fullView, int recursionLevel) {
        String enumOrClass;
        String string = enumOrClass = field.isEnum() ? "Enum " : "class ";
        String typeCategorgy = field.isInterface() ? "interface " : (field.isPrimitive() ? "" : enumOrClass);
        String typeName = field.getTypeName() + field.getGenericFieldTypeString();
        String mspace = ClassFieldDescription.spaces(recursionLevel * ClassUtils.getIndentationNumberOfSpace());
        boolean isSerialisable = field.isSerializable();
        if (isSerialisable || fullView) {
            LOGGER.atInfo().addArgument((Object)mspace).addArgument((Object)(isSerialisable ? "  " : "//")).addArgument((Object)field.getModifierString()).addArgument((Object)typeCategorgy).addArgument((Object)typeName).addArgument((Object)field.getFieldName()).log("{} {} {} {}{} {}");
            if (field.isAnnotationPresent()) {
                LOGGER.atInfo().addArgument((Object)mspace).addArgument((Object)(isSerialisable ? "  " : "//")).addArgument((Object)field.getFieldUnit()).addArgument((Object)field.getFieldDescription()).addArgument((Object)field.getFieldDirection()).addArgument(field.getFieldGroups()).log("{} {}         <meta-info: unit:'{}' description:'{}' direction:'{}' groups:'{}'>");
            }
            field.getChildren().forEach(f -> ClassFieldDescription.printClassStructure((ClassFieldDescription)f, fullView, recursionLevel + 1));
        }
    }

    private static String getFieldDescription(AnnotatedElement annotatedElement) {
        MetaInfo[] annotationMeta = (MetaInfo[])annotatedElement.getAnnotationsByType(MetaInfo.class);
        if (annotationMeta != null && annotationMeta.length > 0) {
            return annotationMeta[0].description().intern();
        }
        Description[] annotationDescription = (Description[])annotatedElement.getAnnotationsByType(Description.class);
        if (annotationDescription != null && annotationDescription.length > 0) {
            return annotationDescription[0].value().intern();
        }
        return null;
    }

    private static String getFieldDirection(AnnotatedElement annotatedElement) {
        MetaInfo[] annotationMeta = (MetaInfo[])annotatedElement.getAnnotationsByType(MetaInfo.class);
        if (annotationMeta != null && annotationMeta.length > 0) {
            return annotationMeta[0].direction().intern();
        }
        Direction[] annotationDirection = (Direction[])annotatedElement.getAnnotationsByType(Direction.class);
        if (annotationDirection != null && annotationDirection.length > 0) {
            return annotationDirection[0].value().intern();
        }
        return null;
    }

    private static List<String> getFieldGroups(AnnotatedElement annotatedElement) {
        MetaInfo[] annotationMeta = (MetaInfo[])annotatedElement.getAnnotationsByType(MetaInfo.class);
        if (annotationMeta != null && annotationMeta.length > 0) {
            return Arrays.asList(annotationMeta[0].groups());
        }
        Groups[] annotationGroups = (Groups[])annotatedElement.getAnnotationsByType(Groups.class);
        if (annotationGroups != null && annotationGroups.length > 0) {
            ArrayList<String> ret = new ArrayList<String>(annotationGroups[0].value().length);
            for (int i = 0; i < annotationGroups[0].value().length; ++i) {
                ret.add(annotationGroups[0].value()[i].intern());
            }
            return ret;
        }
        return Collections.emptyList();
    }

    private static String getFieldUnit(AnnotatedElement annotatedElement) {
        MetaInfo[] annotationMeta = (MetaInfo[])annotatedElement.getAnnotationsByType(MetaInfo.class);
        if (annotationMeta != null && annotationMeta.length > 0) {
            return annotationMeta[0].unit().intern();
        }
        Unit[] annotationUnit = (Unit[])annotatedElement.getAnnotationsByType(Unit.class);
        if (annotationUnit != null && annotationUnit.length > 0) {
            return annotationUnit[0].value().intern();
        }
        return null;
    }

    private static String spaces(int spaces) {
        return CharBuffer.allocate(spaces).toString().replace('\u0000', ' ');
    }

    public static class FieldAccess {
        private static final Unsafe unsafe;
        private final Field field;
        private final long fieldByteOffset;

        private FieldAccess(Field field) {
            this.field = field;
            field.setAccessible(true);
            long offset = -1L;
            try {
                offset = unsafe.objectFieldOffset(field);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.fieldByteOffset = offset;
        }

        public Object get(Object classReference) {
            return unsafe.getObject(classReference, this.fieldByteOffset);
        }

        public boolean getBoolean(Object classReference) {
            return unsafe.getBoolean(classReference, this.fieldByteOffset);
        }

        public byte getByte(Object classReference) {
            return unsafe.getByte(classReference, this.fieldByteOffset);
        }

        public char getChar(Object classReference) {
            return unsafe.getChar(classReference, this.fieldByteOffset);
        }

        public double getDouble(Object classReference) {
            return unsafe.getDouble(classReference, this.fieldByteOffset);
        }

        public Field getField() {
            return this.field;
        }

        public float getFloat(Object classReference) {
            return unsafe.getFloat(classReference, this.fieldByteOffset);
        }

        public int getInt(Object classReference) {
            return unsafe.getInt(classReference, this.fieldByteOffset);
        }

        public long getLong(Object classReference) {
            return unsafe.getLong(classReference, this.fieldByteOffset);
        }

        public short getShort(Object classReference) {
            return unsafe.getShort(classReference, this.fieldByteOffset);
        }

        public void set(Object classReference, Object obj) {
            unsafe.putObject(classReference, this.fieldByteOffset, obj);
        }

        public void setBoolean(Object classReference, boolean value) {
            unsafe.putBoolean(classReference, this.fieldByteOffset, value);
        }

        public void setByte(Object classReference, byte value) {
            unsafe.putByte(classReference, this.fieldByteOffset, value);
        }

        public void setChar(Object classReference, char value) {
            unsafe.putChar(classReference, this.fieldByteOffset, value);
        }

        public void setDouble(Object classReference, double value) {
            unsafe.putDouble(classReference, this.fieldByteOffset, value);
        }

        public void setFloat(Object classReference, float value) {
            unsafe.putFloat(classReference, this.fieldByteOffset, value);
        }

        public void setInt(Object classReference, int value) {
            unsafe.putInt(classReference, this.fieldByteOffset, value);
        }

        public void setLong(Object classReference, long value) {
            unsafe.putLong(classReference, this.fieldByteOffset, value);
        }

        public void setShort(Object classReference, short value) {
            unsafe.putShort(classReference, this.fieldByteOffset, value);
        }

        static {
            try {
                Field field = Unsafe.class.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                unsafe = (Unsafe)field.get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
                throw new SecurityException(e);
            }
        }
    }
}

