/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.storage;

import de.gsi.math.storage.VoxelArrayND;
import java.util.Arrays;

public class DoubleStorage1D
implements VoxelArrayND {
    protected double[] fdata;

    public DoubleStorage1D(double[] data) {
        this.setArray(data);
    }

    public DoubleStorage1D(DoubleStorage1D data) {
        this.setArray(data.fdata);
    }

    @Override
    public VoxelArrayND copy() {
        return new DoubleStorage1D(this.fdata);
    }

    @Override
    public int getValueDimension() {
        return 1;
    }

    public double[] getArray() {
        return this.fdata;
    }

    public void setArray(double[] data) {
        this.fdata = Arrays.copyOf(data, data.length);
    }

    public double get(int index) {
        return this.fdata[index];
    }

    public void set(int index, double val) {
        this.fdata[index] = val;
    }

    @Override
    public double[] get(int[] index) {
        return new double[]{this.get(index[0])};
    }

    @Override
    public void set(int[] index, double[] val) {
        this.set(index[0], val[0]);
    }

    @Override
    public double[] getLocal(int localIndex) {
        return new double[]{this.get(localIndex)};
    }

    @Override
    public void setLocal(int localIndex, double[] val) {
        this.fdata[localIndex] = val[0];
    }

    @Override
    public int getLocalIndex(int[] index) {
        return index[0];
    }

    @Override
    public int[] getInverseLocalIndex(int index) {
        return new int[]{index};
    }

    @Override
    public int getLocalStorageDim() {
        return this.fdata.length;
    }

    @Override
    public void initialiseWithValue(double val) {
        for (int i = 0; i < this.fdata.length; ++i) {
            this.fdata[i] = val;
        }
    }
}

