/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.spectra.wavelet;

import de.gsi.math.spectra.wavelet.Lift;

public class MyWavelet
extends Lift {
    static final double sqrt3 = Math.sqrt(3.0);
    static final double sqrt2 = Math.sqrt(2.0);

    protected void normalize(double[] S, int N, Lift.Direction direction) {
        int half = N >> 1;
        for (int n = 0; n < half; ++n) {
            if (direction == Lift.Direction.forward) {
                S[n] = (sqrt3 - 1.0) / sqrt2 * S[n];
                S[n + half] = (sqrt3 + 1.0) / sqrt2 * S[n + half];
                continue;
            }
            S[n] = (sqrt3 + 1.0) / sqrt2 * S[n];
            S[n + half] = (sqrt3 - 1.0) / sqrt2 * S[n + half];
        }
    }

    @Override
    protected void predict(double[] S, int N, Lift.Direction direction) {
        int half = N >> 1;
        S[half] = direction == Lift.Direction.forward ? S[half] - sqrt3 / 4.0 * S[0] - (sqrt3 - 2.0) / 4.0 * S[half - 1] : S[half] + sqrt3 / 4.0 * S[0] + (sqrt3 - 2.0) / 4.0 * S[half - 1];
        for (int n = 1; n < half; ++n) {
            S[half + n] = direction == Lift.Direction.forward ? S[half + n] - sqrt3 / 4.0 * S[n] - (sqrt3 - 2.0) / 4.0 * S[n - 1] : S[half + n] + sqrt3 / 4.0 * S[n] + (sqrt3 - 2.0) / 4.0 * S[n - 1];
        }
    }

    protected void updateOne(double[] S, int N, Lift.Direction direction) {
        int half = N >> 1;
        for (int n = 0; n < half; ++n) {
            double updateVal = sqrt3 * S[half + n];
            S[n] = direction == Lift.Direction.forward ? S[n] + updateVal : S[n] - updateVal;
        }
    }

    @Override
    protected void update(double[] S, int N, Lift.Direction direction) {
        int half = N >> 1;
        for (int n = 0; n < half - 1; ++n) {
            S[n] = direction == Lift.Direction.forward ? S[n] - S[half + n + 1] : S[n] + S[half + n + 1];
        }
        S[half - 1] = direction == Lift.Direction.forward ? S[half - 1] - S[half] : S[half - 1] + S[half];
    }

    @Override
    public void forwardTrans(double[] vec) {
        int N;
        for (int n = N = vec.length; n > 1; n >>= 1) {
            this.split(vec, n);
            this.updateOne(vec, n, Lift.Direction.forward);
            this.predict(vec, n, Lift.Direction.forward);
            this.update(vec, n, Lift.Direction.forward);
            this.normalize(vec, n, Lift.Direction.forward);
        }
    }

    @Override
    public void inverseTrans(double[] vec) {
        int N = vec.length;
        for (int n = 2; n <= N; n <<= 1) {
            this.normalize(vec, n, Lift.Direction.inverse);
            this.update(vec, n, Lift.Direction.inverse);
            this.predict(vec, n, Lift.Direction.inverse);
            this.updateOne(vec, n, Lift.Direction.inverse);
            this.merge(vec, n);
        }
    }
}

