/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.spectra.wavelet;

public class DaubechiesWavelet {
    protected final double sqrt_3 = Math.sqrt(3.0);
    protected final double denom = 4.0 * Math.sqrt(2.0);
    protected final double h0 = (1.0 + this.sqrt_3) / this.denom;
    protected final double h1 = (3.0 + this.sqrt_3) / this.denom;
    protected final double h2 = (3.0 - this.sqrt_3) / this.denom;
    protected final double h3;
    protected final double g0 = this.h3 = (1.0 - this.sqrt_3) / this.denom;
    protected final double g1 = -this.h2;
    protected final double g2 = this.h1;
    protected final double g3 = -this.h0;
    protected final double Ih0 = this.h2;
    protected final double Ih1 = this.g2;
    protected final double Ih2 = this.h0;
    protected final double Ih3 = this.g0;
    protected final double Ig0 = this.h3;
    protected final double Ig1 = this.g3;
    protected final double Ig2 = this.h1;
    protected final double Ig3 = this.g1;

    protected void transform(double[] a, int n) {
        if (n >= 4) {
            int half = n >> 1;
            double[] tmp = new double[n];
            System.err.printf("h0 = %f h1 = %f h2 = %f h3= %f\n", this.h0, this.h1, this.h2, this.h3);
            int i = 0;
            for (int j = 0; j < n - 3; j += 2) {
                tmp[i] = a[j] * this.h0 + a[j + 1] * this.h1 + a[j + 2] * this.h2 + a[j + 3] * this.h3;
                tmp[i + half] = a[j] * this.g0 + a[j + 1] * this.g1 + a[j + 2] * this.g2 + a[j + 3] * this.g3;
                ++i;
            }
            tmp[i] = a[n - 2] * this.h0 + a[n - 1] * this.h1 + a[0] * this.h2 + a[1] * this.h3;
            tmp[i + half] = a[n - 2] * this.g0 + a[n - 1] * this.g1 + a[0] * this.g2 + a[1] * this.g3;
            for (i = 0; i < n; ++i) {
                a[i] = tmp[i];
            }
        }
    }

    protected void invTransform(double[] a, int n) {
        if (n >= 4) {
            int i;
            int half = n >> 1;
            int halfPls1 = half + 1;
            double[] tmp = new double[n];
            tmp[0] = a[half - 1] * this.Ih0 + a[n - 1] * this.Ih1 + a[0] * this.Ih2 + a[half] * this.Ih3;
            tmp[1] = a[half - 1] * this.Ig0 + a[n - 1] * this.Ig1 + a[0] * this.Ig2 + a[half] * this.Ig3;
            int j = 2;
            for (i = 0; i < half - 1; ++i) {
                tmp[j++] = a[i] * this.Ih0 + a[i + half] * this.Ih1 + a[i + 1] * this.Ih2 + a[i + halfPls1] * this.Ih3;
                tmp[j++] = a[i] * this.Ig0 + a[i + half] * this.Ig1 + a[i + 1] * this.Ig2 + a[i + halfPls1] * this.Ig3;
            }
            for (i = 0; i < n; ++i) {
                a[i] = tmp[i];
            }
        }
    }

    public void daubTrans(double[] s) {
        int N;
        for (int n = N = s.length; n >= 4; n >>= 1) {
            this.transform(s, n);
        }
    }

    public void invDaubTrans(double[] coef) {
        int N = coef.length;
        for (int n = 4; n <= N; n <<= 1) {
            this.invTransform(coef, n);
        }
    }
}

