/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.spectra.wavelet;

import de.gsi.dataset.spi.DoubleDataSet3D;
import de.gsi.math.TMath;
import de.gsi.math.TMathConstants;
import de.gsi.math.spectra.Convolution;
import de.gsi.math.utils.ConcurrencyUtils;
import java.security.InvalidParameterException;
import java.util.concurrent.Future;
import org.apache.commons.math3.complex.Complex;

public class ContinuousWavelet {
    protected int START_THREADS = 512;
    protected boolean DEBUG = false;
    private int fstatus = 100;
    private final Convolution[] fdecon = new Convolution[ConcurrencyUtils.getNumberOfThreads()];

    public Complex Morlet(double x, double nu) {
        double val1 = 1.0 / Math.sqrt(TMathConstants.TwoPi()) * TMathConstants.Exp(-2.0 * TMathConstants.Sqr(TMathConstants.Sqr(TMathConstants.TwoPi()) * x / nu));
        double val2 = TMathConstants.TwoPi() * nu * x;
        double re = val1 * Math.sin(val2);
        double im = val1 * Math.cos(val2);
        return new Complex(re, im);
    }

    public void Morlet(double x, double nu, double[] ret) {
        double val1 = 1.0 / Math.sqrt(TMathConstants.TwoPi()) * TMathConstants.Exp(-2.0 * TMathConstants.Sqr(TMathConstants.Sqr(TMathConstants.TwoPi()) * x / nu));
        double val2 = TMathConstants.TwoPi() * nu * x;
        ret[0] = val1 * Math.cos(val2);
        ret[1] = val1 * Math.sin(val2);
    }

    public Complex Paul(double x, int m) {
        double val = Math.pow(2.0, m) * TMath.Factorial(m) / Math.sqrt(TMathConstants.Pi() * TMath.Factorial(2 * m));
        Complex c1 = new Complex(1.0, 0.0);
        Complex c2 = new Complex(1.0, 0.0);
        for (int i = 0; i < m + 1; ++i) {
            c1 = c1.multiply(new Complex(1.0, -x));
            if (i >= m) continue;
            c2 = c2.multiply(new Complex(0.0, 1.0));
        }
        return c1.multiply(c2).multiply(val);
    }

    public Complex MexicanHat(double x) {
        double x2 = x * x;
        double im = (1.0 - x2) * Math.exp(-0.5 * x2);
        return new Complex(0.0, im);
    }

    public synchronized Complex WaveletTransform(Complex[] data, double scale, double translation, double nu) {
        double re = 0.0;
        double im = 0.0;
        double norm = 1.0 / Math.sqrt(scale);
        for (int i = 0; i < data.length; ++i) {
            Complex morlet = this.Morlet(((double)i - translation) / scale, nu).multiply(norm);
            re += data[i].multiply(morlet).getReal();
            im += data[i].multiply(morlet).getImaginary();
        }
        return new Complex(re, im);
    }

    public synchronized Complex WaveletTransform(double[] data, double scale, double translation, double nu) {
        double re = 0.0;
        double im = 0.0;
        double[] ret = new double[2];
        double norm = 1.0 / Math.sqrt(scale);
        int centre = (int)translation + 1;
        int width = (int)(10.0 * scale);
        int min = Math.max(0, centre - width);
        int max = Math.min(data.length, centre + width);
        for (int i = min; i < max; ++i) {
            this.Morlet(((double)i - translation) / scale, nu, ret);
            ret[0] = ret[0] * norm;
            ret[1] = ret[1] * norm;
            re += data[i] * ret[1];
            im += data[i] * ret[0];
        }
        return new Complex(re, im);
    }

    public synchronized double[][] getScalogramArray(double[] data, int nQuantx, int nQuanty, double nu, double fmin, double fmax) {
        int nQuantyInternal = (int)Math.floor((double)nQuanty * (fmax - fmin) / 0.5) + 1;
        double[][] ret = new double[nQuantx][nQuantyInternal];
        this.fstatus = 0;
        for (int i = 0; i < nQuantx; ++i) {
            double t = data.length / nQuantx * i;
            this.fstatus = (int)((double)i / (double)nQuantx * 100.0);
            int min = (int)(2.0 * fmin * (double)nQuanty);
            int max = (int)(2.0 * fmax * (double)nQuanty);
            for (int j = min; j < max; ++j) {
                double f = 0.5 * (double)j / (double)nQuanty;
                if (f != 0.0) {
                    double scale = nu / f;
                    Complex val = this.WaveletTransform(data, scale, t, nu);
                    double power = val.getReal() * val.getReal() + val.getImaginary() * val.getImaginary();
                    ret[i][j - min] = 10.0 * TMathConstants.Log10(power + 1.0E-99);
                    continue;
                }
                ret[i][j - min] = Double.NaN;
            }
        }
        this.fstatus = 100;
        return ret;
    }

    public synchronized double[][] getScalogramArrayFourier(final double[] data, final int nQuantx, final int nQuanty, final double nu, double fmin, double fmax) {
        int nQuantyInternal = (int)Math.floor((double)nQuanty * (fmax - fmin) / 0.5) + 1;
        final double[][] ret = new double[nQuantyInternal][nQuantx];
        boolean cyclicBoundaries = true;
        long start = System.nanoTime();
        this.fstatus = 0;
        final int min = (int)(2.0 * fmin * (double)nQuanty);
        int max = (int)(2.0 * fmax * (double)nQuanty);
        int n = max - min;
        final int filterDim = ConcurrencyUtils.nextPow2(1 * data.length);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && n > this.START_THREADS) {
            Future[] futures = new Future[nthreads];
            int k = n / nthreads;
            for (int thread = 0; thread < nthreads; ++thread) {
                final int firstIdx = min + thread * k;
                final int lastIdx = thread == nthreads - 1 ? max : firstIdx + k;
                final int thread_id = thread;
                futures[thread] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        if (ContinuousWavelet.this.fdecon[thread_id] == null) {
                            ((ContinuousWavelet)ContinuousWavelet.this).fdecon[thread_id] = new Convolution();
                        }
                        for (int j = firstIdx; j < lastIdx; ++j) {
                            int i;
                            double f0 = 0.5 * (double)j / (double)nQuanty;
                            if (thread_id == 0) {
                                ContinuousWavelet.this.fstatus = (int)((double)j / (double)lastIdx * 100.0);
                            }
                            double[] filter = Convolution.getMorletFilter(filterDim, f0, nu);
                            double[] wtransformed = ContinuousWavelet.this.fdecon[thread_id].transformFull(data, filter, true);
                            if (f0 != 0.0) {
                                if (nQuantx != filterDim) {
                                    int nbin = filterDim / nQuantx;
                                    for (int i2 = 0; i2 < nQuantx; ++i2) {
                                        int index = i2 * nbin;
                                        int i22 = index << 1;
                                        double power = 0.0;
                                        for (int l = 0; l < nbin; ++l) {
                                            int l2 = l << 1;
                                            double Re = wtransformed[i22 + l2];
                                            double Im = wtransformed[i22 + l2 + 1];
                                            power += TMathConstants.Sqr(Re) + TMathConstants.Sqr(Im);
                                        }
                                        ret[j - min][i2] = 10.0 * TMathConstants.Log10((power /= (double)nbin) + 1.0E-99);
                                    }
                                    continue;
                                }
                                for (i = 0; i < filterDim; ++i) {
                                    int index = i;
                                    int i2 = index << 1;
                                    double Re = wtransformed[i2];
                                    double Im = wtransformed[i2 + 1];
                                    double power = TMathConstants.Sqr(Re) + TMathConstants.Sqr(Im);
                                    ret[j - min][i] = 10.0 * TMathConstants.Log10(power + 1.0E-99);
                                }
                                continue;
                            }
                            for (i = 0; i < nQuantx; ++i) {
                                ret[j - min][i] = Double.NaN;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            boolean thread_id = false;
            if (this.fdecon[0] == null) {
                this.fdecon[0] = new Convolution();
            }
            for (int j = min; j < max; ++j) {
                int i;
                double f0 = 0.5 * (double)j / (double)nQuanty;
                this.fstatus = (int)((double)j / (double)nQuanty * 100.0);
                double[] filter = Convolution.getMorletFilter(filterDim, f0, nu);
                double[] wtransformed = this.fdecon[0].transformFull(data, filter, true);
                if (f0 != 0.0) {
                    if (nQuantx != filterDim) {
                        int nbin = filterDim / nQuantx;
                        for (int i2 = 0; i2 < nQuantx; ++i2) {
                            int index = i2 * nbin;
                            int i22 = index << 1;
                            double power = 0.0;
                            for (int k = 0; k < nbin; ++k) {
                                int k2 = k << 1;
                                double Re = wtransformed[i22 + k2];
                                double Im = wtransformed[i22 + k2 + 1];
                                power += TMathConstants.Sqr(Re) + TMathConstants.Sqr(Im);
                            }
                            ret[j - min][i2] = 10.0 * TMathConstants.Log10((power /= (double)nbin) + 1.0E-99);
                        }
                        continue;
                    }
                    for (i = 0; i < filterDim; ++i) {
                        int index = i;
                        int i2 = index << 1;
                        double Re = wtransformed[i2];
                        double Im = wtransformed[i2 + 1];
                        double power = TMathConstants.Sqr(Re) + TMathConstants.Sqr(Im);
                        ret[j - min][i] = 10.0 * TMathConstants.Log10(power + 1.0E-99);
                    }
                    continue;
                }
                for (i = 0; i < nQuantx; ++i) {
                    ret[j - min][i] = Double.NaN;
                }
            }
        }
        long stop = System.nanoTime();
        if (this.DEBUG) {
            System.err.printf("getScalogramArrayFourier(double[],int,int,double,double,double) - took %f ms\n", (double)(stop - start) * 1.0E-6);
        }
        this.fstatus = 100;
        return ret;
    }

    public double[] getScalogramFrequencyAxis(int nQuantx, int nQuanty, double nu, double fmin, double fmax) {
        double[] ret = new double[(int)Math.floor((double)nQuanty * (fmax - fmin) / 0.5) + 1];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = fmin + (double)i * (fmax - fmin) / (double)ret.length;
        }
        return ret;
    }

    public double[] getScalogramTimeAxis(double[] data, int nQuantx, int nQuanty, double nu, double fmin, double fmax) {
        double[] ret = new double[nQuantx];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = i * data.length / nQuantx;
        }
        return ret;
    }

    public DoubleDataSet3D getScalogram(double[] data, int nQuantx, int nQuanty, double nu, double fmin, double fmax) {
        if (data == null || data.length == 0) {
            throw new InvalidParameterException(" getScalogram(double[],int,int,double,fmin,fmax) - data null or zero length");
        }
        if (fmin < 0.0 || fmax > 0.5 || fmax <= fmin) {
            throw new InvalidParameterException(" getScalogram(double[],int,int,double," + fmin + "," + fmax + ") - frequency range not within 0<=fmin<fmax<=0.5");
        }
        if (nQuantx <= 0 || nQuantx > data.length) {
            throw new InvalidParameterException(" getScalogram(double[]," + nQuantx + ",int,double," + fmin + "," + fmax + ") - nQuantx out of range [0," + data.length + "]");
        }
        DoubleDataSet3D ds = new DoubleDataSet3D("Scalogram");
        ds.set(this.getScalogramTimeAxis(data, nQuantx, nQuanty, nu, fmin, fmax), this.getScalogramFrequencyAxis(nQuantx, nQuanty, nu, fmin, fmax), this.getScalogramArrayFourier(data, nQuantx, nQuanty, nu, fmin, fmax));
        return ds;
    }

    public boolean isBusy() {
        return this.fstatus < 100;
    }

    public int getStatus() {
        return this.fstatus;
    }

    public static void main(String[] args) {
        ContinuousWavelet wTrafo = new ContinuousWavelet();
        Complex result = wTrafo.WaveletTransform(new double[]{0.1, 0.2, 0.0, 3.0}, 0.0, 0.0, 0.8);
        System.err.println("result = " + result);
    }
}

