/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.spectra.fft;

import de.gsi.math.spectra.fft.ComplexFFT_1D;
import de.gsi.math.spectra.fft.DoubleFFT_1D;
import de.gsi.math.spectra.fft.FloatFFT_1D;
import org.apache.commons.math3.complex.Complex;

public class SimpleFFTSpeedTest {
    private int fsize;
    private Complex[] fcdata;
    private Complex[] fcfft;
    private double[] fddata;
    private float[] ffdata;
    private DoubleFFT_1D fdfft;
    private FloatFFT_1D fffft;

    public SimpleFFTSpeedTest(int size) {
        this.initData(size, 0.31);
    }

    private void initData(int size, double frequency) {
        this.fsize = size;
        this.fcdata = new Complex[this.fsize];
        this.fcfft = new Complex[this.fsize];
        this.fddata = new double[this.fsize];
        this.ffdata = new float[this.fsize];
        for (int i = 0; i < this.fsize; ++i) {
            double re = Math.sin(Math.PI * 2 * frequency * (double)i);
            double im = 0.0;
            this.fcdata[i] = new Complex(re, 0.0);
            this.fcfft[i] = new Complex(0.0);
            this.fddata[i] = re;
            this.ffdata[i] = (float)re;
        }
        this.fdfft = new DoubleFFT_1D(size);
        this.fffft = new FloatFFT_1D(size);
        this.runComplexFFT();
    }

    public double getPeakFrequencyC() {
        double max = -1.0E99;
        int max_index = -1;
        for (int i = 0; i < this.fsize / 2; ++i) {
            if (!(this.fcfft[i].abs() > max)) continue;
            max = this.fcfft[i].abs();
            max_index = i;
        }
        if (max_index > 0) {
            return (double)max_index / (double)this.fsize;
        }
        return 0.0;
    }

    public double getPeakFrequencyF() {
        double max = -1.0E99;
        int max_index = -1;
        for (int i = 0; i < this.fsize / 2; ++i) {
            float re = this.ffdata[2 * i];
            float im = this.ffdata[2 * i + 1];
            double val = Math.hypot(re, im);
            if (!(val > max)) continue;
            max = val;
            max_index = i;
        }
        if (max_index > 0) {
            return (double)max_index / (double)this.fsize;
        }
        return 0.0;
    }

    public double getPeakFrequencyD() {
        double max = -1.0E99;
        int max_index = -1;
        for (int i = 0; i < this.fsize / 2; ++i) {
            double re = this.fddata[2 * i];
            double im = this.fddata[2 * i + 1];
            double val = Math.hypot(re, im);
            if (!(val > max)) continue;
            max = val;
            max_index = i;
        }
        if (max_index > 0) {
            return (double)max_index / (double)this.fsize;
        }
        return 0.0;
    }

    public void runComplexFFT() {
        this.fcfft = ComplexFFT_1D.fft(this.fcdata);
    }

    public void runDoubleFFT() {
        this.fdfft.realForward(this.fddata);
    }

    public void runFloatFFT() {
        this.fffft.realForward(this.ffdata);
    }

    public static void main(String[] args) {
        int i;
        SimpleFFTSpeedTest test = new SimpleFFTSpeedTest(32768);
        int n_test = 200;
        long nanoStart = System.nanoTime();
        for (i = 0; i < 200; ++i) {
            test.runComplexFFT();
        }
        long nanoEnd = System.nanoTime();
        double averageTime = (double)((nanoEnd - nanoStart) / 200L) / 1000.0;
        System.out.println("average time (home-brewed) complex FFT = " + averageTime + " us");
        nanoStart = System.nanoTime();
        for (i = 0; i < 200; ++i) {
            test.runDoubleFFT();
        }
        nanoEnd = System.nanoTime();
        averageTime = (double)((nanoEnd - nanoStart) / 200L) / 1000.0;
        System.out.println("average time double FFT (JTransforms) = " + averageTime + " us");
        nanoStart = System.nanoTime();
        for (i = 0; i < 200; ++i) {
            test.runFloatFFT();
        }
        nanoEnd = System.nanoTime();
        averageTime = (double)((nanoEnd - nanoStart) / 200L) / 1000.0;
        System.out.println("average time float FFT (JTransforms) = " + averageTime + " us");
        test.initData(1024, 0.32);
        test.runComplexFFT();
        test.runDoubleFFT();
        test.runFloatFFT();
        System.out.println("C-FFT: detected frequency = " + test.getPeakFrequencyC());
        System.out.println("D-FFT: detected frequency = " + test.getPeakFrequencyD());
        System.out.println("F-FFT: detected frequency = " + test.getPeakFrequencyF());
        test = null;
    }
}

