/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.spectra.dtft;

import de.gsi.math.TMath;
import de.gsi.math.TMathConstants;
import de.gsi.math.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class DiscreteTimeFourierTransform {
    protected int START_THREADS = 128;
    protected boolean DEBUG = false;

    public double[] computeMagnitudeSpectrum(final double[] t, final double[] val, final double[] testFrequencies) {
        int n = testFrequencies.length;
        final int tn = t.length;
        final double[] ret = new double[n];
        long start = System.nanoTime();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && n > this.START_THREADS) {
            Future[] futures = new Future[nthreads];
            int k = n / nthreads;
            for (int thread = 0; thread < nthreads; ++thread) {
                final int firstIdx = thread * k;
                final int lastIdx = thread == nthreads - 1 ? n : firstIdx + k;
                futures[thread] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            double omega = TMathConstants.TwoPi() * testFrequencies[i];
                            double sum1 = 0.0;
                            double sum2 = 0.0;
                            for (int j = 0; j < tn; ++j) {
                                sum1 += val[j] * TMathConstants.Cos(omega * t[j]);
                                sum2 += val[j] * TMathConstants.Sin(omega * t[j]);
                            }
                            ret[i] = 2.0 * TMathConstants.Sqrt(TMathConstants.Sqr(sum1 /= (double)tn) + TMathConstants.Sqr(sum2 /= (double)tn));
                        }
                    }
                });
            }
        } else {
            double sum1 = 0.0;
            double sum2 = 0.0;
            for (int i = 0; i < n; ++i) {
                double omega = TMathConstants.TwoPi() * testFrequencies[i];
                for (int j = 0; j < t.length; ++j) {
                    sum1 += val[j] * TMathConstants.Cos(omega * t[j]);
                    sum2 += val[j] * TMathConstants.Sin(omega * t[j]);
                }
                ret[i] = 2.0 * TMathConstants.Sqrt(TMathConstants.Sqr(sum1 /= (double)t.length) + TMathConstants.Sqr(sum2 /= (double)t.length));
            }
        }
        long stop = System.nanoTime();
        if (this.DEBUG) {
            System.err.printf("computeMagnitudeSpectrum(double[], double[], double[]) - took %f ms\n", (double)(stop - start) * 1.0E-6);
        }
        return ret;
    }

    public double[] computeMagnitudeSpectrum(double[] t, double[] val) {
        return this.computeMagnitudeSpectrum(t, val, this.computeFrequencyRange(t));
    }

    public double[] computeFrequencyRange(double[] time) {
        double t_range = TMath.Maximum(time) - TMath.Minimum(time);
        double t_min = Double.MAX_VALUE;
        for (int i = 1; i < time.length; ++i) {
            double diff = TMathConstants.Abs(time[i] - time[i - 1]);
            if (!(t_min > diff) || !(t_min > 0.0)) continue;
            t_min = diff;
        }
        double f_s = 1.0 / t_min;
        int nTestFrequencies = (int)(t_range / t_min);
        double[] testFrequencies = new double[nTestFrequencies];
        double scale = 0.5 / (double)nTestFrequencies * f_s;
        for (int i = 0; i < nTestFrequencies; ++i) {
            testFrequencies[i] = (double)i * scale;
        }
        return testFrequencies;
    }
}

