/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.spectra.dst;

import de.gsi.math.spectra.dst.DoubleDST_1D;
import de.gsi.math.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class DoubleDST_2D {
    private final int rows;
    private final int columns;
    private double[] t;
    private final DoubleDST_1D dstColumns;
    private DoubleDST_1D dstRows;
    private int oldNthreads;
    private int nt;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public DoubleDST_2D(int rows, int columns) {
        if (rows <= 1 || columns <= 1) {
            throw new IllegalArgumentException("rows and columns must be greater than 1");
        }
        this.rows = rows;
        this.columns = columns;
        if (rows * columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.useThreads = true;
        }
        if (ConcurrencyUtils.isPowerOf2(rows) && ConcurrencyUtils.isPowerOf2(columns)) {
            this.isPowerOfTwo = true;
            this.oldNthreads = ConcurrencyUtils.getNumberOfThreads();
            this.nt = 4 * this.oldNthreads * rows;
            if (columns == 2 * this.oldNthreads) {
                this.nt >>= 1;
            } else if (columns < 2 * this.oldNthreads) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
        }
        this.dstColumns = new DoubleDST_1D(columns);
        this.dstRows = columns == rows ? this.dstColumns : new DoubleDST_1D(rows);
    }

    public void forward(final double[] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads != this.oldNthreads) {
                this.nt = 4 * nthreads * this.rows;
                if (this.columns == 2 * nthreads) {
                    this.nt >>= 1;
                } else if (this.columns < 2 * nthreads) {
                    this.nt >>= 2;
                }
                this.t = new double[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(-1, a, scale);
                this.ddxt2d0_subth(-1, a, scale);
            } else {
                this.ddxt2d_sub(-1, a, scale);
                for (int i = 0; i < this.rows; ++i) {
                    this.dstColumns.forward(a, i * this.columns, scale);
                }
            }
        } else if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
            int l;
            Future[] futures = new Future[nthreads];
            int p = this.rows / nthreads;
            for (l = 0; l < nthreads; ++l) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstRow; i < lastRow; ++i) {
                            DoubleDST_2D.this.dstColumns.forward(a, i * DoubleDST_2D.this.columns, scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.columns / nthreads;
            for (l = 0; l < nthreads; ++l) {
                final int firstColumn = l * p;
                final int lastColumn = l == nthreads - 1 ? this.columns : firstColumn + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDST_2D.this.rows];
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            int r;
                            for (r = 0; r < DoubleDST_2D.this.rows; ++r) {
                                temp[r] = a[r * DoubleDST_2D.this.columns + c];
                            }
                            DoubleDST_2D.this.dstRows.forward(temp, scale);
                            for (r = 0; r < DoubleDST_2D.this.rows; ++r) {
                                a[r * ((DoubleDST_2D)DoubleDST_2D.this).columns + c] = temp[r];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.dstColumns.forward(a, i * this.columns, scale);
            }
            double[] temp = new double[this.rows];
            for (int c = 0; c < this.columns; ++c) {
                int r;
                for (r = 0; r < this.rows; ++r) {
                    temp[r] = a[r * this.columns + c];
                }
                this.dstRows.forward(temp, scale);
                for (r = 0; r < this.rows; ++r) {
                    a[r * this.columns + c] = temp[r];
                }
            }
        }
    }

    public void forward(final double[][] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads != this.oldNthreads) {
                this.nt = 4 * nthreads * this.rows;
                if (this.columns == 2 * nthreads) {
                    this.nt >>= 1;
                } else if (this.columns < 2 * nthreads) {
                    this.nt >>= 2;
                }
                this.t = new double[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(-1, a, scale);
                this.ddxt2d0_subth(-1, a, scale);
            } else {
                this.ddxt2d_sub(-1, a, scale);
                for (int i = 0; i < this.rows; ++i) {
                    this.dstColumns.forward(a[i], scale);
                }
            }
        } else if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
            int l;
            Future[] futures = new Future[nthreads];
            int p = this.rows / nthreads;
            for (l = 0; l < nthreads; ++l) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstRow; i < lastRow; ++i) {
                            DoubleDST_2D.this.dstColumns.forward(a[i], scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.columns / nthreads;
            for (l = 0; l < nthreads; ++l) {
                final int firstColumn = l * p;
                final int lastColumn = l == nthreads - 1 ? this.columns : firstColumn + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDST_2D.this.rows];
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            int r;
                            for (r = 0; r < DoubleDST_2D.this.rows; ++r) {
                                temp[r] = a[r][c];
                            }
                            DoubleDST_2D.this.dstRows.forward(temp, scale);
                            for (r = 0; r < DoubleDST_2D.this.rows; ++r) {
                                a[r][c] = temp[r];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.dstColumns.forward(a[i], scale);
            }
            double[] temp = new double[this.rows];
            for (int c = 0; c < this.columns; ++c) {
                int r;
                for (r = 0; r < this.rows; ++r) {
                    temp[r] = a[r][c];
                }
                this.dstRows.forward(temp, scale);
                for (r = 0; r < this.rows; ++r) {
                    a[r][c] = temp[r];
                }
            }
        }
    }

    public void inverse(final double[] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads != this.oldNthreads) {
                this.nt = 4 * nthreads * this.rows;
                if (this.columns == 2 * nthreads) {
                    this.nt >>= 1;
                } else if (this.columns < 2 * nthreads) {
                    this.nt >>= 2;
                }
                this.t = new double[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(1, a, scale);
                this.ddxt2d0_subth(1, a, scale);
            } else {
                this.ddxt2d_sub(1, a, scale);
                for (int i = 0; i < this.rows; ++i) {
                    this.dstColumns.inverse(a, i * this.columns, scale);
                }
            }
        } else if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
            int l;
            Future[] futures = new Future[nthreads];
            int p = this.rows / nthreads;
            for (l = 0; l < nthreads; ++l) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstRow; i < lastRow; ++i) {
                            DoubleDST_2D.this.dstColumns.inverse(a, i * DoubleDST_2D.this.columns, scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.columns / nthreads;
            for (l = 0; l < nthreads; ++l) {
                final int firstColumn = l * p;
                final int lastColumn = l == nthreads - 1 ? this.columns : firstColumn + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDST_2D.this.rows];
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            int r;
                            for (r = 0; r < DoubleDST_2D.this.rows; ++r) {
                                temp[r] = a[r * DoubleDST_2D.this.columns + c];
                            }
                            DoubleDST_2D.this.dstRows.inverse(temp, scale);
                            for (r = 0; r < DoubleDST_2D.this.rows; ++r) {
                                a[r * ((DoubleDST_2D)DoubleDST_2D.this).columns + c] = temp[r];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.dstColumns.inverse(a, i * this.columns, scale);
            }
            double[] temp = new double[this.rows];
            for (int c = 0; c < this.columns; ++c) {
                int r;
                for (r = 0; r < this.rows; ++r) {
                    temp[r] = a[r * this.columns + c];
                }
                this.dstRows.inverse(temp, scale);
                for (r = 0; r < this.rows; ++r) {
                    a[r * this.columns + c] = temp[r];
                }
            }
        }
    }

    public void inverse(final double[][] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads != this.oldNthreads) {
                this.nt = 4 * nthreads * this.rows;
                if (this.columns == 2 * nthreads) {
                    this.nt >>= 1;
                } else if (this.columns < 2 * nthreads) {
                    this.nt >>= 2;
                }
                this.t = new double[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(1, a, scale);
                this.ddxt2d0_subth(1, a, scale);
            } else {
                this.ddxt2d_sub(1, a, scale);
                for (int i = 0; i < this.rows; ++i) {
                    this.dstColumns.inverse(a[i], scale);
                }
            }
        } else if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
            int l;
            Future[] futures = new Future[nthreads];
            int p = this.rows / nthreads;
            for (l = 0; l < nthreads; ++l) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstRow; i < lastRow; ++i) {
                            DoubleDST_2D.this.dstColumns.inverse(a[i], scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.columns / nthreads;
            for (l = 0; l < nthreads; ++l) {
                final int firstColumn = l * p;
                final int lastColumn = l == nthreads - 1 ? this.columns : firstColumn + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] temp = new double[DoubleDST_2D.this.rows];
                        for (int c = firstColumn; c < lastColumn; ++c) {
                            int r;
                            for (r = 0; r < DoubleDST_2D.this.rows; ++r) {
                                temp[r] = a[r][c];
                            }
                            DoubleDST_2D.this.dstRows.inverse(temp, scale);
                            for (r = 0; r < DoubleDST_2D.this.rows; ++r) {
                                a[r][c] = temp[r];
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                this.dstColumns.inverse(a[i], scale);
            }
            double[] temp = new double[this.rows];
            for (int c = 0; c < this.columns; ++c) {
                int r;
                for (r = 0; r < this.rows; ++r) {
                    temp[r] = a[r][c];
                }
                this.dstRows.inverse(temp, scale);
                for (r = 0; r < this.rows; ++r) {
                    a[r][c] = temp[r];
                }
            }
        }
    }

    private void ddxt2d_subth(final int isgn, final double[] a, final boolean scale) {
        int nthread = ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.rows;
        if (this.columns == 2 * nthread) {
            nt >>= 1;
        } else if (this.columns < 2 * nthread) {
            nthread = this.columns;
            nt >>= 2;
        }
        final int nthreads = nthread;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            final int startt = nt * i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block17: {
                        int r;
                        block18: {
                            int idx2;
                            int idx1;
                            int r2;
                            block16: {
                                if (DoubleDST_2D.this.columns <= 2 * nthreads) break block16;
                                if (isgn == -1) {
                                    for (int c = 4 * n0; c < DoubleDST_2D.this.columns; c += 4 * nthreads) {
                                        int idx22;
                                        int idx12;
                                        int r3;
                                        for (r3 = 0; r3 < DoubleDST_2D.this.rows; ++r3) {
                                            idx12 = r3 * DoubleDST_2D.this.columns + c;
                                            idx22 = startt + DoubleDST_2D.this.rows + r3;
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[startt + r3] = a[idx12];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[idx22] = a[idx12 + 1];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[idx22 + ((DoubleDST_2D)DoubleDST_2D.this).rows] = a[idx12 + 2];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[idx22 + 2 * ((DoubleDST_2D)DoubleDST_2D.this).rows] = a[idx12 + 3];
                                        }
                                        DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, startt, scale);
                                        DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, startt + DoubleDST_2D.this.rows, scale);
                                        DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, startt + 2 * DoubleDST_2D.this.rows, scale);
                                        DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, startt + 3 * DoubleDST_2D.this.rows, scale);
                                        for (r3 = 0; r3 < DoubleDST_2D.this.rows; ++r3) {
                                            idx12 = r3 * DoubleDST_2D.this.columns + c;
                                            idx22 = startt + DoubleDST_2D.this.rows + r3;
                                            a[idx12] = DoubleDST_2D.this.t[startt + r3];
                                            a[idx12 + 1] = DoubleDST_2D.this.t[idx22];
                                            a[idx12 + 2] = DoubleDST_2D.this.t[idx22 + DoubleDST_2D.this.rows];
                                            a[idx12 + 3] = DoubleDST_2D.this.t[idx22 + 2 * DoubleDST_2D.this.rows];
                                        }
                                    }
                                } else {
                                    for (int c = 4 * n0; c < DoubleDST_2D.this.columns; c += 4 * nthreads) {
                                        int idx23;
                                        int idx13;
                                        int r4;
                                        for (r4 = 0; r4 < DoubleDST_2D.this.rows; ++r4) {
                                            idx13 = r4 * DoubleDST_2D.this.columns + c;
                                            idx23 = startt + DoubleDST_2D.this.rows + r4;
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[startt + r4] = a[idx13];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[idx23] = a[idx13 + 1];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[idx23 + ((DoubleDST_2D)DoubleDST_2D.this).rows] = a[idx13 + 2];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[idx23 + 2 * ((DoubleDST_2D)DoubleDST_2D.this).rows] = a[idx13 + 3];
                                        }
                                        DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, startt, scale);
                                        DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, startt + DoubleDST_2D.this.rows, scale);
                                        DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, startt + 2 * DoubleDST_2D.this.rows, scale);
                                        DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, startt + 3 * DoubleDST_2D.this.rows, scale);
                                        for (r4 = 0; r4 < DoubleDST_2D.this.rows; ++r4) {
                                            idx13 = r4 * DoubleDST_2D.this.columns + c;
                                            idx23 = startt + DoubleDST_2D.this.rows + r4;
                                            a[idx13] = DoubleDST_2D.this.t[startt + r4];
                                            a[idx13 + 1] = DoubleDST_2D.this.t[idx23];
                                            a[idx13 + 2] = DoubleDST_2D.this.t[idx23 + DoubleDST_2D.this.rows];
                                            a[idx13 + 3] = DoubleDST_2D.this.t[idx23 + 2 * DoubleDST_2D.this.rows];
                                        }
                                    }
                                }
                                break block17;
                            }
                            if (DoubleDST_2D.this.columns != 2 * nthreads) break block18;
                            for (r2 = 0; r2 < DoubleDST_2D.this.rows; ++r2) {
                                idx1 = r2 * DoubleDST_2D.this.columns + 2 * n0;
                                idx2 = startt + r2;
                                ((DoubleDST_2D)DoubleDST_2D.this).t[idx2] = a[idx1];
                                ((DoubleDST_2D)DoubleDST_2D.this).t[idx2 + ((DoubleDST_2D)DoubleDST_2D.this).rows] = a[idx1 + 1];
                            }
                            if (isgn == -1) {
                                DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, startt, scale);
                                DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, startt + DoubleDST_2D.this.rows, scale);
                            } else {
                                DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, startt, scale);
                                DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, startt + DoubleDST_2D.this.rows, scale);
                            }
                            for (r2 = 0; r2 < DoubleDST_2D.this.rows; ++r2) {
                                idx1 = r2 * DoubleDST_2D.this.columns + 2 * n0;
                                idx2 = startt + r2;
                                a[idx1] = DoubleDST_2D.this.t[idx2];
                                a[idx1 + 1] = DoubleDST_2D.this.t[idx2 + DoubleDST_2D.this.rows];
                            }
                            break block17;
                        }
                        if (DoubleDST_2D.this.columns != nthreads) break block17;
                        for (r = 0; r < DoubleDST_2D.this.rows; ++r) {
                            ((DoubleDST_2D)DoubleDST_2D.this).t[startt + r] = a[r * DoubleDST_2D.this.columns + n0];
                        }
                        if (isgn == -1) {
                            DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, startt, scale);
                        } else {
                            DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, startt, scale);
                        }
                        for (r = 0; r < DoubleDST_2D.this.rows; ++r) {
                            a[r * ((DoubleDST_2D)DoubleDST_2D.this).columns + n0] = DoubleDST_2D.this.t[startt + r];
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void ddxt2d_subth(final int isgn, final double[][] a, final boolean scale) {
        int nthread = ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.rows;
        if (this.columns == 2 * nthread) {
            nt >>= 1;
        } else if (this.columns < 2 * nthread) {
            nthread = this.columns;
            nt >>= 2;
        }
        final int nthreads = nthread;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            final int startt = nt * i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block17: {
                        int r;
                        block18: {
                            int idx2;
                            int r2;
                            block16: {
                                if (DoubleDST_2D.this.columns <= 2 * nthreads) break block16;
                                if (isgn == -1) {
                                    for (int c = 4 * n0; c < DoubleDST_2D.this.columns; c += 4 * nthreads) {
                                        int idx22;
                                        int r3;
                                        for (r3 = 0; r3 < DoubleDST_2D.this.rows; ++r3) {
                                            idx22 = startt + DoubleDST_2D.this.rows + r3;
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[startt + r3] = a[r3][c];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[idx22] = a[r3][c + 1];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[idx22 + ((DoubleDST_2D)DoubleDST_2D.this).rows] = a[r3][c + 2];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[idx22 + 2 * ((DoubleDST_2D)DoubleDST_2D.this).rows] = a[r3][c + 3];
                                        }
                                        DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, startt, scale);
                                        DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, startt + DoubleDST_2D.this.rows, scale);
                                        DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, startt + 2 * DoubleDST_2D.this.rows, scale);
                                        DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, startt + 3 * DoubleDST_2D.this.rows, scale);
                                        for (r3 = 0; r3 < DoubleDST_2D.this.rows; ++r3) {
                                            idx22 = startt + DoubleDST_2D.this.rows + r3;
                                            a[r3][c] = DoubleDST_2D.this.t[startt + r3];
                                            a[r3][c + 1] = DoubleDST_2D.this.t[idx22];
                                            a[r3][c + 2] = DoubleDST_2D.this.t[idx22 + DoubleDST_2D.this.rows];
                                            a[r3][c + 3] = DoubleDST_2D.this.t[idx22 + 2 * DoubleDST_2D.this.rows];
                                        }
                                    }
                                } else {
                                    for (int c = 4 * n0; c < DoubleDST_2D.this.columns; c += 4 * nthreads) {
                                        int idx23;
                                        int r4;
                                        for (r4 = 0; r4 < DoubleDST_2D.this.rows; ++r4) {
                                            idx23 = startt + DoubleDST_2D.this.rows + r4;
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[startt + r4] = a[r4][c];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[idx23] = a[r4][c + 1];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[idx23 + ((DoubleDST_2D)DoubleDST_2D.this).rows] = a[r4][c + 2];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[idx23 + 2 * ((DoubleDST_2D)DoubleDST_2D.this).rows] = a[r4][c + 3];
                                        }
                                        DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, startt, scale);
                                        DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, startt + DoubleDST_2D.this.rows, scale);
                                        DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, startt + 2 * DoubleDST_2D.this.rows, scale);
                                        DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, startt + 3 * DoubleDST_2D.this.rows, scale);
                                        for (r4 = 0; r4 < DoubleDST_2D.this.rows; ++r4) {
                                            idx23 = startt + DoubleDST_2D.this.rows + r4;
                                            a[r4][c] = DoubleDST_2D.this.t[startt + r4];
                                            a[r4][c + 1] = DoubleDST_2D.this.t[idx23];
                                            a[r4][c + 2] = DoubleDST_2D.this.t[idx23 + DoubleDST_2D.this.rows];
                                            a[r4][c + 3] = DoubleDST_2D.this.t[idx23 + 2 * DoubleDST_2D.this.rows];
                                        }
                                    }
                                }
                                break block17;
                            }
                            if (DoubleDST_2D.this.columns != 2 * nthreads) break block18;
                            for (r2 = 0; r2 < DoubleDST_2D.this.rows; ++r2) {
                                idx2 = startt + r2;
                                ((DoubleDST_2D)DoubleDST_2D.this).t[idx2] = a[r2][2 * n0];
                                ((DoubleDST_2D)DoubleDST_2D.this).t[idx2 + ((DoubleDST_2D)DoubleDST_2D.this).rows] = a[r2][2 * n0 + 1];
                            }
                            if (isgn == -1) {
                                DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, startt, scale);
                                DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, startt + DoubleDST_2D.this.rows, scale);
                            } else {
                                DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, startt, scale);
                                DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, startt + DoubleDST_2D.this.rows, scale);
                            }
                            for (r2 = 0; r2 < DoubleDST_2D.this.rows; ++r2) {
                                idx2 = startt + r2;
                                a[r2][2 * n0] = DoubleDST_2D.this.t[idx2];
                                a[r2][2 * n0 + 1] = DoubleDST_2D.this.t[idx2 + DoubleDST_2D.this.rows];
                            }
                            break block17;
                        }
                        if (DoubleDST_2D.this.columns != nthreads) break block17;
                        for (r = 0; r < DoubleDST_2D.this.rows; ++r) {
                            ((DoubleDST_2D)DoubleDST_2D.this).t[startt + r] = a[r][n0];
                        }
                        if (isgn == -1) {
                            DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, startt, scale);
                        } else {
                            DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, startt, scale);
                        }
                        for (r = 0; r < DoubleDST_2D.this.rows; ++r) {
                            a[r][n0] = DoubleDST_2D.this.t[startt + r];
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void ddxt2d0_subth(final int isgn, final double[] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (isgn == -1) {
                        for (int r = n0; r < DoubleDST_2D.this.rows; r += nthreads) {
                            DoubleDST_2D.this.dstColumns.forward(a, r * DoubleDST_2D.this.columns, scale);
                        }
                    } else {
                        for (int r = n0; r < DoubleDST_2D.this.rows; r += nthreads) {
                            DoubleDST_2D.this.dstColumns.inverse(a, r * DoubleDST_2D.this.columns, scale);
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void ddxt2d0_subth(final int isgn, final double[][] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (isgn == -1) {
                        for (int r = n0; r < DoubleDST_2D.this.rows; r += nthreads) {
                            DoubleDST_2D.this.dstColumns.forward(a[r], scale);
                        }
                    } else {
                        for (int r = n0; r < DoubleDST_2D.this.rows; r += nthreads) {
                            DoubleDST_2D.this.dstColumns.inverse(a[r], scale);
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void ddxt2d_sub(int isgn, double[] a, boolean scale) {
        block13: {
            int idx1;
            int r;
            block12: {
                if (this.columns <= 2) break block12;
                if (isgn == -1) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int idx12;
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx12 = r2 * this.columns + c;
                            idx2 = this.rows + r2;
                            this.t[r2] = a[idx12];
                            this.t[idx2] = a[idx12 + 1];
                            this.t[idx2 + this.rows] = a[idx12 + 2];
                            this.t[idx2 + 2 * this.rows] = a[idx12 + 3];
                        }
                        this.dstRows.forward(this.t, 0, scale);
                        this.dstRows.forward(this.t, this.rows, scale);
                        this.dstRows.forward(this.t, 2 * this.rows, scale);
                        this.dstRows.forward(this.t, 3 * this.rows, scale);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx12 = r2 * this.columns + c;
                            idx2 = this.rows + r2;
                            a[idx12] = this.t[r2];
                            a[idx12 + 1] = this.t[idx2];
                            a[idx12 + 2] = this.t[idx2 + this.rows];
                            a[idx12 + 3] = this.t[idx2 + 2 * this.rows];
                        }
                    }
                } else {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int idx13;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx13 = r3 * this.columns + c;
                            idx2 = this.rows + r3;
                            this.t[r3] = a[idx13];
                            this.t[idx2] = a[idx13 + 1];
                            this.t[idx2 + this.rows] = a[idx13 + 2];
                            this.t[idx2 + 2 * this.rows] = a[idx13 + 3];
                        }
                        this.dstRows.inverse(this.t, 0, scale);
                        this.dstRows.inverse(this.t, this.rows, scale);
                        this.dstRows.inverse(this.t, 2 * this.rows, scale);
                        this.dstRows.inverse(this.t, 3 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx13 = r3 * this.columns + c;
                            idx2 = this.rows + r3;
                            a[idx13] = this.t[r3];
                            a[idx13 + 1] = this.t[idx2];
                            a[idx13 + 2] = this.t[idx2 + this.rows];
                            a[idx13 + 3] = this.t[idx2 + 2 * this.rows];
                        }
                    }
                }
                break block13;
            }
            if (this.columns != 2) break block13;
            for (r = 0; r < this.rows; ++r) {
                idx1 = r * this.columns;
                this.t[r] = a[idx1];
                this.t[this.rows + r] = a[idx1 + 1];
            }
            if (isgn == -1) {
                this.dstRows.forward(this.t, 0, scale);
                this.dstRows.forward(this.t, this.rows, scale);
            } else {
                this.dstRows.inverse(this.t, 0, scale);
                this.dstRows.inverse(this.t, this.rows, scale);
            }
            for (r = 0; r < this.rows; ++r) {
                idx1 = r * this.columns;
                a[idx1] = this.t[r];
                a[idx1 + 1] = this.t[this.rows + r];
            }
        }
    }

    private void ddxt2d_sub(int isgn, double[][] a, boolean scale) {
        block13: {
            int r;
            block12: {
                if (this.columns <= 2) break block12;
                if (isgn == -1) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx2 = this.rows + r2;
                            this.t[r2] = a[r2][c];
                            this.t[idx2] = a[r2][c + 1];
                            this.t[idx2 + this.rows] = a[r2][c + 2];
                            this.t[idx2 + 2 * this.rows] = a[r2][c + 3];
                        }
                        this.dstRows.forward(this.t, 0, scale);
                        this.dstRows.forward(this.t, this.rows, scale);
                        this.dstRows.forward(this.t, 2 * this.rows, scale);
                        this.dstRows.forward(this.t, 3 * this.rows, scale);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx2 = this.rows + r2;
                            a[r2][c] = this.t[r2];
                            a[r2][c + 1] = this.t[idx2];
                            a[r2][c + 2] = this.t[idx2 + this.rows];
                            a[r2][c + 3] = this.t[idx2 + 2 * this.rows];
                        }
                    }
                } else {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = this.rows + r3;
                            this.t[r3] = a[r3][c];
                            this.t[idx2] = a[r3][c + 1];
                            this.t[idx2 + this.rows] = a[r3][c + 2];
                            this.t[idx2 + 2 * this.rows] = a[r3][c + 3];
                        }
                        this.dstRows.inverse(this.t, 0, scale);
                        this.dstRows.inverse(this.t, this.rows, scale);
                        this.dstRows.inverse(this.t, 2 * this.rows, scale);
                        this.dstRows.inverse(this.t, 3 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = this.rows + r3;
                            a[r3][c] = this.t[r3];
                            a[r3][c + 1] = this.t[idx2];
                            a[r3][c + 2] = this.t[idx2 + this.rows];
                            a[r3][c + 3] = this.t[idx2 + 2 * this.rows];
                        }
                    }
                }
                break block13;
            }
            if (this.columns != 2) break block13;
            for (r = 0; r < this.rows; ++r) {
                this.t[r] = a[r][0];
                this.t[this.rows + r] = a[r][1];
            }
            if (isgn == -1) {
                this.dstRows.forward(this.t, 0, scale);
                this.dstRows.forward(this.t, this.rows, scale);
            } else {
                this.dstRows.inverse(this.t, 0, scale);
                this.dstRows.inverse(this.t, this.rows, scale);
            }
            for (r = 0; r < this.rows; ++r) {
                a[r][0] = this.t[r];
                a[r][1] = this.t[this.rows + r];
            }
        }
    }
}

