/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.spectra.dst;

import de.gsi.math.spectra.dct.DoubleDCT_1D;
import de.gsi.math.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class DoubleDST_1D {
    private final int n;
    private final DoubleDCT_1D dct;

    public DoubleDST_1D(int n) {
        this.n = n;
        this.dct = new DoubleDCT_1D(n);
    }

    public void forward(double[] a, boolean scale) {
        this.forward(a, 0, scale);
    }

    public void forward(final double[] a, final int offa, boolean scale) {
        if (this.n == 1) {
            return;
        }
        int nd2 = this.n / 2;
        int startIdx = 1 + offa;
        int stopIdx = offa + this.n;
        for (int i = startIdx; i < stopIdx; i += 2) {
            a[i] = -a[i];
        }
        this.dct.forward(a, offa, scale);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && nd2 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            nthreads = 2;
            int k = nd2 / nthreads;
            Future[] futures = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? nd2 : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx0 = offa + DoubleDST_1D.this.n - 1;
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            int idx2 = offa + i;
                            double tmp = a[idx2];
                            int idx1 = idx0 - i;
                            a[idx2] = a[idx1];
                            a[idx1] = tmp;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx0 = offa + this.n - 1;
            for (int i = 0; i < nd2; ++i) {
                int idx2 = offa + i;
                double tmp = a[idx2];
                int idx1 = idx0 - i;
                a[idx2] = a[idx1];
                a[idx1] = tmp;
            }
        }
    }

    public void inverse(double[] a, boolean scale) {
        this.inverse(a, 0, scale);
    }

    public void inverse(final double[] a, final int offa, boolean scale) {
        if (this.n == 1) {
            return;
        }
        int nd2 = this.n / 2;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && nd2 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            nthreads = 2;
            int k = nd2 / nthreads;
            Future[] futures = new Future[nthreads];
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? nd2 : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx0 = offa + DoubleDST_1D.this.n - 1;
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            int idx2 = offa + i;
                            double tmp = a[idx2];
                            int idx1 = idx0 - i;
                            a[idx2] = a[idx1];
                            a[idx1] = tmp;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx0 = offa + this.n - 1;
            for (int i = 0; i < nd2; ++i) {
                double tmp = a[offa + i];
                a[offa + i] = a[idx0 - i];
                a[idx0 - i] = tmp;
            }
        }
        this.dct.inverse(a, offa, scale);
        int startidx = 1 + offa;
        int stopidx = offa + this.n;
        for (int i = startidx; i < stopidx; i += 2) {
            a[i] = -a[i];
        }
    }
}

