/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.spectra.dht;

import de.gsi.math.spectra.dht.FloatDHT_1D;
import de.gsi.math.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class FloatDHT_3D {
    private final int slices;
    private final int rows;
    private final int columns;
    private final int sliceStride;
    private final int rowStride;
    private float[] t;
    private final FloatDHT_1D dhtSlices;
    private FloatDHT_1D dhtRows;
    private FloatDHT_1D dhtColumns;
    private int oldNthreads;
    private int nt;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public FloatDHT_3D(int slices, int rows, int columns) {
        if (slices <= 1 || rows <= 1 || columns <= 1) {
            throw new IllegalArgumentException("slices, rows and columns must be greater than 1");
        }
        this.slices = slices;
        this.rows = rows;
        this.columns = columns;
        this.sliceStride = rows * columns;
        this.rowStride = columns;
        if (slices * rows * columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.useThreads = true;
        }
        if (ConcurrencyUtils.isPowerOf2(slices) && ConcurrencyUtils.isPowerOf2(rows) && ConcurrencyUtils.isPowerOf2(columns)) {
            this.isPowerOfTwo = true;
            this.oldNthreads = ConcurrencyUtils.getNumberOfThreads();
            this.nt = slices;
            if (this.nt < rows) {
                this.nt = rows;
            }
            this.nt *= 4;
            if (this.oldNthreads > 1) {
                this.nt *= this.oldNthreads;
            }
            if (columns == 2) {
                this.nt >>= 1;
            }
            this.t = new float[this.nt];
        }
        this.dhtSlices = new FloatDHT_1D(slices);
        this.dhtRows = slices == rows ? this.dhtSlices : new FloatDHT_1D(rows);
        this.dhtColumns = slices == columns ? this.dhtSlices : (rows == columns ? this.dhtRows : new FloatDHT_1D(columns));
    }

    public void forward(final float[] a) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 4;
                if (nthreads > 1) {
                    this.nt *= nthreads;
                }
                if (this.columns == 2) {
                    this.nt >>= 1;
                }
                this.t = new float[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, a, true);
                this.ddxt3db_subth(-1, a, true);
            } else {
                this.ddxt3da_sub(-1, a, true);
                this.ddxt3db_sub(-1, a, true);
            }
            this.yTransform(a);
        } else {
            if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
                int lastSlice;
                int firstSlice;
                int l;
                Future[] futures = new Future[nthreads];
                int p = this.slices / nthreads;
                for (l = 0; l < nthreads; ++l) {
                    firstSlice = l * p;
                    lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                int idx1 = s * FloatDHT_3D.this.sliceStride;
                                for (int r = 0; r < FloatDHT_3D.this.rows; ++r) {
                                    FloatDHT_3D.this.dhtColumns.forward(a, idx1 + r * FloatDHT_3D.this.rowStride);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
                for (l = 0; l < nthreads; ++l) {
                    firstSlice = l * p;
                    lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] temp = new float[FloatDHT_3D.this.rows];
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                int idx1 = s * FloatDHT_3D.this.sliceStride;
                                for (int c = 0; c < FloatDHT_3D.this.columns; ++c) {
                                    int idx3;
                                    int r;
                                    for (r = 0; r < FloatDHT_3D.this.rows; ++r) {
                                        idx3 = idx1 + r * FloatDHT_3D.this.rowStride + c;
                                        temp[r] = a[idx3];
                                    }
                                    FloatDHT_3D.this.dhtRows.forward(temp);
                                    for (r = 0; r < FloatDHT_3D.this.rows; ++r) {
                                        idx3 = idx1 + r * FloatDHT_3D.this.rowStride + c;
                                        a[idx3] = temp[r];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
                p = this.rows / nthreads;
                for (l = 0; l < nthreads; ++l) {
                    final int startRow = l * p;
                    final int stopRow = l == nthreads - 1 ? this.rows : startRow + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] temp = new float[FloatDHT_3D.this.slices];
                            for (int r = startRow; r < stopRow; ++r) {
                                int idx1 = r * FloatDHT_3D.this.rowStride;
                                for (int c = 0; c < FloatDHT_3D.this.columns; ++c) {
                                    int idx3;
                                    int s;
                                    for (s = 0; s < FloatDHT_3D.this.slices; ++s) {
                                        idx3 = s * FloatDHT_3D.this.sliceStride + idx1 + c;
                                        temp[s] = a[idx3];
                                    }
                                    FloatDHT_3D.this.dhtSlices.forward(temp);
                                    for (s = 0; s < FloatDHT_3D.this.slices; ++s) {
                                        idx3 = s * FloatDHT_3D.this.sliceStride + idx1 + c;
                                        a[idx3] = temp[s];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idx3;
                int c;
                int idx1;
                for (int s = 0; s < this.slices; ++s) {
                    int idx12 = s * this.sliceStride;
                    for (int r = 0; r < this.rows; ++r) {
                        this.dhtColumns.forward(a, idx12 + r * this.rowStride);
                    }
                }
                float[] temp = new float[this.rows];
                for (int s = 0; s < this.slices; ++s) {
                    idx1 = s * this.sliceStride;
                    for (c = 0; c < this.columns; ++c) {
                        int r;
                        for (r = 0; r < this.rows; ++r) {
                            idx3 = idx1 + r * this.rowStride + c;
                            temp[r] = a[idx3];
                        }
                        this.dhtRows.forward(temp);
                        for (r = 0; r < this.rows; ++r) {
                            idx3 = idx1 + r * this.rowStride + c;
                            a[idx3] = temp[r];
                        }
                    }
                }
                temp = new float[this.slices];
                for (int r = 0; r < this.rows; ++r) {
                    idx1 = r * this.rowStride;
                    for (c = 0; c < this.columns; ++c) {
                        int s;
                        for (s = 0; s < this.slices; ++s) {
                            idx3 = s * this.sliceStride + idx1 + c;
                            temp[s] = a[idx3];
                        }
                        this.dhtSlices.forward(temp);
                        for (s = 0; s < this.slices; ++s) {
                            idx3 = s * this.sliceStride + idx1 + c;
                            a[idx3] = temp[s];
                        }
                    }
                }
            }
            this.yTransform(a);
        }
    }

    public void forward(final float[][][] a) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 4;
                if (nthreads > 1) {
                    this.nt *= nthreads;
                }
                if (this.columns == 2) {
                    this.nt >>= 1;
                }
                this.t = new float[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, a, true);
                this.ddxt3db_subth(-1, a, true);
            } else {
                this.ddxt3da_sub(-1, a, true);
                this.ddxt3db_sub(-1, a, true);
            }
            this.yTransform(a);
        } else {
            if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
                int lastSlice;
                int firstSlice;
                int l;
                Future[] futures = new Future[nthreads];
                int p = this.slices / nthreads;
                for (l = 0; l < nthreads; ++l) {
                    firstSlice = l * p;
                    lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                for (int r = 0; r < FloatDHT_3D.this.rows; ++r) {
                                    FloatDHT_3D.this.dhtColumns.forward(a[s][r]);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
                for (l = 0; l < nthreads; ++l) {
                    firstSlice = l * p;
                    lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] temp = new float[FloatDHT_3D.this.rows];
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                for (int c = 0; c < FloatDHT_3D.this.columns; ++c) {
                                    int r;
                                    for (r = 0; r < FloatDHT_3D.this.rows; ++r) {
                                        temp[r] = a[s][r][c];
                                    }
                                    FloatDHT_3D.this.dhtRows.forward(temp);
                                    for (r = 0; r < FloatDHT_3D.this.rows; ++r) {
                                        a[s][r][c] = temp[r];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
                p = this.rows / nthreads;
                for (l = 0; l < nthreads; ++l) {
                    final int firstRow = l * p;
                    final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] temp = new float[FloatDHT_3D.this.slices];
                            for (int r = firstRow; r < lastRow; ++r) {
                                for (int c = 0; c < FloatDHT_3D.this.columns; ++c) {
                                    int s;
                                    for (s = 0; s < FloatDHT_3D.this.slices; ++s) {
                                        temp[s] = a[s][r][c];
                                    }
                                    FloatDHT_3D.this.dhtSlices.forward(temp);
                                    for (s = 0; s < FloatDHT_3D.this.slices; ++s) {
                                        a[s][r][c] = temp[s];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int c;
                int r;
                for (int s = 0; s < this.slices; ++s) {
                    for (r = 0; r < this.rows; ++r) {
                        this.dhtColumns.forward(a[s][r]);
                    }
                }
                float[] temp = new float[this.rows];
                for (int s = 0; s < this.slices; ++s) {
                    for (c = 0; c < this.columns; ++c) {
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            temp[r2] = a[s][r2][c];
                        }
                        this.dhtRows.forward(temp);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            a[s][r2][c] = temp[r2];
                        }
                    }
                }
                temp = new float[this.slices];
                for (r = 0; r < this.rows; ++r) {
                    for (c = 0; c < this.columns; ++c) {
                        int s;
                        for (s = 0; s < this.slices; ++s) {
                            temp[s] = a[s][r][c];
                        }
                        this.dhtSlices.forward(temp);
                        for (s = 0; s < this.slices; ++s) {
                            a[s][r][c] = temp[s];
                        }
                    }
                }
            }
            this.yTransform(a);
        }
    }

    public void inverse(final float[] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 4;
                if (nthreads > 1) {
                    this.nt *= nthreads;
                }
                if (this.columns == 2) {
                    this.nt >>= 1;
                }
                this.t = new float[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(1, a, scale);
                this.ddxt3db_subth(1, a, scale);
            } else {
                this.ddxt3da_sub(1, a, scale);
                this.ddxt3db_sub(1, a, scale);
            }
            this.yTransform(a);
        } else {
            if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
                int lastSlice;
                int firstSlice;
                int l;
                Future[] futures = new Future[nthreads];
                int p = this.slices / nthreads;
                for (l = 0; l < nthreads; ++l) {
                    firstSlice = l * p;
                    lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                int idx1 = s * FloatDHT_3D.this.sliceStride;
                                for (int r = 0; r < FloatDHT_3D.this.rows; ++r) {
                                    FloatDHT_3D.this.dhtColumns.inverse(a, idx1 + r * FloatDHT_3D.this.rowStride, scale);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
                for (l = 0; l < nthreads; ++l) {
                    firstSlice = l * p;
                    lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] temp = new float[FloatDHT_3D.this.rows];
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                int idx1 = s * FloatDHT_3D.this.sliceStride;
                                for (int c = 0; c < FloatDHT_3D.this.columns; ++c) {
                                    int idx3;
                                    int r;
                                    for (r = 0; r < FloatDHT_3D.this.rows; ++r) {
                                        idx3 = idx1 + r * FloatDHT_3D.this.rowStride + c;
                                        temp[r] = a[idx3];
                                    }
                                    FloatDHT_3D.this.dhtRows.inverse(temp, scale);
                                    for (r = 0; r < FloatDHT_3D.this.rows; ++r) {
                                        idx3 = idx1 + r * FloatDHT_3D.this.rowStride + c;
                                        a[idx3] = temp[r];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
                p = this.rows / nthreads;
                for (l = 0; l < nthreads; ++l) {
                    final int firstRow = l * p;
                    final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] temp = new float[FloatDHT_3D.this.slices];
                            for (int r = firstRow; r < lastRow; ++r) {
                                int idx1 = r * FloatDHT_3D.this.rowStride;
                                for (int c = 0; c < FloatDHT_3D.this.columns; ++c) {
                                    int idx3;
                                    int s;
                                    for (s = 0; s < FloatDHT_3D.this.slices; ++s) {
                                        idx3 = s * FloatDHT_3D.this.sliceStride + idx1 + c;
                                        temp[s] = a[idx3];
                                    }
                                    FloatDHT_3D.this.dhtSlices.inverse(temp, scale);
                                    for (s = 0; s < FloatDHT_3D.this.slices; ++s) {
                                        idx3 = s * FloatDHT_3D.this.sliceStride + idx1 + c;
                                        a[idx3] = temp[s];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int idx3;
                int c;
                int idx1;
                for (int s = 0; s < this.slices; ++s) {
                    int idx12 = s * this.sliceStride;
                    for (int r = 0; r < this.rows; ++r) {
                        this.dhtColumns.inverse(a, idx12 + r * this.rowStride, scale);
                    }
                }
                float[] temp = new float[this.rows];
                for (int s = 0; s < this.slices; ++s) {
                    idx1 = s * this.sliceStride;
                    for (c = 0; c < this.columns; ++c) {
                        int r;
                        for (r = 0; r < this.rows; ++r) {
                            idx3 = idx1 + r * this.rowStride + c;
                            temp[r] = a[idx3];
                        }
                        this.dhtRows.inverse(temp, scale);
                        for (r = 0; r < this.rows; ++r) {
                            idx3 = idx1 + r * this.rowStride + c;
                            a[idx3] = temp[r];
                        }
                    }
                }
                temp = new float[this.slices];
                for (int r = 0; r < this.rows; ++r) {
                    idx1 = r * this.rowStride;
                    for (c = 0; c < this.columns; ++c) {
                        int s;
                        for (s = 0; s < this.slices; ++s) {
                            idx3 = s * this.sliceStride + idx1 + c;
                            temp[s] = a[idx3];
                        }
                        this.dhtSlices.inverse(temp, scale);
                        for (s = 0; s < this.slices; ++s) {
                            idx3 = s * this.sliceStride + idx1 + c;
                            a[idx3] = temp[s];
                        }
                    }
                }
            }
            this.yTransform(a);
        }
    }

    public void inverse(final float[][][] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 4;
                if (nthreads > 1) {
                    this.nt *= nthreads;
                }
                if (this.columns == 2) {
                    this.nt >>= 1;
                }
                this.t = new float[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(1, a, scale);
                this.ddxt3db_subth(1, a, scale);
            } else {
                this.ddxt3da_sub(1, a, scale);
                this.ddxt3db_sub(1, a, scale);
            }
            this.yTransform(a);
        } else {
            if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
                int lastSlice;
                int firstSlice;
                int l;
                Future[] futures = new Future[nthreads];
                int p = this.slices / nthreads;
                for (l = 0; l < nthreads; ++l) {
                    firstSlice = l * p;
                    lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                for (int r = 0; r < FloatDHT_3D.this.rows; ++r) {
                                    FloatDHT_3D.this.dhtColumns.inverse(a[s][r], scale);
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
                for (l = 0; l < nthreads; ++l) {
                    firstSlice = l * p;
                    lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] temp = new float[FloatDHT_3D.this.rows];
                            for (int s = firstSlice; s < lastSlice; ++s) {
                                for (int c = 0; c < FloatDHT_3D.this.columns; ++c) {
                                    int r;
                                    for (r = 0; r < FloatDHT_3D.this.rows; ++r) {
                                        temp[r] = a[s][r][c];
                                    }
                                    FloatDHT_3D.this.dhtRows.inverse(temp, scale);
                                    for (r = 0; r < FloatDHT_3D.this.rows; ++r) {
                                        a[s][r][c] = temp[r];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
                p = this.rows / nthreads;
                for (l = 0; l < nthreads; ++l) {
                    final int firstRow = l * p;
                    final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] temp = new float[FloatDHT_3D.this.slices];
                            for (int r = firstRow; r < lastRow; ++r) {
                                for (int c = 0; c < FloatDHT_3D.this.columns; ++c) {
                                    int s;
                                    for (s = 0; s < FloatDHT_3D.this.slices; ++s) {
                                        temp[s] = a[s][r][c];
                                    }
                                    FloatDHT_3D.this.dhtSlices.inverse(temp, scale);
                                    for (s = 0; s < FloatDHT_3D.this.slices; ++s) {
                                        a[s][r][c] = temp[s];
                                    }
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                int c;
                int r;
                for (int s = 0; s < this.slices; ++s) {
                    for (r = 0; r < this.rows; ++r) {
                        this.dhtColumns.inverse(a[s][r], scale);
                    }
                }
                float[] temp = new float[this.rows];
                for (int s = 0; s < this.slices; ++s) {
                    for (c = 0; c < this.columns; ++c) {
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            temp[r2] = a[s][r2][c];
                        }
                        this.dhtRows.inverse(temp, scale);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            a[s][r2][c] = temp[r2];
                        }
                    }
                }
                temp = new float[this.slices];
                for (r = 0; r < this.rows; ++r) {
                    for (c = 0; c < this.columns; ++c) {
                        int s;
                        for (s = 0; s < this.slices; ++s) {
                            temp[s] = a[s][r][c];
                        }
                        this.dhtSlices.inverse(temp, scale);
                        for (s = 0; s < this.slices; ++s) {
                            a[s][r][c] = temp[s];
                        }
                    }
                }
            }
            this.yTransform(a);
        }
    }

    private void ddxt3da_sub(int isgn, float[] a, boolean scale) {
        if (isgn == -1) {
            for (int s = 0; s < this.slices; ++s) {
                int idx1;
                int r;
                int idx0 = s * this.sliceStride;
                for (r = 0; r < this.rows; ++r) {
                    this.dhtColumns.forward(a, idx0 + r * this.rowStride);
                }
                if (this.columns > 2) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx1 = idx0 + r2 * this.rowStride + c;
                            idx2 = this.rows + r2;
                            this.t[r2] = a[idx1];
                            this.t[idx2] = a[idx1 + 1];
                            this.t[idx2 + this.rows] = a[idx1 + 2];
                            this.t[idx2 + 2 * this.rows] = a[idx1 + 3];
                        }
                        this.dhtRows.forward(this.t, 0);
                        this.dhtRows.forward(this.t, this.rows);
                        this.dhtRows.forward(this.t, 2 * this.rows);
                        this.dhtRows.forward(this.t, 3 * this.rows);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx1 = idx0 + r2 * this.rowStride + c;
                            idx2 = this.rows + r2;
                            a[idx1] = this.t[r2];
                            a[idx1 + 1] = this.t[idx2];
                            a[idx1 + 2] = this.t[idx2 + this.rows];
                            a[idx1 + 3] = this.t[idx2 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    this.t[r] = a[idx1];
                    this.t[this.rows + r] = a[idx1 + 1];
                }
                this.dhtRows.forward(this.t, 0);
                this.dhtRows.forward(this.t, this.rows);
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    a[idx1] = this.t[r];
                    a[idx1 + 1] = this.t[this.rows + r];
                }
            }
        } else {
            for (int s = 0; s < this.slices; ++s) {
                int idx1;
                int r;
                int idx0 = s * this.sliceStride;
                for (r = 0; r < this.rows; ++r) {
                    this.dhtColumns.inverse(a, idx0 + r * this.rowStride, scale);
                }
                if (this.columns > 2) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx1 = idx0 + r3 * this.rowStride + c;
                            idx2 = this.rows + r3;
                            this.t[r3] = a[idx1];
                            this.t[idx2] = a[idx1 + 1];
                            this.t[idx2 + this.rows] = a[idx1 + 2];
                            this.t[idx2 + 2 * this.rows] = a[idx1 + 3];
                        }
                        this.dhtRows.inverse(this.t, 0, scale);
                        this.dhtRows.inverse(this.t, this.rows, scale);
                        this.dhtRows.inverse(this.t, 2 * this.rows, scale);
                        this.dhtRows.inverse(this.t, 3 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx1 = idx0 + r3 * this.rowStride + c;
                            idx2 = this.rows + r3;
                            a[idx1] = this.t[r3];
                            a[idx1 + 1] = this.t[idx2];
                            a[idx1 + 2] = this.t[idx2 + this.rows];
                            a[idx1 + 3] = this.t[idx2 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    this.t[r] = a[idx1];
                    this.t[this.rows + r] = a[idx1 + 1];
                }
                this.dhtRows.inverse(this.t, 0, scale);
                this.dhtRows.inverse(this.t, this.rows, scale);
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    a[idx1] = this.t[r];
                    a[idx1 + 1] = this.t[this.rows + r];
                }
            }
        }
    }

    private void ddxt3da_sub(int isgn, float[][][] a, boolean scale) {
        if (isgn == -1) {
            for (int s = 0; s < this.slices; ++s) {
                int r;
                for (r = 0; r < this.rows; ++r) {
                    this.dhtColumns.forward(a[s][r]);
                }
                if (this.columns > 2) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx2 = this.rows + r2;
                            this.t[r2] = a[s][r2][c];
                            this.t[idx2] = a[s][r2][c + 1];
                            this.t[idx2 + this.rows] = a[s][r2][c + 2];
                            this.t[idx2 + 2 * this.rows] = a[s][r2][c + 3];
                        }
                        this.dhtRows.forward(this.t, 0);
                        this.dhtRows.forward(this.t, this.rows);
                        this.dhtRows.forward(this.t, 2 * this.rows);
                        this.dhtRows.forward(this.t, 3 * this.rows);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx2 = this.rows + r2;
                            a[s][r2][c] = this.t[r2];
                            a[s][r2][c + 1] = this.t[idx2];
                            a[s][r2][c + 2] = this.t[idx2 + this.rows];
                            a[s][r2][c + 3] = this.t[idx2 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    this.t[r] = a[s][r][0];
                    this.t[this.rows + r] = a[s][r][1];
                }
                this.dhtRows.forward(this.t, 0);
                this.dhtRows.forward(this.t, this.rows);
                for (r = 0; r < this.rows; ++r) {
                    a[s][r][0] = this.t[r];
                    a[s][r][1] = this.t[this.rows + r];
                }
            }
        } else {
            for (int s = 0; s < this.slices; ++s) {
                int r;
                for (r = 0; r < this.rows; ++r) {
                    this.dhtColumns.inverse(a[s][r], scale);
                }
                if (this.columns > 2) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = this.rows + r3;
                            this.t[r3] = a[s][r3][c];
                            this.t[idx2] = a[s][r3][c + 1];
                            this.t[idx2 + this.rows] = a[s][r3][c + 2];
                            this.t[idx2 + 2 * this.rows] = a[s][r3][c + 3];
                        }
                        this.dhtRows.inverse(this.t, 0, scale);
                        this.dhtRows.inverse(this.t, this.rows, scale);
                        this.dhtRows.inverse(this.t, 2 * this.rows, scale);
                        this.dhtRows.inverse(this.t, 3 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = this.rows + r3;
                            a[s][r3][c] = this.t[r3];
                            a[s][r3][c + 1] = this.t[idx2];
                            a[s][r3][c + 2] = this.t[idx2 + this.rows];
                            a[s][r3][c + 3] = this.t[idx2 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    this.t[r] = a[s][r][0];
                    this.t[this.rows + r] = a[s][r][1];
                }
                this.dhtRows.inverse(this.t, 0, scale);
                this.dhtRows.inverse(this.t, this.rows, scale);
                for (r = 0; r < this.rows; ++r) {
                    a[s][r][0] = this.t[r];
                    a[s][r][1] = this.t[this.rows + r];
                }
            }
        }
    }

    private void ddxt3db_sub(int isgn, float[] a, boolean scale) {
        block19: {
            block17: {
                block18: {
                    if (isgn != -1) break block17;
                    if (this.columns <= 2) break block18;
                    for (int r = 0; r < this.rows; ++r) {
                        int idx0 = r * this.rowStride;
                        for (int c = 0; c < this.columns; c += 4) {
                            int idx2;
                            int idx1;
                            int s;
                            for (s = 0; s < this.slices; ++s) {
                                idx1 = s * this.sliceStride + idx0 + c;
                                idx2 = this.slices + s;
                                this.t[s] = a[idx1];
                                this.t[idx2] = a[idx1 + 1];
                                this.t[idx2 + this.slices] = a[idx1 + 2];
                                this.t[idx2 + 2 * this.slices] = a[idx1 + 3];
                            }
                            this.dhtSlices.forward(this.t, 0);
                            this.dhtSlices.forward(this.t, this.slices);
                            this.dhtSlices.forward(this.t, 2 * this.slices);
                            this.dhtSlices.forward(this.t, 3 * this.slices);
                            for (s = 0; s < this.slices; ++s) {
                                idx1 = s * this.sliceStride + idx0 + c;
                                idx2 = this.slices + s;
                                a[idx1] = this.t[s];
                                a[idx1 + 1] = this.t[idx2];
                                a[idx1 + 2] = this.t[idx2 + this.slices];
                                a[idx1 + 3] = this.t[idx2 + 2 * this.slices];
                            }
                        }
                    }
                    break block19;
                }
                if (this.columns != 2) break block19;
                for (int r = 0; r < this.rows; ++r) {
                    int idx1;
                    int s;
                    int idx0 = r * this.rowStride;
                    for (s = 0; s < this.slices; ++s) {
                        idx1 = s * this.sliceStride + idx0;
                        this.t[s] = a[idx1];
                        this.t[this.slices + s] = a[idx1 + 1];
                    }
                    this.dhtSlices.forward(this.t, 0);
                    this.dhtSlices.forward(this.t, this.slices);
                    for (s = 0; s < this.slices; ++s) {
                        idx1 = s * this.sliceStride + idx0;
                        a[idx1] = this.t[s];
                        a[idx1 + 1] = this.t[this.slices + s];
                    }
                }
                break block19;
            }
            if (this.columns > 2) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx0 = r * this.rowStride;
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int idx1;
                        int s;
                        for (s = 0; s < this.slices; ++s) {
                            idx1 = s * this.sliceStride + idx0 + c;
                            idx2 = this.slices + s;
                            this.t[s] = a[idx1];
                            this.t[idx2] = a[idx1 + 1];
                            this.t[idx2 + this.slices] = a[idx1 + 2];
                            this.t[idx2 + 2 * this.slices] = a[idx1 + 3];
                        }
                        this.dhtSlices.inverse(this.t, 0, scale);
                        this.dhtSlices.inverse(this.t, this.slices, scale);
                        this.dhtSlices.inverse(this.t, 2 * this.slices, scale);
                        this.dhtSlices.inverse(this.t, 3 * this.slices, scale);
                        for (s = 0; s < this.slices; ++s) {
                            idx1 = s * this.sliceStride + idx0 + c;
                            idx2 = this.slices + s;
                            a[idx1] = this.t[s];
                            a[idx1 + 1] = this.t[idx2];
                            a[idx1 + 2] = this.t[idx2 + this.slices];
                            a[idx1 + 3] = this.t[idx2 + 2 * this.slices];
                        }
                    }
                }
            } else if (this.columns == 2) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx1;
                    int s;
                    int idx0 = r * this.rowStride;
                    for (s = 0; s < this.slices; ++s) {
                        idx1 = s * this.sliceStride + idx0;
                        this.t[s] = a[idx1];
                        this.t[this.slices + s] = a[idx1 + 1];
                    }
                    this.dhtSlices.inverse(this.t, 0, scale);
                    this.dhtSlices.inverse(this.t, this.slices, scale);
                    for (s = 0; s < this.slices; ++s) {
                        idx1 = s * this.sliceStride + idx0;
                        a[idx1] = this.t[s];
                        a[idx1 + 1] = this.t[this.slices + s];
                    }
                }
            }
        }
    }

    private void ddxt3db_sub(int isgn, float[][][] a, boolean scale) {
        block19: {
            block17: {
                block18: {
                    if (isgn != -1) break block17;
                    if (this.columns <= 2) break block18;
                    for (int r = 0; r < this.rows; ++r) {
                        for (int c = 0; c < this.columns; c += 4) {
                            int idx2;
                            int s;
                            for (s = 0; s < this.slices; ++s) {
                                idx2 = this.slices + s;
                                this.t[s] = a[s][r][c];
                                this.t[idx2] = a[s][r][c + 1];
                                this.t[idx2 + this.slices] = a[s][r][c + 2];
                                this.t[idx2 + 2 * this.slices] = a[s][r][c + 3];
                            }
                            this.dhtSlices.forward(this.t, 0);
                            this.dhtSlices.forward(this.t, this.slices);
                            this.dhtSlices.forward(this.t, 2 * this.slices);
                            this.dhtSlices.forward(this.t, 3 * this.slices);
                            for (s = 0; s < this.slices; ++s) {
                                idx2 = this.slices + s;
                                a[s][r][c] = this.t[s];
                                a[s][r][c + 1] = this.t[idx2];
                                a[s][r][c + 2] = this.t[idx2 + this.slices];
                                a[s][r][c + 3] = this.t[idx2 + 2 * this.slices];
                            }
                        }
                    }
                    break block19;
                }
                if (this.columns != 2) break block19;
                for (int r = 0; r < this.rows; ++r) {
                    int s;
                    for (s = 0; s < this.slices; ++s) {
                        this.t[s] = a[s][r][0];
                        this.t[this.slices + s] = a[s][r][1];
                    }
                    this.dhtSlices.forward(this.t, 0);
                    this.dhtSlices.forward(this.t, this.slices);
                    for (s = 0; s < this.slices; ++s) {
                        a[s][r][0] = this.t[s];
                        a[s][r][1] = this.t[this.slices + s];
                    }
                }
                break block19;
            }
            if (this.columns > 2) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int s;
                        for (s = 0; s < this.slices; ++s) {
                            idx2 = this.slices + s;
                            this.t[s] = a[s][r][c];
                            this.t[idx2] = a[s][r][c + 1];
                            this.t[idx2 + this.slices] = a[s][r][c + 2];
                            this.t[idx2 + 2 * this.slices] = a[s][r][c + 3];
                        }
                        this.dhtSlices.inverse(this.t, 0, scale);
                        this.dhtSlices.inverse(this.t, this.slices, scale);
                        this.dhtSlices.inverse(this.t, 2 * this.slices, scale);
                        this.dhtSlices.inverse(this.t, 3 * this.slices, scale);
                        for (s = 0; s < this.slices; ++s) {
                            idx2 = this.slices + s;
                            a[s][r][c] = this.t[s];
                            a[s][r][c + 1] = this.t[idx2];
                            a[s][r][c + 2] = this.t[idx2 + this.slices];
                            a[s][r][c + 3] = this.t[idx2 + 2 * this.slices];
                        }
                    }
                }
            } else if (this.columns == 2) {
                for (int r = 0; r < this.rows; ++r) {
                    int s;
                    for (s = 0; s < this.slices; ++s) {
                        this.t[s] = a[s][r][0];
                        this.t[this.slices + s] = a[s][r][1];
                    }
                    this.dhtSlices.inverse(this.t, 0, scale);
                    this.dhtSlices.inverse(this.t, this.slices, scale);
                    for (s = 0; s < this.slices; ++s) {
                        a[s][r][0] = this.t[s];
                        a[s][r][1] = this.t[this.slices + s];
                    }
                }
            }
        }
    }

    private void ddxt3da_subth(final int isgn, final float[] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.slices ? this.slices : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        }
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            final int startt = nt * i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (isgn == -1) {
                        for (int s = n0; s < FloatDHT_3D.this.slices; s += nthreads) {
                            int idx1;
                            int r;
                            int idx0 = s * FloatDHT_3D.this.sliceStride;
                            for (r = 0; r < FloatDHT_3D.this.rows; ++r) {
                                FloatDHT_3D.this.dhtColumns.forward(a, idx0 + r * FloatDHT_3D.this.rowStride);
                            }
                            if (FloatDHT_3D.this.columns > 2) {
                                for (int c = 0; c < FloatDHT_3D.this.columns; c += 4) {
                                    int idx2;
                                    int r2;
                                    for (r2 = 0; r2 < FloatDHT_3D.this.rows; ++r2) {
                                        idx1 = idx0 + r2 * FloatDHT_3D.this.rowStride + c;
                                        idx2 = startt + FloatDHT_3D.this.rows + r2;
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[startt + r2] = a[idx1];
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[idx2] = a[idx1 + 1];
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[idx2 + ((FloatDHT_3D)FloatDHT_3D.this).rows] = a[idx1 + 2];
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[idx2 + 2 * ((FloatDHT_3D)FloatDHT_3D.this).rows] = a[idx1 + 3];
                                    }
                                    FloatDHT_3D.this.dhtRows.forward(FloatDHT_3D.this.t, startt);
                                    FloatDHT_3D.this.dhtRows.forward(FloatDHT_3D.this.t, startt + FloatDHT_3D.this.rows);
                                    FloatDHT_3D.this.dhtRows.forward(FloatDHT_3D.this.t, startt + 2 * FloatDHT_3D.this.rows);
                                    FloatDHT_3D.this.dhtRows.forward(FloatDHT_3D.this.t, startt + 3 * FloatDHT_3D.this.rows);
                                    for (r2 = 0; r2 < FloatDHT_3D.this.rows; ++r2) {
                                        idx1 = idx0 + r2 * FloatDHT_3D.this.rowStride + c;
                                        idx2 = startt + FloatDHT_3D.this.rows + r2;
                                        a[idx1] = FloatDHT_3D.this.t[startt + r2];
                                        a[idx1 + 1] = FloatDHT_3D.this.t[idx2];
                                        a[idx1 + 2] = FloatDHT_3D.this.t[idx2 + FloatDHT_3D.this.rows];
                                        a[idx1 + 3] = FloatDHT_3D.this.t[idx2 + 2 * FloatDHT_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (FloatDHT_3D.this.columns != 2) continue;
                            for (r = 0; r < FloatDHT_3D.this.rows; ++r) {
                                idx1 = idx0 + r * FloatDHT_3D.this.rowStride;
                                ((FloatDHT_3D)FloatDHT_3D.this).t[startt + r] = a[idx1];
                                ((FloatDHT_3D)FloatDHT_3D.this).t[startt + ((FloatDHT_3D)FloatDHT_3D.this).rows + r] = a[idx1 + 1];
                            }
                            FloatDHT_3D.this.dhtRows.forward(FloatDHT_3D.this.t, startt);
                            FloatDHT_3D.this.dhtRows.forward(FloatDHT_3D.this.t, startt + FloatDHT_3D.this.rows);
                            for (r = 0; r < FloatDHT_3D.this.rows; ++r) {
                                idx1 = idx0 + r * FloatDHT_3D.this.rowStride;
                                a[idx1] = FloatDHT_3D.this.t[startt + r];
                                a[idx1 + 1] = FloatDHT_3D.this.t[startt + FloatDHT_3D.this.rows + r];
                            }
                        }
                    } else {
                        for (int s = n0; s < FloatDHT_3D.this.slices; s += nthreads) {
                            int idx1;
                            int r;
                            int idx0 = s * FloatDHT_3D.this.sliceStride;
                            for (r = 0; r < FloatDHT_3D.this.rows; ++r) {
                                FloatDHT_3D.this.dhtColumns.inverse(a, idx0 + r * FloatDHT_3D.this.rowStride, scale);
                            }
                            if (FloatDHT_3D.this.columns > 2) {
                                for (int c = 0; c < FloatDHT_3D.this.columns; c += 4) {
                                    int idx2;
                                    int r3;
                                    for (r3 = 0; r3 < FloatDHT_3D.this.rows; ++r3) {
                                        idx1 = idx0 + r3 * FloatDHT_3D.this.rowStride + c;
                                        idx2 = startt + FloatDHT_3D.this.rows + r3;
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[startt + r3] = a[idx1];
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[idx2] = a[idx1 + 1];
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[idx2 + ((FloatDHT_3D)FloatDHT_3D.this).rows] = a[idx1 + 2];
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[idx2 + 2 * ((FloatDHT_3D)FloatDHT_3D.this).rows] = a[idx1 + 3];
                                    }
                                    FloatDHT_3D.this.dhtRows.inverse(FloatDHT_3D.this.t, startt, scale);
                                    FloatDHT_3D.this.dhtRows.inverse(FloatDHT_3D.this.t, startt + FloatDHT_3D.this.rows, scale);
                                    FloatDHT_3D.this.dhtRows.inverse(FloatDHT_3D.this.t, startt + 2 * FloatDHT_3D.this.rows, scale);
                                    FloatDHT_3D.this.dhtRows.inverse(FloatDHT_3D.this.t, startt + 3 * FloatDHT_3D.this.rows, scale);
                                    for (r3 = 0; r3 < FloatDHT_3D.this.rows; ++r3) {
                                        idx1 = idx0 + r3 * FloatDHT_3D.this.rowStride + c;
                                        idx2 = startt + FloatDHT_3D.this.rows + r3;
                                        a[idx1] = FloatDHT_3D.this.t[startt + r3];
                                        a[idx1 + 1] = FloatDHT_3D.this.t[idx2];
                                        a[idx1 + 2] = FloatDHT_3D.this.t[idx2 + FloatDHT_3D.this.rows];
                                        a[idx1 + 3] = FloatDHT_3D.this.t[idx2 + 2 * FloatDHT_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (FloatDHT_3D.this.columns != 2) continue;
                            for (r = 0; r < FloatDHT_3D.this.rows; ++r) {
                                idx1 = idx0 + r * FloatDHT_3D.this.rowStride;
                                ((FloatDHT_3D)FloatDHT_3D.this).t[startt + r] = a[idx1];
                                ((FloatDHT_3D)FloatDHT_3D.this).t[startt + ((FloatDHT_3D)FloatDHT_3D.this).rows + r] = a[idx1 + 1];
                            }
                            FloatDHT_3D.this.dhtRows.inverse(FloatDHT_3D.this.t, startt, scale);
                            FloatDHT_3D.this.dhtRows.inverse(FloatDHT_3D.this.t, startt + FloatDHT_3D.this.rows, scale);
                            for (r = 0; r < FloatDHT_3D.this.rows; ++r) {
                                idx1 = idx0 + r * FloatDHT_3D.this.rowStride;
                                a[idx1] = FloatDHT_3D.this.t[startt + r];
                                a[idx1 + 1] = FloatDHT_3D.this.t[startt + FloatDHT_3D.this.rows + r];
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void ddxt3da_subth(final int isgn, final float[][][] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.slices ? this.slices : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        }
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            final int startt = nt * i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (isgn == -1) {
                        for (int s = n0; s < FloatDHT_3D.this.slices; s += nthreads) {
                            int r;
                            for (r = 0; r < FloatDHT_3D.this.rows; ++r) {
                                FloatDHT_3D.this.dhtColumns.forward(a[s][r]);
                            }
                            if (FloatDHT_3D.this.columns > 2) {
                                for (int c = 0; c < FloatDHT_3D.this.columns; c += 4) {
                                    int idx2;
                                    int r2;
                                    for (r2 = 0; r2 < FloatDHT_3D.this.rows; ++r2) {
                                        idx2 = startt + FloatDHT_3D.this.rows + r2;
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[startt + r2] = a[s][r2][c];
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[idx2] = a[s][r2][c + 1];
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[idx2 + ((FloatDHT_3D)FloatDHT_3D.this).rows] = a[s][r2][c + 2];
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[idx2 + 2 * ((FloatDHT_3D)FloatDHT_3D.this).rows] = a[s][r2][c + 3];
                                    }
                                    FloatDHT_3D.this.dhtRows.forward(FloatDHT_3D.this.t, startt);
                                    FloatDHT_3D.this.dhtRows.forward(FloatDHT_3D.this.t, startt + FloatDHT_3D.this.rows);
                                    FloatDHT_3D.this.dhtRows.forward(FloatDHT_3D.this.t, startt + 2 * FloatDHT_3D.this.rows);
                                    FloatDHT_3D.this.dhtRows.forward(FloatDHT_3D.this.t, startt + 3 * FloatDHT_3D.this.rows);
                                    for (r2 = 0; r2 < FloatDHT_3D.this.rows; ++r2) {
                                        idx2 = startt + FloatDHT_3D.this.rows + r2;
                                        a[s][r2][c] = FloatDHT_3D.this.t[startt + r2];
                                        a[s][r2][c + 1] = FloatDHT_3D.this.t[idx2];
                                        a[s][r2][c + 2] = FloatDHT_3D.this.t[idx2 + FloatDHT_3D.this.rows];
                                        a[s][r2][c + 3] = FloatDHT_3D.this.t[idx2 + 2 * FloatDHT_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (FloatDHT_3D.this.columns != 2) continue;
                            for (r = 0; r < FloatDHT_3D.this.rows; ++r) {
                                ((FloatDHT_3D)FloatDHT_3D.this).t[startt + r] = a[s][r][0];
                                ((FloatDHT_3D)FloatDHT_3D.this).t[startt + ((FloatDHT_3D)FloatDHT_3D.this).rows + r] = a[s][r][1];
                            }
                            FloatDHT_3D.this.dhtRows.forward(FloatDHT_3D.this.t, startt);
                            FloatDHT_3D.this.dhtRows.forward(FloatDHT_3D.this.t, startt + FloatDHT_3D.this.rows);
                            for (r = 0; r < FloatDHT_3D.this.rows; ++r) {
                                a[s][r][0] = FloatDHT_3D.this.t[startt + r];
                                a[s][r][1] = FloatDHT_3D.this.t[startt + FloatDHT_3D.this.rows + r];
                            }
                        }
                    } else {
                        for (int s = n0; s < FloatDHT_3D.this.slices; s += nthreads) {
                            int r;
                            for (r = 0; r < FloatDHT_3D.this.rows; ++r) {
                                FloatDHT_3D.this.dhtColumns.inverse(a[s][r], scale);
                            }
                            if (FloatDHT_3D.this.columns > 2) {
                                for (int c = 0; c < FloatDHT_3D.this.columns; c += 4) {
                                    int idx2;
                                    int r3;
                                    for (r3 = 0; r3 < FloatDHT_3D.this.rows; ++r3) {
                                        idx2 = startt + FloatDHT_3D.this.rows + r3;
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[startt + r3] = a[s][r3][c];
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[idx2] = a[s][r3][c + 1];
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[idx2 + ((FloatDHT_3D)FloatDHT_3D.this).rows] = a[s][r3][c + 2];
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[idx2 + 2 * ((FloatDHT_3D)FloatDHT_3D.this).rows] = a[s][r3][c + 3];
                                    }
                                    FloatDHT_3D.this.dhtRows.inverse(FloatDHT_3D.this.t, startt, scale);
                                    FloatDHT_3D.this.dhtRows.inverse(FloatDHT_3D.this.t, startt + FloatDHT_3D.this.rows, scale);
                                    FloatDHT_3D.this.dhtRows.inverse(FloatDHT_3D.this.t, startt + 2 * FloatDHT_3D.this.rows, scale);
                                    FloatDHT_3D.this.dhtRows.inverse(FloatDHT_3D.this.t, startt + 3 * FloatDHT_3D.this.rows, scale);
                                    for (r3 = 0; r3 < FloatDHT_3D.this.rows; ++r3) {
                                        idx2 = startt + FloatDHT_3D.this.rows + r3;
                                        a[s][r3][c] = FloatDHT_3D.this.t[startt + r3];
                                        a[s][r3][c + 1] = FloatDHT_3D.this.t[idx2];
                                        a[s][r3][c + 2] = FloatDHT_3D.this.t[idx2 + FloatDHT_3D.this.rows];
                                        a[s][r3][c + 3] = FloatDHT_3D.this.t[idx2 + 2 * FloatDHT_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (FloatDHT_3D.this.columns != 2) continue;
                            for (r = 0; r < FloatDHT_3D.this.rows; ++r) {
                                ((FloatDHT_3D)FloatDHT_3D.this).t[startt + r] = a[s][r][0];
                                ((FloatDHT_3D)FloatDHT_3D.this).t[startt + ((FloatDHT_3D)FloatDHT_3D.this).rows + r] = a[s][r][1];
                            }
                            FloatDHT_3D.this.dhtRows.inverse(FloatDHT_3D.this.t, startt, scale);
                            FloatDHT_3D.this.dhtRows.inverse(FloatDHT_3D.this.t, startt + FloatDHT_3D.this.rows, scale);
                            for (r = 0; r < FloatDHT_3D.this.rows; ++r) {
                                a[s][r][0] = FloatDHT_3D.this.t[startt + r];
                                a[s][r][1] = FloatDHT_3D.this.t[startt + FloatDHT_3D.this.rows + r];
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void ddxt3db_subth(final int isgn, final float[] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.slices;
        if (this.columns == 2) {
            nt >>= 1;
        }
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            final int startt = nt * i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block19: {
                        block17: {
                            block18: {
                                if (isgn != -1) break block17;
                                if (FloatDHT_3D.this.columns <= 2) break block18;
                                for (int r = n0; r < FloatDHT_3D.this.rows; r += nthreads) {
                                    int idx0 = r * FloatDHT_3D.this.rowStride;
                                    for (int c = 0; c < FloatDHT_3D.this.columns; c += 4) {
                                        int idx2;
                                        int idx1;
                                        int s;
                                        for (s = 0; s < FloatDHT_3D.this.slices; ++s) {
                                            idx1 = s * FloatDHT_3D.this.sliceStride + idx0 + c;
                                            idx2 = startt + FloatDHT_3D.this.slices + s;
                                            ((FloatDHT_3D)FloatDHT_3D.this).t[startt + s] = a[idx1];
                                            ((FloatDHT_3D)FloatDHT_3D.this).t[idx2] = a[idx1 + 1];
                                            ((FloatDHT_3D)FloatDHT_3D.this).t[idx2 + ((FloatDHT_3D)FloatDHT_3D.this).slices] = a[idx1 + 2];
                                            ((FloatDHT_3D)FloatDHT_3D.this).t[idx2 + 2 * ((FloatDHT_3D)FloatDHT_3D.this).slices] = a[idx1 + 3];
                                        }
                                        FloatDHT_3D.this.dhtSlices.forward(FloatDHT_3D.this.t, startt);
                                        FloatDHT_3D.this.dhtSlices.forward(FloatDHT_3D.this.t, startt + FloatDHT_3D.this.slices);
                                        FloatDHT_3D.this.dhtSlices.forward(FloatDHT_3D.this.t, startt + 2 * FloatDHT_3D.this.slices);
                                        FloatDHT_3D.this.dhtSlices.forward(FloatDHT_3D.this.t, startt + 3 * FloatDHT_3D.this.slices);
                                        for (s = 0; s < FloatDHT_3D.this.slices; ++s) {
                                            idx1 = s * FloatDHT_3D.this.sliceStride + idx0 + c;
                                            idx2 = startt + FloatDHT_3D.this.slices + s;
                                            a[idx1] = FloatDHT_3D.this.t[startt + s];
                                            a[idx1 + 1] = FloatDHT_3D.this.t[idx2];
                                            a[idx1 + 2] = FloatDHT_3D.this.t[idx2 + FloatDHT_3D.this.slices];
                                            a[idx1 + 3] = FloatDHT_3D.this.t[idx2 + 2 * FloatDHT_3D.this.slices];
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (FloatDHT_3D.this.columns != 2) break block19;
                            for (int r = n0; r < FloatDHT_3D.this.rows; r += nthreads) {
                                int idx1;
                                int s;
                                int idx0 = r * FloatDHT_3D.this.rowStride;
                                for (s = 0; s < FloatDHT_3D.this.slices; ++s) {
                                    idx1 = s * FloatDHT_3D.this.sliceStride + idx0;
                                    ((FloatDHT_3D)FloatDHT_3D.this).t[startt + s] = a[idx1];
                                    ((FloatDHT_3D)FloatDHT_3D.this).t[startt + ((FloatDHT_3D)FloatDHT_3D.this).slices + s] = a[idx1 + 1];
                                }
                                FloatDHT_3D.this.dhtSlices.forward(FloatDHT_3D.this.t, startt);
                                FloatDHT_3D.this.dhtSlices.forward(FloatDHT_3D.this.t, startt + FloatDHT_3D.this.slices);
                                for (s = 0; s < FloatDHT_3D.this.slices; ++s) {
                                    idx1 = s * FloatDHT_3D.this.sliceStride + idx0;
                                    a[idx1] = FloatDHT_3D.this.t[startt + s];
                                    a[idx1 + 1] = FloatDHT_3D.this.t[startt + FloatDHT_3D.this.slices + s];
                                }
                            }
                            break block19;
                        }
                        if (FloatDHT_3D.this.columns > 2) {
                            for (int r = n0; r < FloatDHT_3D.this.rows; r += nthreads) {
                                int idx0 = r * FloatDHT_3D.this.rowStride;
                                for (int c = 0; c < FloatDHT_3D.this.columns; c += 4) {
                                    int idx2;
                                    int idx1;
                                    int s;
                                    for (s = 0; s < FloatDHT_3D.this.slices; ++s) {
                                        idx1 = s * FloatDHT_3D.this.sliceStride + idx0 + c;
                                        idx2 = startt + FloatDHT_3D.this.slices + s;
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[startt + s] = a[idx1];
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[idx2] = a[idx1 + 1];
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[idx2 + ((FloatDHT_3D)FloatDHT_3D.this).slices] = a[idx1 + 2];
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[idx2 + 2 * ((FloatDHT_3D)FloatDHT_3D.this).slices] = a[idx1 + 3];
                                    }
                                    FloatDHT_3D.this.dhtSlices.inverse(FloatDHT_3D.this.t, startt, scale);
                                    FloatDHT_3D.this.dhtSlices.inverse(FloatDHT_3D.this.t, startt + FloatDHT_3D.this.slices, scale);
                                    FloatDHT_3D.this.dhtSlices.inverse(FloatDHT_3D.this.t, startt + 2 * FloatDHT_3D.this.slices, scale);
                                    FloatDHT_3D.this.dhtSlices.inverse(FloatDHT_3D.this.t, startt + 3 * FloatDHT_3D.this.slices, scale);
                                    for (s = 0; s < FloatDHT_3D.this.slices; ++s) {
                                        idx1 = s * FloatDHT_3D.this.sliceStride + idx0 + c;
                                        idx2 = startt + FloatDHT_3D.this.slices + s;
                                        a[idx1] = FloatDHT_3D.this.t[startt + s];
                                        a[idx1 + 1] = FloatDHT_3D.this.t[idx2];
                                        a[idx1 + 2] = FloatDHT_3D.this.t[idx2 + FloatDHT_3D.this.slices];
                                        a[idx1 + 3] = FloatDHT_3D.this.t[idx2 + 2 * FloatDHT_3D.this.slices];
                                    }
                                }
                            }
                        } else if (FloatDHT_3D.this.columns == 2) {
                            for (int r = n0; r < FloatDHT_3D.this.rows; r += nthreads) {
                                int idx1;
                                int s;
                                int idx0 = r * FloatDHT_3D.this.rowStride;
                                for (s = 0; s < FloatDHT_3D.this.slices; ++s) {
                                    idx1 = s * FloatDHT_3D.this.sliceStride + idx0;
                                    ((FloatDHT_3D)FloatDHT_3D.this).t[startt + s] = a[idx1];
                                    ((FloatDHT_3D)FloatDHT_3D.this).t[startt + ((FloatDHT_3D)FloatDHT_3D.this).slices + s] = a[idx1 + 1];
                                }
                                FloatDHT_3D.this.dhtSlices.inverse(FloatDHT_3D.this.t, startt, scale);
                                FloatDHT_3D.this.dhtSlices.inverse(FloatDHT_3D.this.t, startt + FloatDHT_3D.this.slices, scale);
                                for (s = 0; s < FloatDHT_3D.this.slices; ++s) {
                                    idx1 = s * FloatDHT_3D.this.sliceStride + idx0;
                                    a[idx1] = FloatDHT_3D.this.t[startt + s];
                                    a[idx1 + 1] = FloatDHT_3D.this.t[startt + FloatDHT_3D.this.slices + s];
                                }
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void ddxt3db_subth(final int isgn, final float[][][] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.slices;
        if (this.columns == 2) {
            nt >>= 1;
        }
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            final int startt = nt * i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block19: {
                        block17: {
                            block18: {
                                if (isgn != -1) break block17;
                                if (FloatDHT_3D.this.columns <= 2) break block18;
                                for (int r = n0; r < FloatDHT_3D.this.rows; r += nthreads) {
                                    for (int c = 0; c < FloatDHT_3D.this.columns; c += 4) {
                                        int idx2;
                                        int s;
                                        for (s = 0; s < FloatDHT_3D.this.slices; ++s) {
                                            idx2 = startt + FloatDHT_3D.this.slices + s;
                                            ((FloatDHT_3D)FloatDHT_3D.this).t[startt + s] = a[s][r][c];
                                            ((FloatDHT_3D)FloatDHT_3D.this).t[idx2] = a[s][r][c + 1];
                                            ((FloatDHT_3D)FloatDHT_3D.this).t[idx2 + ((FloatDHT_3D)FloatDHT_3D.this).slices] = a[s][r][c + 2];
                                            ((FloatDHT_3D)FloatDHT_3D.this).t[idx2 + 2 * ((FloatDHT_3D)FloatDHT_3D.this).slices] = a[s][r][c + 3];
                                        }
                                        FloatDHT_3D.this.dhtSlices.forward(FloatDHT_3D.this.t, startt);
                                        FloatDHT_3D.this.dhtSlices.forward(FloatDHT_3D.this.t, startt + FloatDHT_3D.this.slices);
                                        FloatDHT_3D.this.dhtSlices.forward(FloatDHT_3D.this.t, startt + 2 * FloatDHT_3D.this.slices);
                                        FloatDHT_3D.this.dhtSlices.forward(FloatDHT_3D.this.t, startt + 3 * FloatDHT_3D.this.slices);
                                        for (s = 0; s < FloatDHT_3D.this.slices; ++s) {
                                            idx2 = startt + FloatDHT_3D.this.slices + s;
                                            a[s][r][c] = FloatDHT_3D.this.t[startt + s];
                                            a[s][r][c + 1] = FloatDHT_3D.this.t[idx2];
                                            a[s][r][c + 2] = FloatDHT_3D.this.t[idx2 + FloatDHT_3D.this.slices];
                                            a[s][r][c + 3] = FloatDHT_3D.this.t[idx2 + 2 * FloatDHT_3D.this.slices];
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (FloatDHT_3D.this.columns != 2) break block19;
                            for (int r = n0; r < FloatDHT_3D.this.rows; r += nthreads) {
                                int s;
                                for (s = 0; s < FloatDHT_3D.this.slices; ++s) {
                                    ((FloatDHT_3D)FloatDHT_3D.this).t[startt + s] = a[s][r][0];
                                    ((FloatDHT_3D)FloatDHT_3D.this).t[startt + ((FloatDHT_3D)FloatDHT_3D.this).slices + s] = a[s][r][1];
                                }
                                FloatDHT_3D.this.dhtSlices.forward(FloatDHT_3D.this.t, startt);
                                FloatDHT_3D.this.dhtSlices.forward(FloatDHT_3D.this.t, startt + FloatDHT_3D.this.slices);
                                for (s = 0; s < FloatDHT_3D.this.slices; ++s) {
                                    a[s][r][0] = FloatDHT_3D.this.t[startt + s];
                                    a[s][r][1] = FloatDHT_3D.this.t[startt + FloatDHT_3D.this.slices + s];
                                }
                            }
                            break block19;
                        }
                        if (FloatDHT_3D.this.columns > 2) {
                            for (int r = n0; r < FloatDHT_3D.this.rows; r += nthreads) {
                                for (int c = 0; c < FloatDHT_3D.this.columns; c += 4) {
                                    int idx2;
                                    int s;
                                    for (s = 0; s < FloatDHT_3D.this.slices; ++s) {
                                        idx2 = startt + FloatDHT_3D.this.slices + s;
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[startt + s] = a[s][r][c];
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[idx2] = a[s][r][c + 1];
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[idx2 + ((FloatDHT_3D)FloatDHT_3D.this).slices] = a[s][r][c + 2];
                                        ((FloatDHT_3D)FloatDHT_3D.this).t[idx2 + 2 * ((FloatDHT_3D)FloatDHT_3D.this).slices] = a[s][r][c + 3];
                                    }
                                    FloatDHT_3D.this.dhtSlices.inverse(FloatDHT_3D.this.t, startt, scale);
                                    FloatDHT_3D.this.dhtSlices.inverse(FloatDHT_3D.this.t, startt + FloatDHT_3D.this.slices, scale);
                                    FloatDHT_3D.this.dhtSlices.inverse(FloatDHT_3D.this.t, startt + 2 * FloatDHT_3D.this.slices, scale);
                                    FloatDHT_3D.this.dhtSlices.inverse(FloatDHT_3D.this.t, startt + 3 * FloatDHT_3D.this.slices, scale);
                                    for (s = 0; s < FloatDHT_3D.this.slices; ++s) {
                                        idx2 = startt + FloatDHT_3D.this.slices + s;
                                        a[s][r][c] = FloatDHT_3D.this.t[startt + s];
                                        a[s][r][c + 1] = FloatDHT_3D.this.t[idx2];
                                        a[s][r][c + 2] = FloatDHT_3D.this.t[idx2 + FloatDHT_3D.this.slices];
                                        a[s][r][c + 3] = FloatDHT_3D.this.t[idx2 + 2 * FloatDHT_3D.this.slices];
                                    }
                                }
                            }
                        } else if (FloatDHT_3D.this.columns == 2) {
                            for (int r = n0; r < FloatDHT_3D.this.rows; r += nthreads) {
                                int s;
                                for (s = 0; s < FloatDHT_3D.this.slices; ++s) {
                                    ((FloatDHT_3D)FloatDHT_3D.this).t[startt + s] = a[s][r][0];
                                    ((FloatDHT_3D)FloatDHT_3D.this).t[startt + ((FloatDHT_3D)FloatDHT_3D.this).slices + s] = a[s][r][1];
                                }
                                FloatDHT_3D.this.dhtSlices.inverse(FloatDHT_3D.this.t, startt, scale);
                                FloatDHT_3D.this.dhtSlices.inverse(FloatDHT_3D.this.t, startt + FloatDHT_3D.this.slices, scale);
                                for (s = 0; s < FloatDHT_3D.this.slices; ++s) {
                                    a[s][r][0] = FloatDHT_3D.this.t[startt + s];
                                    a[s][r][1] = FloatDHT_3D.this.t[startt + FloatDHT_3D.this.slices + s];
                                }
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void yTransform(float[] a) {
        for (int s = 0; s <= this.slices / 2; ++s) {
            int sC = (this.slices - s) % this.slices;
            int idx9 = s * this.sliceStride;
            int idx10 = sC * this.sliceStride;
            for (int r = 0; r <= this.rows / 2; ++r) {
                int rC = (this.rows - r) % this.rows;
                int idx11 = r * this.rowStride;
                int idx12 = rC * this.rowStride;
                for (int c = 0; c <= this.columns / 2; ++c) {
                    int cC = (this.columns - c) % this.columns;
                    int idx1 = idx9 + idx12 + c;
                    int idx2 = idx9 + idx11 + cC;
                    int idx3 = idx10 + idx11 + c;
                    int idx4 = idx10 + idx12 + cC;
                    int idx5 = idx10 + idx12 + c;
                    int idx6 = idx10 + idx11 + cC;
                    int idx7 = idx9 + idx11 + c;
                    int idx8 = idx9 + idx12 + cC;
                    float A = a[idx1];
                    float B = a[idx2];
                    float C = a[idx3];
                    float D = a[idx4];
                    float E = a[idx5];
                    float F = a[idx6];
                    float G = a[idx7];
                    float H = a[idx8];
                    a[idx7] = (A + B + C - D) / 2.0f;
                    a[idx3] = (E + F + G - H) / 2.0f;
                    a[idx1] = (G + H + E - F) / 2.0f;
                    a[idx5] = (C + D + A - B) / 2.0f;
                    a[idx2] = (H + G + F - E) / 2.0f;
                    a[idx6] = (D + C + B - A) / 2.0f;
                    a[idx8] = (B + A + D - C) / 2.0f;
                    a[idx4] = (F + E + H - G) / 2.0f;
                }
            }
        }
    }

    private void yTransform(float[][][] a) {
        for (int s = 0; s <= this.slices / 2; ++s) {
            int sC = (this.slices - s) % this.slices;
            for (int r = 0; r <= this.rows / 2; ++r) {
                int rC = (this.rows - r) % this.rows;
                for (int c = 0; c <= this.columns / 2; ++c) {
                    int cC = (this.columns - c) % this.columns;
                    float A = a[s][rC][c];
                    float B = a[s][r][cC];
                    float C = a[sC][r][c];
                    float D = a[sC][rC][cC];
                    float E = a[sC][rC][c];
                    float F = a[sC][r][cC];
                    float G = a[s][r][c];
                    float H = a[s][rC][cC];
                    a[s][r][c] = (A + B + C - D) / 2.0f;
                    a[sC][r][c] = (E + F + G - H) / 2.0f;
                    a[s][rC][c] = (G + H + E - F) / 2.0f;
                    a[sC][rC][c] = (C + D + A - B) / 2.0f;
                    a[s][r][cC] = (H + G + F - E) / 2.0f;
                    a[sC][r][cC] = (D + C + B - A) / 2.0f;
                    a[s][rC][cC] = (B + A + D - C) / 2.0f;
                    a[sC][rC][cC] = (F + E + H - G) / 2.0f;
                }
            }
        }
    }
}

