/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.spectra.dht;

import de.gsi.math.spectra.dht.FloatDHT_1D;
import de.gsi.math.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class FloatDHT_2D {
    private final int rows;
    private final int columns;
    private float[] t;
    private final FloatDHT_1D dhtColumns;
    private FloatDHT_1D dhtRows;
    private int oldNthreads;
    private int nt;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public FloatDHT_2D(int rows, int column) {
        if (rows <= 1 || column <= 1) {
            throw new IllegalArgumentException("rows and columns must be greater than 1");
        }
        this.rows = rows;
        this.columns = column;
        if (rows * column >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.useThreads = true;
        }
        if (ConcurrencyUtils.isPowerOf2(rows) && ConcurrencyUtils.isPowerOf2(column)) {
            this.isPowerOfTwo = true;
            this.oldNthreads = ConcurrencyUtils.getNumberOfThreads();
            this.nt = 4 * this.oldNthreads * rows;
            if (column == 2 * this.oldNthreads) {
                this.nt >>= 1;
            } else if (column < 2 * this.oldNthreads) {
                this.nt >>= 2;
            }
            this.t = new float[this.nt];
        }
        this.dhtColumns = new FloatDHT_1D(column);
        this.dhtRows = column == rows ? this.dhtColumns : new FloatDHT_1D(rows);
    }

    public void forward(final float[] a) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads != this.oldNthreads) {
                this.nt = 4 * nthreads * this.rows;
                if (this.columns == 2 * nthreads) {
                    this.nt >>= 1;
                } else if (this.columns < 2 * nthreads) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(-1, a, true);
                this.ddxt2d0_subth(-1, a, true);
            } else {
                this.ddxt2d_sub(-1, a, true);
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.forward(a, i * this.columns);
                }
            }
            this.yTransform(a);
        } else {
            if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
                int l;
                Future[] futures = new Future[nthreads];
                int p = this.rows / nthreads;
                for (l = 0; l < nthreads; ++l) {
                    final int firstRow = l * p;
                    final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = firstRow; i < lastRow; ++i) {
                                FloatDHT_2D.this.dhtColumns.forward(a, i * FloatDHT_2D.this.columns);
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
                p = this.columns / nthreads;
                for (l = 0; l < nthreads; ++l) {
                    final int firstColumn = l * p;
                    final int lastColumn = l == nthreads - 1 ? this.columns : firstColumn + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] temp = new float[FloatDHT_2D.this.rows];
                            for (int c = firstColumn; c < lastColumn; ++c) {
                                int r;
                                for (r = 0; r < FloatDHT_2D.this.rows; ++r) {
                                    temp[r] = a[r * FloatDHT_2D.this.columns + c];
                                }
                                FloatDHT_2D.this.dhtRows.forward(temp);
                                for (r = 0; r < FloatDHT_2D.this.rows; ++r) {
                                    a[r * ((FloatDHT_2D)FloatDHT_2D.this).columns + c] = temp[r];
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.forward(a, i * this.columns);
                }
                float[] temp = new float[this.rows];
                for (int c = 0; c < this.columns; ++c) {
                    int r;
                    for (r = 0; r < this.rows; ++r) {
                        temp[r] = a[r * this.columns + c];
                    }
                    this.dhtRows.forward(temp);
                    for (r = 0; r < this.rows; ++r) {
                        a[r * this.columns + c] = temp[r];
                    }
                }
            }
            this.yTransform(a);
        }
    }

    public void forward(final float[][] a) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads != this.oldNthreads) {
                this.nt = 4 * nthreads * this.rows;
                if (this.columns == 2 * nthreads) {
                    this.nt >>= 1;
                } else if (this.columns < 2 * nthreads) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(-1, a, true);
                this.ddxt2d0_subth(-1, a, true);
            } else {
                this.ddxt2d_sub(-1, a, true);
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.forward(a[i]);
                }
            }
            this.y_transform(a);
        } else {
            if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
                int l;
                Future[] futures = new Future[nthreads];
                int p = this.rows / nthreads;
                for (l = 0; l < nthreads; ++l) {
                    final int firstRow = l * p;
                    final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = firstRow; i < lastRow; ++i) {
                                FloatDHT_2D.this.dhtColumns.forward(a[i]);
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
                p = this.columns / nthreads;
                for (l = 0; l < nthreads; ++l) {
                    final int firstColumn = l * p;
                    final int lastColumn = l == nthreads - 1 ? this.columns : firstColumn + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] temp = new float[FloatDHT_2D.this.rows];
                            for (int c = firstColumn; c < lastColumn; ++c) {
                                int r;
                                for (r = 0; r < FloatDHT_2D.this.rows; ++r) {
                                    temp[r] = a[r][c];
                                }
                                FloatDHT_2D.this.dhtRows.forward(temp);
                                for (r = 0; r < FloatDHT_2D.this.rows; ++r) {
                                    a[r][c] = temp[r];
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.forward(a[i]);
                }
                float[] temp = new float[this.rows];
                for (int c = 0; c < this.columns; ++c) {
                    int r;
                    for (r = 0; r < this.rows; ++r) {
                        temp[r] = a[r][c];
                    }
                    this.dhtRows.forward(temp);
                    for (r = 0; r < this.rows; ++r) {
                        a[r][c] = temp[r];
                    }
                }
            }
            this.y_transform(a);
        }
    }

    public void inverse(final float[] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads != this.oldNthreads) {
                this.nt = 4 * nthreads * this.rows;
                if (this.columns == 2 * nthreads) {
                    this.nt >>= 1;
                } else if (this.columns < 2 * nthreads) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(1, a, scale);
                this.ddxt2d0_subth(1, a, scale);
            } else {
                this.ddxt2d_sub(1, a, scale);
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.inverse(a, i * this.columns, scale);
                }
            }
            this.yTransform(a);
        } else {
            if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
                int l;
                Future[] futures = new Future[nthreads];
                int p = this.rows / nthreads;
                for (l = 0; l < nthreads; ++l) {
                    final int firstRow = l * p;
                    final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = firstRow; i < lastRow; ++i) {
                                FloatDHT_2D.this.dhtColumns.inverse(a, i * FloatDHT_2D.this.columns, scale);
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
                p = this.columns / nthreads;
                for (l = 0; l < nthreads; ++l) {
                    final int firstColumn = l * p;
                    final int lastColumn = l == nthreads - 1 ? this.columns : firstColumn + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] temp = new float[FloatDHT_2D.this.rows];
                            for (int c = firstColumn; c < lastColumn; ++c) {
                                int r;
                                for (r = 0; r < FloatDHT_2D.this.rows; ++r) {
                                    temp[r] = a[r * FloatDHT_2D.this.columns + c];
                                }
                                FloatDHT_2D.this.dhtRows.inverse(temp, scale);
                                for (r = 0; r < FloatDHT_2D.this.rows; ++r) {
                                    a[r * ((FloatDHT_2D)FloatDHT_2D.this).columns + c] = temp[r];
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.inverse(a, i * this.columns, scale);
                }
                float[] temp = new float[this.rows];
                for (int c = 0; c < this.columns; ++c) {
                    int r;
                    for (r = 0; r < this.rows; ++r) {
                        temp[r] = a[r * this.columns + c];
                    }
                    this.dhtRows.inverse(temp, scale);
                    for (r = 0; r < this.rows; ++r) {
                        a[r * this.columns + c] = temp[r];
                    }
                }
            }
            this.yTransform(a);
        }
    }

    public void inverse(final float[][] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads != this.oldNthreads) {
                this.nt = 4 * nthreads * this.rows;
                if (this.columns == 2 * nthreads) {
                    this.nt >>= 1;
                } else if (this.columns < 2 * nthreads) {
                    this.nt >>= 2;
                }
                this.t = new float[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(1, a, scale);
                this.ddxt2d0_subth(1, a, scale);
            } else {
                this.ddxt2d_sub(1, a, scale);
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.inverse(a[i], scale);
                }
            }
            this.y_transform(a);
        } else {
            if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
                int l;
                Future[] futures = new Future[nthreads];
                int p = this.rows / nthreads;
                for (l = 0; l < nthreads; ++l) {
                    final int firstRow = l * p;
                    final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = firstRow; i < lastRow; ++i) {
                                FloatDHT_2D.this.dhtColumns.inverse(a[i], scale);
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
                p = this.columns / nthreads;
                for (l = 0; l < nthreads; ++l) {
                    final int firstColumn = l * p;
                    final int lastColumn = l == nthreads - 1 ? this.columns : firstColumn + p;
                    futures[l] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] temp = new float[FloatDHT_2D.this.rows];
                            for (int c = firstColumn; c < lastColumn; ++c) {
                                int r;
                                for (r = 0; r < FloatDHT_2D.this.rows; ++r) {
                                    temp[r] = a[r][c];
                                }
                                FloatDHT_2D.this.dhtRows.inverse(temp, scale);
                                for (r = 0; r < FloatDHT_2D.this.rows; ++r) {
                                    a[r][c] = temp[r];
                                }
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futures);
            } else {
                for (int i = 0; i < this.rows; ++i) {
                    this.dhtColumns.inverse(a[i], scale);
                }
                float[] temp = new float[this.rows];
                for (int c = 0; c < this.columns; ++c) {
                    int r;
                    for (r = 0; r < this.rows; ++r) {
                        temp[r] = a[r][c];
                    }
                    this.dhtRows.inverse(temp, scale);
                    for (r = 0; r < this.rows; ++r) {
                        a[r][c] = temp[r];
                    }
                }
            }
            this.y_transform(a);
        }
    }

    private void ddxt2d_subth(final int isgn, final float[] a, final boolean scale) {
        int nthread = ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.rows;
        if (this.columns == 2 * nthread) {
            nt >>= 1;
        } else if (this.columns < 2 * nthread) {
            nthread = this.columns;
            nt >>= 2;
        }
        final int nthreads = nthread;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            final int startt = nt * i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block17: {
                        int r;
                        block18: {
                            int idx2;
                            int idx1;
                            int r2;
                            block16: {
                                if (FloatDHT_2D.this.columns <= 2 * nthreads) break block16;
                                if (isgn == -1) {
                                    for (int c = 4 * n0; c < FloatDHT_2D.this.columns; c += 4 * nthreads) {
                                        int idx22;
                                        int idx12;
                                        int r3;
                                        for (r3 = 0; r3 < FloatDHT_2D.this.rows; ++r3) {
                                            idx12 = r3 * FloatDHT_2D.this.columns + c;
                                            idx22 = startt + FloatDHT_2D.this.rows + r3;
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[startt + r3] = a[idx12];
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[idx22] = a[idx12 + 1];
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[idx22 + ((FloatDHT_2D)FloatDHT_2D.this).rows] = a[idx12 + 2];
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[idx22 + 2 * ((FloatDHT_2D)FloatDHT_2D.this).rows] = a[idx12 + 3];
                                        }
                                        FloatDHT_2D.this.dhtRows.forward(FloatDHT_2D.this.t, startt);
                                        FloatDHT_2D.this.dhtRows.forward(FloatDHT_2D.this.t, startt + FloatDHT_2D.this.rows);
                                        FloatDHT_2D.this.dhtRows.forward(FloatDHT_2D.this.t, startt + 2 * FloatDHT_2D.this.rows);
                                        FloatDHT_2D.this.dhtRows.forward(FloatDHT_2D.this.t, startt + 3 * FloatDHT_2D.this.rows);
                                        for (r3 = 0; r3 < FloatDHT_2D.this.rows; ++r3) {
                                            idx12 = r3 * FloatDHT_2D.this.columns + c;
                                            idx22 = startt + FloatDHT_2D.this.rows + r3;
                                            a[idx12] = FloatDHT_2D.this.t[startt + r3];
                                            a[idx12 + 1] = FloatDHT_2D.this.t[idx22];
                                            a[idx12 + 2] = FloatDHT_2D.this.t[idx22 + FloatDHT_2D.this.rows];
                                            a[idx12 + 3] = FloatDHT_2D.this.t[idx22 + 2 * FloatDHT_2D.this.rows];
                                        }
                                    }
                                } else {
                                    for (int c = 4 * n0; c < FloatDHT_2D.this.columns; c += 4 * nthreads) {
                                        int idx23;
                                        int idx13;
                                        int r4;
                                        for (r4 = 0; r4 < FloatDHT_2D.this.rows; ++r4) {
                                            idx13 = r4 * FloatDHT_2D.this.columns + c;
                                            idx23 = startt + FloatDHT_2D.this.rows + r4;
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[startt + r4] = a[idx13];
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[idx23] = a[idx13 + 1];
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[idx23 + ((FloatDHT_2D)FloatDHT_2D.this).rows] = a[idx13 + 2];
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[idx23 + 2 * ((FloatDHT_2D)FloatDHT_2D.this).rows] = a[idx13 + 3];
                                        }
                                        FloatDHT_2D.this.dhtRows.inverse(FloatDHT_2D.this.t, startt, scale);
                                        FloatDHT_2D.this.dhtRows.inverse(FloatDHT_2D.this.t, startt + FloatDHT_2D.this.rows, scale);
                                        FloatDHT_2D.this.dhtRows.inverse(FloatDHT_2D.this.t, startt + 2 * FloatDHT_2D.this.rows, scale);
                                        FloatDHT_2D.this.dhtRows.inverse(FloatDHT_2D.this.t, startt + 3 * FloatDHT_2D.this.rows, scale);
                                        for (r4 = 0; r4 < FloatDHT_2D.this.rows; ++r4) {
                                            idx13 = r4 * FloatDHT_2D.this.columns + c;
                                            idx23 = startt + FloatDHT_2D.this.rows + r4;
                                            a[idx13] = FloatDHT_2D.this.t[startt + r4];
                                            a[idx13 + 1] = FloatDHT_2D.this.t[idx23];
                                            a[idx13 + 2] = FloatDHT_2D.this.t[idx23 + FloatDHT_2D.this.rows];
                                            a[idx13 + 3] = FloatDHT_2D.this.t[idx23 + 2 * FloatDHT_2D.this.rows];
                                        }
                                    }
                                }
                                break block17;
                            }
                            if (FloatDHT_2D.this.columns != 2 * nthreads) break block18;
                            for (r2 = 0; r2 < FloatDHT_2D.this.rows; ++r2) {
                                idx1 = r2 * FloatDHT_2D.this.columns + 2 * n0;
                                idx2 = startt + r2;
                                ((FloatDHT_2D)FloatDHT_2D.this).t[idx2] = a[idx1];
                                ((FloatDHT_2D)FloatDHT_2D.this).t[idx2 + ((FloatDHT_2D)FloatDHT_2D.this).rows] = a[idx1 + 1];
                            }
                            if (isgn == -1) {
                                FloatDHT_2D.this.dhtRows.forward(FloatDHT_2D.this.t, startt);
                                FloatDHT_2D.this.dhtRows.forward(FloatDHT_2D.this.t, startt + FloatDHT_2D.this.rows);
                            } else {
                                FloatDHT_2D.this.dhtRows.inverse(FloatDHT_2D.this.t, startt, scale);
                                FloatDHT_2D.this.dhtRows.inverse(FloatDHT_2D.this.t, startt + FloatDHT_2D.this.rows, scale);
                            }
                            for (r2 = 0; r2 < FloatDHT_2D.this.rows; ++r2) {
                                idx1 = r2 * FloatDHT_2D.this.columns + 2 * n0;
                                idx2 = startt + r2;
                                a[idx1] = FloatDHT_2D.this.t[idx2];
                                a[idx1 + 1] = FloatDHT_2D.this.t[idx2 + FloatDHT_2D.this.rows];
                            }
                            break block17;
                        }
                        if (FloatDHT_2D.this.columns != nthreads) break block17;
                        for (r = 0; r < FloatDHT_2D.this.rows; ++r) {
                            ((FloatDHT_2D)FloatDHT_2D.this).t[startt + r] = a[r * FloatDHT_2D.this.columns + n0];
                        }
                        if (isgn == -1) {
                            FloatDHT_2D.this.dhtRows.forward(FloatDHT_2D.this.t, startt);
                        } else {
                            FloatDHT_2D.this.dhtRows.inverse(FloatDHT_2D.this.t, startt, scale);
                        }
                        for (r = 0; r < FloatDHT_2D.this.rows; ++r) {
                            a[r * ((FloatDHT_2D)FloatDHT_2D.this).columns + n0] = FloatDHT_2D.this.t[startt + r];
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void ddxt2d_subth(final int isgn, final float[][] a, final boolean scale) {
        int nthread = ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.rows;
        if (this.columns == 2 * nthread) {
            nt >>= 1;
        } else if (this.columns < 2 * nthread) {
            nthread = this.columns;
            nt >>= 2;
        }
        final int nthreads = nthread;
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            final int startt = nt * i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block17: {
                        int r;
                        block18: {
                            int idx2;
                            int r2;
                            block16: {
                                if (FloatDHT_2D.this.columns <= 2 * nthreads) break block16;
                                if (isgn == -1) {
                                    for (int c = 4 * n0; c < FloatDHT_2D.this.columns; c += 4 * nthreads) {
                                        int idx22;
                                        int r3;
                                        for (r3 = 0; r3 < FloatDHT_2D.this.rows; ++r3) {
                                            idx22 = startt + FloatDHT_2D.this.rows + r3;
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[startt + r3] = a[r3][c];
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[idx22] = a[r3][c + 1];
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[idx22 + ((FloatDHT_2D)FloatDHT_2D.this).rows] = a[r3][c + 2];
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[idx22 + 2 * ((FloatDHT_2D)FloatDHT_2D.this).rows] = a[r3][c + 3];
                                        }
                                        FloatDHT_2D.this.dhtRows.forward(FloatDHT_2D.this.t, startt);
                                        FloatDHT_2D.this.dhtRows.forward(FloatDHT_2D.this.t, startt + FloatDHT_2D.this.rows);
                                        FloatDHT_2D.this.dhtRows.forward(FloatDHT_2D.this.t, startt + 2 * FloatDHT_2D.this.rows);
                                        FloatDHT_2D.this.dhtRows.forward(FloatDHT_2D.this.t, startt + 3 * FloatDHT_2D.this.rows);
                                        for (r3 = 0; r3 < FloatDHT_2D.this.rows; ++r3) {
                                            idx22 = startt + FloatDHT_2D.this.rows + r3;
                                            a[r3][c] = FloatDHT_2D.this.t[startt + r3];
                                            a[r3][c + 1] = FloatDHT_2D.this.t[idx22];
                                            a[r3][c + 2] = FloatDHT_2D.this.t[idx22 + FloatDHT_2D.this.rows];
                                            a[r3][c + 3] = FloatDHT_2D.this.t[idx22 + 2 * FloatDHT_2D.this.rows];
                                        }
                                    }
                                } else {
                                    for (int c = 4 * n0; c < FloatDHT_2D.this.columns; c += 4 * nthreads) {
                                        int idx23;
                                        int r4;
                                        for (r4 = 0; r4 < FloatDHT_2D.this.rows; ++r4) {
                                            idx23 = startt + FloatDHT_2D.this.rows + r4;
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[startt + r4] = a[r4][c];
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[idx23] = a[r4][c + 1];
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[idx23 + ((FloatDHT_2D)FloatDHT_2D.this).rows] = a[r4][c + 2];
                                            ((FloatDHT_2D)FloatDHT_2D.this).t[idx23 + 2 * ((FloatDHT_2D)FloatDHT_2D.this).rows] = a[r4][c + 3];
                                        }
                                        FloatDHT_2D.this.dhtRows.inverse(FloatDHT_2D.this.t, startt, scale);
                                        FloatDHT_2D.this.dhtRows.inverse(FloatDHT_2D.this.t, startt + FloatDHT_2D.this.rows, scale);
                                        FloatDHT_2D.this.dhtRows.inverse(FloatDHT_2D.this.t, startt + 2 * FloatDHT_2D.this.rows, scale);
                                        FloatDHT_2D.this.dhtRows.inverse(FloatDHT_2D.this.t, startt + 3 * FloatDHT_2D.this.rows, scale);
                                        for (r4 = 0; r4 < FloatDHT_2D.this.rows; ++r4) {
                                            idx23 = startt + FloatDHT_2D.this.rows + r4;
                                            a[r4][c] = FloatDHT_2D.this.t[startt + r4];
                                            a[r4][c + 1] = FloatDHT_2D.this.t[idx23];
                                            a[r4][c + 2] = FloatDHT_2D.this.t[idx23 + FloatDHT_2D.this.rows];
                                            a[r4][c + 3] = FloatDHT_2D.this.t[idx23 + 2 * FloatDHT_2D.this.rows];
                                        }
                                    }
                                }
                                break block17;
                            }
                            if (FloatDHT_2D.this.columns != 2 * nthreads) break block18;
                            for (r2 = 0; r2 < FloatDHT_2D.this.rows; ++r2) {
                                idx2 = startt + r2;
                                ((FloatDHT_2D)FloatDHT_2D.this).t[idx2] = a[r2][2 * n0];
                                ((FloatDHT_2D)FloatDHT_2D.this).t[idx2 + ((FloatDHT_2D)FloatDHT_2D.this).rows] = a[r2][2 * n0 + 1];
                            }
                            if (isgn == -1) {
                                FloatDHT_2D.this.dhtRows.forward(FloatDHT_2D.this.t, startt);
                                FloatDHT_2D.this.dhtRows.forward(FloatDHT_2D.this.t, startt + FloatDHT_2D.this.rows);
                            } else {
                                FloatDHT_2D.this.dhtRows.inverse(FloatDHT_2D.this.t, startt, scale);
                                FloatDHT_2D.this.dhtRows.inverse(FloatDHT_2D.this.t, startt + FloatDHT_2D.this.rows, scale);
                            }
                            for (r2 = 0; r2 < FloatDHT_2D.this.rows; ++r2) {
                                idx2 = startt + r2;
                                a[r2][2 * n0] = FloatDHT_2D.this.t[idx2];
                                a[r2][2 * n0 + 1] = FloatDHT_2D.this.t[idx2 + FloatDHT_2D.this.rows];
                            }
                            break block17;
                        }
                        if (FloatDHT_2D.this.columns != nthreads) break block17;
                        for (r = 0; r < FloatDHT_2D.this.rows; ++r) {
                            ((FloatDHT_2D)FloatDHT_2D.this).t[startt + r] = a[r][n0];
                        }
                        if (isgn == -1) {
                            FloatDHT_2D.this.dhtRows.forward(FloatDHT_2D.this.t, startt);
                        } else {
                            FloatDHT_2D.this.dhtRows.inverse(FloatDHT_2D.this.t, startt, scale);
                        }
                        for (r = 0; r < FloatDHT_2D.this.rows; ++r) {
                            a[r][n0] = FloatDHT_2D.this.t[startt + r];
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void ddxt2d0_subth(final int isgn, final float[] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (isgn == -1) {
                        for (int r = n0; r < FloatDHT_2D.this.rows; r += nthreads) {
                            FloatDHT_2D.this.dhtColumns.forward(a, r * FloatDHT_2D.this.columns);
                        }
                    } else {
                        for (int r = n0; r < FloatDHT_2D.this.rows; r += nthreads) {
                            FloatDHT_2D.this.dhtColumns.inverse(a, r * FloatDHT_2D.this.columns, scale);
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void ddxt2d0_subth(final int isgn, final float[][] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (isgn == -1) {
                        for (int r = n0; r < FloatDHT_2D.this.rows; r += nthreads) {
                            FloatDHT_2D.this.dhtColumns.forward(a[r]);
                        }
                    } else {
                        for (int r = n0; r < FloatDHT_2D.this.rows; r += nthreads) {
                            FloatDHT_2D.this.dhtColumns.inverse(a[r], scale);
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void ddxt2d_sub(int isgn, float[] a, boolean scale) {
        block13: {
            int idx1;
            int r;
            block12: {
                if (this.columns <= 2) break block12;
                if (isgn == -1) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int idx12;
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx12 = r2 * this.columns + c;
                            idx2 = this.rows + r2;
                            this.t[r2] = a[idx12];
                            this.t[idx2] = a[idx12 + 1];
                            this.t[idx2 + this.rows] = a[idx12 + 2];
                            this.t[idx2 + 2 * this.rows] = a[idx12 + 3];
                        }
                        this.dhtRows.forward(this.t, 0);
                        this.dhtRows.forward(this.t, this.rows);
                        this.dhtRows.forward(this.t, 2 * this.rows);
                        this.dhtRows.forward(this.t, 3 * this.rows);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx12 = r2 * this.columns + c;
                            idx2 = this.rows + r2;
                            a[idx12] = this.t[r2];
                            a[idx12 + 1] = this.t[idx2];
                            a[idx12 + 2] = this.t[idx2 + this.rows];
                            a[idx12 + 3] = this.t[idx2 + 2 * this.rows];
                        }
                    }
                } else {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int idx13;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx13 = r3 * this.columns + c;
                            idx2 = this.rows + r3;
                            this.t[r3] = a[idx13];
                            this.t[idx2] = a[idx13 + 1];
                            this.t[idx2 + this.rows] = a[idx13 + 2];
                            this.t[idx2 + 2 * this.rows] = a[idx13 + 3];
                        }
                        this.dhtRows.inverse(this.t, 0, scale);
                        this.dhtRows.inverse(this.t, this.rows, scale);
                        this.dhtRows.inverse(this.t, 2 * this.rows, scale);
                        this.dhtRows.inverse(this.t, 3 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx13 = r3 * this.columns + c;
                            idx2 = this.rows + r3;
                            a[idx13] = this.t[r3];
                            a[idx13 + 1] = this.t[idx2];
                            a[idx13 + 2] = this.t[idx2 + this.rows];
                            a[idx13 + 3] = this.t[idx2 + 2 * this.rows];
                        }
                    }
                }
                break block13;
            }
            if (this.columns != 2) break block13;
            for (r = 0; r < this.rows; ++r) {
                idx1 = r * this.columns;
                this.t[r] = a[idx1];
                this.t[this.rows + r] = a[idx1 + 1];
            }
            if (isgn == -1) {
                this.dhtRows.forward(this.t, 0);
                this.dhtRows.forward(this.t, this.rows);
            } else {
                this.dhtRows.inverse(this.t, 0, scale);
                this.dhtRows.inverse(this.t, this.rows, scale);
            }
            for (r = 0; r < this.rows; ++r) {
                idx1 = r * this.columns;
                a[idx1] = this.t[r];
                a[idx1 + 1] = this.t[this.rows + r];
            }
        }
    }

    private void ddxt2d_sub(int isgn, float[][] a, boolean scale) {
        block13: {
            int r;
            block12: {
                if (this.columns <= 2) break block12;
                if (isgn == -1) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx2 = this.rows + r2;
                            this.t[r2] = a[r2][c];
                            this.t[idx2] = a[r2][c + 1];
                            this.t[idx2 + this.rows] = a[r2][c + 2];
                            this.t[idx2 + 2 * this.rows] = a[r2][c + 3];
                        }
                        this.dhtRows.forward(this.t, 0);
                        this.dhtRows.forward(this.t, this.rows);
                        this.dhtRows.forward(this.t, 2 * this.rows);
                        this.dhtRows.forward(this.t, 3 * this.rows);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx2 = this.rows + r2;
                            a[r2][c] = this.t[r2];
                            a[r2][c + 1] = this.t[idx2];
                            a[r2][c + 2] = this.t[idx2 + this.rows];
                            a[r2][c + 3] = this.t[idx2 + 2 * this.rows];
                        }
                    }
                } else {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = this.rows + r3;
                            this.t[r3] = a[r3][c];
                            this.t[idx2] = a[r3][c + 1];
                            this.t[idx2 + this.rows] = a[r3][c + 2];
                            this.t[idx2 + 2 * this.rows] = a[r3][c + 3];
                        }
                        this.dhtRows.inverse(this.t, 0, scale);
                        this.dhtRows.inverse(this.t, this.rows, scale);
                        this.dhtRows.inverse(this.t, 2 * this.rows, scale);
                        this.dhtRows.inverse(this.t, 3 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = this.rows + r3;
                            a[r3][c] = this.t[r3];
                            a[r3][c + 1] = this.t[idx2];
                            a[r3][c + 2] = this.t[idx2 + this.rows];
                            a[r3][c + 3] = this.t[idx2 + 2 * this.rows];
                        }
                    }
                }
                break block13;
            }
            if (this.columns != 2) break block13;
            for (r = 0; r < this.rows; ++r) {
                this.t[r] = a[r][0];
                this.t[this.rows + r] = a[r][1];
            }
            if (isgn == -1) {
                this.dhtRows.forward(this.t, 0);
                this.dhtRows.forward(this.t, this.rows);
            } else {
                this.dhtRows.inverse(this.t, 0, scale);
                this.dhtRows.inverse(this.t, this.rows, scale);
            }
            for (r = 0; r < this.rows; ++r) {
                a[r][0] = this.t[r];
                a[r][1] = this.t[this.rows + r];
            }
        }
    }

    private void yTransform(float[] a) {
        for (int r = 0; r <= this.rows / 2; ++r) {
            int mRow = (this.rows - r) % this.rows;
            int idx1 = r * this.columns;
            int idx2 = mRow * this.columns;
            for (int c = 0; c <= this.columns / 2; ++c) {
                int mCol = (this.columns - c) % this.columns;
                float A = a[idx1 + c];
                float B = a[idx2 + c];
                float C = a[idx1 + mCol];
                float D = a[idx2 + mCol];
                float E = (A + D - (B + C)) / 2.0f;
                a[idx1 + c] = A - E;
                a[idx2 + c] = B + E;
                a[idx1 + mCol] = C + E;
                a[idx2 + mCol] = D - E;
            }
        }
    }

    private void y_transform(float[][] a) {
        for (int r = 0; r <= this.rows / 2; ++r) {
            int mRow = (this.rows - r) % this.rows;
            for (int c = 0; c <= this.columns / 2; ++c) {
                int mCol = (this.columns - c) % this.columns;
                float A = a[r][c];
                float B = a[mRow][c];
                float C = a[r][mCol];
                float D = a[mRow][mCol];
                float E = (A + D - (B + C)) / 2.0f;
                a[r][c] = A - E;
                a[mRow][c] = B + E;
                a[r][mCol] = C + E;
                a[mRow][mCol] = D - E;
            }
        }
    }
}

