/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.spectra.dct;

import de.gsi.math.spectra.dct.FloatDCT_1D;
import de.gsi.math.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class FloatDCT_3D {
    private final int slices;
    private final int rows;
    private final int columns;
    private final int sliceStride;
    private final int rowStride;
    private float[] t;
    private final FloatDCT_1D dctSlices;
    private FloatDCT_1D dctRows;
    private FloatDCT_1D dctColumns;
    private int oldNthreads;
    private int nt;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public FloatDCT_3D(int slices, int rows, int columns) {
        if (slices <= 1 || rows <= 1 || columns <= 1) {
            throw new IllegalArgumentException("slices, rows and columns must be greater than 1");
        }
        this.slices = slices;
        this.rows = rows;
        this.columns = columns;
        this.sliceStride = rows * columns;
        this.rowStride = columns;
        if (slices * rows * columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            this.useThreads = true;
        }
        if (ConcurrencyUtils.isPowerOf2(slices) && ConcurrencyUtils.isPowerOf2(rows) && ConcurrencyUtils.isPowerOf2(columns)) {
            this.isPowerOfTwo = true;
            this.oldNthreads = ConcurrencyUtils.getNumberOfThreads();
            this.nt = slices;
            if (this.nt < rows) {
                this.nt = rows;
            }
            this.nt *= 4;
            if (this.oldNthreads > 1) {
                this.nt *= this.oldNthreads;
            }
            if (columns == 2) {
                this.nt >>= 1;
            }
            this.t = new float[this.nt];
        }
        this.dctSlices = new FloatDCT_1D(slices);
        this.dctRows = slices == rows ? this.dctSlices : new FloatDCT_1D(rows);
        this.dctColumns = slices == columns ? this.dctSlices : (rows == columns ? this.dctRows : new FloatDCT_1D(columns));
    }

    public void forward(final float[] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 4;
                if (nthreads > 1) {
                    this.nt *= nthreads;
                }
                if (this.columns == 2) {
                    this.nt >>= 1;
                }
                this.t = new float[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, a, scale);
                this.ddxt3db_subth(-1, a, scale);
            } else {
                this.ddxt3da_sub(-1, a, scale);
                this.ddxt3db_sub(-1, a, scale);
            }
        } else if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
            int lastSlice;
            int firstSlice;
            int l;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            int idx1 = s * FloatDCT_3D.this.sliceStride;
                            for (int r = 0; r < FloatDCT_3D.this.rows; ++r) {
                                FloatDCT_3D.this.dctColumns.forward(a, idx1 + r * FloatDCT_3D.this.rowStride, scale);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] temp = new float[FloatDCT_3D.this.rows];
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            int idx1 = s * FloatDCT_3D.this.sliceStride;
                            for (int c = 0; c < FloatDCT_3D.this.columns; ++c) {
                                int idx3;
                                int r;
                                for (r = 0; r < FloatDCT_3D.this.rows; ++r) {
                                    idx3 = idx1 + r * FloatDCT_3D.this.rowStride + c;
                                    temp[r] = a[idx3];
                                }
                                FloatDCT_3D.this.dctRows.forward(temp, scale);
                                for (r = 0; r < FloatDCT_3D.this.rows; ++r) {
                                    idx3 = idx1 + r * FloatDCT_3D.this.rowStride + c;
                                    a[idx3] = temp[r];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.rows / nthreads;
            for (l = 0; l < nthreads; ++l) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] temp = new float[FloatDCT_3D.this.slices];
                        for (int r = firstRow; r < lastRow; ++r) {
                            int idx1 = r * FloatDCT_3D.this.rowStride;
                            for (int c = 0; c < FloatDCT_3D.this.columns; ++c) {
                                int idx3;
                                int s;
                                for (s = 0; s < FloatDCT_3D.this.slices; ++s) {
                                    idx3 = s * FloatDCT_3D.this.sliceStride + idx1 + c;
                                    temp[s] = a[idx3];
                                }
                                FloatDCT_3D.this.dctSlices.forward(temp, scale);
                                for (s = 0; s < FloatDCT_3D.this.slices; ++s) {
                                    idx3 = s * FloatDCT_3D.this.sliceStride + idx1 + c;
                                    a[idx3] = temp[s];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx3;
            int c;
            int idx1;
            for (int s = 0; s < this.slices; ++s) {
                int idx12 = s * this.sliceStride;
                for (int r = 0; r < this.rows; ++r) {
                    this.dctColumns.forward(a, idx12 + r * this.rowStride, scale);
                }
            }
            float[] temp = new float[this.rows];
            for (int s = 0; s < this.slices; ++s) {
                idx1 = s * this.sliceStride;
                for (c = 0; c < this.columns; ++c) {
                    int r;
                    for (r = 0; r < this.rows; ++r) {
                        idx3 = idx1 + r * this.rowStride + c;
                        temp[r] = a[idx3];
                    }
                    this.dctRows.forward(temp, scale);
                    for (r = 0; r < this.rows; ++r) {
                        idx3 = idx1 + r * this.rowStride + c;
                        a[idx3] = temp[r];
                    }
                }
            }
            temp = new float[this.slices];
            for (int r = 0; r < this.rows; ++r) {
                idx1 = r * this.rowStride;
                for (c = 0; c < this.columns; ++c) {
                    int s;
                    for (s = 0; s < this.slices; ++s) {
                        idx3 = s * this.sliceStride + idx1 + c;
                        temp[s] = a[idx3];
                    }
                    this.dctSlices.forward(temp, scale);
                    for (s = 0; s < this.slices; ++s) {
                        idx3 = s * this.sliceStride + idx1 + c;
                        a[idx3] = temp[s];
                    }
                }
            }
        }
    }

    public void forward(final float[][][] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 4;
                if (nthreads > 1) {
                    this.nt *= nthreads;
                }
                if (this.columns == 2) {
                    this.nt >>= 1;
                }
                this.t = new float[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(-1, a, scale);
                this.ddxt3db_subth(-1, a, scale);
            } else {
                this.ddxt3da_sub(-1, a, scale);
                this.ddxt3db_sub(-1, a, scale);
            }
        } else if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
            int lastSlice;
            int firstSlice;
            int l;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < FloatDCT_3D.this.rows; ++r) {
                                FloatDCT_3D.this.dctColumns.forward(a[s][r], scale);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] temp = new float[FloatDCT_3D.this.rows];
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int c = 0; c < FloatDCT_3D.this.columns; ++c) {
                                int r;
                                for (r = 0; r < FloatDCT_3D.this.rows; ++r) {
                                    temp[r] = a[s][r][c];
                                }
                                FloatDCT_3D.this.dctRows.forward(temp, scale);
                                for (r = 0; r < FloatDCT_3D.this.rows; ++r) {
                                    a[s][r][c] = temp[r];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.rows / nthreads;
            for (l = 0; l < nthreads; ++l) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] temp = new float[FloatDCT_3D.this.slices];
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < FloatDCT_3D.this.columns; ++c) {
                                int s;
                                for (s = 0; s < FloatDCT_3D.this.slices; ++s) {
                                    temp[s] = a[s][r][c];
                                }
                                FloatDCT_3D.this.dctSlices.forward(temp, scale);
                                for (s = 0; s < FloatDCT_3D.this.slices; ++s) {
                                    a[s][r][c] = temp[s];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int c;
            int r;
            for (int s = 0; s < this.slices; ++s) {
                for (r = 0; r < this.rows; ++r) {
                    this.dctColumns.forward(a[s][r], scale);
                }
            }
            float[] temp = new float[this.rows];
            for (int s = 0; s < this.slices; ++s) {
                for (c = 0; c < this.columns; ++c) {
                    int r2;
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        temp[r2] = a[s][r2][c];
                    }
                    this.dctRows.forward(temp, scale);
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        a[s][r2][c] = temp[r2];
                    }
                }
            }
            temp = new float[this.slices];
            for (r = 0; r < this.rows; ++r) {
                for (c = 0; c < this.columns; ++c) {
                    int s;
                    for (s = 0; s < this.slices; ++s) {
                        temp[s] = a[s][r][c];
                    }
                    this.dctSlices.forward(temp, scale);
                    for (s = 0; s < this.slices; ++s) {
                        a[s][r][c] = temp[s];
                    }
                }
            }
        }
    }

    public void inverse(final float[] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 4;
                if (nthreads > 1) {
                    this.nt *= nthreads;
                }
                if (this.columns == 2) {
                    this.nt >>= 1;
                }
                this.t = new float[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(1, a, scale);
                this.ddxt3db_subth(1, a, scale);
            } else {
                this.ddxt3da_sub(1, a, scale);
                this.ddxt3db_sub(1, a, scale);
            }
        } else if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
            int lastSlice;
            int firstSlice;
            int l;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            int idx1 = s * FloatDCT_3D.this.sliceStride;
                            for (int r = 0; r < FloatDCT_3D.this.rows; ++r) {
                                FloatDCT_3D.this.dctColumns.inverse(a, idx1 + r * FloatDCT_3D.this.rowStride, scale);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] temp = new float[FloatDCT_3D.this.rows];
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            int idx1 = s * FloatDCT_3D.this.sliceStride;
                            for (int c = 0; c < FloatDCT_3D.this.columns; ++c) {
                                int idx3;
                                int r;
                                for (r = 0; r < FloatDCT_3D.this.rows; ++r) {
                                    idx3 = idx1 + r * FloatDCT_3D.this.rowStride + c;
                                    temp[r] = a[idx3];
                                }
                                FloatDCT_3D.this.dctRows.inverse(temp, scale);
                                for (r = 0; r < FloatDCT_3D.this.rows; ++r) {
                                    idx3 = idx1 + r * FloatDCT_3D.this.rowStride + c;
                                    a[idx3] = temp[r];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.rows / nthreads;
            for (l = 0; l < nthreads; ++l) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] temp = new float[FloatDCT_3D.this.slices];
                        for (int r = firstRow; r < lastRow; ++r) {
                            int idx1 = r * FloatDCT_3D.this.rowStride;
                            for (int c = 0; c < FloatDCT_3D.this.columns; ++c) {
                                int idx3;
                                int s;
                                for (s = 0; s < FloatDCT_3D.this.slices; ++s) {
                                    idx3 = s * FloatDCT_3D.this.sliceStride + idx1 + c;
                                    temp[s] = a[idx3];
                                }
                                FloatDCT_3D.this.dctSlices.inverse(temp, scale);
                                for (s = 0; s < FloatDCT_3D.this.slices; ++s) {
                                    idx3 = s * FloatDCT_3D.this.sliceStride + idx1 + c;
                                    a[idx3] = temp[s];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx3;
            int c;
            int idx1;
            for (int s = 0; s < this.slices; ++s) {
                int idx12 = s * this.sliceStride;
                for (int r = 0; r < this.rows; ++r) {
                    this.dctColumns.inverse(a, idx12 + r * this.rowStride, scale);
                }
            }
            float[] temp = new float[this.rows];
            for (int s = 0; s < this.slices; ++s) {
                idx1 = s * this.sliceStride;
                for (c = 0; c < this.columns; ++c) {
                    int r;
                    for (r = 0; r < this.rows; ++r) {
                        idx3 = idx1 + r * this.rowStride + c;
                        temp[r] = a[idx3];
                    }
                    this.dctRows.inverse(temp, scale);
                    for (r = 0; r < this.rows; ++r) {
                        idx3 = idx1 + r * this.rowStride + c;
                        a[idx3] = temp[r];
                    }
                }
            }
            temp = new float[this.slices];
            for (int r = 0; r < this.rows; ++r) {
                idx1 = r * this.rowStride;
                for (c = 0; c < this.columns; ++c) {
                    int s;
                    for (s = 0; s < this.slices; ++s) {
                        idx3 = s * this.sliceStride + idx1 + c;
                        temp[s] = a[idx3];
                    }
                    this.dctSlices.inverse(temp, scale);
                    for (s = 0; s < this.slices; ++s) {
                        idx3 = s * this.sliceStride + idx1 + c;
                        a[idx3] = temp[s];
                    }
                }
            }
        }
    }

    public void inverse(final float[][][] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads != this.oldNthreads) {
                this.nt = this.slices;
                if (this.nt < this.rows) {
                    this.nt = this.rows;
                }
                this.nt *= 4;
                if (nthreads > 1) {
                    this.nt *= nthreads;
                }
                if (this.columns == 2) {
                    this.nt >>= 1;
                }
                this.t = new float[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.ddxt3da_subth(1, a, scale);
                this.ddxt3db_subth(1, a, scale);
            } else {
                this.ddxt3da_sub(1, a, scale);
                this.ddxt3db_sub(1, a, scale);
            }
        } else if (nthreads > 1 && this.useThreads && this.slices >= nthreads && this.rows >= nthreads && this.columns >= nthreads) {
            int lastSlice;
            int firstSlice;
            int l;
            Future[] futures = new Future[nthreads];
            int p = this.slices / nthreads;
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int r = 0; r < FloatDCT_3D.this.rows; ++r) {
                                FloatDCT_3D.this.dctColumns.inverse(a[s][r], scale);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            for (l = 0; l < nthreads; ++l) {
                firstSlice = l * p;
                lastSlice = l == nthreads - 1 ? this.slices : firstSlice + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] temp = new float[FloatDCT_3D.this.rows];
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            for (int c = 0; c < FloatDCT_3D.this.columns; ++c) {
                                int r;
                                for (r = 0; r < FloatDCT_3D.this.rows; ++r) {
                                    temp[r] = a[s][r][c];
                                }
                                FloatDCT_3D.this.dctRows.inverse(temp, scale);
                                for (r = 0; r < FloatDCT_3D.this.rows; ++r) {
                                    a[s][r][c] = temp[r];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.rows / nthreads;
            for (l = 0; l < nthreads; ++l) {
                final int firstRow = l * p;
                final int lastRow = l == nthreads - 1 ? this.rows : firstRow + p;
                futures[l] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] temp = new float[FloatDCT_3D.this.slices];
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < FloatDCT_3D.this.columns; ++c) {
                                int s;
                                for (s = 0; s < FloatDCT_3D.this.slices; ++s) {
                                    temp[s] = a[s][r][c];
                                }
                                FloatDCT_3D.this.dctSlices.inverse(temp, scale);
                                for (s = 0; s < FloatDCT_3D.this.slices; ++s) {
                                    a[s][r][c] = temp[s];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int c;
            int r;
            for (int s = 0; s < this.slices; ++s) {
                for (r = 0; r < this.rows; ++r) {
                    this.dctColumns.inverse(a[s][r], scale);
                }
            }
            float[] temp = new float[this.rows];
            for (int s = 0; s < this.slices; ++s) {
                for (c = 0; c < this.columns; ++c) {
                    int r2;
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        temp[r2] = a[s][r2][c];
                    }
                    this.dctRows.inverse(temp, scale);
                    for (r2 = 0; r2 < this.rows; ++r2) {
                        a[s][r2][c] = temp[r2];
                    }
                }
            }
            temp = new float[this.slices];
            for (r = 0; r < this.rows; ++r) {
                for (c = 0; c < this.columns; ++c) {
                    int s;
                    for (s = 0; s < this.slices; ++s) {
                        temp[s] = a[s][r][c];
                    }
                    this.dctSlices.inverse(temp, scale);
                    for (s = 0; s < this.slices; ++s) {
                        a[s][r][c] = temp[s];
                    }
                }
            }
        }
    }

    private void ddxt3da_sub(int isgn, float[] a, boolean scale) {
        if (isgn == -1) {
            for (int s = 0; s < this.slices; ++s) {
                int idx1;
                int r;
                int idx0 = s * this.sliceStride;
                for (r = 0; r < this.rows; ++r) {
                    this.dctColumns.forward(a, idx0 + r * this.rowStride, scale);
                }
                if (this.columns > 2) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx1 = idx0 + r2 * this.rowStride + c;
                            idx2 = this.rows + r2;
                            this.t[r2] = a[idx1];
                            this.t[idx2] = a[idx1 + 1];
                            this.t[idx2 + this.rows] = a[idx1 + 2];
                            this.t[idx2 + 2 * this.rows] = a[idx1 + 3];
                        }
                        this.dctRows.forward(this.t, 0, scale);
                        this.dctRows.forward(this.t, this.rows, scale);
                        this.dctRows.forward(this.t, 2 * this.rows, scale);
                        this.dctRows.forward(this.t, 3 * this.rows, scale);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx1 = idx0 + r2 * this.rowStride + c;
                            idx2 = this.rows + r2;
                            a[idx1] = this.t[r2];
                            a[idx1 + 1] = this.t[idx2];
                            a[idx1 + 2] = this.t[idx2 + this.rows];
                            a[idx1 + 3] = this.t[idx2 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    this.t[r] = a[idx1];
                    this.t[this.rows + r] = a[idx1 + 1];
                }
                this.dctRows.forward(this.t, 0, scale);
                this.dctRows.forward(this.t, this.rows, scale);
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    a[idx1] = this.t[r];
                    a[idx1 + 1] = this.t[this.rows + r];
                }
            }
        } else {
            for (int s = 0; s < this.slices; ++s) {
                int idx1;
                int r;
                int idx0 = s * this.sliceStride;
                for (r = 0; r < this.rows; ++r) {
                    this.dctColumns.inverse(a, idx0 + r * this.rowStride, scale);
                }
                if (this.columns > 2) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx1 = idx0 + r3 * this.rowStride + c;
                            idx2 = this.rows + r3;
                            this.t[r3] = a[idx1];
                            this.t[idx2] = a[idx1 + 1];
                            this.t[idx2 + this.rows] = a[idx1 + 2];
                            this.t[idx2 + 2 * this.rows] = a[idx1 + 3];
                        }
                        this.dctRows.inverse(this.t, 0, scale);
                        this.dctRows.inverse(this.t, this.rows, scale);
                        this.dctRows.inverse(this.t, 2 * this.rows, scale);
                        this.dctRows.inverse(this.t, 3 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx1 = idx0 + r3 * this.rowStride + c;
                            idx2 = this.rows + r3;
                            a[idx1] = this.t[r3];
                            a[idx1 + 1] = this.t[idx2];
                            a[idx1 + 2] = this.t[idx2 + this.rows];
                            a[idx1 + 3] = this.t[idx2 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    this.t[r] = a[idx1];
                    this.t[this.rows + r] = a[idx1 + 1];
                }
                this.dctRows.inverse(this.t, 0, scale);
                this.dctRows.inverse(this.t, this.rows, scale);
                for (r = 0; r < this.rows; ++r) {
                    idx1 = idx0 + r * this.rowStride;
                    a[idx1] = this.t[r];
                    a[idx1 + 1] = this.t[this.rows + r];
                }
            }
        }
    }

    private void ddxt3da_sub(int isgn, float[][][] a, boolean scale) {
        if (isgn == -1) {
            for (int s = 0; s < this.slices; ++s) {
                int r;
                for (r = 0; r < this.rows; ++r) {
                    this.dctColumns.forward(a[s][r], scale);
                }
                if (this.columns > 2) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int r2;
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx2 = this.rows + r2;
                            this.t[r2] = a[s][r2][c];
                            this.t[idx2] = a[s][r2][c + 1];
                            this.t[idx2 + this.rows] = a[s][r2][c + 2];
                            this.t[idx2 + 2 * this.rows] = a[s][r2][c + 3];
                        }
                        this.dctRows.forward(this.t, 0, scale);
                        this.dctRows.forward(this.t, this.rows, scale);
                        this.dctRows.forward(this.t, 2 * this.rows, scale);
                        this.dctRows.forward(this.t, 3 * this.rows, scale);
                        for (r2 = 0; r2 < this.rows; ++r2) {
                            idx2 = this.rows + r2;
                            a[s][r2][c] = this.t[r2];
                            a[s][r2][c + 1] = this.t[idx2];
                            a[s][r2][c + 2] = this.t[idx2 + this.rows];
                            a[s][r2][c + 3] = this.t[idx2 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    this.t[r] = a[s][r][0];
                    this.t[this.rows + r] = a[s][r][1];
                }
                this.dctRows.forward(this.t, 0, scale);
                this.dctRows.forward(this.t, this.rows, scale);
                for (r = 0; r < this.rows; ++r) {
                    a[s][r][0] = this.t[r];
                    a[s][r][1] = this.t[this.rows + r];
                }
            }
        } else {
            for (int s = 0; s < this.slices; ++s) {
                int r;
                for (r = 0; r < this.rows; ++r) {
                    this.dctColumns.inverse(a[s][r], scale);
                }
                if (this.columns > 2) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int r3;
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = this.rows + r3;
                            this.t[r3] = a[s][r3][c];
                            this.t[idx2] = a[s][r3][c + 1];
                            this.t[idx2 + this.rows] = a[s][r3][c + 2];
                            this.t[idx2 + 2 * this.rows] = a[s][r3][c + 3];
                        }
                        this.dctRows.inverse(this.t, 0, scale);
                        this.dctRows.inverse(this.t, this.rows, scale);
                        this.dctRows.inverse(this.t, 2 * this.rows, scale);
                        this.dctRows.inverse(this.t, 3 * this.rows, scale);
                        for (r3 = 0; r3 < this.rows; ++r3) {
                            idx2 = this.rows + r3;
                            a[s][r3][c] = this.t[r3];
                            a[s][r3][c + 1] = this.t[idx2];
                            a[s][r3][c + 2] = this.t[idx2 + this.rows];
                            a[s][r3][c + 3] = this.t[idx2 + 2 * this.rows];
                        }
                    }
                    continue;
                }
                if (this.columns != 2) continue;
                for (r = 0; r < this.rows; ++r) {
                    this.t[r] = a[s][r][0];
                    this.t[this.rows + r] = a[s][r][1];
                }
                this.dctRows.inverse(this.t, 0, scale);
                this.dctRows.inverse(this.t, this.rows, scale);
                for (r = 0; r < this.rows; ++r) {
                    a[s][r][0] = this.t[r];
                    a[s][r][1] = this.t[this.rows + r];
                }
            }
        }
    }

    private void ddxt3db_sub(int isgn, float[] a, boolean scale) {
        block19: {
            block17: {
                block18: {
                    if (isgn != -1) break block17;
                    if (this.columns <= 2) break block18;
                    for (int r = 0; r < this.rows; ++r) {
                        int idx0 = r * this.rowStride;
                        for (int c = 0; c < this.columns; c += 4) {
                            int idx2;
                            int idx1;
                            int s;
                            for (s = 0; s < this.slices; ++s) {
                                idx1 = s * this.sliceStride + idx0 + c;
                                idx2 = this.slices + s;
                                this.t[s] = a[idx1];
                                this.t[idx2] = a[idx1 + 1];
                                this.t[idx2 + this.slices] = a[idx1 + 2];
                                this.t[idx2 + 2 * this.slices] = a[idx1 + 3];
                            }
                            this.dctSlices.forward(this.t, 0, scale);
                            this.dctSlices.forward(this.t, this.slices, scale);
                            this.dctSlices.forward(this.t, 2 * this.slices, scale);
                            this.dctSlices.forward(this.t, 3 * this.slices, scale);
                            for (s = 0; s < this.slices; ++s) {
                                idx1 = s * this.sliceStride + idx0 + c;
                                idx2 = this.slices + s;
                                a[idx1] = this.t[s];
                                a[idx1 + 1] = this.t[idx2];
                                a[idx1 + 2] = this.t[idx2 + this.slices];
                                a[idx1 + 3] = this.t[idx2 + 2 * this.slices];
                            }
                        }
                    }
                    break block19;
                }
                if (this.columns != 2) break block19;
                for (int r = 0; r < this.rows; ++r) {
                    int idx1;
                    int s;
                    int idx0 = r * this.rowStride;
                    for (s = 0; s < this.slices; ++s) {
                        idx1 = s * this.sliceStride + idx0;
                        this.t[s] = a[idx1];
                        this.t[this.slices + s] = a[idx1 + 1];
                    }
                    this.dctSlices.forward(this.t, 0, scale);
                    this.dctSlices.forward(this.t, this.slices, scale);
                    for (s = 0; s < this.slices; ++s) {
                        idx1 = s * this.sliceStride + idx0;
                        a[idx1] = this.t[s];
                        a[idx1 + 1] = this.t[this.slices + s];
                    }
                }
                break block19;
            }
            if (this.columns > 2) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx0 = r * this.rowStride;
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int idx1;
                        int s;
                        for (s = 0; s < this.slices; ++s) {
                            idx1 = s * this.sliceStride + idx0 + c;
                            idx2 = this.slices + s;
                            this.t[s] = a[idx1];
                            this.t[idx2] = a[idx1 + 1];
                            this.t[idx2 + this.slices] = a[idx1 + 2];
                            this.t[idx2 + 2 * this.slices] = a[idx1 + 3];
                        }
                        this.dctSlices.inverse(this.t, 0, scale);
                        this.dctSlices.inverse(this.t, this.slices, scale);
                        this.dctSlices.inverse(this.t, 2 * this.slices, scale);
                        this.dctSlices.inverse(this.t, 3 * this.slices, scale);
                        for (s = 0; s < this.slices; ++s) {
                            idx1 = s * this.sliceStride + idx0 + c;
                            idx2 = this.slices + s;
                            a[idx1] = this.t[s];
                            a[idx1 + 1] = this.t[idx2];
                            a[idx1 + 2] = this.t[idx2 + this.slices];
                            a[idx1 + 3] = this.t[idx2 + 2 * this.slices];
                        }
                    }
                }
            } else if (this.columns == 2) {
                for (int r = 0; r < this.rows; ++r) {
                    int idx1;
                    int s;
                    int idx0 = r * this.rowStride;
                    for (s = 0; s < this.slices; ++s) {
                        idx1 = s * this.sliceStride + idx0;
                        this.t[s] = a[idx1];
                        this.t[this.slices + s] = a[idx1 + 1];
                    }
                    this.dctSlices.inverse(this.t, 0, scale);
                    this.dctSlices.inverse(this.t, this.slices, scale);
                    for (s = 0; s < this.slices; ++s) {
                        idx1 = s * this.sliceStride + idx0;
                        a[idx1] = this.t[s];
                        a[idx1 + 1] = this.t[this.slices + s];
                    }
                }
            }
        }
    }

    private void ddxt3db_sub(int isgn, float[][][] a, boolean scale) {
        block19: {
            block17: {
                block18: {
                    if (isgn != -1) break block17;
                    if (this.columns <= 2) break block18;
                    for (int r = 0; r < this.rows; ++r) {
                        for (int c = 0; c < this.columns; c += 4) {
                            int idx2;
                            int s;
                            for (s = 0; s < this.slices; ++s) {
                                idx2 = this.slices + s;
                                this.t[s] = a[s][r][c];
                                this.t[idx2] = a[s][r][c + 1];
                                this.t[idx2 + this.slices] = a[s][r][c + 2];
                                this.t[idx2 + 2 * this.slices] = a[s][r][c + 3];
                            }
                            this.dctSlices.forward(this.t, 0, scale);
                            this.dctSlices.forward(this.t, this.slices, scale);
                            this.dctSlices.forward(this.t, 2 * this.slices, scale);
                            this.dctSlices.forward(this.t, 3 * this.slices, scale);
                            for (s = 0; s < this.slices; ++s) {
                                idx2 = this.slices + s;
                                a[s][r][c] = this.t[s];
                                a[s][r][c + 1] = this.t[idx2];
                                a[s][r][c + 2] = this.t[idx2 + this.slices];
                                a[s][r][c + 3] = this.t[idx2 + 2 * this.slices];
                            }
                        }
                    }
                    break block19;
                }
                if (this.columns != 2) break block19;
                for (int r = 0; r < this.rows; ++r) {
                    int s;
                    for (s = 0; s < this.slices; ++s) {
                        this.t[s] = a[s][r][0];
                        this.t[this.slices + s] = a[s][r][1];
                    }
                    this.dctSlices.forward(this.t, 0, scale);
                    this.dctSlices.forward(this.t, this.slices, scale);
                    for (s = 0; s < this.slices; ++s) {
                        a[s][r][0] = this.t[s];
                        a[s][r][1] = this.t[this.slices + s];
                    }
                }
                break block19;
            }
            if (this.columns > 2) {
                for (int r = 0; r < this.rows; ++r) {
                    for (int c = 0; c < this.columns; c += 4) {
                        int idx2;
                        int s;
                        for (s = 0; s < this.slices; ++s) {
                            idx2 = this.slices + s;
                            this.t[s] = a[s][r][c];
                            this.t[idx2] = a[s][r][c + 1];
                            this.t[idx2 + this.slices] = a[s][r][c + 2];
                            this.t[idx2 + 2 * this.slices] = a[s][r][c + 3];
                        }
                        this.dctSlices.inverse(this.t, 0, scale);
                        this.dctSlices.inverse(this.t, this.slices, scale);
                        this.dctSlices.inverse(this.t, 2 * this.slices, scale);
                        this.dctSlices.inverse(this.t, 3 * this.slices, scale);
                        for (s = 0; s < this.slices; ++s) {
                            idx2 = this.slices + s;
                            a[s][r][c] = this.t[s];
                            a[s][r][c + 1] = this.t[idx2];
                            a[s][r][c + 2] = this.t[idx2 + this.slices];
                            a[s][r][c + 3] = this.t[idx2 + 2 * this.slices];
                        }
                    }
                }
            } else if (this.columns == 2) {
                for (int r = 0; r < this.rows; ++r) {
                    int s;
                    for (s = 0; s < this.slices; ++s) {
                        this.t[s] = a[s][r][0];
                        this.t[this.slices + s] = a[s][r][1];
                    }
                    this.dctSlices.inverse(this.t, 0, scale);
                    this.dctSlices.inverse(this.t, this.slices, scale);
                    for (s = 0; s < this.slices; ++s) {
                        a[s][r][0] = this.t[s];
                        a[s][r][1] = this.t[this.slices + s];
                    }
                }
            }
        }
    }

    private void ddxt3da_subth(final int isgn, final float[] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.slices ? this.slices : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        }
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            final int startt = nt * i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (isgn == -1) {
                        for (int s = n0; s < FloatDCT_3D.this.slices; s += nthreads) {
                            int idx1;
                            int r;
                            int idx0 = s * FloatDCT_3D.this.sliceStride;
                            for (r = 0; r < FloatDCT_3D.this.rows; ++r) {
                                FloatDCT_3D.this.dctColumns.forward(a, idx0 + r * FloatDCT_3D.this.rowStride, scale);
                            }
                            if (FloatDCT_3D.this.columns > 2) {
                                for (int c = 0; c < FloatDCT_3D.this.columns; c += 4) {
                                    int idx2;
                                    int r2;
                                    for (r2 = 0; r2 < FloatDCT_3D.this.rows; ++r2) {
                                        idx1 = idx0 + r2 * FloatDCT_3D.this.rowStride + c;
                                        idx2 = startt + FloatDCT_3D.this.rows + r2;
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[startt + r2] = a[idx1];
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[idx2] = a[idx1 + 1];
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[idx2 + ((FloatDCT_3D)FloatDCT_3D.this).rows] = a[idx1 + 2];
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[idx2 + 2 * ((FloatDCT_3D)FloatDCT_3D.this).rows] = a[idx1 + 3];
                                    }
                                    FloatDCT_3D.this.dctRows.forward(FloatDCT_3D.this.t, startt, scale);
                                    FloatDCT_3D.this.dctRows.forward(FloatDCT_3D.this.t, startt + FloatDCT_3D.this.rows, scale);
                                    FloatDCT_3D.this.dctRows.forward(FloatDCT_3D.this.t, startt + 2 * FloatDCT_3D.this.rows, scale);
                                    FloatDCT_3D.this.dctRows.forward(FloatDCT_3D.this.t, startt + 3 * FloatDCT_3D.this.rows, scale);
                                    for (r2 = 0; r2 < FloatDCT_3D.this.rows; ++r2) {
                                        idx1 = idx0 + r2 * FloatDCT_3D.this.rowStride + c;
                                        idx2 = startt + FloatDCT_3D.this.rows + r2;
                                        a[idx1] = FloatDCT_3D.this.t[startt + r2];
                                        a[idx1 + 1] = FloatDCT_3D.this.t[idx2];
                                        a[idx1 + 2] = FloatDCT_3D.this.t[idx2 + FloatDCT_3D.this.rows];
                                        a[idx1 + 3] = FloatDCT_3D.this.t[idx2 + 2 * FloatDCT_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (FloatDCT_3D.this.columns != 2) continue;
                            for (r = 0; r < FloatDCT_3D.this.rows; ++r) {
                                idx1 = idx0 + r * FloatDCT_3D.this.rowStride;
                                ((FloatDCT_3D)FloatDCT_3D.this).t[startt + r] = a[idx1];
                                ((FloatDCT_3D)FloatDCT_3D.this).t[startt + ((FloatDCT_3D)FloatDCT_3D.this).rows + r] = a[idx1 + 1];
                            }
                            FloatDCT_3D.this.dctRows.forward(FloatDCT_3D.this.t, startt, scale);
                            FloatDCT_3D.this.dctRows.forward(FloatDCT_3D.this.t, startt + FloatDCT_3D.this.rows, scale);
                            for (r = 0; r < FloatDCT_3D.this.rows; ++r) {
                                idx1 = idx0 + r * FloatDCT_3D.this.rowStride;
                                a[idx1] = FloatDCT_3D.this.t[startt + r];
                                a[idx1 + 1] = FloatDCT_3D.this.t[startt + FloatDCT_3D.this.rows + r];
                            }
                        }
                    } else {
                        for (int s = n0; s < FloatDCT_3D.this.slices; s += nthreads) {
                            int idx1;
                            int r;
                            int idx0 = s * FloatDCT_3D.this.sliceStride;
                            for (r = 0; r < FloatDCT_3D.this.rows; ++r) {
                                FloatDCT_3D.this.dctColumns.inverse(a, idx0 + r * FloatDCT_3D.this.rowStride, scale);
                            }
                            if (FloatDCT_3D.this.columns > 2) {
                                for (int c = 0; c < FloatDCT_3D.this.columns; c += 4) {
                                    int idx2;
                                    int j;
                                    for (j = 0; j < FloatDCT_3D.this.rows; ++j) {
                                        idx1 = idx0 + j * FloatDCT_3D.this.rowStride + c;
                                        idx2 = startt + FloatDCT_3D.this.rows + j;
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[startt + j] = a[idx1];
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[idx2] = a[idx1 + 1];
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[idx2 + ((FloatDCT_3D)FloatDCT_3D.this).rows] = a[idx1 + 2];
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[idx2 + 2 * ((FloatDCT_3D)FloatDCT_3D.this).rows] = a[idx1 + 3];
                                    }
                                    FloatDCT_3D.this.dctRows.inverse(FloatDCT_3D.this.t, startt, scale);
                                    FloatDCT_3D.this.dctRows.inverse(FloatDCT_3D.this.t, startt + FloatDCT_3D.this.rows, scale);
                                    FloatDCT_3D.this.dctRows.inverse(FloatDCT_3D.this.t, startt + 2 * FloatDCT_3D.this.rows, scale);
                                    FloatDCT_3D.this.dctRows.inverse(FloatDCT_3D.this.t, startt + 3 * FloatDCT_3D.this.rows, scale);
                                    for (j = 0; j < FloatDCT_3D.this.rows; ++j) {
                                        idx1 = idx0 + j * FloatDCT_3D.this.rowStride + c;
                                        idx2 = startt + FloatDCT_3D.this.rows + j;
                                        a[idx1] = FloatDCT_3D.this.t[startt + j];
                                        a[idx1 + 1] = FloatDCT_3D.this.t[idx2];
                                        a[idx1 + 2] = FloatDCT_3D.this.t[idx2 + FloatDCT_3D.this.rows];
                                        a[idx1 + 3] = FloatDCT_3D.this.t[idx2 + 2 * FloatDCT_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (FloatDCT_3D.this.columns != 2) continue;
                            for (r = 0; r < FloatDCT_3D.this.rows; ++r) {
                                idx1 = idx0 + r * FloatDCT_3D.this.rowStride;
                                ((FloatDCT_3D)FloatDCT_3D.this).t[startt + r] = a[idx1];
                                ((FloatDCT_3D)FloatDCT_3D.this).t[startt + ((FloatDCT_3D)FloatDCT_3D.this).rows + r] = a[idx1 + 1];
                            }
                            FloatDCT_3D.this.dctRows.inverse(FloatDCT_3D.this.t, startt, scale);
                            FloatDCT_3D.this.dctRows.inverse(FloatDCT_3D.this.t, startt + FloatDCT_3D.this.rows, scale);
                            for (r = 0; r < FloatDCT_3D.this.rows; ++r) {
                                idx1 = idx0 + r * FloatDCT_3D.this.rowStride;
                                a[idx1] = FloatDCT_3D.this.t[startt + r];
                                a[idx1 + 1] = FloatDCT_3D.this.t[startt + FloatDCT_3D.this.rows + r];
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void ddxt3da_subth(final int isgn, final float[][][] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.slices ? this.slices : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.rows;
        if (this.columns == 2) {
            nt >>= 1;
        }
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            final int startt = nt * i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    if (isgn == -1) {
                        for (int s = n0; s < FloatDCT_3D.this.slices; s += nthreads) {
                            int r;
                            for (r = 0; r < FloatDCT_3D.this.rows; ++r) {
                                FloatDCT_3D.this.dctColumns.forward(a[s][r], scale);
                            }
                            if (FloatDCT_3D.this.columns > 2) {
                                for (int c = 0; c < FloatDCT_3D.this.columns; c += 4) {
                                    int idx2;
                                    int r2;
                                    for (r2 = 0; r2 < FloatDCT_3D.this.rows; ++r2) {
                                        idx2 = startt + FloatDCT_3D.this.rows + r2;
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[startt + r2] = a[s][r2][c];
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[idx2] = a[s][r2][c + 1];
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[idx2 + ((FloatDCT_3D)FloatDCT_3D.this).rows] = a[s][r2][c + 2];
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[idx2 + 2 * ((FloatDCT_3D)FloatDCT_3D.this).rows] = a[s][r2][c + 3];
                                    }
                                    FloatDCT_3D.this.dctRows.forward(FloatDCT_3D.this.t, startt, scale);
                                    FloatDCT_3D.this.dctRows.forward(FloatDCT_3D.this.t, startt + FloatDCT_3D.this.rows, scale);
                                    FloatDCT_3D.this.dctRows.forward(FloatDCT_3D.this.t, startt + 2 * FloatDCT_3D.this.rows, scale);
                                    FloatDCT_3D.this.dctRows.forward(FloatDCT_3D.this.t, startt + 3 * FloatDCT_3D.this.rows, scale);
                                    for (r2 = 0; r2 < FloatDCT_3D.this.rows; ++r2) {
                                        idx2 = startt + FloatDCT_3D.this.rows + r2;
                                        a[s][r2][c] = FloatDCT_3D.this.t[startt + r2];
                                        a[s][r2][c + 1] = FloatDCT_3D.this.t[idx2];
                                        a[s][r2][c + 2] = FloatDCT_3D.this.t[idx2 + FloatDCT_3D.this.rows];
                                        a[s][r2][c + 3] = FloatDCT_3D.this.t[idx2 + 2 * FloatDCT_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (FloatDCT_3D.this.columns != 2) continue;
                            for (r = 0; r < FloatDCT_3D.this.rows; ++r) {
                                ((FloatDCT_3D)FloatDCT_3D.this).t[startt + r] = a[s][r][0];
                                ((FloatDCT_3D)FloatDCT_3D.this).t[startt + ((FloatDCT_3D)FloatDCT_3D.this).rows + r] = a[s][r][1];
                            }
                            FloatDCT_3D.this.dctRows.forward(FloatDCT_3D.this.t, startt, scale);
                            FloatDCT_3D.this.dctRows.forward(FloatDCT_3D.this.t, startt + FloatDCT_3D.this.rows, scale);
                            for (r = 0; r < FloatDCT_3D.this.rows; ++r) {
                                a[s][r][0] = FloatDCT_3D.this.t[startt + r];
                                a[s][r][1] = FloatDCT_3D.this.t[startt + FloatDCT_3D.this.rows + r];
                            }
                        }
                    } else {
                        for (int s = n0; s < FloatDCT_3D.this.slices; s += nthreads) {
                            int r;
                            for (r = 0; r < FloatDCT_3D.this.rows; ++r) {
                                FloatDCT_3D.this.dctColumns.inverse(a[s][r], scale);
                            }
                            if (FloatDCT_3D.this.columns > 2) {
                                for (int c = 0; c < FloatDCT_3D.this.columns; c += 4) {
                                    int idx2;
                                    int r3;
                                    for (r3 = 0; r3 < FloatDCT_3D.this.rows; ++r3) {
                                        idx2 = startt + FloatDCT_3D.this.rows + r3;
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[startt + r3] = a[s][r3][c];
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[idx2] = a[s][r3][c + 1];
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[idx2 + ((FloatDCT_3D)FloatDCT_3D.this).rows] = a[s][r3][c + 2];
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[idx2 + 2 * ((FloatDCT_3D)FloatDCT_3D.this).rows] = a[s][r3][c + 3];
                                    }
                                    FloatDCT_3D.this.dctRows.inverse(FloatDCT_3D.this.t, startt, scale);
                                    FloatDCT_3D.this.dctRows.inverse(FloatDCT_3D.this.t, startt + FloatDCT_3D.this.rows, scale);
                                    FloatDCT_3D.this.dctRows.inverse(FloatDCT_3D.this.t, startt + 2 * FloatDCT_3D.this.rows, scale);
                                    FloatDCT_3D.this.dctRows.inverse(FloatDCT_3D.this.t, startt + 3 * FloatDCT_3D.this.rows, scale);
                                    for (r3 = 0; r3 < FloatDCT_3D.this.rows; ++r3) {
                                        idx2 = startt + FloatDCT_3D.this.rows + r3;
                                        a[s][r3][c] = FloatDCT_3D.this.t[startt + r3];
                                        a[s][r3][c + 1] = FloatDCT_3D.this.t[idx2];
                                        a[s][r3][c + 2] = FloatDCT_3D.this.t[idx2 + FloatDCT_3D.this.rows];
                                        a[s][r3][c + 3] = FloatDCT_3D.this.t[idx2 + 2 * FloatDCT_3D.this.rows];
                                    }
                                }
                                continue;
                            }
                            if (FloatDCT_3D.this.columns != 2) continue;
                            for (r = 0; r < FloatDCT_3D.this.rows; ++r) {
                                ((FloatDCT_3D)FloatDCT_3D.this).t[startt + r] = a[s][r][0];
                                ((FloatDCT_3D)FloatDCT_3D.this).t[startt + ((FloatDCT_3D)FloatDCT_3D.this).rows + r] = a[s][r][1];
                            }
                            FloatDCT_3D.this.dctRows.inverse(FloatDCT_3D.this.t, startt, scale);
                            FloatDCT_3D.this.dctRows.inverse(FloatDCT_3D.this.t, startt + FloatDCT_3D.this.rows, scale);
                            for (r = 0; r < FloatDCT_3D.this.rows; ++r) {
                                a[s][r][0] = FloatDCT_3D.this.t[startt + r];
                                a[s][r][1] = FloatDCT_3D.this.t[startt + FloatDCT_3D.this.rows + r];
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void ddxt3db_subth(final int isgn, final float[] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.slices;
        if (this.columns == 2) {
            nt >>= 1;
        }
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            final int startt = nt * i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block19: {
                        block17: {
                            block18: {
                                if (isgn != -1) break block17;
                                if (FloatDCT_3D.this.columns <= 2) break block18;
                                for (int r = n0; r < FloatDCT_3D.this.rows; r += nthreads) {
                                    int idx0 = r * FloatDCT_3D.this.rowStride;
                                    for (int c = 0; c < FloatDCT_3D.this.columns; c += 4) {
                                        int idx2;
                                        int idx1;
                                        int s;
                                        for (s = 0; s < FloatDCT_3D.this.slices; ++s) {
                                            idx1 = s * FloatDCT_3D.this.sliceStride + idx0 + c;
                                            idx2 = startt + FloatDCT_3D.this.slices + s;
                                            ((FloatDCT_3D)FloatDCT_3D.this).t[startt + s] = a[idx1];
                                            ((FloatDCT_3D)FloatDCT_3D.this).t[idx2] = a[idx1 + 1];
                                            ((FloatDCT_3D)FloatDCT_3D.this).t[idx2 + ((FloatDCT_3D)FloatDCT_3D.this).slices] = a[idx1 + 2];
                                            ((FloatDCT_3D)FloatDCT_3D.this).t[idx2 + 2 * ((FloatDCT_3D)FloatDCT_3D.this).slices] = a[idx1 + 3];
                                        }
                                        FloatDCT_3D.this.dctSlices.forward(FloatDCT_3D.this.t, startt, scale);
                                        FloatDCT_3D.this.dctSlices.forward(FloatDCT_3D.this.t, startt + FloatDCT_3D.this.slices, scale);
                                        FloatDCT_3D.this.dctSlices.forward(FloatDCT_3D.this.t, startt + 2 * FloatDCT_3D.this.slices, scale);
                                        FloatDCT_3D.this.dctSlices.forward(FloatDCT_3D.this.t, startt + 3 * FloatDCT_3D.this.slices, scale);
                                        for (s = 0; s < FloatDCT_3D.this.slices; ++s) {
                                            idx1 = s * FloatDCT_3D.this.sliceStride + idx0 + c;
                                            idx2 = startt + FloatDCT_3D.this.slices + s;
                                            a[idx1] = FloatDCT_3D.this.t[startt + s];
                                            a[idx1 + 1] = FloatDCT_3D.this.t[idx2];
                                            a[idx1 + 2] = FloatDCT_3D.this.t[idx2 + FloatDCT_3D.this.slices];
                                            a[idx1 + 3] = FloatDCT_3D.this.t[idx2 + 2 * FloatDCT_3D.this.slices];
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (FloatDCT_3D.this.columns != 2) break block19;
                            for (int r = n0; r < FloatDCT_3D.this.rows; r += nthreads) {
                                int idx1;
                                int s;
                                int idx0 = r * FloatDCT_3D.this.rowStride;
                                for (s = 0; s < FloatDCT_3D.this.slices; ++s) {
                                    idx1 = s * FloatDCT_3D.this.sliceStride + idx0;
                                    ((FloatDCT_3D)FloatDCT_3D.this).t[startt + s] = a[idx1];
                                    ((FloatDCT_3D)FloatDCT_3D.this).t[startt + ((FloatDCT_3D)FloatDCT_3D.this).slices + s] = a[idx1 + 1];
                                }
                                FloatDCT_3D.this.dctSlices.forward(FloatDCT_3D.this.t, startt, scale);
                                FloatDCT_3D.this.dctSlices.forward(FloatDCT_3D.this.t, startt + FloatDCT_3D.this.slices, scale);
                                for (s = 0; s < FloatDCT_3D.this.slices; ++s) {
                                    idx1 = s * FloatDCT_3D.this.sliceStride + idx0;
                                    a[idx1] = FloatDCT_3D.this.t[startt + s];
                                    a[idx1 + 1] = FloatDCT_3D.this.t[startt + FloatDCT_3D.this.slices + s];
                                }
                            }
                            break block19;
                        }
                        if (FloatDCT_3D.this.columns > 2) {
                            for (int r = n0; r < FloatDCT_3D.this.rows; r += nthreads) {
                                int idx0 = r * FloatDCT_3D.this.rowStride;
                                for (int c = 0; c < FloatDCT_3D.this.columns; c += 4) {
                                    int idx2;
                                    int idx1;
                                    int s;
                                    for (s = 0; s < FloatDCT_3D.this.slices; ++s) {
                                        idx1 = s * FloatDCT_3D.this.sliceStride + idx0 + c;
                                        idx2 = startt + FloatDCT_3D.this.slices + s;
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[startt + s] = a[idx1];
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[idx2] = a[idx1 + 1];
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[idx2 + ((FloatDCT_3D)FloatDCT_3D.this).slices] = a[idx1 + 2];
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[idx2 + 2 * ((FloatDCT_3D)FloatDCT_3D.this).slices] = a[idx1 + 3];
                                    }
                                    FloatDCT_3D.this.dctSlices.inverse(FloatDCT_3D.this.t, startt, scale);
                                    FloatDCT_3D.this.dctSlices.inverse(FloatDCT_3D.this.t, startt + FloatDCT_3D.this.slices, scale);
                                    FloatDCT_3D.this.dctSlices.inverse(FloatDCT_3D.this.t, startt + 2 * FloatDCT_3D.this.slices, scale);
                                    FloatDCT_3D.this.dctSlices.inverse(FloatDCT_3D.this.t, startt + 3 * FloatDCT_3D.this.slices, scale);
                                    for (s = 0; s < FloatDCT_3D.this.slices; ++s) {
                                        idx1 = s * FloatDCT_3D.this.sliceStride + idx0 + c;
                                        idx2 = startt + FloatDCT_3D.this.slices + s;
                                        a[idx1] = FloatDCT_3D.this.t[startt + s];
                                        a[idx1 + 1] = FloatDCT_3D.this.t[idx2];
                                        a[idx1 + 2] = FloatDCT_3D.this.t[idx2 + FloatDCT_3D.this.slices];
                                        a[idx1 + 3] = FloatDCT_3D.this.t[idx2 + 2 * FloatDCT_3D.this.slices];
                                    }
                                }
                            }
                        } else if (FloatDCT_3D.this.columns == 2) {
                            for (int r = n0; r < FloatDCT_3D.this.rows; r += nthreads) {
                                int idx1;
                                int s;
                                int idx0 = r * FloatDCT_3D.this.rowStride;
                                for (s = 0; s < FloatDCT_3D.this.slices; ++s) {
                                    idx1 = s * FloatDCT_3D.this.sliceStride + idx0;
                                    ((FloatDCT_3D)FloatDCT_3D.this).t[startt + s] = a[idx1];
                                    ((FloatDCT_3D)FloatDCT_3D.this).t[startt + ((FloatDCT_3D)FloatDCT_3D.this).slices + s] = a[idx1 + 1];
                                }
                                FloatDCT_3D.this.dctSlices.inverse(FloatDCT_3D.this.t, startt, scale);
                                FloatDCT_3D.this.dctSlices.inverse(FloatDCT_3D.this.t, startt + FloatDCT_3D.this.slices, scale);
                                for (s = 0; s < FloatDCT_3D.this.slices; ++s) {
                                    idx1 = s * FloatDCT_3D.this.sliceStride + idx0;
                                    a[idx1] = FloatDCT_3D.this.t[startt + s];
                                    a[idx1 + 1] = FloatDCT_3D.this.t[startt + FloatDCT_3D.this.slices + s];
                                }
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void ddxt3db_subth(final int isgn, final float[][][] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.slices;
        if (this.columns == 2) {
            nt >>= 1;
        }
        Future[] futures = new Future[nthreads];
        for (int i = 0; i < nthreads; ++i) {
            final int n0 = i;
            final int startt = nt * i;
            futures[i] = ConcurrencyUtils.submit(new Runnable(){

                @Override
                public void run() {
                    block19: {
                        block17: {
                            block18: {
                                if (isgn != -1) break block17;
                                if (FloatDCT_3D.this.columns <= 2) break block18;
                                for (int r = n0; r < FloatDCT_3D.this.rows; r += nthreads) {
                                    for (int c = 0; c < FloatDCT_3D.this.columns; c += 4) {
                                        int idx2;
                                        int s;
                                        for (s = 0; s < FloatDCT_3D.this.slices; ++s) {
                                            idx2 = startt + FloatDCT_3D.this.slices + s;
                                            ((FloatDCT_3D)FloatDCT_3D.this).t[startt + s] = a[s][r][c];
                                            ((FloatDCT_3D)FloatDCT_3D.this).t[idx2] = a[s][r][c + 1];
                                            ((FloatDCT_3D)FloatDCT_3D.this).t[idx2 + ((FloatDCT_3D)FloatDCT_3D.this).slices] = a[s][r][c + 2];
                                            ((FloatDCT_3D)FloatDCT_3D.this).t[idx2 + 2 * ((FloatDCT_3D)FloatDCT_3D.this).slices] = a[s][r][c + 3];
                                        }
                                        FloatDCT_3D.this.dctSlices.forward(FloatDCT_3D.this.t, startt, scale);
                                        FloatDCT_3D.this.dctSlices.forward(FloatDCT_3D.this.t, startt + FloatDCT_3D.this.slices, scale);
                                        FloatDCT_3D.this.dctSlices.forward(FloatDCT_3D.this.t, startt + 2 * FloatDCT_3D.this.slices, scale);
                                        FloatDCT_3D.this.dctSlices.forward(FloatDCT_3D.this.t, startt + 3 * FloatDCT_3D.this.slices, scale);
                                        for (s = 0; s < FloatDCT_3D.this.slices; ++s) {
                                            idx2 = startt + FloatDCT_3D.this.slices + s;
                                            a[s][r][c] = FloatDCT_3D.this.t[startt + s];
                                            a[s][r][c + 1] = FloatDCT_3D.this.t[idx2];
                                            a[s][r][c + 2] = FloatDCT_3D.this.t[idx2 + FloatDCT_3D.this.slices];
                                            a[s][r][c + 3] = FloatDCT_3D.this.t[idx2 + 2 * FloatDCT_3D.this.slices];
                                        }
                                    }
                                }
                                break block19;
                            }
                            if (FloatDCT_3D.this.columns != 2) break block19;
                            for (int r = n0; r < FloatDCT_3D.this.rows; r += nthreads) {
                                int s;
                                for (s = 0; s < FloatDCT_3D.this.slices; ++s) {
                                    ((FloatDCT_3D)FloatDCT_3D.this).t[startt + s] = a[s][r][0];
                                    ((FloatDCT_3D)FloatDCT_3D.this).t[startt + ((FloatDCT_3D)FloatDCT_3D.this).slices + s] = a[s][r][1];
                                }
                                FloatDCT_3D.this.dctSlices.forward(FloatDCT_3D.this.t, startt, scale);
                                FloatDCT_3D.this.dctSlices.forward(FloatDCT_3D.this.t, startt + FloatDCT_3D.this.slices, scale);
                                for (s = 0; s < FloatDCT_3D.this.slices; ++s) {
                                    a[s][r][0] = FloatDCT_3D.this.t[startt + s];
                                    a[s][r][1] = FloatDCT_3D.this.t[startt + FloatDCT_3D.this.slices + s];
                                }
                            }
                            break block19;
                        }
                        if (FloatDCT_3D.this.columns > 2) {
                            for (int r = n0; r < FloatDCT_3D.this.rows; r += nthreads) {
                                for (int c = 0; c < FloatDCT_3D.this.columns; c += 4) {
                                    int idx2;
                                    int s;
                                    for (s = 0; s < FloatDCT_3D.this.slices; ++s) {
                                        idx2 = startt + FloatDCT_3D.this.slices + s;
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[startt + s] = a[s][r][c];
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[idx2] = a[s][r][c + 1];
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[idx2 + ((FloatDCT_3D)FloatDCT_3D.this).slices] = a[s][r][c + 2];
                                        ((FloatDCT_3D)FloatDCT_3D.this).t[idx2 + 2 * ((FloatDCT_3D)FloatDCT_3D.this).slices] = a[s][r][c + 3];
                                    }
                                    FloatDCT_3D.this.dctSlices.inverse(FloatDCT_3D.this.t, startt, scale);
                                    FloatDCT_3D.this.dctSlices.inverse(FloatDCT_3D.this.t, startt + FloatDCT_3D.this.slices, scale);
                                    FloatDCT_3D.this.dctSlices.inverse(FloatDCT_3D.this.t, startt + 2 * FloatDCT_3D.this.slices, scale);
                                    FloatDCT_3D.this.dctSlices.inverse(FloatDCT_3D.this.t, startt + 3 * FloatDCT_3D.this.slices, scale);
                                    for (s = 0; s < FloatDCT_3D.this.slices; ++s) {
                                        idx2 = startt + FloatDCT_3D.this.slices + s;
                                        a[s][r][c] = FloatDCT_3D.this.t[startt + s];
                                        a[s][r][c + 1] = FloatDCT_3D.this.t[idx2];
                                        a[s][r][c + 2] = FloatDCT_3D.this.t[idx2 + FloatDCT_3D.this.slices];
                                        a[s][r][c + 3] = FloatDCT_3D.this.t[idx2 + 2 * FloatDCT_3D.this.slices];
                                    }
                                }
                            }
                        } else if (FloatDCT_3D.this.columns == 2) {
                            for (int r = n0; r < FloatDCT_3D.this.rows; r += nthreads) {
                                int s;
                                for (s = 0; s < FloatDCT_3D.this.slices; ++s) {
                                    ((FloatDCT_3D)FloatDCT_3D.this).t[startt + s] = a[s][r][0];
                                    ((FloatDCT_3D)FloatDCT_3D.this).t[startt + ((FloatDCT_3D)FloatDCT_3D.this).slices + s] = a[s][r][1];
                                }
                                FloatDCT_3D.this.dctSlices.inverse(FloatDCT_3D.this.t, startt, scale);
                                FloatDCT_3D.this.dctSlices.inverse(FloatDCT_3D.this.t, startt + FloatDCT_3D.this.slices, scale);
                                for (s = 0; s < FloatDCT_3D.this.slices; ++s) {
                                    a[s][r][0] = FloatDCT_3D.this.t[startt + s];
                                    a[s][r][1] = FloatDCT_3D.this.t[startt + FloatDCT_3D.this.slices + s];
                                }
                            }
                        }
                    }
                }
            });
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }
}

