/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.spectra;

public class TSpectrum {
    protected int fMaxPeaks;
    protected int fNPeaks;
    protected double[] fPosition;
    protected double[] fPositionX;
    protected double[] fPositionY;
    protected double fResolution;
    protected static int fgAverageWindow = 3;
    protected static int fgIterations = 3;
    private static int PEAK_WINDOW = 1024;
    private static int kBackOrder2 = 0;
    private static int kBackOrder4 = 1;
    private static int kBackOrder6 = 2;
    private static int kBackOrder8 = 3;
    private static int kBackIncreasingWindow = 0;
    private static int kBackDecreasingWindow = 1;
    private static int kBackSmoothing3 = 3;
    private static int kBackSmoothing5 = 5;
    private static int kBackSmoothing7 = 7;
    private static int kBackSmoothing9 = 9;
    private static int kBackSmoothing11 = 11;
    private static int kBackSmoothing13 = 13;
    private static int kBackSmoothing15 = 15;

    public TSpectrum() {
        int n;
        this.fMaxPeaks = n = 100;
        this.fPosition = new double[n];
        this.fPositionX = new double[n];
        this.fPositionY = new double[n];
        this.fResolution = 1.0;
        this.fNPeaks = 0;
    }

    public TSpectrum(int maxpositions, double resolution) {
        int n = maxpositions;
        if (n <= 0) {
            n = 1;
        }
        this.fMaxPeaks = n;
        this.fPosition = new double[n];
        this.fPositionX = new double[n];
        this.fPositionY = new double[n];
        this.fNPeaks = 0;
        this.SetResolution(resolution);
    }

    public void finalize() {
        this.fPosition = null;
        this.fPositionX = null;
        this.fPositionY = null;
    }

    public void SetAverageWindow(int w) {
        fgAverageWindow = w;
    }

    void SetDeconIterations(int n) {
        fgIterations = n;
    }

    double[] Background(double[] h, int numberIterations, String option) {
        if (h == null) {
            System.out.println("TSpectrum::Background() - dataset is null");
            return null;
        }
        String opt = option.toLowerCase();
        int direction = kBackDecreasingWindow;
        if (opt.indexOf("backincreasingwindow") >= 0) {
            direction = kBackIncreasingWindow;
        }
        int filterOrder = kBackOrder2;
        if (opt.indexOf("backorder4") >= 0) {
            filterOrder = kBackOrder4;
        }
        if (opt.indexOf("backorder6") >= 0) {
            filterOrder = kBackOrder6;
        }
        if (opt.indexOf("backorder8") >= 0) {
            filterOrder = kBackOrder8;
        }
        boolean smoothing = true;
        if (opt.indexOf("nosmoothing") >= 0) {
            smoothing = false;
        }
        int smoothWindow = kBackSmoothing3;
        if (opt.indexOf("backsmoothing5") >= 0) {
            smoothWindow = kBackSmoothing5;
        }
        if (opt.indexOf("backsmoothing7") >= 0) {
            smoothWindow = kBackSmoothing7;
        }
        if (opt.indexOf("backsmoothing9") >= 0) {
            smoothWindow = kBackSmoothing9;
        }
        if (opt.indexOf("backsmoothing11") >= 0) {
            smoothWindow = kBackSmoothing11;
        }
        if (opt.indexOf("backsmoothing13") >= 0) {
            smoothWindow = kBackSmoothing13;
        }
        if (opt.indexOf("backsmoothing15") >= 0) {
            smoothWindow = kBackSmoothing15;
        }
        boolean compton = false;
        if (opt.indexOf("compton") >= 0) {
            compton = true;
        }
        int first = 0;
        int last = h.length - 1;
        int size = last - first + 1;
        double[] source = new double[size];
        for (int i = 0; i < size; ++i) {
            source[i] = h[i + first];
        }
        this.Background(source, size, numberIterations, direction, filterOrder, smoothing, smoothWindow, compton);
        return source;
    }

    void Print() {
        System.out.println("Number of positions = " + this.fNPeaks);
        for (int i = 0; i < this.fNPeaks; ++i) {
            System.out.println(" x[" + i + "] = " + this.fPositionX[i] + ", y[" + i + "] = " + this.fPositionY[i]);
        }
    }

    public int Search(double[] hinX, double[] hinY, double[] houtX, double[] houtY, double sigma, String option, double threshold) {
        if (hinX == null || hinY == null) {
            return 0;
        }
        boolean dimension = true;
        if (threshold <= 0.0 || threshold >= 1.0) {
            System.out.println("Search: threshold must 0<threshold<1, threshol=0.05 assumed");
            threshold = 0.05;
        }
        String opt = option.toLowerCase();
        boolean background = true;
        if (opt.indexOf("nobackground") >= 0) {
            background = false;
            opt = opt.replaceAll("nobackground", "");
        }
        boolean markov = true;
        if (opt.indexOf("nomarkov") >= 0) {
            markov = false;
            opt = opt.replaceAll("nomarkov", "");
        }
        int first = 0;
        int last = hinX.length - 1;
        int size = last - first + 1;
        double[] source = new double[size];
        double[] dest = new double[size];
        for (int i = 0; i < size - 1; ++i) {
            source[i] = hinY[i + first];
        }
        if (sigma <= 1.0) {
            sigma = size / this.fMaxPeaks;
            if (sigma < 1.0) {
                sigma = 1.0;
            }
            if (sigma > 8.0) {
                sigma = 8.0;
            }
        }
        int npeaks = this.SearchHighRes(source, dest, size, sigma, 100.0 * threshold, background, fgIterations, markov, fgAverageWindow);
        System.out.println("N peaks is: " + npeaks);
        houtX = new double[this.fPositionX.length];
        houtY = new double[this.fPositionY.length];
        for (int i = 0; i < npeaks; ++i) {
            int bin = first + (int)(this.fPositionX[i] + 0.5);
            this.fPositionX[i] = hinX[--bin];
            this.fPositionY[i] = hinY[bin];
            houtX[i] = this.fPositionX[i];
            houtY[i] = this.fPositionY[i];
        }
        source = null;
        dest = null;
        if (opt.indexOf("goff") >= 0) {
            return npeaks;
        }
        if (npeaks == 0) {
            return 0;
        }
        return npeaks;
    }

    public void SetResolution(double resolution) {
        this.fResolution = resolution > 1.0 ? resolution : 1.0;
    }

    String Background(double[] spectrum, int ssize, int numberIterations, int direction, int filterOrder, boolean smoothing, int smoothWindow, boolean compton) {
        double g6;
        double f6;
        double e6;
        double d6;
        double c6;
        double b6;
        double d;
        double e4;
        double d4;
        double c4;
        double b4;
        double ai;
        double c;
        int w;
        double men;
        double av;
        double a;
        double b;
        int j;
        int i;
        if (ssize <= 0) {
            return "Wrong Parameters";
        }
        if (numberIterations < 1) {
            return "Width of Clipping Window Must Be Positive";
        }
        if (ssize < 2 * numberIterations + 1) {
            return "Too Large Clipping Window";
        }
        if (smoothing && smoothWindow != kBackSmoothing3 && smoothWindow != kBackSmoothing5 && smoothWindow != kBackSmoothing7 && smoothWindow != kBackSmoothing9 && smoothWindow != kBackSmoothing11 && smoothWindow != kBackSmoothing13 && smoothWindow != kBackSmoothing15) {
            return "Incorrect width of smoothing window";
        }
        double[] working_space = new double[2 * ssize];
        for (i = 0; i < ssize; ++i) {
            working_space[i] = spectrum[i];
            working_space[i + ssize] = spectrum[i];
        }
        int bw = (smoothWindow - 1) / 2;
        if (direction == kBackIncreasingWindow) {
            i = 1;
        } else if (direction == kBackDecreasingWindow) {
            i = numberIterations;
        }
        if (filterOrder == kBackOrder2) {
            do {
                for (j = i; j < ssize - i; ++j) {
                    if (!smoothing) {
                        b = (working_space[ssize + j - i] + working_space[ssize + j + i]) / 2.0;
                        a = working_space[ssize + j];
                        if (b < a) {
                            a = b;
                        }
                        working_space[j] = a;
                        continue;
                    }
                    if (!smoothing) continue;
                    a = working_space[ssize + j];
                    av = 0.0;
                    men = 0.0;
                    for (w = j - bw; w <= j + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        av += working_space[ssize + w];
                        men += 1.0;
                    }
                    av /= men;
                    b = 0.0;
                    men = 0.0;
                    for (w = j - i - bw; w <= j - i + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        b += working_space[ssize + w];
                        men += 1.0;
                    }
                    b /= men;
                    c = 0.0;
                    men = 0.0;
                    for (w = j + i - bw; w <= j + i + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        c += working_space[ssize + w];
                        men += 1.0;
                    }
                    if ((b = (b + (c /= men)) / 2.0) < a) {
                        av = b;
                    }
                    working_space[j] = av;
                }
                for (j = i; j < ssize - i; ++j) {
                    working_space[ssize + j] = working_space[j];
                }
                if (direction == kBackIncreasingWindow) {
                    ++i;
                    continue;
                }
                if (direction != kBackDecreasingWindow) continue;
                --i;
            } while (direction == kBackIncreasingWindow && i <= numberIterations || direction == kBackDecreasingWindow && i >= 1);
        } else if (filterOrder == kBackOrder4) {
            do {
                for (j = i; j < ssize - i; ++j) {
                    if (!smoothing) {
                        a = working_space[ssize + j];
                        b = (working_space[ssize + j - i] + working_space[ssize + j + i]) / 2.0;
                        c = 0.0;
                        ai = i / 2;
                        c -= working_space[ssize + j - (int)(2.0 * ai)] / 6.0;
                        c += 4.0 * working_space[ssize + j - (int)ai] / 6.0;
                        c += 4.0 * working_space[ssize + j + (int)ai] / 6.0;
                        if (b < (c -= working_space[ssize + j + (int)(2.0 * ai)] / 6.0)) {
                            b = c;
                        }
                        if (b < a) {
                            a = b;
                        }
                        working_space[j] = a;
                        continue;
                    }
                    if (!smoothing) continue;
                    a = working_space[ssize + j];
                    av = 0.0;
                    men = 0.0;
                    for (w = j - bw; w <= j + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        av += working_space[ssize + w];
                        men += 1.0;
                    }
                    av /= men;
                    b = 0.0;
                    men = 0.0;
                    for (w = j - i - bw; w <= j - i + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        b += working_space[ssize + w];
                        men += 1.0;
                    }
                    b /= men;
                    c = 0.0;
                    men = 0.0;
                    for (w = j + i - bw; w <= j + i + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        c += working_space[ssize + w];
                        men += 1.0;
                    }
                    b = (b + (c /= men)) / 2.0;
                    ai = i / 2;
                    b4 = 0.0;
                    men = 0.0;
                    for (w = j - (int)(2.0 * ai) - bw; w <= j - (int)(2.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        b4 += working_space[ssize + w];
                        men += 1.0;
                    }
                    b4 /= men;
                    c4 = 0.0;
                    men = 0.0;
                    for (w = j - (int)ai - bw; w <= j - (int)ai + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        c4 += working_space[ssize + w];
                        men += 1.0;
                    }
                    c4 /= men;
                    d4 = 0.0;
                    men = 0.0;
                    for (w = j + (int)ai - bw; w <= j + (int)ai + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        d4 += working_space[ssize + w];
                        men += 1.0;
                    }
                    d4 /= men;
                    e4 = 0.0;
                    men = 0.0;
                    for (w = j + (int)(2.0 * ai) - bw; w <= j + (int)(2.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        e4 += working_space[ssize + w];
                        men += 1.0;
                    }
                    if (b < (b4 = (-b4 + 4.0 * c4 + 4.0 * d4 - (e4 /= men)) / 6.0)) {
                        b = b4;
                    }
                    if (b < a) {
                        av = b;
                    }
                    working_space[j] = av;
                }
                for (j = i; j < ssize - i; ++j) {
                    working_space[ssize + j] = working_space[j];
                }
                if (direction == kBackIncreasingWindow) {
                    ++i;
                    continue;
                }
                if (direction != kBackDecreasingWindow) continue;
                --i;
            } while (direction == kBackIncreasingWindow && i <= numberIterations || direction == kBackDecreasingWindow && i >= 1);
        } else if (filterOrder == kBackOrder6) {
            do {
                for (j = i; j < ssize - i; ++j) {
                    if (smoothing) {
                        a = working_space[ssize + j];
                        b = (working_space[ssize + j - i] + working_space[ssize + j + i]) / 2.0;
                        c = 0.0;
                        ai = i / 2;
                        c -= working_space[ssize + j - (int)(2.0 * ai)] / 6.0;
                        c += 4.0 * working_space[ssize + j - (int)ai] / 6.0;
                        c += 4.0 * working_space[ssize + j + (int)ai] / 6.0;
                        c -= working_space[ssize + j + (int)(2.0 * ai)] / 6.0;
                        d = 0.0;
                        ai = i / 3;
                        d += working_space[ssize + j - (int)(3.0 * ai)] / 20.0;
                        d -= 6.0 * working_space[ssize + j - (int)(2.0 * ai)] / 20.0;
                        d += 15.0 * working_space[ssize + j - (int)ai] / 20.0;
                        d += 15.0 * working_space[ssize + j + (int)ai] / 20.0;
                        d -= 6.0 * working_space[ssize + j + (int)(2.0 * ai)] / 20.0;
                        if (b < (d += working_space[ssize + j + (int)(3.0 * ai)] / 20.0)) {
                            b = d;
                        }
                        if (b < c) {
                            b = c;
                        }
                        if (b < a) {
                            a = b;
                        }
                        working_space[j] = a;
                        continue;
                    }
                    if (!smoothing) continue;
                    a = working_space[ssize + j];
                    av = 0.0;
                    men = 0.0;
                    for (w = j - bw; w <= j + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        av += working_space[ssize + w];
                        men += 1.0;
                    }
                    av /= men;
                    b = 0.0;
                    men = 0.0;
                    for (w = j - i - bw; w <= j - i + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        b += working_space[ssize + w];
                        men += 1.0;
                    }
                    b /= men;
                    c = 0.0;
                    men = 0.0;
                    for (w = j + i - bw; w <= j + i + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        c += working_space[ssize + w];
                        men += 1.0;
                    }
                    b = (b + (c /= men)) / 2.0;
                    ai = i / 2;
                    b4 = 0.0;
                    men = 0.0;
                    for (w = j - (int)(2.0 * ai) - bw; w <= j - (int)(2.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        b4 += working_space[ssize + w];
                        men += 1.0;
                    }
                    b4 /= men;
                    c4 = 0.0;
                    men = 0.0;
                    for (w = j - (int)ai - bw; w <= j - (int)ai + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        c4 += working_space[ssize + w];
                        men += 1.0;
                    }
                    c4 /= men;
                    d4 = 0.0;
                    men = 0.0;
                    for (w = j + (int)ai - bw; w <= j + (int)ai + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        d4 += working_space[ssize + w];
                        men += 1.0;
                    }
                    d4 /= men;
                    e4 = 0.0;
                    men = 0.0;
                    for (w = j + (int)(2.0 * ai) - bw; w <= j + (int)(2.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        e4 += working_space[ssize + w];
                        men += 1.0;
                    }
                    b4 = (-b4 + 4.0 * c4 + 4.0 * d4 - (e4 /= men)) / 6.0;
                    ai = i / 3;
                    b6 = 0.0;
                    men = 0.0;
                    for (w = j - (int)(3.0 * ai) - bw; w <= j - (int)(3.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        b6 += working_space[ssize + w];
                        men += 1.0;
                    }
                    b6 /= men;
                    c6 = 0.0;
                    men = 0.0;
                    for (w = j - (int)(2.0 * ai) - bw; w <= j - (int)(2.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        c6 += working_space[ssize + w];
                        men += 1.0;
                    }
                    c6 /= men;
                    d6 = 0.0;
                    men = 0.0;
                    for (w = j - (int)ai - bw; w <= j - (int)ai + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        d6 += working_space[ssize + w];
                        men += 1.0;
                    }
                    d6 /= men;
                    e6 = 0.0;
                    men = 0.0;
                    for (w = j + (int)ai - bw; w <= j + (int)ai + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        e6 += working_space[ssize + w];
                        men += 1.0;
                    }
                    e6 /= men;
                    f6 = 0.0;
                    men = 0.0;
                    for (w = j + (int)(2.0 * ai) - bw; w <= j + (int)(2.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        f6 += working_space[ssize + w];
                        men += 1.0;
                    }
                    f6 /= men;
                    g6 = 0.0;
                    men = 0.0;
                    for (w = j + (int)(3.0 * ai) - bw; w <= j + (int)(3.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        g6 += working_space[ssize + w];
                        men += 1.0;
                    }
                    if (b < (b6 = (b6 - 6.0 * c6 + 15.0 * d6 + 15.0 * e6 - 6.0 * f6 + (g6 /= men)) / 20.0)) {
                        b = b6;
                    }
                    if (b < b4) {
                        b = b4;
                    }
                    if (b < a) {
                        av = b;
                    }
                    working_space[j] = av;
                }
                for (j = i; j < ssize - i; ++j) {
                    working_space[ssize + j] = working_space[j];
                }
                if (direction == kBackIncreasingWindow) {
                    ++i;
                    continue;
                }
                if (direction != kBackDecreasingWindow) continue;
                --i;
            } while (direction == kBackIncreasingWindow && i <= numberIterations || direction == kBackDecreasingWindow && i >= 1);
        } else if (filterOrder == kBackOrder8) {
            do {
                for (j = i; j < ssize - i; ++j) {
                    if (!smoothing) {
                        a = working_space[ssize + j];
                        b = (working_space[ssize + j - i] + working_space[ssize + j + i]) / 2.0;
                        c = 0.0;
                        ai = i / 2;
                        c -= working_space[ssize + j - (int)(2.0 * ai)] / 6.0;
                        c += 4.0 * working_space[ssize + j - (int)ai] / 6.0;
                        c += 4.0 * working_space[ssize + j + (int)ai] / 6.0;
                        c -= working_space[ssize + j + (int)(2.0 * ai)] / 6.0;
                        d = 0.0;
                        ai = i / 3;
                        d += working_space[ssize + j - (int)(3.0 * ai)] / 20.0;
                        d -= 6.0 * working_space[ssize + j - (int)(2.0 * ai)] / 20.0;
                        d += 15.0 * working_space[ssize + j - (int)ai] / 20.0;
                        d += 15.0 * working_space[ssize + j + (int)ai] / 20.0;
                        d -= 6.0 * working_space[ssize + j + (int)(2.0 * ai)] / 20.0;
                        d += working_space[ssize + j + (int)(3.0 * ai)] / 20.0;
                        double e = 0.0;
                        ai = i / 4;
                        e -= working_space[ssize + j - (int)(4.0 * ai)] / 70.0;
                        e += 8.0 * working_space[ssize + j - (int)(3.0 * ai)] / 70.0;
                        e -= 28.0 * working_space[ssize + j - (int)(2.0 * ai)] / 70.0;
                        e += 56.0 * working_space[ssize + j - (int)ai] / 70.0;
                        e += 56.0 * working_space[ssize + j + (int)ai] / 70.0;
                        e -= 28.0 * working_space[ssize + j + (int)(2.0 * ai)] / 70.0;
                        e += 8.0 * working_space[ssize + j + (int)(3.0 * ai)] / 70.0;
                        if (b < (e -= working_space[ssize + j + (int)(4.0 * ai)] / 70.0)) {
                            b = e;
                        }
                        if (b < d) {
                            b = d;
                        }
                        if (b < c) {
                            b = c;
                        }
                        if (b < a) {
                            a = b;
                        }
                        working_space[j] = a;
                        continue;
                    }
                    if (!smoothing) continue;
                    a = working_space[ssize + j];
                    av = 0.0;
                    men = 0.0;
                    for (w = j - bw; w <= j + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        av += working_space[ssize + w];
                        men += 1.0;
                    }
                    av /= men;
                    b = 0.0;
                    men = 0.0;
                    for (w = j - i - bw; w <= j - i + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        b += working_space[ssize + w];
                        men += 1.0;
                    }
                    b /= men;
                    c = 0.0;
                    men = 0.0;
                    for (w = j + i - bw; w <= j + i + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        c += working_space[ssize + w];
                        men += 1.0;
                    }
                    b = (b + (c /= men)) / 2.0;
                    ai = i / 2;
                    b4 = 0.0;
                    men = 0.0;
                    for (w = j - (int)(2.0 * ai) - bw; w <= j - (int)(2.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        b4 += working_space[ssize + w];
                        men += 1.0;
                    }
                    b4 /= men;
                    c4 = 0.0;
                    men = 0.0;
                    for (w = j - (int)ai - bw; w <= j - (int)ai + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        c4 += working_space[ssize + w];
                        men += 1.0;
                    }
                    c4 /= men;
                    d4 = 0.0;
                    men = 0.0;
                    for (w = j + (int)ai - bw; w <= j + (int)ai + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        d4 += working_space[ssize + w];
                        men += 1.0;
                    }
                    d4 /= men;
                    e4 = 0.0;
                    men = 0.0;
                    for (w = j + (int)(2.0 * ai) - bw; w <= j + (int)(2.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        e4 += working_space[ssize + w];
                        men += 1.0;
                    }
                    b4 = (-b4 + 4.0 * c4 + 4.0 * d4 - (e4 /= men)) / 6.0;
                    ai = i / 3;
                    b6 = 0.0;
                    men = 0.0;
                    for (w = j - (int)(3.0 * ai) - bw; w <= j - (int)(3.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        b6 += working_space[ssize + w];
                        men += 1.0;
                    }
                    b6 /= men;
                    c6 = 0.0;
                    men = 0.0;
                    for (w = j - (int)(2.0 * ai) - bw; w <= j - (int)(2.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        c6 += working_space[ssize + w];
                        men += 1.0;
                    }
                    c6 /= men;
                    d6 = 0.0;
                    men = 0.0;
                    for (w = j - (int)ai - bw; w <= j - (int)ai + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        d6 += working_space[ssize + w];
                        men += 1.0;
                    }
                    d6 /= men;
                    e6 = 0.0;
                    men = 0.0;
                    for (w = j + (int)ai - bw; w <= j + (int)ai + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        e6 += working_space[ssize + w];
                        men += 1.0;
                    }
                    e6 /= men;
                    f6 = 0.0;
                    men = 0.0;
                    for (w = j + (int)(2.0 * ai) - bw; w <= j + (int)(2.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        f6 += working_space[ssize + w];
                        men += 1.0;
                    }
                    f6 /= men;
                    g6 = 0.0;
                    men = 0.0;
                    for (w = j + (int)(3.0 * ai) - bw; w <= j + (int)(3.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        g6 += working_space[ssize + w];
                        men += 1.0;
                    }
                    b6 = (b6 - 6.0 * c6 + 15.0 * d6 + 15.0 * e6 - 6.0 * f6 + (g6 /= men)) / 20.0;
                    ai = i / 4;
                    double b8 = 0.0;
                    men = 0.0;
                    for (w = j - (int)(4.0 * ai) - bw; w <= j - (int)(4.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        b8 += working_space[ssize + w];
                        men += 1.0;
                    }
                    b8 /= men;
                    double c8 = 0.0;
                    men = 0.0;
                    for (w = j - (int)(3.0 * ai) - bw; w <= j - (int)(3.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        c8 += working_space[ssize + w];
                        men += 1.0;
                    }
                    c8 /= men;
                    double d8 = 0.0;
                    men = 0.0;
                    for (w = j - (int)(2.0 * ai) - bw; w <= j - (int)(2.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        d8 += working_space[ssize + w];
                        men += 1.0;
                    }
                    d8 /= men;
                    double e8 = 0.0;
                    men = 0.0;
                    for (w = j - (int)ai - bw; w <= j - (int)ai + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        e8 += working_space[ssize + w];
                        men += 1.0;
                    }
                    e8 /= men;
                    double f8 = 0.0;
                    men = 0.0;
                    for (w = j + (int)ai - bw; w <= j + (int)ai + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        f8 += working_space[ssize + w];
                        men += 1.0;
                    }
                    f8 /= men;
                    double g8 = 0.0;
                    men = 0.0;
                    for (w = j + (int)(2.0 * ai) - bw; w <= j + (int)(2.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        g8 += working_space[ssize + w];
                        men += 1.0;
                    }
                    g8 /= men;
                    double h8 = 0.0;
                    men = 0.0;
                    for (w = j + (int)(3.0 * ai) - bw; w <= j + (int)(3.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        h8 += working_space[ssize + w];
                        men += 1.0;
                    }
                    h8 /= men;
                    double i8 = 0.0;
                    men = 0.0;
                    for (w = j + (int)(4.0 * ai) - bw; w <= j + (int)(4.0 * ai) + bw; ++w) {
                        if (w < 0 || w >= ssize) continue;
                        i8 += working_space[ssize + w];
                        men += 1.0;
                    }
                    if (b < (b8 = (-b8 + 8.0 * c8 - 28.0 * d8 + 56.0 * e8 - 56.0 * f8 - 28.0 * g8 + 8.0 * h8 - (i8 /= men)) / 70.0)) {
                        b = b8;
                    }
                    if (b < b6) {
                        b = b6;
                    }
                    if (b < b4) {
                        b = b4;
                    }
                    if (b < a) {
                        av = b;
                    }
                    working_space[j] = av;
                }
                for (j = i; j < ssize - i; ++j) {
                    working_space[ssize + j] = working_space[j];
                }
                if (direction == kBackIncreasingWindow) {
                    ++i;
                    continue;
                }
                if (direction != kBackDecreasingWindow) continue;
                --i;
            } while (direction == kBackIncreasingWindow && i <= numberIterations || direction == kBackDecreasingWindow && i >= 1);
        }
        if (compton) {
            int b2 = 0;
            for (i = 0; i < ssize; ++i) {
                double yb2;
                int b1 = b2;
                a = working_space[i];
                b = spectrum[i];
                j = i;
                if (!(Math.abs(a - b) >= 1.0)) continue;
                b1 = i - 1;
                if (b1 < 0) {
                    b1 = 0;
                }
                double yb1 = working_space[b1];
                c = 0.0;
                boolean priz = false;
                for (b2 = b1 + 1; !priz && b2 < ssize; ++b2) {
                    a = working_space[b2];
                    b = spectrum[b2];
                    c = c + b - yb1;
                    if (!(Math.abs(a - b) < 1.0)) continue;
                    priz = true;
                    double d2 = b;
                }
                if (b2 == ssize) {
                    --b2;
                }
                if (yb1 <= (yb2 = working_space[b2])) {
                    c = 0.0;
                    for (j = b1; j <= b2; ++j) {
                        b = spectrum[j];
                        c = c + b - yb1;
                    }
                    if (c > 1.0) {
                        c = (yb2 - yb1) / c;
                        d = 0.0;
                        for (j = b1; j <= b2 && j < ssize; ++j) {
                            b = spectrum[j];
                            d = d + b - yb1;
                            working_space[ssize + j] = a = c * d + yb1;
                        }
                    }
                } else {
                    c = 0.0;
                    for (j = b2; j >= b1; --j) {
                        b = spectrum[j];
                        c = c + b - yb2;
                    }
                    if (c > 1.0) {
                        c = (yb1 - yb2) / c;
                        d = 0.0;
                        for (j = b2; j >= b1 && j >= 0; --j) {
                            b = spectrum[j];
                            d = d + b - yb2;
                            working_space[ssize + j] = a = c * d + yb2;
                        }
                    }
                }
                i = b2;
            }
        }
        for (j = 0; j < ssize; ++j) {
            spectrum[j] = working_space[ssize + j];
        }
        working_space = null;
        return null;
    }

    String SmoothMarkov(double[] source, int ssize, int averWindow) {
        int i;
        double area = 0.0;
        if (averWindow <= 0) {
            return "Averaging Window must be positive";
        }
        double[] working_space = new double[ssize];
        int xmin = 0;
        int xmax = ssize - 1;
        double maxch = 0.0;
        for (i = 0; i < ssize; ++i) {
            working_space[i] = 0.0;
            if (maxch < source[i]) {
                maxch = source[i];
            }
            area += source[i];
        }
        if (maxch == 0.0) {
            return null;
        }
        double nom = 1.0;
        working_space[xmin] = 1.0;
        for (i = xmin; i < xmax; ++i) {
            double a;
            double nip = source[i] / maxch;
            double nim = source[i + 1] / maxch;
            double sp = 0.0;
            double sm = 0.0;
            for (int l = 1; l <= averWindow; ++l) {
                a = i + l > xmax ? source[xmax] / maxch : source[i + l] / maxch;
                double b = a - nip;
                a = a + nip <= 0.0 ? 1.0 : Math.sqrt(a + nip);
                b /= a;
                b = Math.exp(b);
                sp += b;
                a = i - l + 1 < xmin ? source[xmin] / maxch : source[i - l + 1] / maxch;
                b = a - nim;
                a = a + nim <= 0.0 ? 1.0 : Math.sqrt(a + nim);
                b /= a;
                b = Math.exp(b);
                sm += b;
            }
            a = sp / sm;
            double d = working_space[i] * a;
            working_space[i + 1] = d;
            a = d;
            nom += a;
        }
        for (i = xmin; i <= xmax; ++i) {
            working_space[i] = working_space[i] / nom;
        }
        for (i = 0; i < ssize; ++i) {
            source[i] = working_space[i] * area;
        }
        working_space = null;
        return null;
    }

    String Deconvolution(double[] source, double[] response, int ssize, int numberIterations, int numberRepetitions, double boost) {
        double ldc;
        int k;
        double ldb;
        int j;
        double lda;
        int i;
        if (ssize <= 0) {
            return "Wrong Parameters";
        }
        if (numberRepetitions <= 0) {
            return "Wrong Parameters";
        }
        double[] working_space = new double[4 * ssize];
        double area = 0.0;
        int lh_gold = -1;
        int posit = 0;
        double maximum = 0.0;
        for (i = 0; i < ssize; ++i) {
            lda = response[i];
            if (lda != 0.0) {
                lh_gold = i + 1;
            }
            working_space[i] = lda;
            area += lda;
            if (!(lda > maximum)) continue;
            maximum = lda;
            posit = i;
        }
        if (lh_gold == -1) {
            return "ZERO RESPONSE VECTOR";
        }
        for (i = 0; i < ssize; ++i) {
            working_space[2 * ssize + i] = source[i];
        }
        for (i = 0; i < ssize; ++i) {
            lda = 0.0;
            for (j = 0; j < ssize; ++j) {
                ldb = working_space[j];
                k = i + j;
                if (k >= ssize) continue;
                ldc = working_space[k];
                lda += ldb * ldc;
            }
            working_space[ssize + i] = lda;
            lda = 0.0;
            for (k = 0; k < ssize; ++k) {
                int l = k - i;
                if (l < 0) continue;
                ldb = working_space[l];
                ldc = working_space[2 * ssize + k];
                lda += ldb * ldc;
            }
            working_space[3 * ssize + i] = lda;
        }
        for (i = 0; i < ssize; ++i) {
            working_space[2 * ssize + i] = working_space[3 * ssize + i];
        }
        for (i = 0; i < ssize; ++i) {
            working_space[i] = 1.0;
        }
        for (int repet = 0; repet < numberRepetitions; ++repet) {
            if (repet != 0) {
                for (i = 0; i < ssize; ++i) {
                    working_space[i] = Math.pow(working_space[i], boost);
                }
            }
            for (int lindex = 0; lindex < numberIterations; ++lindex) {
                for (i = 0; i < ssize; ++i) {
                    if (!(working_space[2 * ssize + i] > 1.0E-6) || !(working_space[i] > 1.0E-6)) continue;
                    lda = 0.0;
                    for (j = 0; j < lh_gold; ++j) {
                        ldb = working_space[j + ssize];
                        if (j != 0) {
                            k = i + j;
                            ldc = 0.0;
                            if (k < ssize) {
                                ldc = working_space[k];
                            }
                            if ((k = i - j) >= 0) {
                                ldc += working_space[k];
                            }
                        } else {
                            ldc = working_space[i];
                        }
                        lda += ldb * ldc;
                    }
                    ldb = working_space[2 * ssize + i];
                    lda = lda != 0.0 ? ldb / lda : 0.0;
                    ldb = working_space[i];
                    working_space[3 * ssize + i] = lda *= ldb;
                }
                for (i = 0; i < ssize; ++i) {
                    working_space[i] = working_space[3 * ssize + i];
                }
            }
        }
        for (i = 0; i < ssize; ++i) {
            lda = working_space[i];
            j = i + posit;
            working_space[ssize + (j %= ssize)] = lda;
        }
        for (i = 0; i < ssize; ++i) {
            source[i] = area * working_space[ssize + i];
        }
        working_space = null;
        return null;
    }

    String DeconvolutionRL(double[] source, double[] response, int ssize, int numberIterations, int numberRepetitions, double boost) {
        int j;
        double lda;
        int i;
        if (ssize <= 0) {
            return "Wrong Parameters";
        }
        if (numberRepetitions <= 0) {
            return "Wrong Parameters";
        }
        double[] working_space = new double[4 * ssize];
        int lh_gold = -1;
        int posit = 0;
        double maximum = 0.0;
        for (i = 0; i < ssize; ++i) {
            lda = response[i];
            if (lda != 0.0) {
                lh_gold = i + 1;
            }
            working_space[ssize + i] = lda;
            if (!(lda > maximum)) continue;
            maximum = lda;
            posit = i;
        }
        if (lh_gold == -1) {
            return "ZERO RESPONSE VECTOR";
        }
        for (i = 0; i < ssize; ++i) {
            working_space[2 * ssize + i] = source[i];
        }
        for (i = 0; i < ssize; ++i) {
            working_space[i] = i <= ssize - lh_gold ? 1.0 : 0.0;
        }
        for (int repet = 0; repet < numberRepetitions; ++repet) {
            if (repet != 0) {
                for (i = 0; i < ssize; ++i) {
                    working_space[i] = Math.pow(working_space[i], boost);
                }
            }
            for (int lindex = 0; lindex < numberIterations; ++lindex) {
                for (i = 0; i <= ssize - lh_gold; ++i) {
                    lda = 0.0;
                    if (working_space[i] > 0.0) {
                        for (j = i; j < i + lh_gold; ++j) {
                            double ldb = working_space[2 * ssize + j];
                            if (j < ssize) {
                                if (ldb > 0.0) {
                                    int kmin;
                                    int kmax = j;
                                    if (kmax > lh_gold - 1) {
                                        kmax = lh_gold - 1;
                                    }
                                    if ((kmin = j + lh_gold - ssize) < 0) {
                                        kmin = 0;
                                    }
                                    double ldc = 0.0;
                                    for (int k = kmax; k >= kmin; --k) {
                                        ldc += working_space[ssize + k] * working_space[j - k];
                                    }
                                    ldb = ldc > 0.0 ? (ldb /= ldc) : 0.0;
                                }
                                ldb *= working_space[ssize + j - i];
                            }
                            lda += ldb;
                        }
                        lda *= working_space[i];
                    }
                    working_space[3 * ssize + i] = lda;
                }
                for (i = 0; i < ssize; ++i) {
                    working_space[i] = working_space[3 * ssize + i];
                }
            }
        }
        for (i = 0; i < ssize; ++i) {
            lda = working_space[i];
            j = i + posit;
            working_space[ssize + (j %= ssize)] = lda;
        }
        for (i = 0; i < ssize; ++i) {
            source[i] = working_space[ssize + i];
        }
        working_space = null;
        return null;
    }

    String Unfolding(double[] source, double[][] respMatrix, int ssizex, int ssizey, int numberIterations, int numberRepetitions, double boost) {
        double ldc;
        double ldb;
        int k;
        double lda;
        int i;
        int j;
        int lhx = 0;
        if (ssizex <= 0 || ssizey <= 0) {
            return "Wrong Parameters";
        }
        if (ssizex < ssizey) {
            return "Sizex must be greater than sizey)";
        }
        if (numberIterations <= 0) {
            return "Number of iterations must be positive";
        }
        double[] working_space = new double[ssizex * ssizey + 2 * ssizey * ssizey + 4 * ssizex];
        for (j = 0; j < ssizey && lhx != -1; ++j) {
            double area = 0.0;
            lhx = -1;
            for (i = 0; i < ssizex; ++i) {
                lda = respMatrix[j][i];
                if (lda != 0.0) {
                    lhx = i + 1;
                }
                working_space[j * ssizex + i] = lda;
                area += lda;
            }
            if (lhx == -1) continue;
            for (i = 0; i < ssizex; ++i) {
                int n = j * ssizex + i;
                working_space[n] = working_space[n] / area;
            }
        }
        if (lhx == -1) {
            return "ZERO COLUMN IN RESPONSE MATRIX";
        }
        for (i = 0; i < ssizex; ++i) {
            working_space[ssizex * ssizey + 2 * ssizey * ssizey + 2 * ssizex + i] = source[i];
        }
        for (i = 0; i < ssizey; ++i) {
            for (j = 0; j < ssizey; ++j) {
                lda = 0.0;
                for (k = 0; k < ssizex; ++k) {
                    ldb = working_space[ssizex * i + k];
                    ldc = working_space[ssizex * j + k];
                    lda += ldb * ldc;
                }
                working_space[ssizex * ssizey + ssizey * i + j] = lda;
            }
            lda = 0.0;
            for (k = 0; k < ssizex; ++k) {
                ldb = working_space[ssizex * i + k];
                ldc = working_space[ssizex * ssizey + 2 * ssizey * ssizey + 2 * ssizex + k];
                lda += ldb * ldc;
            }
            working_space[ssizex * ssizey + 2 * ssizey * ssizey + 3 * ssizex + i] = lda;
        }
        for (i = 0; i < ssizey; ++i) {
            working_space[ssizex * ssizey + 2 * ssizey * ssizey + 2 * ssizex + i] = working_space[ssizex * ssizey + 2 * ssizey * ssizey + 3 * ssizex + i];
        }
        for (i = 0; i < ssizey; ++i) {
            for (j = 0; j < ssizey; ++j) {
                lda = 0.0;
                for (k = 0; k < ssizey; ++k) {
                    ldb = working_space[ssizex * ssizey + ssizey * i + k];
                    ldc = working_space[ssizex * ssizey + ssizey * j + k];
                    lda += ldb * ldc;
                }
                working_space[ssizex * ssizey + ssizey * ssizey + ssizey * i + j] = lda;
            }
            lda = 0.0;
            for (k = 0; k < ssizey; ++k) {
                ldb = working_space[ssizex * ssizey + ssizey * i + k];
                ldc = working_space[ssizex * ssizey + 2 * ssizey * ssizey + 2 * ssizex + k];
                lda += ldb * ldc;
            }
            working_space[ssizex * ssizey + 2 * ssizey * ssizey + 3 * ssizex + i] = lda;
        }
        for (i = 0; i < ssizey; ++i) {
            working_space[ssizex * ssizey + 2 * ssizey * ssizey + 2 * ssizex + i] = working_space[ssizex * ssizey + 2 * ssizey * ssizey + 3 * ssizex + i];
        }
        for (i = 0; i < ssizey; ++i) {
            working_space[ssizex * ssizey + 2 * ssizey * ssizey + i] = 1.0;
        }
        for (int repet = 0; repet < numberRepetitions; ++repet) {
            if (repet != 0) {
                for (i = 0; i < ssizey; ++i) {
                    working_space[ssizex * ssizey + 2 * ssizey * ssizey + i] = Math.pow(working_space[ssizex * ssizey + 2 * ssizey * ssizey + i], boost);
                }
            }
            for (int lindex = 0; lindex < numberIterations; ++lindex) {
                for (i = 0; i < ssizey; ++i) {
                    lda = 0.0;
                    for (j = 0; j < ssizey; ++j) {
                        ldb = working_space[ssizex * ssizey + ssizey * ssizey + ssizey * i + j];
                        ldc = working_space[ssizex * ssizey + 2 * ssizey * ssizey + j];
                        lda += ldb * ldc;
                    }
                    ldb = working_space[ssizex * ssizey + 2 * ssizey * ssizey + 2 * ssizex + i];
                    lda = lda != 0.0 ? ldb / lda : 0.0;
                    ldb = working_space[ssizex * ssizey + 2 * ssizey * ssizey + i];
                    working_space[ssizex * ssizey + 2 * ssizey * ssizey + 3 * ssizex + i] = lda *= ldb;
                }
                for (i = 0; i < ssizey; ++i) {
                    working_space[ssizex * ssizey + 2 * ssizey * ssizey + i] = working_space[ssizex * ssizey + 2 * ssizey * ssizey + 3 * ssizex + i];
                }
            }
        }
        for (i = 0; i < ssizex; ++i) {
            source[i] = i < ssizey ? working_space[ssizex * ssizey + 2 * ssizey * ssizey + i] : 0.0;
        }
        return null;
    }

    public int SearchHighRes(double[] source, double[] destVector, int ssize, double sigma, double threshold, boolean backgroundRemove, int deconIterations, boolean markov, int averWindow) {
        double ldc;
        double ldb;
        int jmax;
        int jmin;
        double lda;
        double b;
        double a;
        int i;
        int numberIterations = (int)(7.0 * sigma + 0.5);
        int peak_index = 0;
        int size_ext = ssize + 2 * numberIterations;
        int shift = numberIterations;
        int bw = 2;
        double plocha = 0.0;
        double m0low = 0.0;
        double m1low = 0.0;
        double m2low = 0.0;
        double l0low = 0.0;
        double l1low = 0.0;
        if (sigma < 1.0) {
            System.out.println("SearchHighRes Invalid sigma, must be greater than or equal to 1");
            return 0;
        }
        if (threshold <= 0.0 || threshold >= 100.0) {
            System.out.println("SearchHighRes: Invalid threshold, must be positive and less than 100");
            return 0;
        }
        int j = (int)(5.0 * sigma + 0.5);
        if (j >= PEAK_WINDOW / 2) {
            System.out.println("SearchHighRes: Too large sigma");
            return 0;
        }
        if (markov && averWindow <= 0) {
            System.out.println("SearchHighRes: Averanging window must be positive");
            return 0;
        }
        if (backgroundRemove && ssize < 2 * numberIterations + 1) {
            System.out.println("SearchHighRes: Too large clipping window");
            return 0;
        }
        int k = (int)(2.0 * sigma + 0.5);
        if (k >= 2) {
            for (i = 0; i < k; ++i) {
                a = i;
                b = source[i];
                m0low += 1.0;
                m1low += a;
                m2low += a * a;
                l0low += b;
                l1low += a * b;
            }
            double detlow = m0low * m2low - m1low * m1low;
            l1low = detlow != 0.0 ? (-l0low * m1low + l1low * m0low) / detlow : 0.0;
            if (l1low > 0.0) {
                l1low = 0.0;
            }
        } else {
            l1low = 0.0;
        }
        i = (int)(7.0 * sigma + 0.5);
        i = 2 * i;
        double[] working_space = new double[7 * (ssize + i)];
        for (j = 0; j < 7 * (ssize + i); ++j) {
            working_space[j] = 0.0;
        }
        for (i = 0; i < size_ext; ++i) {
            if (i < shift) {
                a = i - shift;
                working_space[i + size_ext] = source[0] + l1low * a;
                if (!(working_space[i + size_ext] < 0.0)) continue;
                working_space[i + size_ext] = 0.0;
                continue;
            }
            if (i >= ssize + shift) {
                a = i - (ssize - 1 + shift);
                working_space[i + size_ext] = source[ssize - 1];
                if (!(working_space[i + size_ext] < 0.0)) continue;
                working_space[i + size_ext] = 0.0;
                continue;
            }
            working_space[i + size_ext] = source[i - shift];
        }
        if (backgroundRemove) {
            for (i = 1; i <= numberIterations; ++i) {
                for (j = i; j < size_ext - i; ++j) {
                    int w;
                    if (!markov) {
                        b = (working_space[size_ext + j - i] + working_space[size_ext + j + i]) / 2.0;
                        a = working_space[size_ext + j];
                        if (b < a) {
                            a = b;
                        }
                        working_space[j] = a;
                        continue;
                    }
                    a = working_space[size_ext + j];
                    double av = 0.0;
                    double men = 0.0;
                    for (w = j - bw; w <= j + bw; ++w) {
                        if (w < 0 || w >= size_ext) continue;
                        av += working_space[size_ext + w];
                        men += 1.0;
                    }
                    av /= men;
                    b = 0.0;
                    men = 0.0;
                    for (w = j - i - bw; w <= j - i + bw; ++w) {
                        if (w < 0 || w >= size_ext) continue;
                        b += working_space[size_ext + w];
                        men += 1.0;
                    }
                    b /= men;
                    double c = 0.0;
                    men = 0.0;
                    for (w = j + i - bw; w <= j + i + bw; ++w) {
                        if (w < 0 || w >= size_ext) continue;
                        c += working_space[size_ext + w];
                        men += 1.0;
                    }
                    if ((b = (b + (c /= men)) / 2.0) < a) {
                        av = b;
                    }
                    working_space[j] = av;
                }
                for (j = i; j < size_ext - i; ++j) {
                    working_space[size_ext + j] = working_space[j];
                }
            }
            for (j = 0; j < size_ext; ++j) {
                if (j < shift) {
                    a = j - shift;
                    b = source[0] + l1low * a;
                    if (b < 0.0) {
                        b = 0.0;
                    }
                    working_space[size_ext + j] = b - working_space[size_ext + j];
                    continue;
                }
                if (j >= ssize + shift) {
                    a = j - (ssize - 1 + shift);
                    b = source[ssize - 1];
                    if (b < 0.0) {
                        b = 0.0;
                    }
                    working_space[size_ext + j] = b - working_space[size_ext + j];
                    continue;
                }
                working_space[size_ext + j] = source[j - shift] - working_space[size_ext + j];
            }
            for (j = 0; j < size_ext; ++j) {
                if (!(working_space[size_ext + j] < 0.0)) continue;
                working_space[size_ext + j] = 0.0;
            }
        }
        for (i = 0; i < size_ext; ++i) {
            working_space[i + 6 * size_ext] = working_space[i + size_ext];
        }
        if (markov) {
            for (j = 0; j < size_ext; ++j) {
                working_space[2 * size_ext + j] = working_space[size_ext + j];
            }
            int xmin = 0;
            int xmax = size_ext - 1;
            double maxch = 0.0;
            for (i = 0; i < size_ext; ++i) {
                working_space[i] = 0.0;
                if (maxch < working_space[2 * size_ext + i]) {
                    maxch = working_space[2 * size_ext + i];
                }
                plocha += working_space[2 * size_ext + i];
            }
            if (maxch == 0.0) {
                working_space = null;
                return 0;
            }
            double nom = 1.0;
            working_space[xmin] = 1.0;
            for (i = xmin; i < xmax; ++i) {
                double nip = working_space[2 * size_ext + i] / maxch;
                double nim = working_space[2 * size_ext + i + 1] / maxch;
                double sp = 0.0;
                double sm = 0.0;
                for (int l = 1; l <= averWindow; ++l) {
                    a = i + l > xmax ? working_space[2 * size_ext + xmax] / maxch : working_space[2 * size_ext + i + l] / maxch;
                    b = a - nip;
                    a = a + nip <= 0.0 ? 1.0 : Math.sqrt(a + nip);
                    b /= a;
                    b = Math.exp(b);
                    sp += b;
                    a = i - l + 1 < xmin ? working_space[2 * size_ext + xmin] / maxch : working_space[2 * size_ext + i - l + 1] / maxch;
                    b = a - nim;
                    a = a + nim <= 0.0 ? 1.0 : Math.sqrt(a + nim);
                    b /= a;
                    b = Math.exp(b);
                    sm += b;
                }
                a = sp / sm;
                double d = working_space[i] * a;
                working_space[i + 1] = d;
                a = d;
                nom += a;
            }
            for (i = xmin; i <= xmax; ++i) {
                working_space[i] = working_space[i] / nom;
            }
            for (j = 0; j < size_ext; ++j) {
                working_space[size_ext + j] = working_space[j] * plocha;
            }
            for (j = 0; j < size_ext; ++j) {
                working_space[2 * size_ext + j] = working_space[size_ext + j];
            }
            if (backgroundRemove) {
                for (i = 1; i <= numberIterations; ++i) {
                    for (j = i; j < size_ext - i; ++j) {
                        b = (working_space[size_ext + j - i] + working_space[size_ext + j + i]) / 2.0;
                        a = working_space[size_ext + j];
                        if (b < a) {
                            a = b;
                        }
                        working_space[j] = a;
                    }
                    for (j = i; j < size_ext - i; ++j) {
                        working_space[size_ext + j] = working_space[j];
                    }
                }
                for (j = 0; j < size_ext; ++j) {
                    working_space[size_ext + j] = working_space[2 * size_ext + j] - working_space[size_ext + j];
                }
            }
        }
        double area = 0.0;
        int lh_gold = -1;
        int posit = 0;
        double maximum = 0.0;
        for (i = 0; i < size_ext; ++i) {
            lda = (double)i - 3.0 * sigma;
            lda = lda * lda / (2.0 * sigma * sigma);
            j = (int)(1000.0 * Math.exp(-lda));
            if ((lda = (double)j) != 0.0) {
                lh_gold = i + 1;
            }
            working_space[i] = lda;
            area += lda;
            if (!(lda > maximum)) continue;
            maximum = lda;
            posit = i;
        }
        for (i = 0; i < size_ext; ++i) {
            working_space[2 * size_ext + i] = Math.abs(working_space[size_ext + i]);
        }
        i = lh_gold - 1;
        if (i > size_ext) {
            i = size_ext;
        }
        int imin = -i;
        int imax = i;
        for (i = imin; i <= imax; ++i) {
            lda = 0.0;
            jmin = 0;
            if (i < 0) {
                jmin = -i;
            }
            if ((jmax = lh_gold - 1 - i) > lh_gold - 1) {
                jmax = lh_gold - 1;
            }
            for (j = jmin; j <= jmax; ++j) {
                ldb = working_space[j];
                ldc = working_space[i + j];
                lda += ldb * ldc;
            }
            working_space[size_ext + i - imin] = lda;
        }
        i = lh_gold - 1;
        imin = -i;
        imax = size_ext + i - 1;
        for (i = imin; i <= imax; ++i) {
            lda = 0.0;
            for (j = 0; j <= lh_gold - 1; ++j) {
                ldb = working_space[j];
                k = i + j;
                if (k < 0 || k >= size_ext) continue;
                ldc = working_space[2 * size_ext + k];
                lda += ldb * ldc;
            }
            working_space[4 * size_ext + i - imin] = lda;
        }
        for (i = imin; i <= imax; ++i) {
            working_space[2 * size_ext + i - imin] = working_space[4 * size_ext + i - imin];
        }
        for (i = 0; i < size_ext; ++i) {
            working_space[i] = 1.0;
        }
        for (int lindex = 0; lindex < deconIterations; ++lindex) {
            for (i = 0; i < size_ext; ++i) {
                if (!(Math.abs(working_space[2 * size_ext + i]) > 1.0E-5) || !(Math.abs(working_space[i]) > 1.0E-5)) continue;
                lda = 0.0;
                jmin = lh_gold - 1;
                if (jmin > i) {
                    jmin = i;
                }
                jmin = -jmin;
                jmax = lh_gold - 1;
                if (jmax > size_ext - 1 - i) {
                    jmax = size_ext - 1 - i;
                }
                for (j = jmin; j <= jmax; ++j) {
                    ldb = working_space[j + lh_gold - 1 + size_ext];
                    ldc = working_space[i + j];
                    lda += ldb * ldc;
                }
                ldb = working_space[2 * size_ext + i];
                lda = lda != 0.0 ? ldb / lda : 0.0;
                ldb = working_space[i];
                working_space[3 * size_ext + i] = lda *= ldb;
            }
            for (i = 0; i < size_ext; ++i) {
                working_space[i] = working_space[3 * size_ext + i];
            }
        }
        for (i = 0; i < size_ext; ++i) {
            lda = working_space[i];
            j = i + posit;
            working_space[size_ext + (j %= size_ext)] = lda;
        }
        maximum = 0.0;
        double maximum_decon = 0.0;
        j = lh_gold - 1;
        for (i = 0; i < size_ext - j; ++i) {
            if (i >= shift && i < ssize + shift) {
                working_space[i] = area * working_space[size_ext + i + j];
                if (maximum_decon < working_space[i]) {
                    maximum_decon = working_space[i];
                }
                if (!(maximum < working_space[6 * size_ext + i])) continue;
                maximum = working_space[6 * size_ext + i];
                continue;
            }
            working_space[i] = 0.0;
        }
        lda = 1.0;
        if (lda > threshold) {
            lda = threshold;
        }
        lda /= 100.0;
        for (i = 1; i < size_ext - 1; ++i) {
            if (!(working_space[i] > working_space[i - 1]) || !(working_space[i] > working_space[i + 1]) || i < shift || i >= ssize + shift || !(working_space[i] > lda * maximum_decon) || !(working_space[6 * size_ext + i] > threshold * maximum / 100.0)) continue;
            a = 0.0;
            b = 0.0;
            for (j = i - 1; j <= i + 1; ++j) {
                a += (double)(j - shift) * working_space[j];
                b += working_space[j];
            }
            if ((a /= b) < 0.0) {
                a = 0.0;
            }
            if (a >= (double)ssize) {
                a = ssize - 1;
            }
            if (peak_index == 0) {
                this.fPositionX[0] = a;
                peak_index = 1;
                continue;
            }
            boolean priz = false;
            for (j = 0; j < peak_index && !priz; ++j) {
                if (!(working_space[6 * size_ext + shift + (int)a] > working_space[6 * size_ext + shift + (int)this.fPositionX[j]])) continue;
                priz = true;
            }
            if (!priz) {
                if (j < this.fMaxPeaks) {
                    this.fPositionX[j] = a;
                }
            } else {
                for (k = peak_index; k >= j; --k) {
                    if (k >= this.fMaxPeaks) continue;
                    this.fPositionX[k] = this.fPositionX[k - 1];
                }
                this.fPositionX[j - 1] = a;
            }
            if (peak_index >= this.fMaxPeaks) continue;
            ++peak_index;
        }
        for (i = 0; i < ssize; ++i) {
            destVector[i] = working_space[i + shift];
        }
        working_space = null;
        this.fNPeaks = peak_index;
        if (peak_index == this.fMaxPeaks) {
            System.out.println("SearchHighRes: Peak buffer full");
        }
        return this.fNPeaks;
    }

    int StaticSearch(double[] histX, double[] histY, double[] houtX, double[] houtY, double sigma, String option, double threshold) {
        TSpectrum s = new TSpectrum();
        return s.Search(histX, histY, houtX, houtY, sigma, option, threshold);
    }

    double[] StaticBackground(double[] hist, int niter, String option) {
        TSpectrum s = new TSpectrum();
        return s.Background(hist, niter, option);
    }

    public int getNPeaks() {
        return this.fNPeaks;
    }

    public double[] getPeakX() {
        double[] peakDouble = new double[this.fNPeaks];
        for (int i = 0; i < this.fNPeaks; ++i) {
            peakDouble[i] = this.fPositionX[i];
        }
        return peakDouble;
    }

    public double[] getPeakY() {
        double[] peakDouble = new double[this.fNPeaks];
        for (int i = 0; i < this.fNPeaks; ++i) {
            peakDouble[i] = this.fPositionY[i];
        }
        return peakDouble;
    }

    public static void main(String[] argv) {
    }
}

