/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.spectra;

import de.gsi.math.TMath;
import de.gsi.math.TMathConstants;
import de.gsi.math.fitter.NonLinearRegressionFitter;
import de.gsi.math.functions.CombFunction;
import de.gsi.math.functions.Function1D;
import de.gsi.math.spectra.fft.DoubleFFT_1D;
import java.util.Arrays;

public class SpectrumTools {
    public static double interpolateBaryCentre(double[] data, int index) {
        double tresolution = 1.0 / (2.0 * (double)data.length);
        if (index > 0 && index < data.length - 1) {
            double sum = Math.pow(data[index - 1], 1.0);
            sum += Math.pow(data[index - 0], 1.0);
            double val = data[index - 1] * (double)(index - 1);
            val += data[index + 0] * (double)(index + 0);
            val += data[index + 1] * (double)(index + 1);
            return (val /= (sum += Math.pow(data[index + 1], 1.0))) * tresolution;
        }
        return (double)index * tresolution;
    }

    public static double interpolateGaussian(double[] data, int index) {
        double tresolution = 1.0 / (double)(2 * data.length);
        if (index > 0 && index < data.length - 1) {
            double left = Math.pow(data[index - 1], 1.0);
            double center = Math.pow(data[index - 0], 1.0);
            double right = Math.pow(data[index + 1], 1.0);
            double val = index;
            return (val += 0.5 * Math.log(right / left) / Math.log(Math.pow(center, 2.0) / (left * right))) * tresolution;
        }
        return (double)index * tresolution;
    }

    public static double interpolateParabolic(double[] data, int index) {
        double tresolution = 1.0 / (2.0 * (double)data.length);
        if (index > 0 && index < data.length - 1) {
            double left = Math.pow(data[index - 1], 1.0);
            double center = Math.pow(data[index - 0], 1.0);
            double right = Math.pow(data[index + 1], 1.0);
            return ((double)index + 0.5 * (right - left) / (2.0 * center - left - right)) * tresolution;
        }
        return data[index] * tresolution;
    }

    public static double interpolateNAFF(double[] data, int index) {
        double val = (double)index / (double)(2 * data.length);
        if (index > 0 && index < data.length - 1) {
            double pin = TMathConstants.Pi() / (double)data.length;
            double left = Math.pow(data[index - 1], 1.0);
            double center = Math.pow(data[index - 0], 1.0);
            double right = Math.pow(data[index + 1], 1.0);
            if (left < right) {
                return val + TMathConstants.ATan2(right * TMathConstants.Sin(pin), center + right * TMathConstants.Cos(pin)) / TMathConstants.Pi();
            }
            return val - TMathConstants.ATan2(left * TMathConstants.Sin(pin), center + left * TMathConstants.Cos(pin)) / TMathConstants.Pi();
        }
        return val;
    }

    public static double[] computeMagnitudeSpectrum(double[] data) {
        return SpectrumTools.computeMagnitudeSpectrum(data, true);
    }

    public static double[] computeMagnitudeSpectrum(double[] data, boolean truncateDCNyq) {
        double[] ret = new double[data.length / 2];
        for (int i = 0; i < ret.length; ++i) {
            int i2 = i << 1;
            double Re = data[i2];
            double Im = data[i2 + 1];
            ret[i] = TMathConstants.Sqrt(TMathConstants.Sqr(Re) + TMathConstants.Sqr(Im)) / (double)ret.length;
        }
        if (truncateDCNyq) {
            ret[0] = ret[1];
            ret[ret.length - 1] = ret[ret.length - 2];
        } else {
            ret[0] = data[0] / (double)ret.length;
            ret[ret.length - 1] = data[1] / (double)ret.length;
        }
        return ret;
    }

    public static double[] computeMagnitudeSpectrum_dB(double[] data, boolean truncateDCNyq) {
        int n2 = data.length / 2;
        double[] ret = new double[n2];
        for (int i = 0; i < ret.length; ++i) {
            int i2 = i << 1;
            double Re = data[i2];
            double Im = data[i2 + 1];
            ret[i] = 10.0 * TMathConstants.Log10(TMathConstants.Sqr(Re / (double)n2) + TMathConstants.Sqr(Im / (double)n2));
        }
        if (truncateDCNyq) {
            ret[0] = ret[1];
            ret[n2 - 1] = ret[n2 - 2];
        } else {
            ret[0] = data[0];
            ret[ret.length - 1] = data[1];
        }
        return ret;
    }

    public static float[] computeMagnitudeSpectrum_dB(float[] data) {
        float[] ret = new float[data.length / 2];
        for (int i = 0; i < ret.length; ++i) {
            int i2 = i << 1;
            double Re = data[i2];
            double Im = data[i2 + 1];
            ret[i] = (float)(10.0 * TMathConstants.Log10((TMathConstants.Sqr(Re) + TMathConstants.Sqr(Im)) / (double)ret.length));
        }
        ret[0] = data[0];
        ret[ret.length - 1] = data[1];
        return ret;
    }

    public static float[] computeMagnitudeSpectrum(float[] data) {
        return SpectrumTools.computeMagnitudeSpectrum(data);
    }

    public static float[] computeMagnitudeSpectrum(float[] data, boolean truncateDCNyq) {
        float[] ret = new float[data.length / 2];
        for (int i = 0; i < ret.length; ++i) {
            int i2 = i << 1;
            double Re = data[i2];
            double Im = data[i2 + 1];
            ret[i] = (float)(TMathConstants.Sqrt(TMathConstants.Sqr(Re) + TMathConstants.Sqr(Im)) / (double)ret.length);
        }
        if (truncateDCNyq) {
            ret[0] = ret[1];
            ret[ret.length - 1] = ret[ret.length - 2];
        } else {
            ret[0] = data[0] / (float)ret.length;
            ret[ret.length - 1] = data[1] / (float)ret.length;
        }
        return ret;
    }

    public static double[] computePhaseSpectrum(double[] data) {
        double[] ret = new double[data.length / 2];
        for (int i = 0; i < ret.length; ++i) {
            int i2 = i << 1;
            double Re = data[i2];
            double Im = data[i2 + 1];
            ret[i] = TMathConstants.ATan2(Im, Re);
        }
        ret[0] = ret[1];
        ret[ret.length - 1] = ret[ret.length - 2];
        return ret;
    }

    public static float[] computePhaseSpectrum(float[] data) {
        float[] ret = new float[data.length / 2];
        for (int i = 0; i < ret.length; ++i) {
            int i2 = i << 1;
            double Re = data[i2];
            double Im = data[i2 + 1];
            ret[i] = (float)TMathConstants.ATan2(Im, Re);
        }
        ret[0] = ret[1];
        ret[ret.length - 1] = ret[ret.length - 2];
        return ret;
    }

    public static synchronized double[] interpolateSpectrum(double[] data, int noversampling) {
        double[] val1 = Arrays.copyOf(data, data.length);
        DoubleFFT_1D fft1D = new DoubleFFT_1D(data.length);
        fft1D.realInverse(val1, true);
        double[] val2 = new double[noversampling * val1.length];
        System.arraycopy(val1, 0, val2, 0, val1.length - 2);
        fft1D = new DoubleFFT_1D(noversampling * data.length);
        fft1D.realForward(val2);
        int i = 0;
        while (i < val2.length) {
            int n = i++;
            val2[n] = val2[n] * (double)noversampling;
        }
        return val2;
    }

    public static double[] computeFrequencyScale(int nMag) {
        double[] ret = new double[nMag];
        double scale = 0.5 / (double)nMag;
        for (int i = 0; i < nMag; ++i) {
            ret[i] = (double)i * scale;
        }
        return ret;
    }

    public static float[] computeFrequencyScaleFloat(int nMag) {
        float[] ret = new float[nMag];
        float scale = 0.5f / (float)nMag;
        for (int i = 0; i < nMag; ++i) {
            ret[i] = (float)i * scale;
        }
        return ret;
    }

    public static double[][] computeMaxima(double[] data) {
        int n = data.length;
        double[][] ret = new double[2][2];
        double[] x = new double[n];
        double[] y = new double[n];
        x[0] = 0.0;
        y[0] = data[1];
        int npeaks = 1;
        for (int i = 1; i < n - 1; ++i) {
            if (!(data[i - 1] <= data[i] & data[i] >= data[i + 1])) continue;
            x[npeaks] = i;
            y[npeaks] = data[i];
            ++npeaks;
        }
        x[npeaks] = n - 1;
        y[npeaks] = data[n - 1];
        if (npeaks >= 3) {
            double slope2;
            double tmp2;
            double slope1 = (y[1] - y[2]) / (x[1] - x[2]);
            double tmp1 = slope1 * (x[0] - x[1]) + y[1];
            if (tmp1 > y[0]) {
                y[0] = tmp1;
            }
            if ((tmp2 = (slope2 = (y[npeaks - 1] - y[npeaks - 2]) / (x[npeaks - 1] - x[npeaks - 2])) * (x[npeaks] - x[npeaks - 1]) + y[npeaks - 1]) > y[npeaks]) {
                y[npeaks] = tmp2;
            }
        }
        ret[0] = Arrays.copyOf(x, ++npeaks);
        ret[1] = Arrays.copyOf(y, npeaks);
        return ret;
    }

    public static double[][] computeMinima(double[] data) {
        int n = data.length;
        double[][] ret = new double[2][2];
        double[] x = new double[n];
        double[] y = new double[n];
        x[0] = 0.0;
        y[0] = data[0];
        int npeaks = 1;
        for (int i = 2; i < n - 1; ++i) {
            if (!(data[i - 1] >= data[i]) || !(data[i] <= data[i + 1])) continue;
            x[npeaks] = i;
            y[npeaks] = data[i];
            ++npeaks;
        }
        x[npeaks] = n - 1;
        x[npeaks] = data[n - 1];
        if (npeaks >= 3) {
            double slope2;
            double tmp2;
            double slope1 = (y[1] - y[2]) / (x[1] - x[2]);
            double tmp1 = slope1 * (x[0] - x[1]) + y[1];
            if (tmp1 < y[0]) {
                y[0] = tmp1;
            }
            if ((tmp2 = (slope2 = (y[npeaks - 1] - y[npeaks - 2]) / (x[npeaks - 1] - x[npeaks - 2])) * (x[npeaks] - x[npeaks - 1]) + y[npeaks - 1]) < y[npeaks]) {
                y[npeaks] = tmp2;
            }
        }
        ret[0] = Arrays.copyOf(x, ++npeaks);
        ret[1] = Arrays.copyOf(y, npeaks);
        return ret;
    }

    public static double[][] filterPeaksSignalToNoise(double[][] peaks, double snRatio, boolean dBScale) {
        double[][] ret = new double[2][peaks[0].length];
        double[] x = peaks[0];
        double[] y = peaks[1];
        int count = 0;
        double max = TMath.Maximum(y);
        if (!dBScale) {
            for (int i = 0; i < peaks[0].length; ++i) {
                if (!(y[i] > max / snRatio)) continue;
                ret[0][count] = x[i];
                ret[1][count] = y[i];
                ++count;
            }
        } else {
            for (int i = 0; i < peaks[0].length; ++i) {
                if (!(y[i] > max - snRatio)) continue;
                ret[0][count] = x[i];
                ret[1][count] = y[i];
                ++count;
            }
        }
        ret[0] = Arrays.copyOf(ret[0], count);
        ret[1] = Arrays.copyOf(ret[1], count);
        return ret;
    }

    public static double[][] filterPeaksHarmonics(double[][] peaks, double[] magnitude, double estimate, boolean useRealAmplitudes) {
        int i;
        double[] testDataX = new double[magnitude.length];
        double[] testDataY = new double[magnitude.length];
        double[][] ret = new double[][]{Arrays.copyOf(peaks[0], peaks[0].length), Arrays.copyOf(peaks[1], peaks[1].length)};
        for (i = 0; i < magnitude.length; ++i) {
            testDataX[i] = i;
        }
        for (i = 0; i < peaks[0].length; ++i) {
            int index = (int)peaks[0][i];
            if (index <= 0) continue;
            if (useRealAmplitudes) {
                testDataY[index - 1] = 0.5 * magnitude[index];
                testDataY[index + 0] = 1.0 * magnitude[index];
                testDataY[index + 1] = 0.5 * magnitude[index];
                continue;
            }
            testDataY[index - 1] = 0.5;
            testDataY[index + 0] = 1.0;
            testDataY[index + 1] = 0.5;
        }
        CombFunction combFunction = new CombFunction("myCombFunction", new double[]{estimate, 1.0, 1.2 / (double)(2 * magnitude.length)});
        combFunction.fixParameter(1, true);
        combFunction.fixParameter(2, true);
        NonLinearRegressionFitter fitter = new NonLinearRegressionFitter(testDataX, testDataY);
        double[] start = new double[]{estimate, 1.0, 1.5 / (double)(2 * magnitude.length)};
        double[] step = new double[]{1.0E-5, 0.1, 1.0E-5};
        fitter.simplex((Function1D)combFunction, start, step);
        double[] parameter = fitter.getBestEstimates();
        for (int i2 = 0; i2 < parameter.length; ++i2) {
            System.out.printf("parameter %d = %f\n", i2, parameter[i2]);
        }
        estimate = parameter[0];
        System.err.println("set estimate to " + estimate);
        int count = 0;
        for (int i3 = 0; i3 < peaks[0].length; ++i3) {
            double comb = combFunction.getValue(peaks[0][i3]);
            if (!(comb > 0.0)) continue;
            ret[0][count] = peaks[0][i3];
            ret[1][count] = peaks[1][i3];
            ++count;
        }
        System.err.println("filtered " + count);
        ret[0] = Arrays.copyOf(ret[0], count);
        ret[1] = Arrays.copyOf(ret[1], count);
        return ret;
    }

    public static void main(String[] args) {
        double[] data = new double[1024];
        double mean = 128.12345678912345;
        double sigma = 1.2;
        for (int i = 0; i < 1024; ++i) {
            double x = i;
            data[i] = TMath.Gauss(x, 128.12345678912345, 1.2, true);
        }
        int lmax = (int)TMath.LocationMaximum(data, data.length);
        System.out.println("found highest peak at bin = " + lmax);
        double interGauss = SpectrumTools.interpolateGaussian(data, lmax) * 2.0 * (double)data.length;
        double interBary = SpectrumTools.interpolateBaryCentre(data, lmax) * 2.0 * (double)data.length;
        double interPara = SpectrumTools.interpolateParabolic(data, lmax) * 2.0 * (double)data.length;
        double interNAFF = SpectrumTools.interpolateNAFF(data, lmax) * 2.0 * (double)data.length;
        System.out.println(" ");
        System.out.printf("no interpolation                 f=%f [bins], abs. error = %e[bins]\n", lmax, Math.abs((double)lmax - 128.12345678912345));
        System.out.printf("Gaussian peak frequency estimate f=%f [bins], abs. error = %e[bins]\n", interGauss, Math.abs(interGauss - 128.12345678912345));
        System.out.printf("Bary-centre frequency estimate   f=%f [bins], abs. error = %e[bins]\n", interBary, Math.abs(interBary - 128.12345678912345));
        System.out.printf("Parabolic frequency estimate     f=%f [bins], abs. error = %e[bins]\n", interPara, Math.abs(interPara - 128.12345678912345));
        System.out.printf("'NAFF'/'SUSSIX'-type estimate    f=%f [bins], abs. error = %e[bins]\n", interNAFF, Math.abs(interNAFF - 128.12345678912345));
        System.out.println(" ");
    }
}

