/*
 * Decompiled with CFR 0.152.
 */
package de.gsi.math.spectra;

import de.gsi.math.TMathConstants;
import de.gsi.math.spectra.fft.DoubleFFT_1D;
import de.gsi.math.utils.ConcurrencyUtils;
import java.security.InvalidParameterException;
import java.util.Arrays;

public class Convolution {
    public DoubleFFT_1D f1dFFT;

    private void init(int size) {
        if (this.f1dFFT == null) {
            this.f1dFFT = new DoubleFFT_1D(size);
        } else if (this.f1dFFT.getDimension() != size) {
            this.f1dFFT = new DoubleFFT_1D(size);
        }
    }

    public double[] transform(double[] data, double[] filter, boolean cyclicBoundary) {
        int offset;
        if (data == null || data.length == 0) {
            throw new InvalidParameterException("Convolution::transform(double[], double[]-data is null");
        }
        int nsamples = (cyclicBoundary ? 1 : 3) * data.length;
        int fft_samples = ConcurrencyUtils.nextPow2(nsamples);
        int n = offset = cyclicBoundary ? 0 : fft_samples / 3 - 1;
        if (filter == null || filter.length == 0 || filter.length != fft_samples) {
            throw new InvalidParameterException("Convolution::transform(double[], double[]-filter is null or its dimension (" + (filter == null ? "null" : Integer.valueOf(filter.length)) + ") does not match the data");
        }
        this.init(fft_samples);
        double[] fdata = new double[fft_samples];
        if (cyclicBoundary) {
            for (int i = 0; i < fft_samples; ++i) {
                fdata[i] = i < data.length ? data[i] : 0.0;
            }
        } else {
            for (int i = 0; i < fft_samples; ++i) {
                if (i < offset) {
                    fdata[i] = data[0];
                    continue;
                }
                if (i < offset + data.length) {
                    fdata[i] = data[i - offset];
                    continue;
                }
                if (i <= offset + data.length) continue;
                fdata[i] = data[data.length - 1];
            }
        }
        this.f1dFFT.realForward(fdata);
        Convolution.complexMultiply(fdata, filter);
        this.f1dFFT.realInverse(fdata, true);
        if (cyclicBoundary) {
            return fdata.length != data.length ? Arrays.copyOf(fdata, data.length) : fdata;
        }
        return Arrays.copyOfRange(fdata, offset, offset + data.length);
    }

    public double[] transformFull(double[] data, double[] filter, boolean cyclicBoundary) {
        int i;
        int offset;
        if (data == null || data.length == 0) {
            throw new InvalidParameterException("Convolution::transform(double[], double[], boolean)\n-data is null");
        }
        int nsamples = (cyclicBoundary ? 1 : 3) * data.length;
        int fft_samples = ConcurrencyUtils.nextPow2(nsamples);
        int n = offset = cyclicBoundary ? 0 : fft_samples / 3 - 1;
        if (filter == null || filter.length == 0 || filter.length != 2 * fft_samples) {
            throw new InvalidParameterException("Convolution::transform(double[], double[], boolean)\n-filter is null or its dimension (" + (filter == null ? "null" : Integer.valueOf(filter.length)) + ") does not match the data dimension (" + fft_samples + ")");
        }
        this.init(fft_samples);
        double[] fdata = new double[fft_samples];
        if (cyclicBoundary) {
            for (i = 0; i < fft_samples; ++i) {
                fdata[i] = i < data.length ? data[i] : 0.0;
            }
        } else {
            for (i = 0; i < fft_samples; ++i) {
                if (i < offset) {
                    fdata[i] = data[0];
                    continue;
                }
                if (i < offset + data.length) {
                    fdata[i] = data[i - offset];
                    continue;
                }
                if (i <= offset + data.length) continue;
                fdata[i] = data[data.length - 1];
            }
        }
        double[] fdataFull = new double[2 * fft_samples];
        for (int i2 = 0; i2 < fft_samples; ++i2) {
            fdataFull[i2 << 1] = fdata[i2];
        }
        this.f1dFFT.complexForward(fdataFull);
        Convolution.complexMultiply(fdataFull, filter);
        this.f1dFFT.complexInverse(fdataFull, true);
        if (cyclicBoundary) {
            return fdataFull;
        }
        return Arrays.copyOfRange(fdataFull, 2 * offset, 2 * offset + 2 * data.length);
    }

    public static void complexMultiply(double[] data1, double[] data2) {
        int length = data2.length >> 1;
        for (int i = 0; i < length; ++i) {
            int i2 = i << 1;
            int i21 = i2 + 1;
            double a_re = data1[i2];
            double a_im = data1[i21];
            double b_re = data2[i2];
            double b_im = data2[i21];
            data1[2 * i] = a_re * b_re - a_im * b_im;
            data1[2 * i + 1] = a_re * b_im + a_im * b_re;
        }
    }

    public static double[] getIdentityFilter(int length) {
        if (length <= 0 || !ConcurrencyUtils.isPowerOf2(length)) {
            throw new InvalidParameterException("getIdentityFilter(" + length + ") - length has to be a power of two");
        }
        double[] ret = new double[length];
        for (int i = 0; i < length >> 1; ++i) {
            ret[i << 1] = 1.0;
        }
        return ret;
    }

    public static double[] getHilbertFilter(int length) {
        if (length <= 0 || !ConcurrencyUtils.isPowerOf2(length)) {
            throw new InvalidParameterException("getHilbertFilter(" + length + ") - length has to be positive and a power of two");
        }
        double[] ret = new double[length];
        int half = length >> 1;
        for (int i = 0; i < half; ++i) {
            int i2 = i << 1;
            ret[i << 1] = 1.0;
            if (i < half) {
                ret[i2] = 0.0;
                ret[i2 + 1] = -1.0;
            } else {
                ret[i2] = 0.0;
                ret[i2 + 1] = 1.0;
            }
            if (i2 != 0) continue;
            ret[i2] = 0.0;
            ret[i2 + 1] = 0.0;
        }
        ret[1] = 1.0;
        return ret;
    }

    public static double[] getDerivativeFilter(int length) {
        if (length <= 0 || length % 2 != 0) {
            throw new InvalidParameterException("getDerivativeFilter(" + length + ") - length has to be positive and multiples of two");
        }
        double[] ret = new double[length];
        int half = length >> 1;
        double norm = TMathConstants.TwoPi() / (double)length;
        for (int i = 0; i < half; ++i) {
            int i2 = i << 1;
            double window = Math.cos(TMathConstants.Pi() * (double)i / (double)(length - 1));
            double val = window * norm * (double)i;
            if (i < half) {
                ret[i2] = 0.0;
                ret[i2 + 1] = val;
                continue;
            }
            ret[i2] = 0.0;
            ret[i2 + 1] = -val;
        }
        ret[1] = 0.0;
        return ret;
    }

    public static double[] getLowPassFilter(int length, double frequency) {
        if (length <= 0 || length % 2 != 0) {
            throw new InvalidParameterException("getLowPassFilter(" + length + ") - length has to be positive and a power of two");
        }
        if (frequency > 0.5) {
            frequency = 0.5;
        }
        double[] ret = new double[length];
        int half = length >> 1;
        double TwoPiTau = TMathConstants.TwoPi() / frequency;
        for (int i = 0; i < half; ++i) {
            int i2 = i << 1;
            double f = (double)i / (double)length;
            double Re = 1.0 / (1.0 + TMathConstants.Sqr(TwoPiTau * f));
            double Im = Re * TwoPiTau * f;
            ret[i2] = Re;
            ret[i2 + 1] = Im;
        }
        return ret;
    }

    protected static double MorletWaveletFunctionFourier(double frequency, double f0, double width) {
        double heisenberg = width / 2.0;
        double K_sigma = TMathConstants.Exp(-0.5 * TMathConstants.Sqr(TMathConstants.TwoPi() * f0 * heisenberg));
        double C_sigmaPi = TMathConstants.Power(TMathConstants.Pi(), 0.25);
        double val = C_sigmaPi * (TMathConstants.Exp(-0.5 * TMathConstants.Sqr(TMathConstants.TwoPi() * (f0 - frequency) * heisenberg)) - K_sigma * TMathConstants.Exp(-0.5 * TMathConstants.Sqr(TMathConstants.TwoPi() * frequency * heisenberg)));
        return val;
    }

    public static double[] getMorletFilter(int length, double f0, double width) {
        if (length <= 0 || !ConcurrencyUtils.isPowerOf2(length)) {
            throw new InvalidParameterException("getMorletFilter(" + length + "," + f0 + ") - length has to be positive and multiples of two");
        }
        if (f0 < 0.0 || f0 > 5.0 / TMathConstants.TwoPi()) {
            throw new InvalidParameterException("getMorletFilter(" + length + "," + f0 + ") - frequency has to be within [0,0.5]");
        }
        double[] ret = new double[2 * length];
        int half = length;
        int end = 2 * length - 1;
        for (int i = 0; i < half; ++i) {
            double Re;
            int i2 = i << 1;
            double f = (double)i / (double)length;
            ret[i2] = Re = Convolution.MorletWaveletFunctionFourier(f, f0, width);
            ret[i2 + 1] = 0.0;
            ret[end - i2] = Re;
        }
        return ret;
    }

    public void Test() {
        int nbins = 1024;
        boolean cyclicBoundaries = false;
        double[] testa = new double[1024];
        double[] testb = new double[1024];
        for (int i = 0; i < 1024; ++i) {
            testa[i] = 100.0 * Math.cos(1.9477874452256718 * (double)i + 0.1) + 100.0;
        }
        System.arraycopy(testa, 0, testb, 0, testa.length);
        int filterDim = ConcurrencyUtils.nextPow2(3072);
        double[] filter = Convolution.getIdentityFilter(filterDim);
        testa = this.transform(testa, filter, false);
        double err = 0.0;
        for (int i = 0; i < 1023; ++i) {
            double e = Math.abs(testa[i] - testb[i]);
            err = Math.max(err, e);
        }
        System.out.printf("reconstruction error = %e\n", err);
    }

    public static void main(String[] args) {
        Convolution decon = new Convolution();
        decon.Test();
    }
}

